/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDatabaseConfigurable;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.BaseDatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseErrorHandlerSink;
import com.intellij.database.dialects.DatabaseErrorHandlerSinkImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OraErrorHandler
extends BaseDatabaseErrorHandler {
    @RegExp
    private static final String LINE_COLUMN_PATTERN = "(ORA-\\d+: line|Line:) (\\d+), column:? (\\d+)";
    @RegExp
    private static final String OFFSET_PATTERN = "(Error : \\d+, Position :|Position:) (\\d+)";
    private static final String DATABASE_EXCEPTION_PREFIX = "oracle.jdbc.OracleDatabaseException:";

    public int getErrorOffsetFromException(@NotNull Project project, @NotNull Throwable error, @NotNull String queryText) {
        String errorMessage;
        int offset;
        if (project == null) {
            OraErrorHandler.$$$reportNull$$$0(0);
        }
        if (error == null) {
            OraErrorHandler.$$$reportNull$$$0(1);
        }
        if (queryText == null) {
            OraErrorHandler.$$$reportNull$$$0(2);
        }
        return (offset = OraErrorHandler.getOffset(errorMessage = StringUtil.notNullize((String)error.getMessage()))) == -1 ? OraErrorHandler.getOffsetFromMessageImpl((String)LINE_COLUMN_PATTERN, (int)-1, (int)2, (int)3, (String)errorMessage, (String)queryText, null) : offset;
    }

    private static int getOffset(@NotNull String text) {
        Matcher matcher;
        if (text == null) {
            OraErrorHandler.$$$reportNull$$$0(3);
        }
        return (matcher = Pattern.compile(OFFSET_PATTERN).matcher(text)).find() ? StringUtil.parseInt((String)matcher.group(2), (int)-1) : -1;
    }

    @NotNull
    public String getErrorMessage(@Nullable LocalDataSource dataSource, @NotNull Throwable original, @NotNull Throwable cause, @NotNull DatabaseErrorHandlerSink sink) {
        Matcher lcMatcher;
        String message2;
        if (original == null) {
            OraErrorHandler.$$$reportNull$$$0(4);
        }
        if (cause == null) {
            OraErrorHandler.$$$reportNull$$$0(5);
        }
        if (sink == null) {
            OraErrorHandler.$$$reportNull$$$0(6);
        }
        if ((message2 = original.getMessage()) == null) {
            String string = super.getErrorMessage(dataSource, original, cause, sink);
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(7);
            }
            return string;
        }
        StringBuilder sb = new StringBuilder();
        OraErrorHandler.appendGenericMessage((Throwable)original, (StringBuilder)sb);
        if (sink instanceof DatabaseErrorHandlerSinkImpl && StringUtil.contains((CharSequence)sb, (CharSequence)"ORA-12705:")) {
            sb.append("\n").append(DatabaseBundle.message((String)"error.message.ora.nls", (Object[])new Object[]{dataSource == null ? "" : dataSource.getName()}));
            ((DatabaseErrorHandlerSinkImpl)sink).addSettingsFix(AnalysisBundle.message((String)"OraErrorHandler.set.locale", (Object[])new Object[0]), dataSource, configurable -> {
                String example = "-Duser.language=en -Duser.region=US -Duser.country=en";
                DataSourceUiUtil.modify((DataSourceConfigurable)configurable, ds -> {
                    String options2 = ds.getVmOptions();
                    ds.setVmOptions((String)(StringUtil.isEmpty((String)options2) ? example : options2 + " " + example));
                });
                DatabaseErrorHandlerSinkImpl.focusVmOptions((AbstractDatabaseConfigurable)configurable);
            });
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(8);
            }
            return string;
        }
        Pattern lineColumnPattern = Pattern.compile(LINE_COLUMN_PATTERN);
        Pattern offsetPattern = Pattern.compile(OFFSET_PATTERN);
        if (lineColumnPattern.matcher(sb).find() || offsetPattern.matcher(sb).find()) {
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(9);
            }
            return string;
        }
        String causeMessage = cause.getMessage();
        if (causeMessage == null) {
            String string = super.getErrorMessage(dataSource, original, cause, sink);
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(10);
            }
            return string;
        }
        boolean isDatabaseException = causeMessage.startsWith(DATABASE_EXCEPTION_PREFIX);
        if (isDatabaseException) {
            causeMessage = causeMessage.substring(DATABASE_EXCEPTION_PREFIX.length()).trim();
        }
        if ((lcMatcher = lineColumnPattern.matcher(causeMessage)).find()) {
            String line = lcMatcher.group(2);
            String column2 = lcMatcher.group(3);
            sb.append(String.format("Line: %s, column: %s", line, column2));
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(11);
            }
            return string;
        }
        Matcher oMatcher = offsetPattern.matcher(causeMessage);
        if (oMatcher.find()) {
            String offset = oMatcher.group(2);
            sb.append(String.format("Position: %s", offset));
            String string = sb.toString();
            if (string == null) {
                OraErrorHandler.$$$reportNull$$$0(12);
            }
            return string;
        }
        String string = isDatabaseException ? causeMessage : super.getErrorMessage(dataSource, original, cause, sink);
        if (string == null) {
            OraErrorHandler.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Nullable
    public Boolean mayRequestPassword(@NotNull SQLException e2) {
        if (e2 == null) {
            OraErrorHandler.$$$reportNull$$$0(14);
        }
        if (e2.getErrorCode() == 28001) {
            return true;
        }
        if (e2.getErrorCode() == 12705) {
            return false;
        }
        return super.mayRequestPassword(e2);
    }

    public boolean isPasswordExpired(@NotNull SQLException e2) {
        if (e2 == null) {
            OraErrorHandler.$$$reportNull$$$0(15);
        }
        return e2.getErrorCode() == 28001;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/oracle/OraErrorHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorOffsetFromException";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mayRequestPassword";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPasswordExpired";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

