/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import java.io.File;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.composite.internal.IncludedBuildController;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.initialization.exception.ExceptionAnalyser;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildLifecycleController;
import org.gradle.internal.build.BuildLifecycleControllerFactory;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.StandAloneNestedBuild;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.buildtree.BuildTreeState;
import org.gradle.internal.buildtree.DefaultBuildTreeLifecycleController;
import org.gradle.internal.buildtree.DefaultBuildTreeWorkExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.Path;

class DefaultNestedBuild
extends AbstractBuildState
implements StandAloneNestedBuild,
Stoppable {
    private final Path identityPath;
    private final BuildState owner;
    private final ProjectStateRegistry projectStateRegistry;
    private final BuildIdentifier buildIdentifier;
    private final BuildDefinition buildDefinition;
    private final BuildLifecycleController buildLifecycleController;

    DefaultNestedBuild(BuildIdentifier buildIdentifier, Path identityPath, BuildDefinition buildDefinition, BuildState owner, BuildTreeState buildTree, BuildLifecycleControllerFactory buildLifecycleControllerFactory, ProjectStateRegistry projectStateRegistry) {
        this.buildIdentifier = buildIdentifier;
        this.identityPath = identityPath;
        this.buildDefinition = buildDefinition;
        this.owner = owner;
        this.projectStateRegistry = projectStateRegistry;
        BuildScopeServices buildScopeServices = new BuildScopeServices(buildTree.getServices());
        this.buildLifecycleController = buildLifecycleControllerFactory.newInstance(buildDefinition, this, owner.getMutableModel(), buildScopeServices);
    }

    @Override
    protected ProjectStateRegistry getProjectStateRegistry() {
        return this.projectStateRegistry;
    }

    @Override
    public BuildIdentifier getBuildIdentifier() {
        return this.buildIdentifier;
    }

    @Override
    public Path getIdentityPath() {
        return this.identityPath;
    }

    @Override
    public boolean isImplicitBuild() {
        return true;
    }

    @Override
    public void stop() {
        this.buildLifecycleController.stop();
    }

    @Override
    public <T> T run(Function<? super BuildTreeLifecycleController, T> buildAction) {
        IncludedBuildControllers controllers = this.buildLifecycleController.getGradle().getServices().get(IncludedBuildControllers.class);
        WorkerLeaseService workerLeaseService = this.buildLifecycleController.getGradle().getServices().get(WorkerLeaseService.class);
        ExceptionAnalyser exceptionAnalyser = this.buildLifecycleController.getGradle().getServices().get(ExceptionAnalyser.class);
        DoNoFinishIncludedBuildControllers noFinishController = new DoNoFinishIncludedBuildControllers(controllers);
        DefaultBuildTreeWorkExecutor workExecutor = new DefaultBuildTreeWorkExecutor(controllers, this.buildLifecycleController);
        DefaultBuildTreeLifecycleController buildController = new DefaultBuildTreeLifecycleController(this.buildLifecycleController, workerLeaseService, workExecutor, noFinishController, exceptionAnalyser);
        return buildAction.apply(buildController);
    }

    @Override
    public SettingsInternal getLoadedSettings() {
        return this.buildLifecycleController.getGradle().getSettings();
    }

    @Override
    public Path getCurrentPrefixForProjectsInChildBuilds() {
        return this.owner.getCurrentPrefixForProjectsInChildBuilds().child(this.buildDefinition.getName());
    }

    @Override
    public Path getIdentityPathForProject(Path projectPath) {
        return this.buildLifecycleController.getGradle().getIdentityPath().append(projectPath);
    }

    @Override
    public File getBuildRootDir() {
        return this.buildLifecycleController.getGradle().getServices().get(BuildLayout.class).getRootDirectory();
    }

    @Override
    public GradleInternal getBuild() {
        return this.buildLifecycleController.getGradle();
    }

    @Override
    public GradleInternal getMutableModel() {
        return this.buildLifecycleController.getGradle();
    }

    private static class DoNoFinishIncludedBuildControllers
    implements IncludedBuildControllers {
        private final IncludedBuildControllers controllers;

        public DoNoFinishIncludedBuildControllers(IncludedBuildControllers controllers) {
            this.controllers = controllers;
        }

        @Override
        public void populateTaskGraphs() {
            this.controllers.populateTaskGraphs();
        }

        @Override
        public void startTaskExecution() {
            this.controllers.startTaskExecution();
        }

        @Override
        public void awaitTaskCompletion(Consumer<? super Throwable> taskFailures) {
            this.controllers.awaitTaskCompletion(taskFailures);
        }

        @Override
        public void finishBuild(Consumer<? super Throwable> collector) {
        }

        @Override
        public IncludedBuildController getBuildController(BuildIdentifier buildIdentifier) {
            return this.controllers.getBuildController(buildIdentifier);
        }
    }
}

