/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.List;
import java.util.Optional;
import org.gradle.api.internal.GeneratedSubclasses;
import org.gradle.execution.plan.LocalTaskNode;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeValidator;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.reflect.validation.Severity;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.internal.reflect.validation.TypeValidationProblem;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.internal.reflect.validation.UserManualReference;

public class DefaultNodeValidator
implements NodeValidator {
    @Override
    public boolean hasValidationProblems(Node node) {
        if (node instanceof LocalTaskNode) {
            LocalTaskNode taskNode = (LocalTaskNode)node;
            WorkValidationContext validationContext = taskNode.getValidationContext();
            Class<?> taskType = GeneratedSubclasses.unpackType(taskNode.getTask());
            TypeValidationContext taskValidationContext = validationContext.forType(taskType, false);
            taskNode.getTaskProperties().validateType(taskValidationContext);
            List<TypeValidationProblem> problems = validationContext.getProblems();
            problems.stream().filter(problem -> ((Severity)((Object)((Object)problem.getSeverity()))).isWarning()).forEach(problem -> {
                Optional<UserManualReference> userManualReference = problem.getUserManualReference();
                String docId = "more_about_tasks";
                String section = "sec:up_to_date_checks";
                if (userManualReference.isPresent()) {
                    UserManualReference docref = userManualReference.get();
                    docId = docref.getId();
                    section = docref.getSection();
                }
                String warning = TypeValidationProblemRenderer.convertToSingleLine(TypeValidationProblemRenderer.renderMinimalInformationAbout(problem, false, false));
                ((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour(warning).withContext("Execution optimizations are disabled to ensure correctness.")).willBeRemovedInGradle8().withUserManual(docId, section).nagUser();
            });
            return !problems.isEmpty();
        }
        return false;
    }
}

