/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.internal.impldep.com.google.common.base.MoreObjects;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.ToolchainSpecInternal;

public class DefaultToolchainSpec
implements ToolchainSpecInternal {
    private final Property<JavaLanguageVersion> languageVersion;
    private final Property<JvmVendorSpec> vendor;
    private final Property<JvmImplementation> implementation;

    @Inject
    public DefaultToolchainSpec(ObjectFactory factory) {
        this.languageVersion = factory.property(JavaLanguageVersion.class);
        this.vendor = factory.property(JvmVendorSpec.class).convention(DefaultJvmVendorSpec.any());
        this.implementation = factory.property(JvmImplementation.class).convention(JvmImplementation.VENDOR_SPECIFIC);
    }

    @Override
    public Property<JavaLanguageVersion> getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Property<JvmVendorSpec> getVendor() {
        return this.vendor;
    }

    @Override
    public Property<JvmImplementation> getImplementation() {
        return this.implementation;
    }

    @Override
    public boolean isConfigured() {
        return this.languageVersion.isPresent();
    }

    @Override
    public String getDisplayName() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((String)"");
        builder.omitNullValues();
        builder.add("languageVersion", (Object)this.languageVersion.map(JavaLanguageVersion::toString).getOrElse("unspecified"));
        builder.add("vendor", (Object)this.vendor.map(Object::toString).getOrNull());
        builder.add("implementation", (Object)this.implementation.map(JvmImplementation::toString).getOrNull());
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultToolchainSpec that = (DefaultToolchainSpec)o;
        return Objects.equal(this.languageVersion.get(), that.languageVersion.get()) && Objects.equal(this.vendor.get(), that.vendor.get()) && Objects.equal(this.implementation.get(), that.implementation.get());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.languageVersion.get(), this.vendor.get(), this.implementation.get()});
    }
}

