/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CUDALanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.CLionCompilationInfo;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdCompilationCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Trustworthiness;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.util.ClangdCommonUtil;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKt;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.lsp4j.jsonrpc.JsonRpcException;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class ClangUtils {
    @NotNull
    public static final String CLANG_UNUSED_INCLUDE_DIAG_ID = "clion_unused_include";
    @NonNls
    public static final String CLANGD_PATH = "CLANGD_PATH";
    @NonNls
    public static final String QT_CORE = "QtCore";
    public static final Key<String> CLANGD_ARCHITECTURE = Key.create((String)"CLANGD_ARCHITECTURE");
    public static final Key<String> CLANGD_OS = Key.create((String)"CLANGD_OS");
    public static final Key<String> CLANGD_ENVIRONMENT = Key.create((String)"CLANGD_ENVIRONMENT");
    @NotNull
    public static final Logger LOG = Logger.getInstance((String)ClangUtils.class.getName());
    @NonNls
    private static final String[] ourPathOpts = new String[]{"--include-directory", "--include-directory-after", "--include-prefix", "--include-with-prefix", "--include-with-prefix-after", "--include-with-prefix-before"};
    @NonNls
    private static final String[] ourPrefixPathOpts = new String[]{"-I", "--include-directory=", "-F", "-idirafter", "--include-directory-after=", "-iframework", "-iquote", "-isystem", "-iprefix", "--include-prefix=", "-iwithprefix", "--include-with-prefix-after=", "--include-with-prefix=", "-iwithprefixbefore", "--include-with-prefix-before=", "-isysroot", "-iwithsysroot", "-imacros"};
    private static final int MSVC_MAJOR_LENGTH = 2;
    private static final int MSVC_MINOR_LENGTH = 2;
    private static final Pattern VS_WARNINGS = Pattern.compile("^-[wW](?:[0-4]|d|e)[0-9]{4}$");
    private static final Key<Boolean> CLANGD_ON = Key.create((String)"CLANGD_ON");
    private static final Key<Boolean> CLANGD_CLANG_TIDY_ON = Key.create((String)"CLANG_TIDY_VIA_CLANGD_ON");
    private static final Key<Boolean> CLANGD_SHOW_ERRORS_ON = Key.create((String)"CLANGD_SHOW_ERRORS_ON");
    private static final Key<Boolean> CLANGD_NAVIGATION_ON = Key.create((String)"CLANGD_NAVIGATION_ON");
    private static final ScheduledExecutorService ourTimeoutHelper = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"TimeoutHelper");

    public static boolean isClangdAllowed(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(0);
        }
        return !ApplicationManager.getApplication().isUnitTestMode() || project.getUserData(CLANGD_ON) == Boolean.TRUE;
    }

    public static boolean isBlacklistedPPDefine(@NotNull String macro) {
        if (macro == null) {
            ClangUtils.$$$reportNull$$$0(1);
        }
        return macro.contains(" __has_include") || macro.contains(" __has_cpp_attribute");
    }

    @NotNull
    public static List<String> filterPPDefines(@NotNull List<String> defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(2);
        }
        List list = ContainerUtil.filter(defines, define -> !ClangUtils.isBlacklistedPPDefine(define));
        if (list == null) {
            ClangUtils.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public static CLionCompilationInfo getCLionCompilationInfo(@NotNull Project project, @Nullable ResolveInfo resolveInfo) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(4);
        }
        if (resolveInfo == null) {
            return null;
        }
        OCResolveConfiguration configuration = resolveInfo.configuration;
        OCLanguageKind languageKind = resolveInfo.languageKind;
        VirtualFile root = resolveInfo.root;
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings(languageKind, root);
        UnknownCompilerKind compiler = compilerSettings.getCompilerKind() != null ? compilerSettings.getCompilerKind() : UnknownCompilerKind.INSTANCE;
        File compilerExecutable = compilerSettings.getCompilerExecutable() != null ? compilerSettings.getCompilerExecutable() : new File("unknown");
        File compilerWorkingDir = compilerSettings.getCompilerWorkingDir() != null ? compilerSettings.getCompilerWorkingDir() : new File("");
        List headerPaths = compilerSettings.getHeadersSearchPaths();
        return new CLionCompilationInfo(project, configuration, compilerSettings, (OCCompilerKind)compiler, compilerExecutable, compilerWorkingDir, root, headerPaths, languageKind, resolveInfo.guessed);
    }

    @Nullable
    public static ResolveInfo getResolveInfoForFileFromWorkspace(@NotNull Project project, @NotNull VirtualFile vf) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(5);
        }
        if (vf == null) {
            ClangUtils.$$$reportNull$$$0(6);
        }
        List configs = OCWorkspace.getInstance((Project)project).getConfigurationsForFile(vf);
        OCResolveConfiguration config = (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project, (Collection)configs).first;
        OCLanguageKind kind = OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)project, (String)vf.getName());
        return config != null && kind != null ? new ResolveInfo(config, vf, kind, false) : null;
    }

    @NotNull
    public static PathOptType getPathOptType(@NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(7);
        }
        PathOptType pathOptType = ClangUtils.getPathOptInfo((String)option).type;
        if (pathOptType == null) {
            ClangUtils.$$$reportNull$$$0(8);
        }
        return pathOptType;
    }

    @NotNull
    public static PathOptInfo getPathOptInfo(@NonNls @NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(9);
        }
        if (option.equals("-I-")) {
            return new PathOptInfo(PathOptType.NotAPathOpt, "-I-");
        }
        for (String opt : ourPathOpts) {
            if (!option.equals(opt)) continue;
            return new PathOptInfo(PathOptType.NextWithPath, opt);
        }
        for (String opt : ourPrefixPathOpts) {
            if (!option.startsWith(opt)) continue;
            return new PathOptInfo(PathOptType.ThisWithPath, opt);
        }
        return new PathOptInfo(PathOptType.NotAPathOpt, option);
    }

    public static void addPreparedCompilerOptions(@NotNull List<String> transformed, @NotNull List<String> original) {
        if (transformed == null) {
            ClangUtils.$$$reportNull$$$0(10);
        }
        if (original == null) {
            ClangUtils.$$$reportNull$$$0(11);
        }
        boolean nextIsPathOption = false;
        for (String option : original) {
            if (nextIsPathOption) {
                option = FileUtil.toSystemDependentName((String)option);
                nextIsPathOption = false;
            } else if (option.startsWith("-std:")) {
                option = option.replaceFirst(":", "=");
            } else {
                switch (ClangUtils.getPathOptType(option)) {
                    case NextWithPath: {
                        nextIsPathOption = true;
                        break;
                    }
                    case ThisWithPath: {
                        option = FileUtil.toSystemDependentName((String)option);
                    }
                }
            }
            transformed.add(option);
        }
    }

    @Nullable
    public static ClangdCompilationCommand getCompilationCommand(@NotNull ClangUrlConverter converter, @NotNull Project project, @NotNull VirtualFile file, @NotNull @NonNls String pathToMacrosFile, @Nullable ResolveInfo resolveInfo) {
        ClangCompilationCommand clangCommand;
        if (converter == null) {
            ClangUtils.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(13);
        }
        if (file == null) {
            ClangUtils.$$$reportNull$$$0(14);
        }
        if (pathToMacrosFile == null) {
            ClangUtils.$$$reportNull$$$0(15);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        CLionCompilationInfo ccInfo = ClangUtils.getCLionCompilationInfo(project, resolveInfo);
        if (ccInfo == null) {
            if (ClangDebugLevel.isWarnOrMore()) {
                CidrLogService.logOnce((Level)Level.WARNING, (String)("Failed to get or create compile command for file " + file.getPath()));
            }
            return null;
        }
        try {
            clangCommand = ClangUtils.createCompilationCommand(file, ccInfo, false);
        }
        catch (IOException ex) {
            LOG.error("Failed to get or create compile command for file " + file.getPath(), (Throwable)ex);
            return null;
        }
        String entryFile = clangCommand.entryFile;
        ArrayList<String> compilerOptions = new ArrayList<String>();
        Map userCompilationCommands = (Map)project.getUserData(ClangDaemonContext.USER_DEFINED_COMPILATION_COMMANDS);
        if (userCompilationCommands == null || !userCompilationCommands.containsKey(clangCommand.inputFile)) {
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.compilerExecutable));
            compilerOptions.add("-nostdinc");
            compilerOptions.add("-nostdlib");
            compilerOptions.add("-nostdlibinc");
            compilerOptions.add("-ccc-no-implicit-pch-or-pth");
            compilerOptions.add("-clion-take-last-input");
            compilerOptions.add("-D__CLION_IDE_");
            ClangUtils.addPreparedCompilerOptions(compilerOptions, clangCommand.compilerOptions);
            compilerOptions.add("-imacros" + FileUtil.toSystemDependentName((String)pathToMacrosFile));
            compilerOptions.add(FileUtil.toSystemDependentName((String)clangCommand.entryFile));
        } else {
            String userEntryFile;
            compilerOptions.addAll((Collection)userCompilationCommands.get(clangCommand.inputFile));
            if (compilerOptions.size() > 0 && Files.exists(Paths.get(userEntryFile = (String)compilerOptions.get(compilerOptions.size() - 1), new String[0]), new LinkOption[0])) {
                entryFile = userEntryFile;
            }
        }
        String macroDefinitions = StringUtil.isNotEmpty((String)clangCommand.preprocessorDefines) ? clangCommand.preprocessorDefines : null;
        ClionCompileCommandParams compileCommandParams = new ClionCompileCommandParams(converter.toUri(clangCommand.inputFile), converter.toUri(entryFile), clangCommand.workingDir, compilerOptions, "/dev/null");
        Trustworthiness trustworthiness = new Trustworthiness();
        if (ccInfo.isGuessed()) {
            trustworthiness = trustworthiness.with(2);
        }
        return new ClangdCompilationCommand(compileCommandParams, macroDefinitions, trustworthiness);
    }

    @NotNull
    public static ClangCompilationCommand createCompilationCommand(@NotNull VirtualFile inputVirtualFile, @NotNull CLionCompilationInfo info, boolean useInputFileAsEntryFile) throws IOException {
        if (inputVirtualFile == null) {
            ClangUtils.$$$reportNull$$$0(16);
        }
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(17);
        }
        CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        Application application = ApplicationManager.getApplication();
        Ref compilerExecutableRef = Ref.create();
        Ref compilerWorkingDirRef = Ref.create();
        Ref preprocessorDefinesRef = Ref.create();
        Ref inputFileRef = Ref.create();
        Ref entryFileRef = Ref.create();
        application.runReadAction(() -> {
            if (info.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            OCResolveConfiguration configuration = info.getConfiguration();
            OCLanguageKind languageKind = info.getLanguageKind();
            VirtualFile rootVirtualFile = info.getRootVirtualFile();
            OCCompilerKind compiler = info.getCompilerKind();
            File compilerExecutable = info.getCompilerExecutable();
            List<String> ppDefines = ClangUtils.filterPPDefines(configuration.getCompilerSettings(languageKind, rootVirtualFile).getPreprocessorDefines());
            if (compiler == MSVCCompilerKind.INSTANCE || compiler == ClangClCompilerKind.INSTANCE) {
                if (ppDefines.contains("__cplusplus")) {
                    compilerExecutableRef.set((Object)"clang++");
                } else {
                    compilerExecutableRef.set((Object)"clang");
                }
            } else {
                compilerExecutableRef.set((Object)compilerExecutable.getAbsolutePath());
            }
            compilerWorkingDirRef.set((Object)info.getCompilerWorkingDir());
            ClangUtils.addCompilerSwitches(info, compilerOptions);
            ClangUtils.addQobjectDefsDirectories(info, compilerOptions);
            ClangUtils.addIncludeDirectories(info, compilerOptions);
            preprocessorDefinesRef.set(ppDefines);
            inputFileRef.set((Object)inputVirtualFile.getPath());
            entryFileRef.set((Object)rootVirtualFile.getPath());
            return null;
        });
        compilerOptions.addSingleRaw("-ferror-limit=0");
        String entryFile = useInputFileAsEntryFile ? (String)inputFileRef.get() : (String)entryFileRef.get();
        return new ClangCompilationCommand((String)inputFileRef.get(), entryFile, ((File)compilerWorkingDirRef.get()).getAbsolutePath(), (String)compilerExecutableRef.get(), compilerOptions.getArgs(), ClangUtils.preparePreprocessorDefines((List)preprocessorDefinesRef.get()));
    }

    private static void addCompilerSwitches(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        OCCompilerSettings compilerSettings;
        CidrCompilerSwitches compilerSwitches;
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(18);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(19);
        }
        if ((compilerSwitches = (compilerSettings = ccInfo.getCompilerSettings()).getCompilerSwitches()) == null) {
            compilerSwitches = CidrCompilerSwitches.EMPTY;
        }
        String definesString = StringUtil.join(ClangUtils.filterPPDefines(ccInfo.getConfiguration().getCompilerSettings(ccInfo.getLanguageKind(), ccInfo.getRootVirtualFile()).getPreprocessorDefines()), (String)"\n");
        compilerSwitches = ClangUtils.filterOutSearchPaths(compilerSwitches);
        compilerSwitches = ClangUtils.filterOutOrFixUnknownArguments(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.addLanguageStandardIfNeeded(ccInfo, definesString, compilerSwitches);
        compilerSwitches = ClangUtils.addGccConceptsIfNeeded(ccInfo, compilerSwitches);
        compilerSwitches = ClangUtils.filterOutErroneousFlags(compilerSwitches);
        switchBuilder.addAll(compilerSwitches);
        ClangUtils.addInputLanguageIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addTargetIfNeeded(ccInfo, definesString, compilerSwitches, switchBuilder);
        ClangUtils.addCompatibilityModeIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCudaIncludeIfNeeded(ccInfo, compilerSwitches, switchBuilder);
        ClangUtils.addCudaSwitches(ccInfo, switchBuilder);
        ClangUtils.applyUserFlags(ccInfo.getProject(), switchBuilder);
    }

    @NotNull
    private static CidrCompilerSwitches addGccConceptsIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(20);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(21);
        }
        if (ccInfo.getCompilerKind() != GCCCompilerKind.INSTANCE) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(22);
            }
            return cidrCompilerSwitches;
        }
        ArrayList<String> flags = new ArrayList<String>(compilerSwitches.getList(CidrCompilerSwitches.Format.RAW));
        boolean hasConceptsFlag = flags.stream().anyMatch(it -> it.equals("-fconcepts"));
        if (!hasConceptsFlag) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(23);
            }
            return cidrCompilerSwitches;
        }
        int cxxStandardIdx = ContainerUtil.indexOf(flags, it -> it.startsWith("-std="));
        if (cxxStandardIdx == -1) {
            flags.add("-std=c++20");
        } else {
            flags.set(cxxStandardIdx, "-std=c++20");
        }
        flags.remove("-fconcepts");
        return new CidrCompilerSwitches(flags);
    }

    private static void addCudaSwitches(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(24);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(25);
        }
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        switchBuilder.addSingleRaw("--cuda-device-only");
        switchBuilder.addSingleRaw("-fno-cuda-host-device-constexpr");
    }

    private static void addInputLanguageIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(26);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(27);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(28);
        }
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.equals("-x")) continue;
            return;
        }
        OCLanguageKind kind = ccInfo.getLanguageKind();
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c");
                    break;
                }
                case OBJ_C: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c");
                    break;
                }
                case CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("c++");
                    break;
                }
                case OBJ_CPP: {
                    switchBuilder.addSingleRaw("-x");
                    switchBuilder.addSingleRaw("objective-c++");
                    break;
                }
                default: {
                    LOG.warn("Unexpected language kind: " + kind);
                    break;
                }
            }
        } else if (kind instanceof CUDALanguageKind) {
            switchBuilder.addSingleRaw("-x");
            switchBuilder.addSingleRaw("cuda");
        }
    }

    private static void addCompatibilityModeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(29);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(30);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(31);
        }
        if (ccInfo.getCompilerKind() == MSVCCompilerKind.INSTANCE || ccInfo.getCompilerKind() == ClangClCompilerKind.INSTANCE) {
            switchBuilder.addSingleRaw("-fms-compatibility");
        }
        if ((ccInfo.getCompilerKind() == MSVCCompilerKind.INSTANCE || ccInfo.getCompilerKind() == GCCCompilerKind.INSTANCE) && ccInfo.getLanguageKind().isCpp() && KnownCppStandard.isCpp17OrLater(compilerSwitches)) {
            switchBuilder.addSingleRaw("-frelaxed-template-template-args");
        }
    }

    private static void addCudaIncludeIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(32);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(33);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(34);
        }
        if (ccInfo.getLanguageKind() != CUDALanguageKind.CUDA) {
            return;
        }
        List flags = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        if (!flags.contains("cuda_runtime.h")) {
            switchBuilder.addSingleRaw("-include");
            switchBuilder.addSingleRaw("cuda_runtime.h");
        }
        switchBuilder.addSingleRaw("-I" + ClangUtils.getClangCudaHeaderDir().getAbsolutePath() + "/cuda_wrappers");
        switchBuilder.addSingleRaw("-I" + ClangUtils.getClangCudaHeaderDir().getAbsolutePath());
    }

    @NotNull
    static CidrCompilerSwitches addLanguageStandardIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull String definesString, @NotNull CidrCompilerSwitches compilerSwitches) {
        OCLanguageStandard featureStd;
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(35);
        }
        if (definesString == null) {
            ClangUtils.$$$reportNull$$$0(36);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(37);
        }
        if ((featureStd = (OCLanguageStandard)ccInfo.getCompilerSettings().getCompilerFeatures().get(OCCompilerFeatures.LANGUAGE_STANDARD)) != null) {
            Enum std = null;
            if (featureStd == OCLanguageStandard.CPP98) {
                std = KnownCppStandard.CPP_98;
            } else if (featureStd == OCLanguageStandard.CPP11) {
                std = KnownCppStandard.CPP_11;
            } else if (featureStd == OCLanguageStandard.CPP14) {
                std = KnownCppStandard.CPP_14;
            } else if (featureStd == OCLanguageStandard.CPP17) {
                std = KnownCppStandard.CPP_17;
            } else if (featureStd == OCLanguageStandard.CPP20) {
                std = KnownCppStandard.CPP_20;
            } else if (featureStd == OCLanguageStandard.C89) {
                std = KnownCStandard.C89;
            } else if (featureStd == OCLanguageStandard.C99) {
                std = KnownCStandard.C99;
            } else if (featureStd == OCLanguageStandard.C11) {
                std = KnownCStandard.C11;
            }
            if (std != null) {
                return ClangUtils.setLangStandard(std, compilerSwitches);
            }
        }
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(38);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches setLangStandard(@NotNull KnownLangStandard std, @NotNull CidrCompilerSwitches switches) {
        if (std == null) {
            ClangUtils.$$$reportNull$$$0(39);
        }
        if (switches == null) {
            ClangUtils.$$$reportNull$$$0(40);
        }
        if (std != ClangUtils.findLangStandard(switches)) {
            ArrayList<String> updatedFlags = new ArrayList<String>(switches.getList(CidrCompilerSwitches.Format.RAW));
            updatedFlags.add(std.getDefaultCommandLineFlag());
            return new CidrCompilerSwitches(updatedFlags);
        }
        CidrCompilerSwitches cidrCompilerSwitches = switches;
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(41);
        }
        return cidrCompilerSwitches;
    }

    private static void addTargetIfNeeded(@NotNull CLionCompilationInfo ccInfo, @NotNull String definesString, @NotNull CidrCompilerSwitches compilerSwitches, @NotNull CidrSwitchBuilder switchBuilder) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(42);
        }
        if (definesString == null) {
            ClangUtils.$$$reportNull$$$0(43);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(44);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(45);
        }
        boolean hasTargetParam = false;
        for (String arg : compilerSwitches.getList(CidrCompilerSwitches.Format.RAW)) {
            if (!arg.startsWith("--target=")) continue;
            hasTargetParam = true;
            break;
        }
        if (!hasTargetParam) {
            String architecture = ClangUtils.detectArchitecture(ccInfo.getProject(), definesString);
            String vendor = "unknown";
            String os = ClangUtils.detectOS(ccInfo.getProject(), definesString);
            String environment = ClangUtils.detectEnvironment(ccInfo.getProject(), definesString, architecture);
            if (architecture != null) {
                switchBuilder.addSingleRaw("--target=" + architecture + "-" + vendor + "-" + os + "-" + environment);
            }
        }
    }

    @Nullable
    private static String detectArchitecture(@NotNull Project project, @NotNull String defines) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(46);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(47);
        }
        if ((forced = (String)project.getUserData(CLANGD_ARCHITECTURE)) != null) {
            return forced;
        }
        String architecture = null;
        if (defines.contains("__x86_64__") || defines.contains("__amd64__") || defines.contains("_M_X64") || defines.contains("_M_AMD64")) {
            architecture = "x86_64";
        } else if (defines.contains("__i386__") || defines.contains("__i486__") || defines.contains("__i586__") || defines.contains("__i686__") || defines.contains("__i786__") || defines.contains("__i886__") || defines.contains("__i986__") || defines.contains("_M_IX86") || defines.contains("_M_I86") || defines.contains("__X86__") || defines.contains("__I86__") || defines.contains("_X86_")) {
            architecture = "i386";
        } else if (defines.contains("__arm__") || defines.contains("_M_ARM")) {
            architecture = "arm";
        } else if (defines.contains("__aarch64__")) {
            architecture = "arm64";
        } else if (defines.contains("__mips__")) {
            architecture = "mips";
        } else if (defines.contains("__powerpc__") || defines.contains("_M_PPC")) {
            architecture = "powerpc";
        } else if (defines.contains("__powerpc64__")) {
            architecture = "powerpc64";
        } else if (defines.contains("__riscv")) {
            architecture = ClangUtils.getIntValueOfMacroOr(defines, "__riscv_xlen", 64) == 32 ? "riscv32" : "riscv64";
        }
        return architecture;
    }

    @NotNull
    private static String detectOS(@NotNull Project project, @NotNull String defines) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(48);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(49);
        }
        if ((forced = (String)project.getUserData(CLANGD_OS)) != null) {
            String string = forced;
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(50);
            }
            return string;
        }
        if (defines.contains("__APPLE__") || defines.contains("__MACH__")) {
            return "darwin";
        }
        if (defines.contains("_WIN32") || defines.contains("_WIN64")) {
            return "windows";
        }
        if (defines.contains("__linux__")) {
            return "linux";
        }
        if (defines.contains("__FreeBSD__")) {
            return "freebsd";
        }
        return "unknown";
    }

    @NotNull
    private static String detectEnvironment(@NotNull Project project, @NotNull String defines, @Nullable String architecture) {
        String forced;
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(51);
        }
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(52);
        }
        if ((forced = (String)project.getUserData(CLANGD_ENVIRONMENT)) != null) {
            String string = forced;
            if (string == null) {
                ClangUtils.$$$reportNull$$$0(53);
            }
            return string;
        }
        if (defines.contains("__CYGWIN__")) {
            return "cygnus";
        }
        if (defines.contains("__MINGW32__") || defines.contains("__MINGW64__")) {
            return "gnu";
        }
        if (defines.contains("_MSC_FULL_VER")) {
            String version;
            int versionStartPos = defines.indexOf("_MSC_FULL_VER") + "_MSC_FULL_VER".length() + 1;
            int versionEndPos = defines.indexOf(10, versionStartPos);
            if (versionStartPos >= 0 && versionEndPos >= 0 && (version = defines.substring(versionStartPos, versionEndPos)).length() > 4) {
                String string = "msvc" + version.substring(0, 2) + "." + version.substring(2, 4) + "." + version.substring(4);
                if (string == null) {
                    ClangUtils.$$$reportNull$$$0(54);
                }
                return string;
            }
        } else {
            if (defines.contains("__riscv_float_abi_single")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32f" : "lp64f";
            }
            if (defines.contains("__riscv_float_abi_double")) {
                return StringUtil.equals((CharSequence)architecture, (CharSequence)"riscv32") ? "ilp32d" : "lp64d";
            }
            if (defines.contains("__riscv_abi_rve")) {
                return "ilp32e";
            }
            if (defines.contains("__riscv_float_abi_soft")) {
                return "unknown";
            }
        }
        return "unknown";
    }

    @Nullable
    private static KnownCppStandard detectMsvcCppStandardFromMSVC_LANG(@NotNull String defines) {
        String msvcLang;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(55);
        }
        if ((msvcLang = ClangUtils.getStringValueOfMacro(defines, "_MSVC_LANG")) != null) {
            switch (msvcLang.trim()) {
                case "201402L": {
                    return KnownCppStandard.CPP_14;
                }
                case "201703L": {
                    return KnownCppStandard.CPP_17;
                }
            }
        }
        return null;
    }

    @Nullable
    private static KnownCppStandard detectDefaultMsvcCppStandard(@NotNull String defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(56);
        }
        if (!defines.contains("__cplusplus")) {
            return null;
        }
        Integer mscVer = ClangUtils.getIntValueOfMacro(defines, "_MSC_VER");
        if (mscVer != null) {
            if (mscVer >= 1800) {
                return KnownCppStandard.CPP_14;
            }
            if (mscVer >= 1600) {
                return KnownCppStandard.CPP_11;
            }
            return KnownCppStandard.CPP_98;
        }
        return null;
    }

    @Nullable
    private static String getStringValueOfMacro(@NotNull String defines, @NotNull String macroName) {
        int indexOfMacroValue;
        int indexOfEndOfMacroDefinition;
        int indexOfMacroName;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(57);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(58);
        }
        if ((indexOfMacroName = defines.indexOf(macroName)) >= 0 && (indexOfEndOfMacroDefinition = defines.indexOf(10, indexOfMacroValue = indexOfMacroName + macroName.length() + 1)) >= 0) {
            return defines.substring(indexOfMacroValue, indexOfEndOfMacroDefinition);
        }
        return null;
    }

    @Nullable
    private static Integer getIntValueOfMacro(@NotNull String defines, @NotNull String macroName) {
        String stringValue;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(59);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(60);
        }
        if ((stringValue = ClangUtils.getStringValueOfMacro(defines, macroName)) != null) {
            try {
                return Integer.parseInt(stringValue.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static int getIntValueOfMacroOr(@NotNull String defines, @NotNull String macroName, int defaultValue) {
        Integer value;
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(61);
        }
        if (macroName == null) {
            ClangUtils.$$$reportNull$$$0(62);
        }
        return (value = ClangUtils.getIntValueOfMacro(defines, macroName)) != null ? value : defaultValue;
    }

    private static String preparePreprocessorDefines(@NotNull List<String> defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(63);
        }
        boolean isMSVC = SystemInfo.isWindows && defines.stream().anyMatch(define -> define.contains("_MSC_VER"));
        Stream<Object> definesStream = defines.stream();
        definesStream = definesStream.filter(define -> {
            if (define.startsWith("#define __has_feature(") || define.startsWith("#define __has_extension(") || define.startsWith("#define __has_builtin(") || define.startsWith("#define __has_attribute(") || define.startsWith("#define __has_include(") || define.startsWith("#define __has_include_next(") || define.startsWith("#define __has_warning(") || define.startsWith("#define __is_identifier(") || define.startsWith("#define __building_module(") || define.startsWith("#define __has_cpp_attribute(") || define.startsWith("#define __has_c_attribute(") || define.startsWith("#define __has_declspec(") || define.startsWith("#define __is_target_arch(") || define.startsWith("#define __is_target_vendor(") || define.startsWith("#define __is_target_os(") || define.startsWith("#define __is_target_environment(") || define.startsWith("#define __is_target_variant_os(") || define.startsWith("#define __is_target_variant_environment(")) {
                return false;
            }
            if (define.startsWith("#define __builtin_va_start(list, paramN)") || define.startsWith("#define __builtin_va_arg(list, type)") || define.startsWith("#define __builtin_va_end(list)") || define.startsWith("#define __builtin_va_copy(dest, src)") || define.startsWith("#define __builtin_offsetof(type, member)") || define.startsWith("#define __builtin_types_compatible_p(X,Y)") || define.startsWith("#define __builtin_choose_expr(C,T,E)")) {
                return false;
            }
            return !define.startsWith("#define __extension__");
        });
        if (isMSVC) {
            Set<String> msvcMacrosNames = MacrosNames.MSVC_MACORS_NAMES;
            definesStream = definesStream.filter(define -> {
                if (!define.startsWith("#define ")) {
                    return true;
                }
                Matcher matcher = MacrosNames.DEFINE_NAME.matcher((CharSequence)define);
                if (!matcher.find()) {
                    return true;
                }
                String macroName = matcher.group(1);
                return !msvcMacrosNames.contains(macroName);
            });
        }
        StringBuilder filteredDefines = new StringBuilder();
        definesStream.forEach(define -> filteredDefines.append((String)define).append("\n"));
        ClangUtils.appendUnsupportedBuiltins2Intrinsics(filteredDefines);
        return filteredDefines.toString();
    }

    private static void appendUnsupportedBuiltins2Intrinsics(@NotNull StringBuilder defines) {
        if (defines == null) {
            ClangUtils.$$$reportNull$$$0(64);
        }
        defines.append("#define __builtin_ia32_addps _mm_add_ps\n#define __builtin_ia32_addsd _mm_add_sd\n#define __builtin_ia32_addpd _mm_add_pd\n#define __builtin_ia32_addss _mm_add_ss\n#define __builtin_ia32_paddb128 _mm_add_epi8\n#define __builtin_ia32_paddw128 _mm_add_epi16\n#define __builtin_ia32_paddd128 _mm_add_epi32\n#define __builtin_ia32_paddq128 _mm_add_epi64\n#define __builtin_ia32_subps _mm_sub_ps\n#define __builtin_ia32_subsd _mm_sub_sd\n#define __builtin_ia32_subpd _mm_sub_pd\n#define __builtin_ia32_subss _mm_sub_ss\n#define __builtin_ia32_psubb128 _mm_sub_epi8\n#define __builtin_ia32_psubw128 _mm_sub_epi16\n#define __builtin_ia32_psubd128 _mm_sub_epi32\n#define __builtin_ia32_psubq128 _mm_sub_epi64\n#define __builtin_ia32_mulsd _mm_mul_sd\n#define __builtin_ia32_mulpd _mm_mul_pd\n#define __builtin_ia32_mulps _mm_mul_ps\n#define __builtin_ia32_mulss _mm_mul_ss\n#define __builtin_ia32_pmullw128 _mm_mullo_epi16\n#define __builtin_ia32_divsd _mm_div_sd\n#define __builtin_ia32_divpd _mm_div_pd\n#define __builtin_ia32_divps _mm_div_ps\n#define __builtin_ia32_subss _mm_div_ss\n#define __builtin_ia32_andpd _mm_and_pd\n#define __builtin_ia32_andps _mm_and_ps\n#define __builtin_ia32_pand128 _mm_and_si128\n#define __builtin_ia32_andnpd _mm_andnot_pd\n#define __builtin_ia32_andnps _mm_andnot_ps\n#define __builtin_ia32_pandn128 _mm_andnot_si128\n#define __builtin_ia32_orpd _mm_or_pd\n#define __builtin_ia32_orps _mm_or_ps\n#define __builtin_ia32_por128 _mm_or_si128\n#define __builtin_ia32_xorpd _mm_xor_pd\n#define __builtin_ia32_xorps _mm_xor_ps\n#define __builtin_ia32_pxor128 _mm_xor_si128\n#define __builtin_ia32_cvtps2dq _mm_cvtps_epi32\n#define __builtin_ia32_cvtsd2ss _mm_cvtsd_ss\n#define __builtin_ia32_cvtsi2sd _mm_cvtsi32_sd\n#define __builtin_ia32_cvtss2sd _mm_cvtss_sd\n#define __builtin_ia32_cvttsd2si _mm_cvttsd_si32\n#define __builtin_ia32_vec_ext_v2df _mm_cvtsd_f64\n#define __builtin_ia32_loadhpd _mm_loadh_pd\n#define __builtin_ia32_loadlpd _mm_loadl_pd\n#define __builtin_ia32_loadlv4si _mm_loadl_epi64\n#define __builtin_ia32_cmpeqps _mm_cmpeq_ps\n#define __builtin_ia32_cmpltps _mm_cmplt_ps\n#define __builtin_ia32_cmpleps _mm_cmple_ps\n#define __builtin_ia32_cmpgtps _mm_cmpgt_ps\n#define __builtin_ia32_cmpgeps _mm_cmpge_ps\n#define __builtin_ia32_cmpunordps _mm_cmpunord_ps\n#define __builtin_ia32_cmpneqps _mm_cmpneq_ps\n#define __builtin_ia32_cmpnltps _mm_cmpnlt_ps\n#define __builtin_ia32_cmpnleps _mm_cmpnle_ps\n#define __builtin_ia32_cmpngtps _mm_cmpngt_ps\n#define __builtin_ia32_cmpordps _mm_cmpord_ps\n#define __builtin_ia32_cmpeqss _mm_cmpeq_ss\n#define __builtin_ia32_cmpltss _mm_cmplt_ss\n#define __builtin_ia32_cmpless _mm_cmple_ss\n#define __builtin_ia32_cmpunordss _mm_cmpunord_ss\n#define __builtin_ia32_cmpneqss _mm_cmpneq_ss\n#define __builtin_ia32_cmpnltss _mm_cmpnlt_ss\n#define __builtin_ia32_cmpnless _mm_cmpnle_ss\n#define __builtin_ia32_cmpngtss _mm_cmpngt_ss\n#define __builtin_ia32_cmpngess _mm_cmpnge_ss\n#define __builtin_ia32_cmpordss _mm_cmpord_ss\n#define __builtin_ia32_movss _mm_move_ss\n#define __builtin_ia32_movsd _mm_move_sd\n#define __builtin_ia32_movhlps _mm_movehl_ps\n#define __builtin_ia32_movlhps _mm_movelh_ps\n#define __builtin_ia32_movqv4si _mm_move_epi64\n#define __builtin_ia32_unpckhps _mm_unpackhi_ps\n#define __builtin_ia32_unpckhpd _mm_unpackhi_pd\n#define __builtin_ia32_punpckhbw128 _mm_unpackhi_epi8\n#define __builtin_ia32_punpckhwd128 _mm_unpackhi_epi16\n#define __builtin_ia32_punpckhdq128 _mm_unpackhi_epi32\n#define __builtin_ia32_punpckhqdq128 _mm_unpackhi_epi64\n#define __builtin_ia32_unpcklps _mm_unpacklo_ps\n#define __builtin_ia32_unpcklpd _mm_unpacklo_pd\n#define __builtin_ia32_punpcklbw128 _mm_unpacklo_epi8\n#define __builtin_ia32_punpcklwd128 _mm_unpacklo_epi16\n#define __builtin_ia32_punpckldq128 _mm_unpacklo_epi32\n#define __builtin_ia32_punpcklqdq128 _mm_unpacklo_epi64\n#define __builtin_ia32_cmpeqpd _mm_cmpeq_pd\n#define __builtin_ia32_cmpltpd _mm_cmplt_pd\n#define __builtin_ia32_cmplepd _mm_cmple_pd\n#define __builtin_ia32_cmpgtpd _mm_cmpgt_pd\n#define __builtin_ia32_cmpgepd _mm_cmpge_pd\n#define __builtin_ia32_cmpunordpd _mm_cmpunord_pd\n#define __builtin_ia32_cmpneqpd _mm_cmpneq_pd\n#define __builtin_ia32_cmpnltpd _mm_cmpnlt_pd\n#define __builtin_ia32_cmpnlepd _mm_cmpnle_pd\n#define __builtin_ia32_cmpngtpd _mm_cmpngt_pd\n#define __builtin_ia32_cmpngepd _mm_cmpnge_pd\n#define __builtin_ia32_cmpordpd _mm_cmpord_pd\n#define __builtin_ia32_cmpeqsd _mm_cmpeq_sd\n#define __builtin_ia32_cmpltsd _mm_cmplt_sd\n#define __builtin_ia32_cmplesd _mm_cmple_sd\n#define __builtin_ia32_cmpunordsd _mm_cmpunord_sd\n#define __builtin_ia32_cmpneqsd _mm_cmpneq_sd\n#define __builtin_ia32_cmpnltsd _mm_cmpnlt_sd\n#define __builtin_ia32_cmpnlesd _mm_cmpnle_sd\n#define __builtin_ia32_cmpordsd _mm_cmpord_sd\n#define __builtin_ia32_cvtsi642ss _mm_cvtsi64_ss\n#define __builtin_ia32_cvttss2si64 _mm_cvtss_si64\n#define __builtin_ia32_shufpd _mm_shuffle_pd\n#define __builtin_ia32_pshufhw _mm_shufflehi_epi16\n#define __builtin_ia32_pshuflw _mm_shufflelo_epi16\n#define __builtin_ia32_pshufd _mm_shuffle_epi32\n#define __builtin_ia32_movshdup _mm_movehdup_ps\n#define __builtin_ia32_movsldup _mm_moveldup_ps\n#define __builtin_ia32_maxps _mm_max_ps\n#define __builtin_ia32_pslldi128 _mm_slli_epi32\n#define __builtin_ia32_vec_set_v16qi _mm_insert_epi8\n#define __builtin_ia32_vec_set_v8hi _mm_insert_epi16\n#define __builtin_ia32_vec_set_v4si _mm_insert_epi32\n#define __builtin_ia32_vec_set_v2di _mm_insert_epi64\n#define __builtin_ia32_vec_ext_v16qi _mm_extract_epi8\n#define __builtin_ia32_vec_ext_v8hi _mm_extract_epi16\n#define __builtin_ia32_vec_ext_v4si _mm_extract_epi32\n#define __builtin_ia32_vec_ext_v2di _mm_extract_epi64\n#define __builtin_ia32_vec_ext_v4sf _mm_extract_ps\n");
    }

    private static void applyUserFlags(@NotNull Project project, @NotNull CidrSwitchBuilder switchBuilder) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(65);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(66);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        List userFlags = ContainerUtil.map((Collection)StringUtil.split((String)settings.getClangFlags(), (String)","), StringUtil::trim);
        List disabledWarnings = (List)project.getUserData(ClangdCommonUtil.DISABLED_WARNINGS);
        if (!ContainerUtil.isEmpty((Collection)userFlags)) {
            for (String flag : userFlags) {
                if (ClangUtils.isWarningOption(flag)) {
                    String warnOptName = ClangUtils.getWarningName(flag);
                    if (disabledWarnings != null && disabledWarnings.contains(warnOptName)) continue;
                }
                switchBuilder.addSingleRaw(flag);
            }
        }
    }

    @NotNull
    private static CidrCompilerSwitches filterOutSearchPaths(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(67);
        }
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                PathOptType pathOptType = ClangUtils.getPathOptType(parameter);
                switch (pathOptType) {
                    case NextWithPath: {
                        this.skipOptionValue = true;
                        return false;
                    }
                    case ThisWithPath: {
                        return false;
                    }
                }
                return true;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches.filterOptions((BiFunction)filter);
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(68);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches filterOutErroneousFlags(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(69);
        }
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            boolean skipNext = false;
            boolean hasArchArg = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipNext) {
                    this.skipNext = false;
                    return false;
                }
                if (parameter.equals("-include-pch")) {
                    this.skipNext = true;
                    return false;
                }
                if (parameter.equals("-fconcepts")) {
                    return false;
                }
                if (parameter.startsWith("-mabi=")) {
                    return false;
                }
                if (parameter.startsWith("-mfloat-gprs=")) {
                    return false;
                }
                if (parameter.equals("-arch")) {
                    if (this.hasArchArg) {
                        this.skipNext = true;
                        return false;
                    }
                    this.hasArchArg = true;
                }
                return true;
            }
        };
        CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches.filterOptions((BiFunction)filter);
        if (cidrCompilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(70);
        }
        return cidrCompilerSwitches;
    }

    @NotNull
    private static CidrCompilerSwitches filterOutOrFixUnknownArguments(@NotNull CLionCompilationInfo ccInfo, @NotNull CidrCompilerSwitches compilerSwitches) {
        if (ccInfo == null) {
            ClangUtils.$$$reportNull$$$0(71);
        }
        if (compilerSwitches == null) {
            ClangUtils.$$$reportNull$$$0(72);
        }
        if (ccInfo.getCompilerKind() != MSVCCompilerKind.INSTANCE && ccInfo.getCompilerKind() != ClangClCompilerKind.INSTANCE) {
            CidrCompilerSwitches cidrCompilerSwitches = compilerSwitches;
            if (cidrCompilerSwitches == null) {
                ClangUtils.$$$reportNull$$$0(73);
            }
            return cidrCompilerSwitches;
        }
        ArrayList<String> filtered = new ArrayList<String>();
        List switches = compilerSwitches.getList(CidrCompilerSwitches.Format.RAW);
        boolean addNext = false;
        for (String aSwitch : switches) {
            String parameter = aSwitch.trim();
            if (addNext) {
                filtered.add(parameter);
                addNext = false;
                continue;
            }
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/D", "-D")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/D", "-D")) continue;
            if (ClangUtils.fixParameterWithArgument(parameter, filtered, "/FI", "-include")) {
                addNext = true;
                continue;
            }
            if (ClangUtils.fixGluedParameter(parameter, filtered, "/FI", "-include") || ClangUtils.fixGluedParameter(parameter, filtered, "/std:", "-std=") || ClangUtils.fixGluedParameter(parameter, filtered, "-std:", "-std=") || parameter.startsWith("/") || parameter.startsWith("@") || VS_WARNINGS.matcher(parameter).matches() || parameter.equalsIgnoreCase("-bigobj")) continue;
            filtered.add(parameter);
        }
        return filtered.isEmpty() ? CidrCompilerSwitches.EMPTY : new CidrCompilerSwitches(filtered);
    }

    private static boolean fixGluedParameter(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter == null) {
            ClangUtils.$$$reportNull$$$0(74);
        }
        if (filtered == null) {
            ClangUtils.$$$reportNull$$$0(75);
        }
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(76);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(77);
        }
        if (parameter.startsWith(from) && parameter.length() > from.length()) {
            filtered.add(to + parameter.substring(from.length()));
            return true;
        }
        return false;
    }

    private static boolean fixParameterWithArgument(@NotNull String parameter, @NotNull List<String> filtered, @NotNull String from, @NotNull String to) {
        if (parameter == null) {
            ClangUtils.$$$reportNull$$$0(78);
        }
        if (filtered == null) {
            ClangUtils.$$$reportNull$$$0(79);
        }
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(80);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(81);
        }
        if (parameter.equals(from)) {
            filtered.add(to);
            return true;
        }
        return false;
    }

    private static void addQobjectDefsDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(82);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(83);
        }
        boolean hasQtCore = false;
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (!path.getPath().contains(QT_CORE)) continue;
            hasQtCore = true;
            break;
        }
        if (hasQtCore) {
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath());
            switchBuilder.addSingleRaw("-I" + ClangRequestsHelper.getMacrosParentPath() + "/QtCore");
        }
    }

    private static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(84);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(85);
        }
        ClangUtils.addIncludeDirectories(info, switchBuilder, info.getRootVirtualFile().getParent(), false);
    }

    public static void addIncludeDirectories(@NotNull CLionCompilationInfo info, @NotNull CidrSwitchBuilder switchBuilder, @Nullable VirtualFile parentDirectory, boolean restrictToClang) {
        if (info == null) {
            ClangUtils.$$$reportNull$$$0(86);
        }
        if (switchBuilder == null) {
            ClangUtils.$$$reportNull$$$0(87);
        }
        ClangSwitchBuilder clangSwitchBuilder = new ClangSwitchBuilder(switchBuilder);
        if (parentDirectory != null && parentDirectory.isDirectory()) {
            clangSwitchBuilder.withQuoteIncludePath(parentDirectory.getPath());
        }
        for (HeadersSearchPath path : info.getHeaderPaths()) {
            if (restrictToClang) {
                clangSwitchBuilder.withSwitch("-Xclang");
            }
            clangSwitchBuilder.withHeaderSearchPath(path);
        }
    }

    @NotNull
    public static Pair<File, Boolean> getClangdPath() {
        boolean customClangd = true;
        File clangdPath = ClangUtils.getCustomClangdPath();
        if (clangdPath == null) {
            customClangd = false;
            clangdPath = ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "clangd.exe" : "clangd");
        }
        Pair pair = Pair.create((Object)clangdPath, (Object)customClangd);
        if (pair == null) {
            ClangUtils.$$$reportNull$$$0(88);
        }
        return pair;
    }

    @Nullable
    private static File getCustomClangdPath() {
        String path = System.getProperty(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        path = System.getenv(CLANGD_PATH);
        if (path != null) {
            return new File(path);
        }
        return null;
    }

    @NotNull
    public static File getBuiltinClangToolPath(@NonNls @NotNull String toolName) {
        if (toolName == null) {
            ClangUtils.$$$reportNull$$$0(89);
        }
        File file = CidrPathManager.getBinPath(ClangUtils.class, (String)"clion/bin", (String)("clang/" + CidrPathManager.getPlatformRelativePath((String)toolName)), null).toFile();
        if (file == null) {
            ClangUtils.$$$reportNull$$$0(90);
        }
        return file;
    }

    @NotNull
    public static File getClangCudaHeaderDir() {
        File includeDir = ClangUtils.getClangHeaderDir();
        if (!includeDir.exists()) {
            includeDir = ClangUtils.getBuiltinClangToolPath("cuda_includes");
        }
        File file = includeDir;
        if (file == null) {
            ClangUtils.$$$reportNull$$$0(91);
        }
        return file;
    }

    @NotNull
    public static File getClangHeaderDir() {
        return ClangUtils.getBuiltinClangToolPath("include");
    }

    private static boolean isWarningOption(@NonNls @NotNull String option) {
        if (option == null) {
            ClangUtils.$$$reportNull$$$0(92);
        }
        return option.startsWith("-W");
    }

    private static boolean isWarningOptionOn(@NonNls @NotNull String warning) {
        if (warning == null) {
            ClangUtils.$$$reportNull$$$0(93);
        }
        assert (ClangUtils.isWarningOption(warning));
        return !warning.startsWith("-Wno-");
    }

    private static boolean isWarningOptionOff(@NonNls @NotNull String warning) {
        if (warning == null) {
            ClangUtils.$$$reportNull$$$0(94);
        }
        return !ClangUtils.isWarningOptionOn(warning);
    }

    @NotNull
    @NlsSafe
    private static String getWarningName(@NotNull @NlsSafe String warningOption) {
        if (warningOption == null) {
            ClangUtils.$$$reportNull$$$0(95);
        }
        assert (ClangUtils.isWarningOption(warningOption));
        String string = ClangUtils.isWarningOptionOn(warningOption) ? warningOption.substring("-W".length()) : warningOption.substring("-Wno-".length());
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(96);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOn(@NotNull @NlsSafe String warningOptName) {
        if (warningOptName == null) {
            ClangUtils.$$$reportNull$$$0(97);
        }
        assert (!ClangUtils.isWarningOption(warningOptName));
        String string = "-W" + warningOptName;
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(98);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    private static String makeWarningOff(@NotNull @NlsSafe String warningOptName) {
        if (warningOptName == null) {
            ClangUtils.$$$reportNull$$$0(99);
        }
        assert (!ClangUtils.isWarningOption(warningOptName));
        String string = "-Wno-" + warningOptName;
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(100);
        }
        return string;
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(101);
        }
        if (logTask == null) {
            ClangUtils.$$$reportNull$$$0(102);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.warn(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(103);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(104);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(msg);
        }
    }

    public static void warnClangd(@NotNull Logger logger, @NotNull Throwable ex) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(105);
        }
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(106);
        }
        if (ClangDebugLevel.isWarnOrMore()) {
            logger.warn(ex);
        }
    }

    public static void infoClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(107);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(108);
        }
        if (ClangDebugLevel.isInfoOrMore()) {
            logger.info(msg);
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NotNull Supplier<@NonNls String> logTask) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(109);
        }
        if (logTask == null) {
            ClangUtils.$$$reportNull$$$0(110);
        }
        if (ClangDebugLevel.isTraceOrMore()) {
            try {
                String message = logTask.get();
                if (message != null) {
                    logger.info(message);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void traceClangd(@NotNull Logger logger, @NonNls @NotNull String msg) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(111);
        }
        if (msg == null) {
            ClangUtils.$$$reportNull$$$0(112);
        }
        if (ClangDebugLevel.isTraceOrMore()) {
            logger.info(msg);
        }
    }

    public static boolean isClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(113);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ClangUtils.hasKey(CLANGD_ON, project)) {
            return ClangUtils.getKey(CLANGD_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn();
    }

    public static void forceClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(114);
        }
        project.putUserData(CLANGD_ON, (Object)true);
    }

    public static void forceClangdOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(115);
        }
        project.putUserData(CLANGD_ON, (Object)false);
    }

    public static void nonForceClangd(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(116);
        }
        project.putUserData(CLANGD_ON, null);
    }

    public static boolean isClangTidyViaClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(117);
        }
        if (ClangUtils.hasKey(CLANGD_CLANG_TIDY_ON, project)) {
            return ClangUtils.getKey(CLANGD_CLANG_TIDY_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdOn() && settings.isClangTidyViaClangd();
    }

    public static void forceClangTidyViaClangdOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(118);
        }
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)true);
    }

    public static void forceClangTidyViaClangdOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(119);
        }
        project.putUserData(CLANGD_CLANG_TIDY_ON, (Object)false);
    }

    public static boolean isClangTidyViaClangdForced(@Nullable Project project) {
        return project != null && project.getUserData(CLANGD_CLANG_TIDY_ON) != null;
    }

    public static void forceClangdShowErrorsOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(120);
        }
        project.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)true);
    }

    public static void forceClangdShowErrorsOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(121);
        }
        project.putUserData(CLANGD_SHOW_ERRORS_ON, (Object)false);
    }

    public static void nonForceClangdShowErrors(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(122);
        }
        project.putUserData(CLANGD_SHOW_ERRORS_ON, null);
    }

    public static boolean isClangdShowErrors(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(123);
        }
        if (ClangUtils.hasKey(CLANGD_SHOW_ERRORS_ON, project)) {
            return ClangUtils.getKey(CLANGD_SHOW_ERRORS_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isClangdShowErrors();
    }

    public static void forceClangdNavigationOn(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(124);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)true);
    }

    public static void forceClangdNavigationOff(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(125);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, (Object)false);
    }

    public static void stopForcingClangdNavigation(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(126);
        }
        project.putUserData(CLANGD_NAVIGATION_ON, null);
    }

    public static boolean isNavigationViaClangd(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(127);
        }
        if (ClangUtils.hasKey(CLANGD_NAVIGATION_ON, project)) {
            return ClangUtils.getKey(CLANGD_NAVIGATION_ON, project);
        }
        ClangdSettings settings = ClangdSettings.getInstance(project);
        return settings != null && settings.isNavigationViaClangd();
    }

    private static boolean hasKey(@NotNull Key<?> projectKey, @Nullable Project project) {
        if (projectKey == null) {
            ClangUtils.$$$reportNull$$$0(128);
        }
        if (project != null) {
            Object forced = project.getUserData(projectKey);
            return forced != null;
        }
        return false;
    }

    private static boolean getKey(@NotNull Key<Boolean> projectKey, @Nullable Project project) {
        Boolean forced;
        if (projectKey == null) {
            ClangUtils.$$$reportNull$$$0(129);
        }
        if (project != null && (forced = (Boolean)project.getUserData(projectKey)) != null) {
            return forced;
        }
        return false;
    }

    @Nullable
    public static <T> T waitForClangFuture(@NotNull Future<? extends Supplier<? extends T>> future) throws ExecutionException {
        Supplier supplier;
        if (future == null) {
            ClangUtils.$$$reportNull$$$0(130);
        }
        return (supplier = (Supplier)CidrConcurrentUtilsKt.waitCancelAware(future, (String)"clang future")) != null ? (T)supplier.get() : null;
    }

    private static boolean isServerException(@NotNull ExecutionException ex) {
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(131);
        }
        return ex.getCause() instanceof ResponseErrorException || ex.getCause() instanceof JsonRpcException;
    }

    public static void logServerException(@NotNull Logger logger, @NotNull String message, @NotNull ExecutionException ex) {
        if (logger == null) {
            ClangUtils.$$$reportNull$$$0(132);
        }
        if (message == null) {
            ClangUtils.$$$reportNull$$$0(133);
        }
        if (ex == null) {
            ClangUtils.$$$reportNull$$$0(134);
        }
        if (ClangUtils.isServerException(ex)) {
            CidrLogService.logOnce((Level)Level.WARNING, (String)message, (Throwable)ex);
        } else if (ex.getCause() instanceof TimeoutException) {
            logger.warn(message, (Throwable)ex);
        } else {
            logger.error(message, (Throwable)ex);
        }
    }

    public static void subscribeToStyleChanges(final @NotNull ClangdLanguageServiceProvider provider, final @NotNull Project project) {
        if (provider == null) {
            ClangUtils.$$$reportNull$$$0(135);
        }
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(136);
        }
        final Ref headerExtensions = new Ref((Object)ClangUtils.getCurrentHeaderExtensions(project));
        CodeStyleSettingsManager.getInstance((Project)project).addListener(new CodeStyleSettingsListener(){

            public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
                String currentHeaderExtensions;
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!(currentHeaderExtensions = ClangUtils.getCurrentHeaderExtensions(project)).equals(headerExtensions.get())) {
                    headerExtensions.set((Object)currentHeaderExtensions);
                    ClangLanguageService service = provider.getIfStarted();
                    if (service != null) {
                        service.shutDownServer();
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$3", "codeStyleSettingsChanged"));
            }
        });
    }

    public static String getCurrentHeaderExtensions(@NotNull Project project) {
        if (project == null) {
            ClangUtils.$$$reportNull$$$0(137);
        }
        ImmutableList<FileExtensionPair> extensionPairs = ClangdBridge.getFileExtensions(project);
        StringBuilder headerExtBuilder = new StringBuilder();
        for (FileExtensionPair extensionPair : extensionPairs) {
            headerExtBuilder.append(extensionPair.myHeaderExt).append(';');
        }
        return headerExtBuilder.toString();
    }

    @NlsSafe
    @NotNull
    public static String getClangTidyConfig(@NlsSafe @NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        if (checks == null) {
            ClangUtils.$$$reportNull$$$0(138);
        }
        if (checkOptions == null) {
            ClangUtils.$$$reportNull$$$0(139);
        }
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangUtils.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        String string = rootObject.toString();
        if (string == null) {
            ClangUtils.$$$reportNull$$$0(140);
        }
        return string;
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        if (check == null) {
            ClangUtils.$$$reportNull$$$0(141);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            ClangUtils.$$$reportNull$$$0(142);
        }
        return jsonObject2;
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, null);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeoutInSeconds, T completeValue) {
        return ClangUtils.timeoutAfter(timeoutInSeconds, TimeUnit.SECONDS, completeValue);
    }

    public static <T> CompletableFuture<T> timeoutAfter(long timeout, TimeUnit unit, T completeValue) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.complete(completeValue), timeout, unit);
        return result;
    }

    public static <T> void tie(@NotNull CompletableFuture<T> first, @NotNull CompletableFuture<T> second) {
        if (first == null) {
            ClangUtils.$$$reportNull$$$0(143);
        }
        if (second == null) {
            ClangUtils.$$$reportNull$$$0(144);
        }
        ClangUtils.propagate(first, second);
        ClangUtils.propagate(second, first);
    }

    private static <T> void propagate(@NotNull CompletableFuture<T> from, @NotNull CompletableFuture<T> to) {
        if (from == null) {
            ClangUtils.$$$reportNull$$$0(145);
        }
        if (to == null) {
            ClangUtils.$$$reportNull$$$0(146);
        }
        from.whenComplete((res, ex) -> {
            if (!to.isDone()) {
                if (ex != null) {
                    to.completeExceptionally((Throwable)ex);
                } else {
                    to.complete(res);
                }
            }
        });
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeoutInSeconds) {
        return ClangUtils.exceptTimeoutAfter(timeoutInSeconds, TimeUnit.SECONDS);
    }

    public static <T> CompletableFuture<T> exceptTimeoutAfter(long timeout, TimeUnit unit) {
        CompletableFuture result = new CompletableFuture();
        ourTimeoutHelper.schedule(() -> result.completeExceptionally(new TimeoutException()), timeout, unit);
        return result;
    }

    public static CompletableFuture<String> getClangToolVersionAsync(final @NotNull String toolName, final @NotNull String path, @NotNull ProgressIndicator indicator) {
        if (toolName == null) {
            ClangUtils.$$$reportNull$$$0(147);
        }
        if (path == null) {
            ClangUtils.$$$reportNull$$$0(148);
        }
        if (indicator == null) {
            ClangUtils.$$$reportNull$$$0(149);
        }
        final CompletableFuture<String> future = new CompletableFuture<String>();
        Task.Backgroundable task = new Task.Backgroundable(null, ClangdBundle.message("configurable.clangTool.version.task.title", toolName)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                try {
                    CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(new String[]{path, "--version"}));
                    String processOutput = processHandler.runProcessWithProgressIndicator(indicator).getStdout();
                    ProgressManager.checkCanceled();
                    future.complete(processOutput.trim());
                }
                catch (com.intellij.execution.ExecutionException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.complete(null);
                }
                catch (ProcessCanceledException e) {
                    LOG.debug("Failed to check builtin " + toolName + " version", (Throwable)e);
                    future.completeExceptionally(e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$4", "run"));
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, indicator);
        return future;
    }

    @Nullable
    public static TextRange findIdentifierRange(@NotNull CharSequence text, int offset) {
        if (text == null) {
            ClangUtils.$$$reportNull$$$0(150);
        }
        if (offset >= 0 && offset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(offset))) {
            int curOffset;
            for (curOffset = offset; curOffset >= 0 && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); --curOffset) {
            }
            ++curOffset;
            while (Character.isDigit(text.charAt(curOffset)) && curOffset < offset) {
                ++curOffset;
            }
            if (ClangUtils.isCppIdentifierStart(text.charAt(curOffset))) {
                int startRange = curOffset;
                for (curOffset = offset; curOffset < text.length() && ClangUtils.isCppIdentifierPart(text.charAt(curOffset)); ++curOffset) {
                }
                int endRange = curOffset;
                return new TextRange(startRange, endRange);
            }
        }
        return null;
    }

    private static boolean isCppIdentifierPart(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private static boolean isCppIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_';
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static KnownLangStandard findLangStandard(@NotNull CidrCompilerSwitches switches) {
        if (switches == null) {
            ClangUtils.$$$reportNull$$$0(151);
        }
        @NotNull @Unmodifiable List list = switches.getList(CidrCompilerSwitches.Format.RAW);
        ListIterator iterator = list.listIterator(list.size());
        while (iterator.hasPrevious()) {
            String arg = (String)iterator.previous();
            String stdArgPrefix = KnownLangStandard.isStdArgument(arg);
            if (stdArgPrefix == null) continue;
            KnownCppStandard cppStandard = KnownCppStandard.getCppStandard(arg);
            if (cppStandard != null) {
                return cppStandard;
            }
            KnownCStandard cStandard = KnownCStandard.getCStandard(arg);
            if (cStandard != null) {
                return cStandard;
            }
            return null;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 23: 
            case 38: 
            case 41: 
            case 50: 
            case 53: 
            case 54: 
            case 68: 
            case 70: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 23: 
            case 38: 
            case 41: 
            case 50: 
            case 53: 
            case 54: 
            case 68: 
            case 70: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macro";
                break;
            }
            case 2: 
            case 47: 
            case 49: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defines";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 23: 
            case 38: 
            case 41: 
            case 50: 
            case 53: 
            case 54: 
            case 68: 
            case 70: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 7: 
            case 9: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformed";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToMacrosFile";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputVirtualFile";
                break;
            }
            case 17: 
            case 82: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 18: 
            case 20: 
            case 24: 
            case 26: 
            case 29: 
            case 32: 
            case 35: 
            case 42: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ccInfo";
                break;
            }
            case 19: 
            case 25: 
            case 28: 
            case 31: 
            case 34: 
            case 45: 
            case 66: 
            case 83: 
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBuilder";
                break;
            }
            case 21: 
            case 27: 
            case 30: 
            case 33: 
            case 37: 
            case 44: 
            case 67: 
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 36: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definesString";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "std";
                break;
            }
            case 40: 
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 58: 
            case 60: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 74: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filtered";
                break;
            }
            case 76: 
            case 80: 
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 77: 
            case 81: 
            case 146: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 89: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 93: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warning";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningOption";
                break;
            }
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "warningOptName";
                break;
            }
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 102: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logTask";
                break;
            }
            case 104: 
            case 108: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "msg";
                break;
            }
            case 106: 
            case 131: 
            case 134: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 128: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectKey";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 148: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPPDefines";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathOptType";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "addGccConceptsIfNeeded";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "addLanguageStandardIfNeeded";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setLangStandard";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "detectOS";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "detectEnvironment";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutSearchPaths";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutErroneousFlags";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "filterOutOrFixUnknownArguments";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangdPath";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltinClangToolPath";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangCudaHeaderDir";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getWarningName";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningOn";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "makeWarningOff";
                break;
            }
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyConfig";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "toJsonObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isClangdAllowed";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBlacklistedPPDefine";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "filterPPDefines";
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 23: 
            case 38: 
            case 41: 
            case 50: 
            case 53: 
            case 54: 
            case 68: 
            case 70: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCLionCompilationInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResolveInfoForFileFromWorkspace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPathOptType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPathOptInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addPreparedCompilerOptions";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCompilationCommand";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationCommand";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addCompilerSwitches";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addGccConceptsIfNeeded";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addCudaSwitches";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addInputLanguageIfNeeded";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addCompatibilityModeIfNeeded";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addCudaIncludeIfNeeded";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addLanguageStandardIfNeeded";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setLangStandard";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "addTargetIfNeeded";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "detectArchitecture";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "detectOS";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "detectEnvironment";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "detectMsvcCppStandardFromMSVC_LANG";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "detectDefaultMsvcCppStandard";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getStringValueOfMacro";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getIntValueOfMacro";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getIntValueOfMacroOr";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "preparePreprocessorDefines";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "appendUnsupportedBuiltins2Intrinsics";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "applyUserFlags";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "filterOutSearchPaths";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "filterOutErroneousFlags";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "filterOutOrFixUnknownArguments";
                break;
            }
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "fixGluedParameter";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "fixParameterWithArgument";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "addQobjectDefsDirectories";
                break;
            }
            case 84: 
            case 85: 
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "addIncludeDirectories";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getBuiltinClangToolPath";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOption";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOptionOn";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "isWarningOptionOff";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getWarningName";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "makeWarningOn";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "makeWarningOff";
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "warnClangd";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "infoClangd";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "traceClangd";
                break;
            }
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "isClangdOn";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdOn";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdOff";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "nonForceClangd";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "isClangTidyViaClangdOn";
                break;
            }
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "forceClangTidyViaClangdOn";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "forceClangTidyViaClangdOff";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdShowErrorsOn";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdShowErrorsOff";
                break;
            }
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "nonForceClangdShowErrors";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "isClangdShowErrors";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdNavigationOn";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "forceClangdNavigationOff";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "stopForcingClangdNavigation";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isNavigationViaClangd";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "hasKey";
                break;
            }
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "getKey";
                break;
            }
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "waitForClangFuture";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "isServerException";
                break;
            }
            case 132: 
            case 133: 
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "logServerException";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "subscribeToStyleChanges";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHeaderExtensions";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "toJsonObject";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "tie";
                break;
            }
            case 145: 
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "propagate";
                break;
            }
            case 147: 
            case 148: 
            case 149: {
                objectArray = objectArray;
                objectArray[2] = "getClangToolVersionAsync";
                break;
            }
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "findIdentifierRange";
                break;
            }
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "findLangStandard";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: 
            case 22: 
            case 23: 
            case 38: 
            case 41: 
            case 50: 
            case 53: 
            case 54: 
            case 68: 
            case 70: 
            case 73: 
            case 88: 
            case 90: 
            case 91: 
            case 96: 
            case 98: 
            case 100: 
            case 140: 
            case 142: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class KnownCppStandard
    extends Enum<KnownCppStandard>
    implements KnownLangStandard {
        public static final /* enum */ KnownCppStandard CPP_98 = new KnownCppStandard("98");
        public static final /* enum */ KnownCppStandard CPP_03 = new KnownCppStandard("03");
        public static final /* enum */ KnownCppStandard CPP_11 = new KnownCppStandard("11", "0x");
        public static final /* enum */ KnownCppStandard CPP_14 = new KnownCppStandard("14", "1y");
        public static final /* enum */ KnownCppStandard CPP_17 = new KnownCppStandard("17", "1z");
        public static final /* enum */ KnownCppStandard CPP_20 = new KnownCppStandard("20", "2a");
        public static final /* enum */ KnownCppStandard CPP_23 = new KnownCppStandard("2b");
        public static final /* enum */ KnownCppStandard CPP_LATEST = new KnownCppStandard("latest");
        @NotNull
        final @NotNull String @NotNull [] myIds;
        private static final /* synthetic */ KnownCppStandard[] $VALUES;

        public static KnownCppStandard[] values() {
            return (KnownCppStandard[])$VALUES.clone();
        }

        public static KnownCppStandard valueOf(String name) {
            return Enum.valueOf(KnownCppStandard.class, name);
        }

        private KnownCppStandard(String ... ids) {
            if (ids == null) {
                KnownCppStandard.$$$reportNull$$$0(0);
            }
            this.myIds = ids;
        }

        @Override
        @NotNull
        public String getDefaultCommandLineFlag() {
            String string = "-std=c++" + this.myIds[0];
            if (string == null) {
                KnownCppStandard.$$$reportNull$$$0(1);
            }
            return string;
        }

        public static boolean isCpp17OrLater(@NotNull CidrCompilerSwitches switches) {
            KnownLangStandard std;
            if (switches == null) {
                KnownCppStandard.$$$reportNull$$$0(2);
            }
            return (std = ClangUtils.findLangStandard(switches)) instanceof KnownCppStandard && std.ordinal() >= CPP_17.ordinal();
        }

        @Nullable
        public static KnownCppStandard getCppStandard(@NotNull String arg) {
            int index;
            if (arg == null) {
                KnownCppStandard.$$$reportNull$$$0(3);
            }
            if (KnownLangStandard.isStdArgument(arg) != null && (index = arg.indexOf("++")) != -1) {
                String rest = arg.substring(index + "++".length());
                for (KnownCppStandard std : KnownCppStandard.values()) {
                    for (String id : std.myIds) {
                        if (!rest.startsWith(id)) continue;
                        return std;
                    }
                }
            }
            return null;
        }

        @NotNull
        public static KnownCppStandard getLatestStandard() {
            KnownCppStandard[] values = KnownCppStandard.values();
            assert (values[values.length - 1] == CPP_LATEST);
            KnownCppStandard knownCppStandard = values[values.length - 2];
            if (knownCppStandard == null) {
                KnownCppStandard.$$$reportNull$$$0(4);
            }
            return knownCppStandard;
        }

        static {
            $VALUES = new KnownCppStandard[]{CPP_98, CPP_03, CPP_11, CPP_14, CPP_17, CPP_20, CPP_23, CPP_LATEST};
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$KnownCppStandard";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "switches";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$KnownCppStandard";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCommandLineFlag";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLatestStandard";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCpp17OrLater";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getCppStandard";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum KnownCStandard implements KnownLangStandard
    {
        C89("c89", "c90", "gnu89", "gnu90", "iso9899:1990"),
        ISO9899("iso9899:199409"),
        C99("c99", "gnu99", "iso9899:1999"),
        C11("c11", "gnu11", "iso9899:2011"),
        C17("c17", "gnu17", "gnu18"),
        C2X("c2x", "gnu2x");

        @NotNull
        final @NotNull String @NotNull [] myIds;

        private KnownCStandard(String ... ids) {
            if (ids == null) {
                KnownCStandard.$$$reportNull$$$0(0);
            }
            this.myIds = ids;
        }

        @Override
        @NotNull
        public String getDefaultCommandLineFlag() {
            String string = "-std=" + this.myIds[0];
            if (string == null) {
                KnownCStandard.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public static KnownCStandard getCStandard(@NotNull String arg) {
            String stdArgPrefix;
            if (arg == null) {
                KnownCStandard.$$$reportNull$$$0(2);
            }
            if ((stdArgPrefix = KnownLangStandard.isStdArgument(arg)) != null) {
                String rest = arg.substring(stdArgPrefix.length());
                for (KnownCStandard std : KnownCStandard.values()) {
                    for (String id : std.myIds) {
                        if (!rest.startsWith(id)) continue;
                        return std;
                    }
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ids";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$KnownCStandard";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "arg";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$KnownCStandard";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultCommandLineFlag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getCStandard";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static interface KnownLangStandard {
        @NotNull
        public String getDefaultCommandLineFlag();

        public int ordinal();

        @Nullable
        public static String isStdArgument(@NotNull String arg) {
            if (arg == null) {
                KnownLangStandard.$$$reportNull$$$0(0);
            }
            if (arg.startsWith("-std=")) {
                return "-std=";
            }
            if (arg.startsWith("-std:")) {
                return "-std:";
            }
            if (arg.startsWith("/std:")) {
                return "/std:";
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$KnownLangStandard", "isStdArgument"));
        }
    }

    public static class NotAllowedException
    extends RuntimeException {
        public NotAllowedException() {
            super("Call 'forceClangdOn()' in your test");
        }
    }

    private static class MacrosNames {
        @NotNull
        private static final Set<String> MSVC_MACORS_NAMES = new HashSet<String>(MSVCCompilerKt.getBuiltinMacrosNames());
        @NotNull
        private static final Pattern DEFINE_NAME = Pattern.compile("#define ([\\w]+)");

        private MacrosNames() {
        }
    }

    public static final class PathOptInfo {
        @NotNull
        public final PathOptType type;
        @NlsSafe
        @NotNull
        public final String opt;

        public PathOptInfo(@NotNull PathOptType type, @NlsSafe @NotNull String opt) {
            if (type == null) {
                PathOptInfo.$$$reportNull$$$0(0);
            }
            if (opt == null) {
                PathOptInfo.$$$reportNull$$$0(1);
            }
            this.type = type;
            this.opt = opt;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "opt";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$PathOptInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum PathOptType {
        ThisWithPath,
        NextWithPath,
        NotAPathOpt;

    }

    public static class ResolveInfo {
        @NotNull
        public final OCResolveConfiguration configuration;
        @NotNull
        public final VirtualFile root;
        @NotNull
        public final OCLanguageKind languageKind;
        public final boolean guessed;

        public ResolveInfo(@NotNull OCResolveConfiguration configuration, @NotNull VirtualFile root, @NotNull OCLanguageKind languageKind, boolean guessed) {
            if (configuration == null) {
                ResolveInfo.$$$reportNull$$$0(0);
            }
            if (root == null) {
                ResolveInfo.$$$reportNull$$$0(1);
            }
            if (languageKind == null) {
                ResolveInfo.$$$reportNull$$$0(2);
            }
            this.configuration = configuration;
            this.root = root;
            this.languageKind = languageKind;
            this.guessed = guessed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "root";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageKind";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$ResolveInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ClangCompilationCommand {
        @NotNull
        public final String inputFile;
        @NotNull
        public final String entryFile;
        @NotNull
        public final String workingDir;
        @NotNull
        public final String compilerExecutable;
        @NotNull
        public final List<String> compilerOptions;
        @Nullable
        public final String preprocessorDefines;

        public ClangCompilationCommand(@NotNull String inputFile, @NotNull String entryFile, @NotNull String workingDir, @NotNull String compilerExecutable, @NotNull List<String> compilerOptions, @Nullable String defines) {
            if (inputFile == null) {
                ClangCompilationCommand.$$$reportNull$$$0(0);
            }
            if (entryFile == null) {
                ClangCompilationCommand.$$$reportNull$$$0(1);
            }
            if (workingDir == null) {
                ClangCompilationCommand.$$$reportNull$$$0(2);
            }
            if (compilerExecutable == null) {
                ClangCompilationCommand.$$$reportNull$$$0(3);
            }
            if (compilerOptions == null) {
                ClangCompilationCommand.$$$reportNull$$$0(4);
            }
            this.inputFile = inputFile;
            this.entryFile = entryFile;
            this.workingDir = workingDir;
            this.compilerExecutable = compilerExecutable;
            this.compilerOptions = Collections.unmodifiableList(compilerOptions);
            this.preprocessorDefines = defines;
        }

        @NotNull
        public ClangCompilationCommand derive(String ... moreOptions) {
            ArrayList<String> newOptions = new ArrayList<String>(this.compilerOptions.size() + moreOptions.length);
            newOptions.addAll(this.compilerOptions);
            newOptions.addAll(Arrays.asList(moreOptions));
            return new ClangCompilationCommand(this.inputFile, this.entryFile, this.workingDir, this.compilerExecutable, newOptions, this.preprocessorDefines);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "entryFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workingDir";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerExecutable";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerOptions";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/ClangUtils$ClangCompilationCommand";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

