/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangPreprocessedReport;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ThrowableFunction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionItem;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.CLionCompletionList;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContextImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.Obfuscator;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClient;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.client.ClangClientAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCheckPreprocessedCaseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionClangPreprocessResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionCompletionCacheReadyParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionSymbolInformation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.CLionWorkspaceSymbolParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCancelParseParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionCompileCommandParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionFileStats;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDFAInputsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishHighlightingsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishNamehintParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionPublishTidyDiagnosticsParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionReparseTextDocumentParams;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClionWantDiagnostics;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLine;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangCommandLineArgument;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.RemoteWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.TextDocumentServiceAdapter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangCrashHandler {
    private static final Logger LOG = Logger.getInstance(ClangCrashHandler.class);
    private static final int FAILURES_THRESHOLD = 2;
    private static final int PENDING_FUTURES_THRESHOLD = 4096;
    private static final long DONT_NOTIFY_CRASH_INTERVAL_MS = 300000L;
    @NotNull
    private static final AtomicBoolean ourCrashReporterRunning = new AtomicBoolean(false);
    @NotNull
    private static final ExecutorService ourCrashReporterService = ConcurrencyUtil.newSingleThreadExecutor((String)"Clang crash reporter");
    @NotNull
    private final Map<PendingParse.ActionType, Long> myCrashReport2Timestamp;
    @NotNull
    private final Map<PendingParse.ActionType, Integer> myCrashReason2Counter;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final PendingInteractions myPendingInteractions;
    @NotNull
    private final Cache<String, Integer> myTrackedFailures;
    @NotNull
    private final AtomicInteger myCookieGenerator;

    public ClangCrashHandler(@NotNull ClangDaemonContext context) {
        if (context == null) {
            ClangCrashHandler.$$$reportNull$$$0(0);
        }
        this.myCrashReport2Timestamp = new HashMap<PendingParse.ActionType, Long>();
        this.myCrashReason2Counter = new HashMap<PendingParse.ActionType, Integer>();
        this.myPendingInteractions = new PendingInteractions();
        this.myTrackedFailures = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
        this.myCookieGenerator = new AtomicInteger(0);
        this.myContext = context;
    }

    public boolean isBanned(@NotNull String url) {
        if (url == null) {
            ClangCrashHandler.$$$reportNull$$$0(1);
        }
        if (ClangCrashHandler.isBlacklistEnabled() && this.myContext.getUrlConverter().isAcceptable(url)) {
            String uri = this.myContext.getUrlConverter().toUri(url);
            Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
            return numOfFailures != null && numOfFailures >= 2;
        }
        return false;
    }

    private static boolean isBlacklistEnabled() {
        return Registry.is((String)"clion.clang.clangd.blacklist");
    }

    public boolean hasPendingInteractions() {
        return !this.myPendingInteractions.empty();
    }

    public void onServerFailure() {
        ArrayList<PendingParse> pendingParses = new ArrayList<PendingParse>();
        ArrayList<PendingRequest> pendingRequests = new ArrayList<PendingRequest>();
        this.myPendingInteractions.runAndClear((parsesMapping, requestsMapping) -> {
            for (Map.Entry uriAndParses : parsesMapping.entrySet()) {
                SortedMap parses = (SortedMap)uriAndParses.getValue();
                if (parses.isEmpty()) continue;
                pendingParses.add((PendingParse)parses.values().iterator().next());
            }
            HashMap<String, PendingRequest> uriToFirstRequest = new HashMap<String, PendingRequest>();
            for (PendingRequest request : requestsMapping.values()) {
                PendingRequest existing = uriToFirstRequest.computeIfAbsent(request.uri, u -> request);
                if (existing == request || !request.before(existing)) continue;
                uriToFirstRequest.put(request.uri, request);
            }
            pendingRequests.addAll(uriToFirstRequest.values());
        });
        this.reportCrash(pendingParses, pendingRequests);
        List<String> newBannedFiles = this.updatedCrashTracker(pendingParses, pendingRequests);
        if (!newBannedFiles.isEmpty() && ClangCrashHandler.isBlacklistEnabled() && ClangDebugLevel.isWarnOrMore()) {
            Notifications.Bus.notify((Notification)new BannedNotification(newBannedFiles), (Project)this.myContext.getProject());
        }
    }

    void reportCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(2);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(3);
        }
        FUCounterUsageLogger.getInstance().logEvent("oc.clangd.crash", "total");
        if (!ourCrashReporterRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ourCrashReporterService.execute(() -> {
                try {
                    BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)this.myContext, () -> {
                        if (this.myContext.isIndexer()) {
                            ClangCrashHandler.doSimpleCrashReport(this.myContext, pendingParses, pendingRequests);
                        } else if (!pendingParses.isEmpty() || !pendingRequests.isEmpty()) {
                            Set<String> filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests);
                            if (!filesCausedCrash.isEmpty() && Registry.is((String)"clion.clang.clangd.crash_reports")) {
                                this.doAdvancedCrashReport(filesCausedCrash, pendingParses, pendingRequests);
                            } else {
                                ClangCrashHandler.doSimpleCrashReport(this.myContext, pendingParses, pendingRequests);
                            }
                            this.investigateCrash(pendingParses, pendingRequests);
                        }
                    });
                }
                finally {
                    ourCrashReporterRunning.set(false);
                }
            });
        }
        catch (Throwable thr) {
            ourCrashReporterRunning.set(false);
        }
    }

    private void investigateCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(4);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(5);
        }
        PendingParse.ActionType whatCrashed = null;
        for (PendingParse parse : pendingParses) {
            PendingParse.ActionType crashReason = parse.getWhomToBlame();
            if (whatCrashed != null) {
                if (crashReason == null || whatCrashed == crashReason) continue;
                whatCrashed = null;
                break;
            }
            whatCrashed = crashReason;
        }
        boolean hasDangerousRequests = pendingRequests.stream().anyMatch(r -> r.type.isDangerous());
        if (whatCrashed != null && !hasDangerousRequests) {
            PendingParse.ActionDisabler disabler;
            long timeSinceLastReport;
            int crashCounter = this.myCrashReason2Counter.merge(whatCrashed, 1, Integer::sum);
            switch (whatCrashed) {
                case CLANG_TIDY: 
                case CLION_CLANG_TIDY: {
                    FUCounterUsageLogger.getInstance().logEvent("oc.clangd.crash", "tidy");
                    break;
                }
                case NAMEHINTS: {
                    FUCounterUsageLogger.getInstance().logEvent("oc.clangd.crash", "namehints");
                }
            }
            Long lastReportTs = this.myCrashReport2Timestamp.get((Object)whatCrashed);
            long currentTs = System.currentTimeMillis();
            long l = timeSinceLastReport = lastReportTs != null ? currentTs - lastReportTs : Long.MAX_VALUE;
            if (timeSinceLastReport < 300000L) {
                return;
            }
            if (crashCounter >= whatCrashed.beforeDisableCrashCount && whatCrashed.disablerSupplier != null && (disabler = whatCrashed.disablerSupplier.get()).disable(this.myContext.getProject())) {
                ClangCrashHandler.notifyDisabled(ClangdBundle.message(whatCrashed.nameKey, new Object[0]), () -> disabler.enableBack(this.myContext.getProject()));
                this.myCrashReport2Timestamp.put(whatCrashed, currentTs);
                this.myCrashReason2Counter.put(whatCrashed, 0);
            }
        }
    }

    private static void notifyDisabled(@Nls @NotNull String what, final @NotNull Runnable rollback) {
        if (what == null) {
            ClangCrashHandler.$$$reportNull$$$0(6);
        }
        if (rollback == null) {
            ClangCrashHandler.$$$reportNull$$$0(7);
        }
        NotificationAction keepDisabledAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.keep", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        NotificationAction rollbackAction = new NotificationAction(ClangdBundle.message("language.cpp.clangd.disable.rollback", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (notification == null) {
                    2.$$$reportNull$$$0(1);
                }
                notification.expire();
                rollback.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$2";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Notification notification = new Notification("System Messages", ClangdBundle.message("language.cpp.clangd.disable.title", what), ClangdBundle.message("language.cpp.clangd.disable.message", what), NotificationType.INFORMATION);
        notification.addAction((AnAction)keepDisabledAction);
        notification.addAction((AnAction)rollbackAction);
        Notifications.Bus.notify((Notification)notification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<String> updatedCrashTracker(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        Set<String> filesCausedCrash;
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(8);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(9);
        }
        if ((filesCausedCrash = ClangCrashHandler.getCandidatesCausedCrash(pendingParses, pendingRequests)).isEmpty()) {
            assert (pendingParses.isEmpty()) : "Why there are no affected files, if there are pending parses?";
            for (PendingRequest pendingRequest : pendingRequests) {
                if (pendingRequest.uri == null) continue;
                filesCausedCrash.add(pendingRequest.uri);
            }
        }
        ArrayList<String> newBannedFiles = new ArrayList<String>();
        Cache<String, Integer> cache = this.myTrackedFailures;
        synchronized (cache) {
            for (String uri : filesCausedCrash) {
                Integer numOfFailures = (Integer)this.myTrackedFailures.getIfPresent((Object)uri);
                numOfFailures = numOfFailures != null ? numOfFailures + 1 : 1;
                this.myTrackedFailures.put((Object)uri, (Object)numOfFailures);
                if (numOfFailures != 2) continue;
                newBannedFiles.add(uri);
            }
        }
        ArrayList<String> arrayList = newBannedFiles;
        if (arrayList == null) {
            ClangCrashHandler.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public void onServerStop() {
        this.myPendingInteractions.clear();
    }

    private void doAdvancedCrashReport(@NotNull Set<String> filesCausedCrash, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (filesCausedCrash == null) {
            ClangCrashHandler.$$$reportNull$$$0(11);
        }
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(12);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(13);
        }
        assert (!filesCausedCrash.isEmpty()) : "Why generating advanced report if there are no candidates to preprocess?";
        String advancedCrashMessage = ClangCrashHandler.getCrashMessage(ClangdBundle.message("language.cpp.clangd.crash.message", new Object[0]), pendingParses, pendingRequests);
        List urls = ContainerUtil.map(filesCausedCrash, uri -> this.myContext.getUrlConverter().fromUriToUrl((String)uri));
        boolean success = this.withCrashLanguageService(urls, crashService -> {
            long startTime = System.nanoTime();
            CompletableFuture<ClangPreprocessedReport> reportFuture = crashService.generatePreprocessedReport(urls);
            ClangPreprocessedReport report = (ClangPreprocessedReport)CidrConcurrentUtilsKt.waitCancelAware(reportFuture, (String)"crash report");
            if (report == null) {
                return false;
            }
            long reportTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
            LOG.warn("Making crash report took " + reportTime + "ms");
            ArrayList<Attachment> attachments = new ArrayList<Attachment>();
            StringBuilder compilationInfoBuilder = new StringBuilder();
            for (ClangPreprocessedReport.PreprocessedFile preprocessedFile : report.getPreprocessedFiles()) {
                if (compilationInfoBuilder.length() > 0) {
                    compilationInfoBuilder.append("\n\n\n");
                }
                Obfuscator obfuscator = !PluginManagerCore.isRunningFromSources() && !ApplicationManager.getApplication().isUnitTestMode() ? ClangdBridge.getObfuscator() : null;
                compilationInfoBuilder.append(preprocessedFile.getCompilationInfoAsString(obfuscator));
                attachments.add(new Attachment("preprocessed-" + PathUtilRt.getFileName((String)preprocessedFile.getTargetPath(obfuscator)), preprocessedFile.getContent(obfuscator)));
            }
            if (attachments.isEmpty()) {
                return false;
            }
            attachments.add(0, new Attachment("compilation-info.txt", compilationInfoBuilder.toString()));
            LOG.error(advancedCrashMessage, attachments.toArray(Attachment.EMPTY_ARRAY));
            return true;
        });
        if (!success) {
            ClangCrashHandler.doSimpleCrashReport(this.myContext, pendingParses, pendingRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean withCrashLanguageService(@NotNull List<String> urls, @NotNull ThrowableFunction<ClangLanguageService, Boolean, Exception> crashServiceConsumer) {
        boolean bl;
        block14: {
            ClangDaemonContextImpl crashContext;
            block12: {
                if (urls == null) {
                    ClangCrashHandler.$$$reportNull$$$0(14);
                }
                if (crashServiceConsumer == null) {
                    ClangCrashHandler.$$$reportNull$$$0(15);
                }
                HashSet<String> crashedUrls = new HashSet<String>(urls);
                crashContext = null;
                ClangdLanguageService service = null;
                try {
                    crashContext = new ClangDaemonContextImpl.Builder("crash", this.myContext.getProject()).create();
                    ClangRemoteWorkspace crashRemoteWorkspace = crashContext.getRemoteWorkspace();
                    List<String> allRegisteredUrls = this.myContext.getRemoteWorkspace().getRegisteredUrls();
                    this.myContext.getRemoteWorkspace().modify(allRegisteredUrls, mapOfFiles -> mapOfFiles.forEach((url, rf) -> {
                        if (crashedUrls.contains(url)) {
                            crashRemoteWorkspace.modify((String)url, crf -> {
                                crf.put(RemoteWorkspaceFile.VERSION, 0);
                                crf.put(RemoteWorkspaceFile.IS_OPENED, rf.isOpened());
                                crf.put(RemoteWorkspaceFile.REMOTE_RECOVERED_COMPILATION_COMMAND, rf.getReparseParams());
                                crf.put(RemoteWorkspaceFile.IS_SAVED, rf.isSaved());
                                crf.put(RemoteWorkspaceFile.CONTENT, rf.getContent());
                            });
                        } else if (!rf.isSaved()) {
                            crashRemoteWorkspace.modify((String)url, crf -> {
                                crf.put(RemoteWorkspaceFile.VERSION, 0);
                                crf.put(RemoteWorkspaceFile.IS_SAVED, false);
                                crf.put(RemoteWorkspaceFile.CONTENT, rf.getContent());
                            });
                        }
                    }));
                    service = new ClangdLanguageService(crashContext);
                    bl = crashServiceConsumer.apply(service);
                    if (service == null) break block12;
                }
                catch (Throwable thr) {
                    boolean bl2;
                    block15: {
                        block13: {
                            try {
                                if (!(thr instanceof ControlFlowException)) {
                                    LOG.error(thr);
                                }
                                bl2 = false;
                                if (service == null) break block13;
                            }
                            catch (Throwable throwable) {
                                if (service != null) {
                                    ClangCrashHandler.stopService(service);
                                } else if (crashContext != null) {
                                    Disposer.dispose(crashContext);
                                }
                                throw throwable;
                            }
                            ClangCrashHandler.stopService(service);
                            break block15;
                        }
                        if (crashContext != null) {
                            Disposer.dispose((Disposable)crashContext);
                        }
                    }
                    return bl2;
                }
                ClangCrashHandler.stopService(service);
                break block14;
            }
            if (crashContext != null) {
                Disposer.dispose((Disposable)crashContext);
            }
        }
        return bl;
    }

    private static void stopService(@NotNull ClangLanguageService service) {
        if (service == null) {
            ClangCrashHandler.$$$reportNull$$$0(16);
        }
        ClangStopData stopData = service.stop();
        try {
            stopData.exitCode.get(450L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            LOG.warn((Throwable)ex);
        }
        catch (TimeoutException ex) {
            LOG.info((Throwable)ex);
            stopData.killRunnable.run();
        }
    }

    private static void doSimpleCrashReport(@NotNull ClangDaemonContext ctx, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (ctx == null) {
            ClangCrashHandler.$$$reportNull$$$0(17);
        }
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(18);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(19);
        }
        String title = ctx.isIndexer() ? ClangdBundle.message("language.cpp.clangd.indexer.crash.message.simple", new Object[0]) : ClangdBundle.message("language.cpp.clangd.crash.message.simple", new Object[0]);
        String crashMessage = ClangCrashHandler.getCrashMessage(title, pendingParses, pendingRequests);
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.error(crashMessage);
        } else {
            LOG.warn(crashMessage);
        }
    }

    @NotNull
    private static String getCrashMessage(@NotNull String title, @NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (title == null) {
            ClangCrashHandler.$$$reportNull$$$0(20);
        }
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(21);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(22);
        }
        String pendingParsesText = !pendingParses.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.parses.message", pendingParses.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) + "\n" : "";
        String pendingRequestsText = !pendingRequests.isEmpty() ? ClangdBundle.message("language.cpp.clangd.crash.requests.message", pendingRequests.stream().map(r -> r.displayText()).collect(Collectors.joining("\n"))) : "";
        String string = title + "\n" + pendingParsesText + pendingRequestsText;
        if (string == null) {
            ClangCrashHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static Set<String> getCandidatesCausedCrash(@NotNull List<PendingParse> pendingParses, @NotNull List<PendingRequest> pendingRequests) {
        if (pendingParses == null) {
            ClangCrashHandler.$$$reportNull$$$0(24);
        }
        if (pendingRequests == null) {
            ClangCrashHandler.$$$reportNull$$$0(25);
        }
        HashSet<String> candidates = new HashSet<String>();
        for (PendingParse pendingParse : pendingParses) {
            candidates.add(pendingParse.uri);
        }
        for (PendingRequest pendingRequest : pendingRequests) {
            if (pendingRequest.uri == null || !pendingRequest.type.isDangerous()) continue;
            candidates.add(pendingRequest.uri);
        }
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            ClangCrashHandler.$$$reportNull$$$0(26);
        }
        return hashSet;
    }

    @NotNull
    public ClangClient spyOn(@NotNull ClangClient client) {
        if (client == null) {
            ClangCrashHandler.$$$reportNull$$$0(27);
        }
        return new ClangClientSpy(client);
    }

    @NotNull
    public ClangServer spyOn(@NotNull ClangServer server) {
        if (server == null) {
            ClangCrashHandler.$$$reportNull$$$0(28);
        }
        return new ClangServerSpy(server);
    }

    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        if (linePrefix == null) {
            ClangCrashHandler.$$$reportNull$$$0(29);
        }
        String string = this.myPendingInteractions.printStats(linePrefix);
        if (string == null) {
            ClangCrashHandler.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: 
            case 18: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pendingParses";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 13: 
            case 19: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pendingRequests";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rollback";
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesCausedCrash";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "crashServiceConsumer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "updatedCrashTracker";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCrashMessage";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesCausedCrash";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "printStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isBanned";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "reportCrash";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "investigateCrash";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyDisabled";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updatedCrashTracker";
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 30: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doAdvancedCrashReport";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "withCrashLanguageService";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "stopService";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doSimpleCrashReport";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getCrashMessage";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesCausedCrash";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "spyOn";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "printStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 23: 
            case 26: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum RequestType {
        COMPLETION(true),
        DEFINITION(false),
        DUMP_AST(false),
        DUMP_TOKENS(false),
        PARSE_COMMAND_LINE(false),
        CLANGFORMAT_CONFIG(false),
        REQUEST_TIMINGS(false),
        PREPROCESS(false),
        RANGE_FORMAT(false),
        ON_TYPE_FORMAT(false),
        DUMP_MEMORY_STAT(false),
        CHECK_CRASH(true),
        CLION_SYMBOL(false);

        final boolean myIsDangerous;

        private RequestType(boolean isDangerous) {
            this.myIsDangerous = isDangerous;
        }

        boolean isDangerous() {
            return this.myIsDangerous;
        }
    }

    private static class PendingCompletionRequest
    extends PendingRequest {
        @NotNull
        private final CompletionParams myCompletionParams;

        PendingCompletionRequest(int cookie, @NotNull CompletionParams params) {
            if (params == null) {
                PendingCompletionRequest.$$$reportNull$$$0(0);
            }
            super(cookie, RequestType.COMPLETION, params.getTextDocument().getUri());
            this.myCompletionParams = params;
        }

        @Override
        @NotNull
        String displayText() {
            String string = this.uri + ":" + this.myCompletionParams.getPosition().getLine() + ":" + this.myCompletionParams.getPosition().getCharacter() + ", " + this.type.name();
            if (string == null) {
                PendingCompletionRequest.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingCompletionRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingCompletionRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PendingRequest
    extends AbstractPending {
        @NotNull
        public final RequestType type;
        @Nullable
        public final String uri;

        PendingRequest(int cookie, @NotNull RequestType type, @Nullable String uri) {
            if (type == null) {
                PendingRequest.$$$reportNull$$$0(0);
            }
            super(cookie);
            this.type = type;
            this.uri = uri;
        }

        @NotNull
        String displayText() {
            String string = this.uri + ", " + this.type.name();
            if (string == null) {
                PendingRequest.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NonNls
        public String toString() {
            return "PendingRequest{type=" + this.type + ", uri='" + this.uri + "'}";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingRequest";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingRequest";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PendingParse
    extends AbstractPending {
        @NotNull
        public final String uri;
        public final int version;
        @NotNull
        public final CompletableFuture<ResultState> compilerDiagsState;
        @NotNull
        public final CompletableFuture<ResultState> highlightingsState;
        @NotNull
        public final CompletableFuture<ResultState> DFAInputState;
        @NotNull
        public final CompletableFuture<ResultState> namehintsState;
        @NotNull
        public final CompletableFuture<ResultState> CLionClangTidyState;
        @NotNull
        public final CompletableFuture<ResultState> clazyState;
        @NotNull
        public final CompletableFuture<ResultState> clangTidyState;
        @NotNull
        public final CompletableFuture<ResultState> completionCacheState;

        PendingParse(int cookie, @NotNull PendingInteractions parses, @NotNull ClionReparseTextDocumentParams params) {
            if (parses == null) {
                PendingParse.$$$reportNull$$$0(0);
            }
            if (params == null) {
                PendingParse.$$$reportNull$$$0(1);
            }
            super(cookie);
            this.compilerDiagsState = new CompletableFuture();
            this.highlightingsState = new CompletableFuture();
            this.DFAInputState = new CompletableFuture();
            this.namehintsState = new CompletableFuture();
            this.CLionClangTidyState = new CompletableFuture();
            this.clazyState = new CompletableFuture();
            this.clangTidyState = new CompletableFuture();
            this.completionCacheState = new CompletableFuture();
            this.uri = params.getTextDocument().getUri();
            this.version = params.getTextDocument().getVersion();
            if (!PendingParse.waitForCompilerDiags(params)) {
                this.compilerDiagsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForHighlightings(params)) {
                this.highlightingsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForCompletionCache(params)) {
                this.completionCacheState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForDFAInputState(params)) {
                this.DFAInputState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForNamehintsState(params)) {
                this.namehintsState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForCLionClangTidyState(params)) {
                this.CLionClangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClazyState(params)) {
                this.clazyState.complete(ResultState.NOT_REQUESTED);
            }
            if (!PendingParse.waitForClangTidyState(params)) {
                this.clangTidyState.complete(ResultState.NOT_REQUESTED);
            }
            CompletableFuture.allOf(this.compilerDiagsState, this.highlightingsState, this.completionCacheState, this.DFAInputState, this.namehintsState, this.CLionClangTidyState, this.clazyState, this.clangTidyState).whenComplete((res, ex) -> parses.removePendingParse(this.uri, this.version));
        }

        @Nullable
        ActionType getWhomToBlame() {
            ActionType guilty = ActionType.PARSING;
            if (this.compilerDiagsState.isDone()) {
                guilty = ActionType.HIGHLIGHTINGS;
                if (this.highlightingsState.isDone()) {
                    guilty = ActionType.COMPLETION_CACHE;
                    if (this.completionCacheState.isDone()) {
                        guilty = ActionType.DFA_INPUT;
                        if (this.DFAInputState.isDone()) {
                            guilty = ActionType.NAMEHINTS;
                            if (this.namehintsState.isDone()) {
                                guilty = ActionType.CLION_CLANG_TIDY;
                                if (this.CLionClangTidyState.isDone()) {
                                    guilty = ActionType.CLAZY;
                                    if (this.clazyState.isDone()) {
                                        guilty = ActionType.CLANG_TIDY;
                                        if (this.clangTidyState.isDone()) {
                                            guilty = null;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return guilty;
        }

        @NlsSafe
        @NotNull
        String displayText() {
            String string = this.uri + ", compilerDiags=" + this.stateText(this.compilerDiagsState) + ", highlightings=" + this.stateText(this.highlightingsState) + ", DFAInput=" + this.stateText(this.DFAInputState) + ", Namehints=" + this.stateText(this.namehintsState) + ", CLion-clang-tidy=" + this.stateText(this.CLionClangTidyState) + ", Clazy=" + this.stateText(this.clazyState) + ", clang-tidy=" + this.stateText(this.clangTidyState);
            if (string == null) {
                PendingParse.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NlsSafe
        @NotNull
        String stateText(@NotNull CompletableFuture<ResultState> state) {
            String string;
            if (state == null) {
                PendingParse.$$$reportNull$$$0(3);
            }
            if (!state.isDone()) {
                return "WAITING";
            }
            try {
                string = state.get().name();
            }
            catch (Throwable throwable) {
                return "EXCEPTION?";
            }
            if (string == null) {
                PendingParse.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static boolean waitForCompilerDiags(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(5);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForHighlightings(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(6);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics();
        }

        private static boolean waitForCompletionCache(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(7);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && (params.getGlobalCompletionCacheParams() == null || params.getGlobalCompletionCacheParams().getEnabled());
        }

        private static boolean waitForDFAInputState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(8);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getDFAOptions() != null;
        }

        private static boolean waitForNamehintsState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(9);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangNamehintOptions() != null && params.getClangNamehintOptions().isEnableNamehints();
        }

        private static boolean waitForClazyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(10);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClazyOptions() != null;
        }

        private static boolean waitForCLionClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(11);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getClionConfig() != null;
        }

        private static boolean waitForClangTidyState(@NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingParse.$$$reportNull$$$0(12);
            }
            return ClionWantDiagnostics.No.value != params.getWantDiagnostics() && params.getClangTidyOptions() != null && params.getClangTidyOptions().getConfig() != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parses";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "displayText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "stateText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "stateText";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForCompilerDiags";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForHighlightings";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForCompletionCache";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForDFAInputState";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForNamehintsState";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForClazyState";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForCLionClangTidyState";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "waitForClangTidyState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        static enum ActionType {
            PARSING("clangd.crash.reason.parsing", Integer.MAX_VALUE, null),
            HIGHLIGHTINGS("clangd.crash.reason.highlightings", Integer.MAX_VALUE, null),
            COMPLETION_CACHE("clangd.crash.reason.completion.cache", Integer.MAX_VALUE, null),
            DFA_INPUT("clangd.crash.reason.dfa", 2, () -> new ActionDisabler(){
                final List myDisabledClasses = new ArrayList();

                @Override
                public boolean disable(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myDisabledClasses.addAll(OCInspectionUtil.setClangdDFADisabled((Project)project));
                    return !this.myDisabledClasses.isEmpty();
                }

                @Override
                public void enableBack(@NotNull Project project) {
                    if (project == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!this.myDisabledClasses.isEmpty()) {
                        for (Class cls : this.myDisabledClasses) {
                            OCInspectionUtil.setInspectionEnabled((Project)project, (Class)cls, (boolean)true);
                        }
                        this.myDisabledClasses.clear();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "disable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "enableBack";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }),
            NAMEHINTS("clangd.crash.reason.namehints", 2, () -> new ActionDisabler(){

                @Override
                public boolean disable(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (ClangdBridge.getParameterHints(project)) {
                        ClangdBridge.setParameterHints(project, false);
                        return true;
                    }
                    return false;
                }

                @Override
                public void enableBack(@NotNull Project project) {
                    if (project == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    ClangdBridge.setParameterHints(project, true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "disable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "enableBack";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }),
            CLAZY("clangd.crash.reason.clazy", 2, () -> new ActionDisabler(){

                @Override
                public boolean disable(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)false);
                    return true;
                }

                @Override
                public void enableBack(@NotNull Project project) {
                    if (project == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    OCInspectionUtil.setInspectionEnabled((Project)project, ClangdBridge.getClazyInspection(), (boolean)true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType$3";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "disable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "enableBack";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }),
            CLION_CLANG_TIDY("clangd.crash.reason.clion.clang.tidy", 1, () -> new ActionDisabler(){

                @Override
                public boolean disable(@NotNull Project project) {
                    if (project == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                        ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                        return true;
                    }
                    return false;
                }

                @Override
                public void enableBack(@NotNull Project project) {
                    if (project == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType$4";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "disable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "enableBack";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }),
            CLANG_TIDY("clangd.crash.reason.clang.tidy", 1, () -> new ActionDisabler(){

                @Override
                public boolean disable(@NotNull Project project) {
                    if (project == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (ClangdSettings.getInstance(project).isClangTidyViaClangd()) {
                        ClangdSettings.getInstance(project).setClangTidyViaClangd(false);
                        return true;
                    }
                    return false;
                }

                @Override
                public void enableBack(@NotNull Project project) {
                    if (project == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    ClangdSettings.getInstance(project).setClangTidyViaClangd(true);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "project";
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "disable";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "enableBack";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });

            @NonNls
            @NotNull
            final String nameKey;
            final int beforeDisableCrashCount;
            @Nullable
            final Supplier<ActionDisabler> disablerSupplier;

            private ActionType(@Nullable String nameKey, int beforeDisableCrashCount, Supplier<ActionDisabler> disablerSupplier) {
                if (nameKey == null) {
                    ActionType.$$$reportNull$$$0(0);
                }
                this.nameKey = nameKey;
                this.beforeDisableCrashCount = beforeDisableCrashCount;
                this.disablerSupplier = disablerSupplier;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameKey", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingParse$ActionType", "<init>"));
            }
        }

        static interface ActionDisabler {
            public boolean disable(@NotNull Project var1);

            public void enableBack(@NotNull Project var1);
        }

        static enum ResultState {
            ARRIVED,
            NOT_REQUESTED;

        }
    }

    private static class AbstractPending {
        public final int cookie;

        private AbstractPending(int cookie) {
            this.cookie = cookie;
        }

        boolean before(@NotNull AbstractPending other) {
            if (other == null) {
                AbstractPending.$$$reportNull$$$0(0);
            }
            return this.cookie < other.cookie;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$AbstractPending", "before"));
        }
    }

    private static class PendingInteractions {
        private static final int MAX_PENDING_SIZE = 1024;
        @NotNull
        private final Object myLock = new Object();
        @NotNull
        private final Map<String, SortedMap<Integer, PendingParse>> myPendingParses = new HashMap<String, SortedMap<Integer, PendingParse>>();
        @NotNull
        private final IdentityHashMap<CompletableFuture<?>, PendingRequest> myPendingRequests = new IdentityHashMap();
        private int myMaxPendingParsesNumber = 0;
        private int myMaxPendingRequestsNumber = 0;
        private int myPendingParsesNumber = 0;

        private PendingInteractions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addPendingParse(int cookie, @NotNull ClionReparseTextDocumentParams params) {
            if (params == null) {
                PendingInteractions.$$$reportNull$$$0(0);
            }
            String uri = params.getTextDocument().getUri();
            int version = params.getTextDocument().getVersion();
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.computeIfAbsent(uri, u -> new TreeMap());
                if (subMap.size() > 1024) {
                    LOG.warn("Blacklist: too many pending parses to track, clearing now.\nThe first request: " + ((PendingParse)subMap.values().iterator().next()).displayText());
                    subMap.clear();
                    this.myPendingParsesNumber = this.myPendingParses.values().stream().map(versions -> versions.size()).reduce(0, Integer::sum);
                }
                if (subMap.put(version, new PendingParse(cookie, this, params)) == null) {
                    ++this.myPendingParsesNumber;
                }
                this.myMaxPendingParsesNumber = Math.max(this.myMaxPendingParsesNumber, subMap.size());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removePendingParse(@NotNull String uri, int version) {
            if (uri == null) {
                PendingInteractions.$$$reportNull$$$0(1);
            }
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.get(uri);
                if (subMap != null && subMap.remove(version) != null) {
                    --this.myPendingParsesNumber;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        PendingParse findPendingParse(@NotNull String uri, int version) {
            if (uri == null) {
                PendingInteractions.$$$reportNull$$$0(2);
            }
            Object object = this.myLock;
            synchronized (object) {
                Map subMap = this.myPendingParses.get(uri);
                return subMap != null ? (PendingParse)subMap.get(version) : null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean empty() {
            Object object = this.myLock;
            synchronized (object) {
                assert (this.myPendingParsesNumber >= 0) : "Pending parses number < 0?";
                return this.myPendingRequests.isEmpty() && this.myPendingParsesNumber == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAndClear(@NotNull BiConsumer<Map<String, SortedMap<Integer, PendingParse>>, Map<CompletableFuture<?>, PendingRequest>> consumer) {
            ArrayList pendingFutures;
            if (consumer == null) {
                PendingInteractions.$$$reportNull$$$0(3);
            }
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                consumer.accept(this.myPendingParses, this.myPendingRequests);
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            ArrayList pendingFutures;
            Iterator iterator = this.myLock;
            synchronized (iterator) {
                pendingFutures = new ArrayList(this.myPendingRequests.keySet());
                this.myPendingParses.clear();
                this.myPendingRequests.clear();
                this.myPendingParsesNumber = 0;
            }
            for (CompletableFuture completableFuture : pendingFutures) {
                completableFuture.complete(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> CompletableFuture<T> trackFuture(@NotNull CompletableFuture<T> response, @NotNull PendingRequest request) {
            if (response == null) {
                PendingInteractions.$$$reportNull$$$0(4);
            }
            if (request == null) {
                PendingInteractions.$$$reportNull$$$0(5);
            }
            boolean warnThresholdExceeded = false;
            Object object = this.myLock;
            synchronized (object) {
                if (this.myPendingRequests.size() >= 4096) {
                    warnThresholdExceeded = true;
                    this.myPendingRequests.clear();
                }
                this.myPendingRequests.put(response, request);
                this.myMaxPendingRequestsNumber = Math.max(this.myMaxPendingRequestsNumber, this.myPendingRequests.size());
            }
            response.whenComplete((res, ex) -> {
                Object object = this.myLock;
                synchronized (object) {
                    this.myPendingRequests.remove(response);
                }
            });
            if (warnThresholdExceeded) {
                LOG.warn("Exceeded amount of tracked requests (4096), clearing pending requests");
            }
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @NonNls
        @NotNull
        String printStats(@NonNls @NotNull String linePrefix) {
            if (linePrefix == null) {
                PendingInteractions.$$$reportNull$$$0(6);
            }
            Object object = this.myLock;
            // MONITORENTER : object
            String string = linePrefix + "seen files number = " + this.myPendingParses.size() + "\n" + linePrefix + "pending files number = " + this.myPendingParses.values().stream().filter(versions -> !versions.isEmpty()).count() + "\n" + linePrefix + "max pending versions number = " + this.myMaxPendingParsesNumber + "\n" + linePrefix + "pending requests number = " + this.myPendingRequests.size() + "\n" + linePrefix + "max pending requests number = " + this.myMaxPendingRequestsNumber + "\n";
            // MONITOREXIT : object
            if (string != null) return string;
            PendingInteractions.$$$reportNull$$$0(7);
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uri";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "response";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linePrefix";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingInteractions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$PendingInteractions";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "printStats";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addPendingParse";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "removePendingParse";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "findPendingParse";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "runAndClear";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "trackFuture";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "printStats";
                    break;
                }
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class BannedNotification
    extends Notification {
        private BannedNotification(@NotNull List<String> banned) {
            if (banned == null) {
                BannedNotification.$$$reportNull$$$0(0);
            }
            super("System Messages", ClangdBundle.message("language.cpp.clangd.blacklist.title", new Object[0]), ClangdBundle.message("language.cpp.clangd.blacklist.description", banned), NotificationType.INFORMATION);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "banned", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$BannedNotification", "<init>"));
        }
    }

    private class ClangClientSpy
    extends ClangClientAdapter {
        ClangClientSpy(ClangClient delegate) {
            if (delegate == null) {
                ClangClientSpy.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        public void clionPublishDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(1);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.compilerDiagsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishHighlightings(@NotNull ClionPublishHighlightingsParams highlightings) {
            PendingParse pendingParse;
            if (highlightings == null) {
                ClangClientSpy.$$$reportNull$$$0(2);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(highlightings.getUri(), highlightings.getVersion())) != null) {
                pendingParse.highlightingsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishHighlightings(highlightings);
        }

        @Override
        public void clionPublishDFAInput(@NotNull ClionPublishDFAInputsParams input) {
            PendingParse pendingParse;
            if (input == null) {
                ClangClientSpy.$$$reportNull$$$0(3);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(input.getUri(), input.getVersion())) != null) {
                pendingParse.DFAInputState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishDFAInput(input);
        }

        @Override
        public void clionPublishNamehints(@NotNull ClionPublishNamehintParams nameHints) {
            PendingParse pendingParse;
            if (nameHints == null) {
                ClangClientSpy.$$$reportNull$$$0(4);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(nameHints.getUri(), nameHints.getVersion())) != null) {
                pendingParse.namehintsState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishNamehints(nameHints);
        }

        @Override
        public void clionPublishOurTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(5);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.CLionClangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishOurTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishTidyDiagnostics(@NotNull ClionPublishTidyDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(6);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.clangTidyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishTidyDiagnostics(diagnostics);
        }

        @Override
        public void clionPublishClazyDiagnostics(@NotNull ClionPublishDiagnosticsParams diagnostics) {
            PendingParse pendingParse;
            if (diagnostics == null) {
                ClangClientSpy.$$$reportNull$$$0(7);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(diagnostics.getUri(), diagnostics.getVersion())) != null) {
                pendingParse.clazyState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionPublishClazyDiagnostics(diagnostics);
        }

        @Override
        public void clionCompletionCacheReady(@NotNull CLionCompletionCacheReadyParams params) {
            PendingParse pendingParse;
            if (params == null) {
                ClangClientSpy.$$$reportNull$$$0(8);
            }
            if ((pendingParse = ClangCrashHandler.this.myPendingInteractions.findPendingParse(params.getUri(), params.getVersion())) != null) {
                pendingParse.completionCacheState.complete(PendingParse.ResultState.ARRIVED);
            }
            super.clionCompletionCacheReady(params);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnostics";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "highlightings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameHints";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "params";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangClientSpy";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishDiagnostics";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishHighlightings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishDFAInput";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishNamehints";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishOurTidyDiagnostics";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishTidyDiagnostics";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionPublishClazyDiagnostics";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "clionCompletionCacheReady";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ClangServerSpy
    extends ClangServerAdapter {
        @NotNull
        private final TextDocumentServiceSpy myTextDocumentService;

        ClangServerSpy(ClangServer delegate) {
            if (delegate == null) {
                ClangServerSpy.$$$reportNull$$$0(0);
            }
            super(delegate);
            this.myTextDocumentService = new TextDocumentServiceSpy(delegate.getTextDocumentService());
        }

        @Override
        public void clionReparse(ClionReparseTextDocumentParams params) {
            ClangCrashHandler.this.myPendingInteractions.addPendingParse(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), params);
            super.clionReparse(params);
        }

        @Override
        public void clionCancelParse(ClionCancelParseParams params) {
            assert (params != null);
            String uri = params.getUri();
            int version = params.getVersion();
            ClangCrashHandler.this.myPendingInteractions.removePendingParse(uri, version);
            super.clionCancelParse(params);
        }

        @Override
        @NotNull
        public CompletableFuture<List<? extends SymbolInformation>> clionDefinition(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(1);
            }
            CompletableFuture<List<? extends SymbolInformation>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDefinition(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DEFINITION, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpAST(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(3);
            }
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpAST(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_AST, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(4);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<CLionSymbolInformation>> clionWorkspaceSymbol(@Nullable CLionWorkspaceSymbolParams params) {
            CompletableFuture<List<CLionSymbolInformation>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionWorkspaceSymbol(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLION_SYMBOL, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(5);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionDumpTokens(@NotNull TextDocumentPositionParams position) {
            if (position == null) {
                ClangServerSpy.$$$reportNull$$$0(6);
            }
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDumpTokens(position), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_TOKENS, position.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(7);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionMemoryUsageInfo> clionDebugDumpMemoryStat() {
            CompletableFuture<ClionMemoryUsageInfo> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionDebugDumpMemoryStat(), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.DUMP_MEMORY_STAT, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(8);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionPublishDiagnosticsParams> clionCheckPreprocessedCase(@Nullable CLionCheckPreprocessedCaseParams params) {
            CompletableFuture<ClionPublishDiagnosticsParams> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCheckPreprocessedCase(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CHECK_CRASH, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<String> clionClangFormatConfiguration(TextDocumentPositionParams document) {
            CompletableFuture<String> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionClangFormatConfiguration(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.CLANGFORMAT_CONFIG, document.getTextDocument().getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(10);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<ClionFileStats> clionRequestTimingsStat(TextDocumentIdentifier document) {
            CompletableFuture<ClionFileStats> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionRequestTimingsStat(document), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.REQUEST_TIMINGS, document.getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(11);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> clionCompletion(CompletionParams position) {
            CompletableFuture<Either<List<CLionCompletionItem>, CLionCompletionList>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionCompletion(position), new PendingCompletionRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), position));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(12);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<List<ClangCommandLineArgument>> clionParseCommandLine(ClangCommandLine commandLine) {
            CompletableFuture<List<ClangCommandLineArgument>> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionParseCommandLine(commandLine), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PARSE_COMMAND_LINE, null));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(13);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public CompletableFuture<CLionClangPreprocessResult> clionPreprocessFile(@NotNull ClionCompileCommandParams commandLine) {
            if (commandLine == null) {
                ClangServerSpy.$$$reportNull$$$0(14);
            }
            CompletableFuture<CLionClangPreprocessResult> completableFuture = ClangCrashHandler.this.myPendingInteractions.trackFuture(super.clionPreprocessFile(commandLine), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.PREPROCESS, commandLine.getUri()));
            if (completableFuture == null) {
                ClangServerSpy.$$$reportNull$$$0(15);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public TextDocumentService getTextDocumentService() {
            TextDocumentServiceSpy textDocumentServiceSpy = this.myTextDocumentService;
            if (textDocumentServiceSpy == null) {
                ClangServerSpy.$$$reportNull$$$0(16);
            }
            return textDocumentServiceSpy;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: 
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "commandLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDefinition";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDumpAST";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionWorkspaceSymbol";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDumpTokens";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionDebugDumpMemoryStat";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionCheckPreprocessedCase";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionClangFormatConfiguration";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionRequestTimingsStat";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionCompletion";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionParseCommandLine";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "clionPreprocessFile";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTextDocumentService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDefinition";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDumpAST";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "clionDumpTokens";
                    break;
                }
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "clionPreprocessFile";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private final class TextDocumentServiceSpy
        extends TextDocumentServiceAdapter {
            private TextDocumentServiceSpy(TextDocumentService delegate) {
                if (delegate == null) {
                    TextDocumentServiceSpy.$$$reportNull$$$0(0);
                }
                super(delegate);
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.rangeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.RANGE_FORMAT, params.getTextDocument().getUri()));
            }

            @Override
            public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
                return ClangCrashHandler.this.myPendingInteractions.trackFuture(super.onTypeFormatting(params), new PendingRequest(ClangCrashHandler.this.myCookieGenerator.incrementAndGet(), RequestType.ON_TYPE_FORMAT, params.getTextDocument().getUri()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangCrashHandler$ClangServerSpy$TextDocumentServiceSpy", "<init>"));
            }
        }
    }
}

