/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.system.IonReaderBuilder;
import com.amazon.ion.util.IonStreamUtils;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.IExternalSystemSourceType;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.DefaultExternalDependencyId;
import org.jetbrains.plugins.gradle.ExternalDependencyId;
import org.jetbrains.plugins.gradle.model.AbstractExternalDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalFilter;
import org.jetbrains.plugins.gradle.model.DefaultExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalProject;
import org.jetbrains.plugins.gradle.model.DefaultExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.DefaultExternalSourceSet;
import org.jetbrains.plugins.gradle.model.DefaultExternalTask;
import org.jetbrains.plugins.gradle.model.DefaultFileCollectionDependency;
import org.jetbrains.plugins.gradle.model.DefaultUnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalDependency;
import org.jetbrains.plugins.gradle.model.ExternalFilter;
import org.jetbrains.plugins.gradle.model.ExternalLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalMultiLibraryDependency;
import org.jetbrains.plugins.gradle.model.ExternalProject;
import org.jetbrains.plugins.gradle.model.ExternalProjectDependency;
import org.jetbrains.plugins.gradle.model.ExternalSourceDirectorySet;
import org.jetbrains.plugins.gradle.model.ExternalSourceSet;
import org.jetbrains.plugins.gradle.model.ExternalTask;
import org.jetbrains.plugins.gradle.model.FileCollectionDependency;
import org.jetbrains.plugins.gradle.model.FilePatternSet;
import org.jetbrains.plugins.gradle.model.FilePatternSetImpl;
import org.jetbrains.plugins.gradle.model.UnresolvedExternalDependency;
import org.jetbrains.plugins.gradle.tooling.serialization.SerializationService;
import org.jetbrains.plugins.gradle.tooling.serialization.ToolingStreamApiUtils;
import org.jetbrains.plugins.gradle.tooling.util.IntObjectMap;
import org.jetbrains.plugins.gradle.tooling.util.ObjectCollector;

public final class ExternalProjectSerializationService
implements SerializationService<ExternalProject> {
    private final WriteContext myWriteContext = new WriteContext();
    private final ReadContext myReadContext = new ReadContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] write(ExternalProject project, Class<? extends ExternalProject> modelClazz) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IonWriter writer = ToolingStreamApiUtils.createIonWriter().build((OutputStream)out);
        try {
            ExternalProjectSerializationService.writeProject(writer, this.myWriteContext, project);
        }
        finally {
            writer.close();
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalProject read(byte[] object, Class<? extends ExternalProject> modelClazz) throws IOException {
        IonReader reader = IonReaderBuilder.standard().build(object);
        try {
            DefaultExternalProject defaultExternalProject = ExternalProjectSerializationService.readProject(reader, this.myReadContext);
            return defaultExternalProject;
        }
        finally {
            reader.close();
        }
    }

    public Class<? extends ExternalProject> getModelClass() {
        return ExternalProject.class;
    }

    private static void writeProject(final IonWriter writer, final WriteContext context, final ExternalProject project) throws IOException {
        context.getProjectsCollector().add((Object)project, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"id", (String)project.getId());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"name", (String)project.getName());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"qName", (String)project.getQName());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"description", (String)project.getDescription());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"group", (String)project.getGroup());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"version", (String)project.getVersion());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"sourceCompatibility", (String)project.getSourceCompatibility());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"targetCompatibility", (String)project.getTargetCompatibility());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"projectDir", (String)project.getProjectDir().getPath());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"buildDir", (String)project.getBuildDir().getPath());
                    ToolingStreamApiUtils.writeFile((IonWriter)writer, (String)"buildFile", (File)project.getBuildFile());
                    ExternalProjectSerializationService.writeTasks(writer, project.getTasks());
                    ExternalProjectSerializationService.writeSourceSets(writer, context, project.getSourceSets());
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"artifacts", (Collection)project.getArtifacts());
                    ExternalProjectSerializationService.writeArtifactsByConfiguration(writer, project.getArtifactsByConfiguration());
                    ExternalProjectSerializationService.writeChildProjects(writer, context, project.getChildProjects());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeChildProjects(IonWriter writer, WriteContext context, Map<String, ? extends ExternalProject> projects) throws IOException {
        writer.setFieldName("childProjects");
        writer.stepIn(IonType.LIST);
        for (ExternalProject externalProject : projects.values()) {
            ExternalProjectSerializationService.writeProject(writer, context, externalProject);
        }
        writer.stepOut();
    }

    private static void writeSourceSets(IonWriter writer, WriteContext context, Map<String, ? extends ExternalSourceSet> sets) throws IOException {
        writer.setFieldName("sourceSets");
        writer.stepIn(IonType.LIST);
        for (ExternalSourceSet externalSourceSet : sets.values()) {
            ExternalProjectSerializationService.writeSourceSet(writer, context, externalSourceSet);
        }
        writer.stepOut();
    }

    private static void writeSourceSet(IonWriter writer, WriteContext context, ExternalSourceSet sourceSet) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"name", (String)sourceSet.getName());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"sourceCompatibility", (String)sourceSet.getSourceCompatibility());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"targetCompatibility", (String)sourceSet.getTargetCompatibility());
        ToolingStreamApiUtils.writeBoolean((IonWriter)writer, (String)"isPreview", (boolean)sourceSet.isPreview());
        ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"artifacts", (Collection)sourceSet.getArtifacts());
        ExternalProjectSerializationService.writeDependencies(writer, context, sourceSet.getDependencies());
        ExternalProjectSerializationService.writeSourceDirectorySets(writer, sourceSet.getSources());
        writer.stepOut();
    }

    private static void writeSourceDirectorySets(IonWriter writer, Map<? extends IExternalSystemSourceType, ? extends ExternalSourceDirectorySet> sources) throws IOException {
        writer.setFieldName("sources");
        writer.stepIn(IonType.LIST);
        for (Map.Entry<? extends IExternalSystemSourceType, ? extends ExternalSourceDirectorySet> entry : sources.entrySet()) {
            ExternalProjectSerializationService.writeSourceDirectorySet(writer, entry.getKey(), entry.getValue());
        }
        writer.stepOut();
    }

    private static void writeSourceDirectorySet(IonWriter writer, IExternalSystemSourceType sourceType, ExternalSourceDirectorySet directorySet) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"sourceType", (String)ExternalSystemSourceType.from((IExternalSystemSourceType)sourceType).name());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"name", (String)directorySet.getName());
        ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"srcDirs", (Collection)directorySet.getSrcDirs());
        ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"gradleOutputDirs", (Collection)directorySet.getGradleOutputDirs());
        ToolingStreamApiUtils.writeFile((IonWriter)writer, (String)"outputDir", (File)directorySet.getOutputDir());
        writer.setFieldName("inheritedCompilerOutput");
        writer.writeBool(directorySet.isCompilerOutputPathInherited());
        ExternalProjectSerializationService.writePatterns(writer, directorySet.getPatterns());
        ExternalProjectSerializationService.writeFilters(writer, directorySet.getFilters());
        writer.stepOut();
    }

    private static void writeFilters(IonWriter writer, List<? extends ExternalFilter> filters) throws IOException {
        writer.setFieldName("filters");
        writer.stepIn(IonType.LIST);
        for (ExternalFilter externalFilter : filters) {
            ExternalProjectSerializationService.writeFilter(writer, externalFilter);
        }
        writer.stepOut();
    }

    private static void writeFilter(IonWriter writer, ExternalFilter filter) throws IOException {
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"filterType", (String)filter.getFilterType());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"propertiesAsJsonMap", (String)filter.getPropertiesAsJsonMap());
        writer.stepOut();
    }

    private static void writePatterns(IonWriter writer, FilePatternSet patterns) throws IOException {
        writer.setFieldName("patterns");
        writer.stepIn(IonType.STRUCT);
        writer.setFieldName("includes");
        IonStreamUtils.writeStringList((IonWriter)writer, (String[])patterns.getIncludes().toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        writer.setFieldName("excludes");
        IonStreamUtils.writeStringList((IonWriter)writer, (String[])patterns.getExcludes().toArray(ArrayUtilRt.EMPTY_STRING_ARRAY));
        writer.stepOut();
    }

    private static void writeDependencies(IonWriter writer, WriteContext context, Collection<ExternalDependency> dependencies) throws IOException {
        writer.setFieldName("dependencies");
        writer.stepIn(IonType.LIST);
        for (ExternalDependency dependency : dependencies) {
            ExternalProjectSerializationService.writeDependency(writer, context, dependency);
        }
        writer.stepOut();
    }

    static void writeDependency(IonWriter writer, WriteContext context, ExternalDependency dependency) throws IOException {
        if (dependency instanceof ExternalLibraryDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalLibraryDependency)dependency);
        } else if (dependency instanceof ExternalMultiLibraryDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalMultiLibraryDependency)dependency);
        } else if (dependency instanceof ExternalProjectDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (ExternalProjectDependency)dependency);
        } else if (dependency instanceof FileCollectionDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (FileCollectionDependency)dependency);
        } else if (dependency instanceof UnresolvedExternalDependency) {
            ExternalProjectSerializationService.writeDependency(writer, context, (UnresolvedExternalDependency)dependency);
        }
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalLibraryDependency dependency) throws IOException {
        context.getDependenciesCollector().add((Object)dependency, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalLibraryDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFile((IonWriter)writer, (String)"file", (File)dependency.getFile());
                    ToolingStreamApiUtils.writeFile((IonWriter)writer, (String)"source", (File)dependency.getSource());
                    ToolingStreamApiUtils.writeFile((IonWriter)writer, (String)"javadoc", (File)dependency.getJavadoc());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalMultiLibraryDependency dependency) throws IOException {
        context.getDependenciesCollector().add((Object)dependency, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalMultiLibraryDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"files", (Collection)dependency.getFiles());
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"sources", (Collection)dependency.getSources());
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"javadocs", (Collection)dependency.getJavadoc());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final ExternalProjectDependency dependency) throws IOException {
        context.getDependenciesCollector().add((Object)dependency, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(ExternalProjectDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"projectPath", (String)dependency.getProjectPath());
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"configurationName", (String)dependency.getConfigurationName());
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"projectDependencyArtifacts", (Collection)dependency.getProjectDependencyArtifacts());
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"projectDependencyArtifactsSources", (Collection)dependency.getProjectDependencyArtifactsSources());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final FileCollectionDependency dependency) throws IOException {
        context.getDependenciesCollector().add((Object)dependency, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(FileCollectionDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"files", (Collection)dependency.getFiles());
                    if (dependency instanceof DefaultFileCollectionDependency) {
                        ToolingStreamApiUtils.writeBoolean((IonWriter)writer, (String)"excludedFromIndexing", (boolean)((DefaultFileCollectionDependency)dependency).isExcludedFromIndexing());
                    }
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependency(final IonWriter writer, final WriteContext context, final UnresolvedExternalDependency dependency) throws IOException {
        context.getDependenciesCollector().add((Object)dependency, (ObjectCollector.Processor)new ObjectCollector.Processor<IOException>(){

            public void process(boolean isAdded, int objectId) throws IOException {
                writer.stepIn(IonType.STRUCT);
                writer.setFieldName("objectID");
                writer.writeInt((long)objectId);
                if (isAdded) {
                    writer.setFieldName("_type");
                    writer.writeString(UnresolvedExternalDependency.class.getSimpleName());
                    ExternalProjectSerializationService.writeDependencyCommonFields(writer, context, (ExternalDependency)dependency);
                    ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"failureMessage", (String)dependency.getFailureMessage());
                }
                writer.stepOut();
            }
        });
    }

    private static void writeDependencyCommonFields(IonWriter writer, WriteContext context, ExternalDependency dependency) throws IOException {
        ExternalDependencyId id = dependency.getId();
        writer.setFieldName("id");
        writer.stepIn(IonType.STRUCT);
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"group", (String)id.getGroup());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"name", (String)id.getName());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"version", (String)id.getVersion());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"packaging", (String)id.getPackaging());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"classifier", (String)id.getClassifier());
        writer.stepOut();
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"scope", (String)dependency.getScope());
        ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"selectionReason", (String)dependency.getSelectionReason());
        writer.setFieldName("classpathOrder");
        writer.writeInt((long)dependency.getClasspathOrder());
        writer.setFieldName("exported");
        writer.writeBool(dependency.getExported());
        ExternalProjectSerializationService.writeDependencies(writer, context, dependency.getDependencies());
    }

    private static void writeTasks(IonWriter writer, Map<String, ? extends ExternalTask> tasks) throws IOException {
        writer.setFieldName("tasks");
        writer.stepIn(IonType.LIST);
        for (ExternalTask externalTask : tasks.values()) {
            writer.stepIn(IonType.STRUCT);
            ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"name", (String)externalTask.getName());
            ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"qName", (String)externalTask.getQName());
            ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"description", (String)externalTask.getDescription());
            ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"group", (String)externalTask.getGroup());
            ToolingStreamApiUtils.writeString((IonWriter)writer, (String)"type", (String)externalTask.getType());
            writer.setFieldName("isTest");
            writer.writeBool(externalTask.isTest());
            writer.stepOut();
        }
        writer.stepOut();
    }

    private static void writeArtifactsByConfiguration(final IonWriter writer, Map<String, Set<File>> configuration) throws IOException {
        ToolingStreamApiUtils.writeMap((IonWriter)writer, (String)"artifactsByConfiguration", configuration, (ThrowableConsumer)new ThrowableConsumer<String, IOException>(){

            public void consume(String s) throws IOException {
                writer.writeString(s);
            }
        }, (ThrowableConsumer)new ThrowableConsumer<Set<File>, IOException>(){

            public void consume(Set<File> files) throws IOException {
                ToolingStreamApiUtils.writeFiles((IonWriter)writer, (String)"value", files);
            }
        });
    }

    @Nullable
    private static DefaultExternalProject readProject(final @NotNull IonReader reader, final @NotNull ReadContext context) {
        if (reader == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(1);
        }
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalProject project = (DefaultExternalProject)context.getProjectsMap().computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<DefaultExternalProject>(){

            public DefaultExternalProject newInstance() {
                return new DefaultExternalProject();
            }

            public void fill(DefaultExternalProject externalProject) {
                File buildFile;
                File buildDir;
                externalProject.setExternalSystemId("GRADLE");
                externalProject.setId((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"id")));
                externalProject.setName((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"name")));
                externalProject.setQName((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"qName")));
                externalProject.setDescription(ToolingStreamApiUtils.readString((IonReader)reader, (String)"description"));
                externalProject.setGroup((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"group")));
                externalProject.setVersion((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"version")));
                externalProject.setSourceCompatibility(ToolingStreamApiUtils.readString((IonReader)reader, (String)"sourceCompatibility"));
                externalProject.setTargetCompatibility(ToolingStreamApiUtils.readString((IonReader)reader, (String)"targetCompatibility"));
                File projectDir = ToolingStreamApiUtils.readFile((IonReader)reader, (String)"projectDir");
                if (projectDir != null) {
                    externalProject.setProjectDir(projectDir);
                }
                if ((buildDir = ToolingStreamApiUtils.readFile((IonReader)reader, (String)"buildDir")) != null) {
                    externalProject.setBuildDir(buildDir);
                }
                if ((buildFile = ToolingStreamApiUtils.readFile((IonReader)reader, (String)"buildFile")) != null) {
                    externalProject.setBuildFile(buildFile);
                }
                ExternalProjectSerializationService.readTasks(reader, externalProject);
                ExternalProjectSerializationService.readSourceSets(reader, context, externalProject);
                externalProject.setArtifacts(ToolingStreamApiUtils.readFiles((IonReader)reader));
                externalProject.setArtifactsByConfiguration(ToolingStreamApiUtils.readStringToFileSetMap((IonReader)reader));
                externalProject.setChildProjects(ExternalProjectSerializationService.readProjects(reader, context));
            }
        });
        reader.stepOut();
        return project;
    }

    private static Map<String, DefaultExternalProject> readProjects(@NotNull IonReader reader, @NotNull ReadContext context) {
        DefaultExternalProject project;
        if (reader == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(2);
        }
        if (context == null) {
            ExternalProjectSerializationService.$$$reportNull$$$0(3);
        }
        TreeMap<String, DefaultExternalProject> map = new TreeMap<String, DefaultExternalProject>();
        reader.next();
        reader.stepIn();
        while ((project = ExternalProjectSerializationService.readProject(reader, context)) != null) {
            map.put(project.getName(), project);
        }
        reader.stepOut();
        return map;
    }

    private static void readTasks(IonReader reader, DefaultExternalProject project) {
        DefaultExternalTask task;
        reader.next();
        reader.stepIn();
        HashMap<String, DefaultExternalTask> tasks = new HashMap<String, DefaultExternalTask>();
        while ((task = ExternalProjectSerializationService.readTask(reader)) != null) {
            tasks.put(task.getName(), task);
        }
        project.setTasks(tasks);
        reader.stepOut();
    }

    @Nullable
    private static DefaultExternalTask readTask(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalTask task = new DefaultExternalTask();
        task.setName((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"name")));
        task.setQName((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"qName")));
        task.setDescription(ToolingStreamApiUtils.readString((IonReader)reader, (String)"description"));
        task.setGroup(ToolingStreamApiUtils.readString((IonReader)reader, (String)"group"));
        task.setType(ToolingStreamApiUtils.readString((IonReader)reader, (String)"type"));
        task.setTest(ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"isTest"));
        reader.stepOut();
        return task;
    }

    private static void readSourceSets(IonReader reader, ReadContext context, DefaultExternalProject project) {
        DefaultExternalSourceSet sourceSet;
        reader.next();
        reader.stepIn();
        HashMap<String, DefaultExternalSourceSet> sourceSets = new HashMap<String, DefaultExternalSourceSet>();
        while ((sourceSet = ExternalProjectSerializationService.readSourceSet(reader, context)) != null) {
            sourceSets.put(sourceSet.getName(), sourceSet);
        }
        project.setSourceSets(sourceSets);
        reader.stepOut();
    }

    @Nullable
    private static DefaultExternalSourceSet readSourceSet(IonReader reader, ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        DefaultExternalSourceSet sourceSet = new DefaultExternalSourceSet();
        sourceSet.setName(ToolingStreamApiUtils.readString((IonReader)reader, (String)"name"));
        sourceSet.setSourceCompatibility(ToolingStreamApiUtils.readString((IonReader)reader, (String)"sourceCompatibility"));
        sourceSet.setTargetCompatibility(ToolingStreamApiUtils.readString((IonReader)reader, (String)"targetCompatibility"));
        sourceSet.setPreview(ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"isPreview"));
        sourceSet.setArtifacts(ToolingStreamApiUtils.readFiles((IonReader)reader));
        sourceSet.getDependencies().addAll(ExternalProjectSerializationService.readDependencies(reader, context));
        sourceSet.setSources(ExternalProjectSerializationService.readSourceDirectorySets(reader));
        reader.stepOut();
        return sourceSet;
    }

    private static Map<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> readSourceDirectorySets(IonReader reader) {
        Map.Entry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> entry;
        reader.next();
        reader.stepIn();
        HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> map = new HashMap<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>();
        while ((entry = ExternalProjectSerializationService.readSourceDirectorySet(reader)) != null) {
            map.put(entry.getKey(), entry.getValue());
        }
        reader.stepOut();
        return map;
    }

    @Nullable
    private static Map.Entry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet> readSourceDirectorySet(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalSystemSourceType sourceType = ExternalSystemSourceType.valueOf((String)((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"sourceType"))));
        DefaultExternalSourceDirectorySet directorySet = new DefaultExternalSourceDirectorySet();
        directorySet.setName((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"name")));
        directorySet.setSrcDirs(ToolingStreamApiUtils.readFilesSet((IonReader)reader));
        directorySet.getGradleOutputDirs().addAll(ToolingStreamApiUtils.readFiles((IonReader)reader));
        File outputDir = ToolingStreamApiUtils.readFile((IonReader)reader, (String)"outputDir");
        if (outputDir != null) {
            directorySet.setOutputDir(outputDir);
        }
        directorySet.setInheritedCompilerOutput(ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"inheritedCompilerOutput"));
        FilePatternSet patternSet = ExternalProjectSerializationService.readFilePattern(reader);
        directorySet.setExcludes(patternSet.getExcludes());
        directorySet.setIncludes(patternSet.getIncludes());
        directorySet.setFilters(ExternalProjectSerializationService.readFilters(reader));
        reader.stepOut();
        return new AbstractMap.SimpleEntry<ExternalSystemSourceType, DefaultExternalSourceDirectorySet>(sourceType, directorySet);
    }

    private static List<DefaultExternalFilter> readFilters(IonReader reader) {
        DefaultExternalFilter filter;
        reader.next();
        reader.stepIn();
        ArrayList<DefaultExternalFilter> list = new ArrayList<DefaultExternalFilter>();
        while ((filter = ExternalProjectSerializationService.readFilter(reader)) != null) {
            list.add(filter);
        }
        reader.stepOut();
        return list;
    }

    @Nullable
    private static DefaultExternalFilter readFilter(IonReader reader) {
        if (reader.next() == null) {
            return null;
        }
        DefaultExternalFilter filter = new DefaultExternalFilter();
        reader.stepIn();
        filter.setFilterType((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"filterType")));
        filter.setPropertiesAsJsonMap((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"propertiesAsJsonMap")));
        reader.stepOut();
        return filter;
    }

    private static FilePatternSet readFilePattern(IonReader reader) {
        reader.next();
        reader.stepIn();
        FilePatternSetImpl patternSet = new FilePatternSetImpl();
        patternSet.setIncludes(ToolingStreamApiUtils.readStringSet((IonReader)reader));
        patternSet.setExcludes(ToolingStreamApiUtils.readStringSet((IonReader)reader));
        reader.stepOut();
        return patternSet;
    }

    private static Collection<? extends ExternalDependency> readDependencies(IonReader reader, ReadContext context) {
        ExternalDependency dependency;
        ArrayList<ExternalDependency> dependencies = new ArrayList<ExternalDependency>();
        reader.next();
        reader.stepIn();
        while ((dependency = ExternalProjectSerializationService.readDependency(reader, context)) != null) {
            dependencies.add(dependency);
        }
        reader.stepOut();
        return dependencies;
    }

    static ExternalDependency readDependency(final IonReader reader, final ReadContext context) {
        if (reader.next() == null) {
            return null;
        }
        reader.stepIn();
        ExternalDependency dependency = (ExternalDependency)context.getDependenciesMap().computeIfAbsent(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"objectID"), (IntObjectMap.ObjectFactory)new IntObjectMap.ObjectFactory<AbstractExternalDependency>(){

            public AbstractExternalDependency newInstance() {
                String type = ToolingStreamApiUtils.readString((IonReader)reader, (String)"_type");
                if (ExternalLibraryDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalLibraryDependency();
                }
                if (ExternalMultiLibraryDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalMultiLibraryDependency();
                }
                if (ExternalProjectDependency.class.getSimpleName().equals(type)) {
                    return new DefaultExternalProjectDependency();
                }
                if (FileCollectionDependency.class.getSimpleName().equals(type)) {
                    return new DefaultFileCollectionDependency();
                }
                if (UnresolvedExternalDependency.class.getSimpleName().equals(type)) {
                    return new DefaultUnresolvedExternalDependency();
                }
                throw new RuntimeException("Unsupported dependency");
            }

            public void fill(AbstractExternalDependency externalDependency) {
                ExternalProjectSerializationService.readDependencyCommonFields(reader, context, externalDependency);
                if (externalDependency instanceof DefaultExternalLibraryDependency) {
                    DefaultExternalLibraryDependency libraryDependency = (DefaultExternalLibraryDependency)externalDependency;
                    libraryDependency.setFile(ToolingStreamApiUtils.readFile((IonReader)reader, (String)"file"));
                    libraryDependency.setSource(ToolingStreamApiUtils.readFile((IonReader)reader, (String)"source"));
                    libraryDependency.setJavadoc(ToolingStreamApiUtils.readFile((IonReader)reader, (String)"javadoc"));
                } else if (externalDependency instanceof DefaultExternalMultiLibraryDependency) {
                    DefaultExternalMultiLibraryDependency multiLibraryDependency = (DefaultExternalMultiLibraryDependency)externalDependency;
                    multiLibraryDependency.getFiles().addAll(ToolingStreamApiUtils.readFiles((IonReader)reader));
                    multiLibraryDependency.getSources().addAll(ToolingStreamApiUtils.readFiles((IonReader)reader));
                    multiLibraryDependency.getJavadoc().addAll(ToolingStreamApiUtils.readFiles((IonReader)reader));
                } else if (externalDependency instanceof DefaultExternalProjectDependency) {
                    DefaultExternalProjectDependency projectDependency = (DefaultExternalProjectDependency)externalDependency;
                    projectDependency.setProjectPath(ToolingStreamApiUtils.readString((IonReader)reader, (String)"projectPath"));
                    projectDependency.setConfigurationName(ToolingStreamApiUtils.readString((IonReader)reader, (String)"configurationName"));
                    projectDependency.setProjectDependencyArtifacts(ToolingStreamApiUtils.readFiles((IonReader)reader));
                    projectDependency.setProjectDependencyArtifactsSources(ToolingStreamApiUtils.readFiles((IonReader)reader));
                } else if (externalDependency instanceof DefaultFileCollectionDependency) {
                    DefaultFileCollectionDependency fileCollectionDependency = (DefaultFileCollectionDependency)externalDependency;
                    fileCollectionDependency.getFiles().addAll(ToolingStreamApiUtils.readFiles((IonReader)reader));
                    fileCollectionDependency.setExcludedFromIndexing(ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"excludedFromIndexing"));
                } else if (externalDependency instanceof DefaultUnresolvedExternalDependency) {
                    DefaultUnresolvedExternalDependency unresolvedExternalDependency = (DefaultUnresolvedExternalDependency)externalDependency;
                    unresolvedExternalDependency.setFailureMessage(ToolingStreamApiUtils.readString((IonReader)reader, (String)"failureMessage"));
                } else {
                    throw new RuntimeException("Unsupported dependency type: " + externalDependency.getClass().getName());
                }
            }
        });
        reader.stepOut();
        return dependency;
    }

    private static void readDependencyCommonFields(IonReader reader, ReadContext context, AbstractExternalDependency dependency) {
        ExternalProjectSerializationService.readDependencyId(reader, dependency);
        dependency.setScope(ToolingStreamApiUtils.readString((IonReader)reader, (String)"scope"));
        dependency.setSelectionReason(ToolingStreamApiUtils.readString((IonReader)reader, (String)"selectionReason"));
        dependency.setClasspathOrder(ToolingStreamApiUtils.readInt((IonReader)reader, (String)"classpathOrder"));
        dependency.setExported(ToolingStreamApiUtils.readBoolean((IonReader)reader, (String)"exported"));
        dependency.getDependencies().addAll(ExternalProjectSerializationService.readDependencies(reader, context));
    }

    private static void readDependencyId(IonReader reader, AbstractExternalDependency dependency) {
        DefaultExternalDependencyId id = (DefaultExternalDependencyId)dependency.getId();
        reader.next();
        ToolingStreamApiUtils.assertFieldName((IonReader)reader, (String)"id");
        reader.stepIn();
        id.setGroup(ToolingStreamApiUtils.readString((IonReader)reader, (String)"group"));
        id.setName(ToolingStreamApiUtils.readString((IonReader)reader, (String)"name"));
        id.setVersion(ToolingStreamApiUtils.readString((IonReader)reader, (String)"version"));
        id.setPackaging((String)ToolingStreamApiUtils.assertNotNull((Object)ToolingStreamApiUtils.readString((IonReader)reader, (String)"packaging")));
        id.setClassifier(ToolingStreamApiUtils.readString((IonReader)reader, (String)"classifier"));
        reader.stepOut();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/gradle/tooling/serialization/ExternalProjectSerializationService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readProject";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "readProjects";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WriteContext {
        private final ObjectCollector<ExternalProject, IOException> myProjectsCollector = new ObjectCollector();
        private final ObjectCollector<ExternalDependency, IOException> myDependenciesCollector = new ObjectCollector();

        public ObjectCollector<ExternalProject, IOException> getProjectsCollector() {
            return this.myProjectsCollector;
        }

        public ObjectCollector<ExternalDependency, IOException> getDependenciesCollector() {
            return this.myDependenciesCollector;
        }
    }

    public static class ReadContext {
        private final IntObjectMap<DefaultExternalProject> myProjectsMap = new IntObjectMap();
        private final IntObjectMap<AbstractExternalDependency> myDependenciesMap = new IntObjectMap();

        public IntObjectMap<DefaultExternalProject> getProjectsMap() {
            return this.myProjectsMap;
        }

        public IntObjectMap<AbstractExternalDependency> getDependenciesMap() {
            return this.myDependenciesMap;
        }
    }
}

