/*
 * Decompiled with CFR 0.152.
 */
package org.coffeescript.refactoring.surround;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.psi.JSTryStatement;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.coffeescript.CsBundle;
import org.coffeescript.refactoring.surround.CoffeeScriptBaseSurrounder;
import org.jetbrains.annotations.NotNull;

public class CoffeeScriptWithTryCatchSurrounder
extends CoffeeScriptBaseSurrounder {
    @Override
    protected String getStatementTemplate(PsiElement context) {
        context.getParent();
        return "try\n  body\ncatch error\n  error_handling_code";
    }

    @Override
    @NotNull
    protected ASTNode getNodeToReplace(ASTNode surroundedNode) {
        JSTryStatement tryStatement = (JSTryStatement)surroundedNode.getPsi();
        ASTNode aSTNode = tryStatement.getStatement().getChildren()[0].getNode();
        if (aSTNode == null) {
            CoffeeScriptWithTryCatchSurrounder.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    @Override
    protected TextRange getSurroundSelectionRange(ASTNode statementNode) {
        JSTryStatement tryStatement = (JSTryStatement)statementNode.getPsi();
        ASTNode errorNode = tryStatement.getAllCatchBlocks()[0].getStatement().getNode();
        int startOffset = errorNode.getStartOffset();
        int endOffset = startOffset + errorNode.getTextLength();
        return new TextRange(startOffset, endOffset);
    }

    public String getTemplateDescription() {
        return CsBundle.message("surrounder.try.catch", new Object[0]);
    }

    public boolean isApplicable(PsiElement @NotNull [] elements) {
        if (elements == null) {
            CoffeeScriptWithTryCatchSurrounder.$$$reportNull$$$0(1);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeToReplace";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/coffeescript/refactoring/surround/CoffeeScriptWithTryCatchSurrounder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

