/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClazyAnnotator;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClazyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection,
OCInspectionBase.CLionClangTidyBasedMarker {
    @NotNull
    @NonNls
    private String myClazyChecks = "level0";

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        if (clangTidyMessage == null) {
            ClazyInspection.$$$reportNull$$$0(0);
        }
        String string = isBatchMode ? clangTidyMessage : OCInspectionsBundle.message((String)"inspection.clazy.message", (Object[])new Object[]{clangTidyMessage});
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.static.analysis", (Object[])new Object[0]);
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.clazy.name", (Object[])new Object[0]);
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        ClangTidyFilesState clangTidyFilesState;
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ClazyInspection.$$$reportNull$$$0(5);
        }
        return !(clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class)).hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        if (clangTidyCheckName == null) {
            ClazyInspection.$$$reportNull$$$0(6);
        }
        String string = clangTidyCheckName;
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static String getInspectionShortName() {
        String string = new ClazyInspection().getShortName();
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(8);
        }
        return string;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(9);
        }
        if (manager == null) {
            ClazyInspection.$$$reportNull$$$0(10);
        }
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        if (file == null) {
            ClazyInspection.$$$reportNull$$$0(11);
        }
        if (context == null) {
            ClazyInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            ClazyInspection.$$$reportNull$$$0(13);
        }
        ClazyAnnotator annotator = new ClazyAnnotator(this);
        ProblemDescriptor[] problemDescriptorArray = ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
        if (problemDescriptorArray == null) {
            ClazyInspection.$$$reportNull$$$0(14);
        }
        return problemDescriptorArray;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClazyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.emptyInsets());
        ClazyInspection.addComponent((Component)ClazyInspection.createChecksExampleLink(), childPanel, 1, 1, 2, 0, 0, (Insets)JBUI.emptyInsets());
        builder.addComponent((JComponent)childPanel);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        if (component == null) {
            ClazyInspection.$$$reportNull$$$0(15);
        }
        if (panel == null) {
            ClazyInspection.$$$reportNull$$$0(16);
        }
        if (insets == null) {
            ClazyInspection.$$$reportNull$$$0(17);
        }
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClazyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ClazyInspection.this.myClazyChecks = checksEditor.getText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/inspections/ClazyInspection$1", "textChanged"));
            }
        });
        RawCommandLineEditor rawCommandLineEditor = checksEditor;
        if (rawCommandLineEditor == null) {
            ClazyInspection.$$$reportNull$$$0(18);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel(OCInspectionsBundle.message((String)"configurable.clazy.checks.link", (Object[])new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://github.com/KDE/clazy#list-of-checks"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        HyperlinkLabel hyperlinkLabel = hint;
        if (hyperlinkLabel == null) {
            ClazyInspection.$$$reportNull$$$0(19);
        }
        return hyperlinkLabel;
    }

    @NotNull
    @NonNls
    public String getClazyChecks() {
        String string = this.myClazyChecks;
        if (string == null) {
            ClazyInspection.$$$reportNull$$$0(20);
        }
        return string;
    }

    public void setClazyChecks(@NotNull @NonNls String checks) {
        if (checks == null) {
            ClazyInspection.$$$reportNull$$$0(21);
        }
        this.myClazyChecks = checks;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClazyInspection";
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckName";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClazyInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionShortName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkFile";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksField";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksExampleLink";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getClazyChecks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "canBeDisabledByClangTidyCheckName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setClazyChecks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 14: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

