/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.editor.CssFormattingModelBuilder;
import com.intellij.psi.css.impl.util.editor.IndentedRulesetBlock;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.stylus.formatter.StylusExpressionStatementBlock;
import org.jetbrains.plugins.stylus.formatter.StylusFormattingUtil;
import org.jetbrains.plugins.stylus.psi.StylusElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusStubElementTypes;
import org.jetbrains.plugins.stylus.psi.StylusTokenTypes;

public class StylusRulesetBlock
extends IndentedRulesetBlock {
    private static final TokenSet ELEMENT_HANDLING_TYPED_ENTER = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RULESET, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_VIEWPORT, StylusStubElementTypes.MIXIN, CssElementTypes.CSS_KEYFRAMES_RULE, StylusElementTypes.FOR_CYCLE, StylusElementTypes.IF_STATEMENT});
    private static final TokenSet INDENTS_CHILDREN = TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RULESET, StylusElementTypes.FOR_CYCLE, CssElementTypes.CSS_MEDIA, CssElementTypes.CSS_SUPPORTS, CssElementTypes.CSS_VIEWPORT, CssElementTypes.CSS_KEYFRAMES_RULE, CssElementTypes.CSS_DECLARATION_BLOCK, StylusStubElementTypes.MIXIN, CssElementTypes.CSS_SIMPLE_SELECTOR, StylusElementTypes.IF_STATEMENT});
    public static final TokenSet DECLARATION_BLOCK_FILTER = TokenSet.create((IElementType[])new IElementType[]{StylusElementTypes.DECLARATION_BLOCK});
    private final TokenSet INDENTED_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{StylusElementTypes.FOR_CYCLE, StylusElementTypes.IF_STATEMENT, StylusStubElementTypes.MIXIN, StylusTokenTypes.ELSE_KEYWORD, StylusElementTypes.SCOPE_STATEMENT});

    public StylusRulesetBlock(ASTNode _node, Indent indent, CssFormattingModelBuilder.CssFormattingExtension extension, @Nullable Alignment alignment) {
        super(_node, indent, extension, alignment);
    }

    protected TokenSet getElementsHandlingEnter() {
        return ELEMENT_HANDLING_TYPED_ENTER;
    }

    protected TokenSet getElementsIndentingChildren() {
        return INDENTS_CHILDREN;
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            StylusRulesetBlock.$$$reportNull$$$0(0);
        }
        if (!(child1 instanceof CssFormattingModelBuilder.CssFormatterBlock) || !(child2 instanceof CssFormattingModelBuilder.CssFormatterBlock)) {
            return super.getSpacing(child1, child2);
        }
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock1 = (CssFormattingModelBuilder.CssFormatterBlock)child1;
        CssFormattingModelBuilder.CssFormatterBlock formatterBlock2 = (CssFormattingModelBuilder.CssFormatterBlock)child2;
        IElementType blockType1 = formatterBlock1.getNode().getElementType();
        IElementType blockType2 = formatterBlock2.getNode().getElementType();
        ASTNode blockParent2 = formatterBlock2.getNode().getTreeParent();
        Spacing slashResult = StylusFormattingUtil.processSlash(formatterBlock1.getNode(), formatterBlock2.getNode());
        if (slashResult != null) {
            return slashResult;
        }
        if (formatterBlock2 instanceof CssFormattingModelBuilder.CssPropertyBlock && !(formatterBlock2 instanceof CssFormattingModelBuilder.CssTermListBlock) && blockParent2.getElementType() != CssElementTypes.CSS_MEDIA_EXPRESSION || formatterBlock2 instanceof CssFormattingModelBuilder.CssMediaBlock) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        if (this.INDENTED_ELEMENTS.contains(blockType2)) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines());
        }
        if (blockType1 == CssElementTypes.CSS_LPAREN || (this.getNode().getElementType() == StylusStubElementTypes.MIXIN || blockType1 == CssElementTypes.CSS_FUNCTION_TOKEN) && blockType2 == CssElementTypes.CSS_LPAREN || blockType2 == CssElementTypes.CSS_RPAREN) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (blockType1 == StylusTokenTypes.SPLAT || blockType2 == StylusTokenTypes.SPLAT) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (blockType1 == CssElementTypes.CSS_PLUS && this.getNode().getElementType() == StylusElementTypes.BLOCK_MIXIN_INVOCATION) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (blockType2 == StylusElementTypes.BLOCK_MIXIN_INVOCATION) {
            return Spacing.createSpacing((int)1, (int)1, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        if (child2 instanceof StylusExpressionStatementBlock) {
            return this.getCustomSettings().KEEP_SINGLE_LINE_BLOCKS ? Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.getKeepBlankLines()) : Spacing.createSpacing((int)2, (int)2, (int)1, (boolean)true, (int)this.getKeepBlankLines());
        }
        return super.getSpacing(child1, child2);
    }

    protected boolean shouldIndentChild() {
        return this.getElementsIndentingChildren().contains(this.getNode().getElementType());
    }

    protected boolean shouldNodeHandleTypedEnter(@NotNull ASTNode node, int typedEnterOffset) {
        ASTNode lastDeclarationBlock;
        ASTNode[] closingBraces;
        ASTNode[] declarationBlocks;
        if (node == null) {
            StylusRulesetBlock.$$$reportNull$$$0(1);
        }
        if ((declarationBlocks = node.getChildren(DECLARATION_BLOCK_FILTER)).length > 0 && (closingBraces = (lastDeclarationBlock = declarationBlocks[declarationBlocks.length - 1]).getChildren(TokenSet.create((IElementType[])new IElementType[]{CssElementTypes.CSS_RBRACE}))).length > 0 && closingBraces[closingBraces.length - 1].getStartOffset() < typedEnterOffset) {
            return false;
        }
        return super.shouldNodeHandleTypedEnter(node, typedEnterOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/stylus/formatter/StylusRulesetBlock";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getSpacing";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldNodeHandleTypedEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

