/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKindContributor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.light.OCLightFileType;
import com.jetbrains.cidr.lang.light.OCSlowLanguage;
import com.jetbrains.cidr.lang.light.psi.OCLightFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageUtils {
    private OCLanguageUtils() {
    }

    private static boolean isLightPsiOn() {
        return false;
    }

    private static boolean assertLightPsiOn(@Nullable Object message) {
        return OCLog.LOG.assertTrue(OCLanguageUtils.isLightPsiOn(), message);
    }

    @NotNull
    public static Language getConfigLanguage() {
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            OCLanguageUtils.$$$reportNull$$$0(0);
        }
        return oCLanguage;
    }

    @NotNull
    public static Language getLightLanguage() {
        OCLanguage oCLanguage = OCLanguage.getInstance();
        if (oCLanguage == null) {
            OCLanguageUtils.$$$reportNull$$$0(1);
        }
        return oCLanguage;
    }

    @NotNull
    public static Language getSlowLanguage() {
        Language language = OCLanguageUtils.isLightPsiOn() ? OCSlowLanguage.getInstance() : OCLanguage.getInstance();
        if (language == null) {
            OCLanguageUtils.$$$reportNull$$$0(2);
        }
        return language;
    }

    @NotNull
    public static FileType getBaseFileType() {
        LanguageFileType languageFileType = OCLanguageUtils.isLightPsiOn() ? OCLightFileType.INSTANCE : OCFileType.INSTANCE;
        if (languageFileType == null) {
            OCLanguageUtils.$$$reportNull$$$0(3);
        }
        return languageFileType;
    }

    public static boolean isSupported(@Nullable Language language) {
        return language == OCLanguageUtils.getSlowLanguage() || language == OCLanguageUtils.getLightLanguage();
    }

    @Contract(value="null -> false")
    public static boolean isSupported(@Nullable PsiFile file) {
        return file instanceof OCFile || file instanceof OCLightFile && OCLanguageUtils.assertLightPsiOn(file);
    }

    public static boolean isSupported(@NotNull VirtualFile virtualFile) {
        FileTypeManager fileTypeManager;
        if (virtualFile == null) {
            OCLanguageUtils.$$$reportNull$$$0(4);
        }
        return (fileTypeManager = FileTypeManager.getInstance()).isFileOfType(virtualFile, (FileType)OCFileType.INSTANCE) || fileTypeManager.isFileOfType(virtualFile, (FileType)OCLightFileType.INSTANCE) && OCLanguageUtils.assertLightPsiOn(virtualFile);
    }

    public static boolean isSupported(@NotNull FileType fileType) {
        if (fileType == null) {
            OCLanguageUtils.$$$reportNull$$$0(5);
        }
        return fileType == OCFileType.INSTANCE || fileType == OCLightFileType.INSTANCE && OCLanguageUtils.assertLightPsiOn(fileType);
    }

    @Contract(value="null -> false")
    public static boolean supportsResolve(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return true;
        }
        return file != null && OCLanguageKindContributor.isSupported(file);
    }

    @Contract(value="null -> null")
    public static OCPsiFile asOCPsiFile(@Nullable PsiFile file) {
        if (file instanceof OCPsiFile) {
            return (OCPsiFile)file;
        }
        return null;
    }

    @Contract(value="_, null -> null")
    public static OCPsiFile asOCPsiFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(6);
        }
        if (file == null) {
            return null;
        }
        return OCLanguageUtils.asOCPsiFile(PsiManager.getInstance((Project)project).findFile(file));
    }

    @Contract(value="null -> null")
    public static OCFile asOCFile(@Nullable PsiFile file) {
        OCPsiFile opf = OCLanguageUtils.asOCPsiFile(file);
        return opf == null ? null : opf.getOCFile();
    }

    @Contract(value="_, null -> null")
    public static OCFile asOCFile(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(7);
        }
        return OCLanguageUtils.asOCFile(OCLanguageUtils.asOCPsiFile(project, file));
    }

    @Contract(value="!null -> !null; null -> null")
    public static PsiFile tryGetOCFile(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile == null ? file : ocFile;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@Nullable PsiFile file) {
        OCFile ocFile = OCLanguageUtils.asOCFile(file);
        return ocFile != null ? ocFile : (OCLanguageUtils.supportsResolve(file) ? file : null);
    }

    @Contract(value="_, null -> null")
    @Nullable
    public static PsiFile asFileWithOCResolve(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            OCLanguageUtils.$$$reportNull$$$0(8);
        }
        return file != null ? OCLanguageUtils.asFileWithOCResolve(PsiManager.getInstance((Project)project).findFile(file)) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCLanguageUtils";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLightLanguage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSlowLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseFileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCLanguageUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isSupported";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "asOCPsiFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "asOCFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "asFileWithOCResolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

