/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInstruction {
    private final InstructionKind myKind;
    private final OCNode myNode;
    @Nullable
    private OCInstruction myAssociatedInstruction;
    @NotNull
    private final OCSymbol mySymbol;
    private final PsiElement myLValue;
    private final PsiElement myRValue;
    private boolean myTransparentRead;

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @NotNull OCSymbol symbol) {
        if (kind == null) {
            OCInstruction.$$$reportNull$$$0(0);
        }
        if (node == null) {
            OCInstruction.$$$reportNull$$$0(1);
        }
        if (symbol == null) {
            OCInstruction.$$$reportNull$$$0(2);
        }
        this(kind, node, lValue, null, symbol);
    }

    OCInstruction(@NotNull InstructionKind kind, @NotNull OCNode node, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @NotNull OCSymbol symbol) {
        if (kind == null) {
            OCInstruction.$$$reportNull$$$0(3);
        }
        if (node == null) {
            OCInstruction.$$$reportNull$$$0(4);
        }
        if (symbol == null) {
            OCInstruction.$$$reportNull$$$0(5);
        }
        this.myKind = kind;
        this.myNode = node;
        this.myLValue = lValue;
        this.mySymbol = symbol;
        this.myRValue = rValue;
    }

    @Nullable
    public PsiElement getLValue() {
        return this.myLValue;
    }

    @Nullable
    public PsiElement getRValue() {
        return this.myRValue;
    }

    @NotNull
    public InstructionKind getKind() {
        InstructionKind instructionKind = this.myKind;
        if (instructionKind == null) {
            OCInstruction.$$$reportNull$$$0(6);
        }
        return instructionKind;
    }

    @NotNull
    public OCNode getNode() {
        OCNode oCNode = this.myNode;
        if (oCNode == null) {
            OCInstruction.$$$reportNull$$$0(7);
        }
        return oCNode;
    }

    @NotNull
    public OCSymbol getSymbol() {
        OCSymbol oCSymbol = this.mySymbol;
        if (oCSymbol == null) {
            OCInstruction.$$$reportNull$$$0(8);
        }
        return oCSymbol;
    }

    public long getSymbolOffset() {
        long offset = this.mySymbol.getComplexOffset();
        return offset != 0L ? offset : (long)this.mySymbol.hashCode();
    }

    public void setAssociatedInstruction(@Nullable OCInstruction associatedInstruction) {
        this.myAssociatedInstruction = associatedInstruction;
    }

    @Nullable
    public OCInstruction getAssociatedInstruction() {
        return this.myAssociatedInstruction;
    }

    public boolean isTransparentRead() {
        return this.myTransparentRead;
    }

    public void setTransparentRead(boolean transparentRead) {
        this.myTransparentRead = transparentRead;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCInstruction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum InstructionKind {
        DECLARATOR,
        READ,
        WRITE,
        KILL,
        REFERENCE,
        READ_IN_BLOCK,
        WRITE_IN_BLOCK;

    }
}

