/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.OCEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class CommentBreakerEnterProcessor
extends SmartEnterProcessorWithFixers.FixEnterProcessor {
    public boolean doEnter(PsiElement atCaret, PsiFile file, @NotNull Editor editor, boolean modified) {
        if (editor == null) {
            CommentBreakerEnterProcessor.$$$reportNull$$$0(0);
        }
        if (modified) {
            return false;
        }
        PsiComment comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)atCaret, PsiComment.class, (boolean)false);
        if (comment != null) {
            this.plainEnter(editor);
            if (comment.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"// ");
                return true;
            }
            SmartEnterProcessor.commitDocument((Editor)editor);
            int offset = editor.getCaretModel().getOffset();
            comment = (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), PsiComment.class, (boolean)false);
            if (comment == null) {
                return true;
            }
            if (!comment.getText().endsWith("*/")) {
                CharSequence text = editor.getDocument().getCharsSequence();
                Object indent = OCEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(editor, offset);
                int curLineIndentEnd = CharArrayUtil.shiftBackward((CharSequence)text, (int)(offset - 1), (String)" \t");
                if (curLineIndentEnd < offset && text.charAt(curLineIndentEnd) == '*') {
                    int maybeCommentLineStart;
                    if ((maybeCommentLineStart = CharArrayUtil.shiftBackward((CharSequence)text, (int)(--curLineIndentEnd), (String)" \t")) == 0 || text.charAt(maybeCommentLineStart) == '\n') {
                        indent = text.subSequence(maybeCommentLineStart, curLineIndentEnd + 1).toString();
                    }
                } else {
                    indent = "\n" + (String)indent;
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)((String)indent + "*/"));
                editor.getCaretModel().moveToOffset(offset);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/CommentBreakerEnterProcessor", "doEnter"));
    }
}

