/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.actions.OCFileNavigationItemForGenerationPopup;
import com.jetbrains.cidr.lang.navigation.OCSymbolNavigationItem;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileSymbolsContainerBase;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCActionContext<P extends OCMembersContainer, M extends OCSymbolWithParent> {
    @Nullable
    private final P myParent;
    @NotNull
    private final PsiElement myContext;
    @Nullable
    private Map<OCOption, Object> myOptionValues;
    @NotNull
    private final Project myProject;

    public OCActionContext(@Nullable P parent, @NotNull PsiElement context) {
        if (context == null) {
            OCActionContext.$$$reportNull$$$0(0);
        }
        this.myParent = parent;
        this.myContext = context;
        this.myProject = context.getProject();
    }

    @NotNull
    public final P getParent() {
        assert (this.myParent != null);
        P p = this.myParent;
        if (p == null) {
            OCActionContext.$$$reportNull$$$0(1);
        }
        return p;
    }

    @NotNull
    public final PsiElement getContext() {
        PsiElement psiElement = this.myContext;
        if (psiElement == null) {
            OCActionContext.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    public boolean isValid() {
        return this.myParent != null && (!(this.myParent instanceof OCSymbol) || !((OCSymbol)this.myParent).isPredeclaration());
    }

    public List<? extends OCSymbol> getSymbolsToModify() {
        return this.myParent instanceof OCSymbol ? Collections.singletonList((OCSymbol)this.myParent) : Collections.emptyList();
    }

    @Nullable
    public Map<OCOption, Object> getOptionValues() {
        return this.myOptionValues;
    }

    public void setOptionValues(@Nullable Map<OCOption, Object> optionValues) {
        this.myOptionValues = optionValues;
    }

    @NotNull
    public abstract Collection<M> getMemberCandidates();

    public abstract Map<OCSymbol, OCSymbol> createParentsMap(Collection<M> var1);

    public String getParentNameUppercase() {
        return "'" + this.getParentPresentableName() + "'";
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            OCActionContext.$$$reportNull$$$0(3);
        }
        return project;
    }

    @NotNull
    public OCResolveContext createResolveContext() {
        OCResolveContext oCResolveContext = OCResolveContext.forPsi(this.myContext);
        if (oCResolveContext == null) {
            OCActionContext.$$$reportNull$$$0(4);
        }
        return oCResolveContext;
    }

    @NotNull
    public String getParentPresentableName() {
        if (this.myParent instanceof OCFileSymbolsContainerBase) {
            String string = OCBundle.message("action.context.file.name", this.myParent.getContainingPsiFile(this.getProject()).getName());
            if (string == null) {
                OCActionContext.$$$reportNull$$$0(5);
            }
            return string;
        }
        if (this.myParent instanceof OCSymbol) {
            String string = ((OCSymbol)this.myParent).getPresentableName();
            if (string == null) {
                OCActionContext.$$$reportNull$$$0(6);
            }
            return string;
        }
        throw new IllegalStateException("Parent should be either symbol or file symbol container!");
    }

    @NotNull
    public PsiElementNavigationItem getParentNavigationItem() {
        if (this.myParent instanceof OCFileSymbolsContainerBase) {
            return new OCFileNavigationItemForGenerationPopup(this.myParent.getContainingPsiFile(this.getProject()));
        }
        if (this.myParent instanceof OCSymbol) {
            return new OCSymbolNavigationItem((OCSymbol)this.myParent, this.getProject());
        }
        throw new IllegalStateException("Parent should be either symbol or file symbol container!");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/actions/OCActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/actions/OCActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

