/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCGenerateBundle;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCElementsMover;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCGenerateMethodHandler
extends OCObjCClassTextActionHandlerBase<OCInstanceVariableSymbol, OCGenerateMethodActionContext> {
    private static final OCBooleanOption DECLARE_IN_INTERFACE = new OCBooleanOption(OCGenerateBundle.message("generate.method.handler.declare.in.interface", new Object[0]));

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateMethodActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(0);
        }
        if (options == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(1);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)DECLARE_IN_INTERFACE, (Object)(settings == null || settings.DECLARE_GENERATED_METHODS ? 1 : 0)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(2);
        }
        settings.DECLARE_GENERATED_METHODS = OCGenerateMethodHandler.getOption(optionValues, DECLARE_IN_INTERFACE);
        super.saveOptions(file, settings, optionValues);
    }

    @Override
    @NlsContexts.DialogTitle
    protected String getMembersChooserTitle() {
        return OCGenerateBundle.message("generate.method.handler.members.chooser.title", new Object[0]);
    }

    @Override
    @Nullable
    protected OCGenerateMethodActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        Project project;
        if (element == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(3);
        }
        if (!(parent.locateDefinition(project = element.getProject()) instanceof OCClassDeclaration)) {
            return null;
        }
        OCObjectType type = parent.getResolvedType(OCResolveContext.forPsi(element), true);
        return new OCGenerateMethodActionContext(parent, ContainerUtil.map((Object[])this.getMethodNames(), methodName -> this.searchForMethod((String)methodName, type, project)), type, element){

            @Override
            public List<OCClassSymbol> getSymbolsToModify() {
                if (OCGenerateMethodHandler.this.getOption(this, DECLARE_IN_INTERFACE).booleanValue()) {
                    return Arrays.asList(this.myInterfaceSymbol, this.myImplementationSymbol);
                }
                return Collections.singletonList(this.myImplementationSymbol);
            }

            @Override
            protected boolean showSymbol(OCInstanceVariableSymbol symbol) {
                return OCGenerateMethodHandler.this.showSymbolInChooser(symbol, this);
            }
        };
    }

    @Override
    @NotNull
    protected Collection<OCInstanceVariableSymbol> getSelectedCandidates(@NotNull OCGenerateMethodActionContext actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<OCInstanceVariableSymbol> candidates) {
        if (actionContext == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(5);
        }
        if (candidates == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(6);
        }
        List<OCInstanceVariableSymbol> list = candidates;
        if (list == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(7);
        }
        return list;
    }

    protected boolean showSymbolInChooser(OCInstanceVariableSymbol symbol, OCGenerateMethodActionContext actionContext) {
        return true;
    }

    @Nullable
    protected String getParentProtocol() {
        return null;
    }

    private OCMethodSymbol searchForMethod(String methodName, OCObjectType type, Project project) {
        CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

            protected boolean accept(OCMethodSymbol symbol) {
                return !symbol.isStatic();
            }
        };
        if (this.getParentProtocol() != null) {
            CommonProcessors.FindFirstProcessor protocolFinder = new CommonProcessors.FindFirstProcessor();
            OCCommonProcessors.TypeFilteredProcessor processor = new OCCommonProcessors.TypeFilteredProcessor((Processor<OCProtocolSymbol>)protocolFinder, OCProtocolSymbol.class);
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(project, processor, this.getParentProtocol());
            OCProtocolSymbol protocol = (OCProtocolSymbol)protocolFinder.getFoundValue();
            if (protocol != null) {
                protocol.processMembers(methodName, OCMethodSymbol.class, finder);
            }
        } else if (type != null) {
            type.processMembers(methodName, OCMethodSymbol.class, finder);
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    @NlsSafe
    protected abstract String[] getMethodNames();

    @Override
    protected boolean checkContext(@NotNull Project project, @Nullable Editor editor, @Nullable OCGenerateMethodActionContext context) {
        PsiElement existingMethod;
        if (project == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(8);
        }
        if (!super.checkContext(project, editor, context)) {
            return false;
        }
        OCMethodSymbol existingSymbol = this.findExistingMethod(context);
        context.setDeleteExisting(true);
        PsiElement psiElement = existingMethod = existingSymbol != null ? existingSymbol.locateDefinition(project) : null;
        if (existingMethod != null) {
            int code;
            String nameWithKind = existingSymbol.getNameWithKindUppercase(OCCompilationContext.create(existingMethod));
            String message = OCGenerateBundle.message("generate.method.handler.method.already.defined", nameWithKind);
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code == 0) {
                return true;
            }
            if (code == 1) {
                context.setDeleteExisting(false);
                return true;
            }
            return false;
        }
        return true;
    }

    protected OCMethodSymbol findExistingMethod(OCGenerateMethodActionContext context) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        for (String methodName : this.getMethodNames()) {
            if (!context.getImplementationSymbol().processMembersInAllCategories(methodName, OCMethodSymbol.class, (Processor)finder, true, context.getProject())) break;
        }
        return (OCMethodSymbol)finder.getFoundValue();
    }

    protected boolean isExistingMethod(String selector) {
        for (String methodName : this.getMethodNames()) {
            if (!selector.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void performAction(@NotNull Project project, @NotNull PsiElement element, int caretPos, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> members, @NotNull OCGenerateMethodActionContext context) {
        if (project == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(9);
        }
        if (element == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(10);
        }
        if (members == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(12);
        }
        if (this.getParentProtocol() != null && element instanceof OCImplementation) {
            PsiElement anInterface = context.getInterfaceSymbol().locateDefinition(project);
            OCProtocolSymbol protocol = (OCProtocolSymbol)context.getBaseMethod().getParent();
            if (anInterface instanceof OCClassDeclaration && !context.getType().implementsProtocol(protocol)) {
                new OCElementsMover().addBaseProtocol((OCClassDeclaration)anInterface, protocol.getName());
            }
        }
        if (context.isDeleteExisting()) {
            for (OCMethod method : ((OCClassDeclaration)element).getMethods()) {
                if (!this.isExistingMethod(method.getSelector())) continue;
                OCChangeUtil.delete(method);
            }
        }
        if (element instanceof OCImplementation) {
            for (OCInstanceVariableSymbol member : members) {
                if (member.getParent().isSameCategory(context.getInterfaceSymbol())) continue;
                new OCImportSymbolFix(element, member.getParent(), false).fixBestItem(project, element.getContainingFile());
            }
        }
        super.performAction(project, element, caretPos, at, members, context);
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCInstanceVariableSymbol> members, OCGenerateMethodActionContext actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.InstanceMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    protected static boolean processStructFields(OCType type, Processor<OCDeclaratorSymbol> processor, @NotNull OCResolveContext context) {
        OCStructSymbol structSymbol;
        if (context == null) {
            OCGenerateMethodHandler.$$$reportNull$$$0(13);
        }
        if (type instanceof OCStructType && !type.isScalar() && (structSymbol = ((OCStructType)type).getSymbol()).isPOD(context)) {
            CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
            structSymbol.processFields((Processor<? super OCDeclaratorSymbol>)collector);
            ArrayList<OCDeclaratorSymbol> fields = new ArrayList<OCDeclaratorSymbol>(collector.getResults());
            fields.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
            for (OCDeclaratorSymbol field : fields) {
                processor.process((Object)field);
            }
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateMethodHandler";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateMethodHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCandidates";
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkContext";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processStructFields";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

