/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.quickfixes;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.intentions.OCCreateMissingSwitchCasesIntentionAction;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCCreateMissingSwitchCasesFix
extends OCCreateMissingSwitchCasesIntentionAction {
    private boolean myDefaultIsMissing;
    protected SmartPsiElementPointer<OCSwitchStatement> mySwitchStatementPtr;

    public OCCreateMissingSwitchCasesFix(OCSwitchStatement switchStatement, boolean defaultIsMissing) {
        this.myDefaultIsMissing = defaultIsMissing;
        this.mySwitchStatementPtr = OCElementUtil.createPsiElementPointer(switchStatement);
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        OCSwitchStatement switchStatement;
        if (project == null) {
            OCCreateMissingSwitchCasesFix.$$$reportNull$$$0(0);
        }
        return (switchStatement = OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr)) != null && OCCodeInsightUtil.isValid(switchStatement) && switchStatement.getBody() instanceof OCBlockStatement;
    }

    @Override
    protected OCSwitchStatement getSwitchStatement(Editor editor, PsiFile file) {
        return OCElementUtil.getPsiElementByPointer(this.mySwitchStatementPtr);
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myDefaultIsMissing ? OCInspectionsBundle.message("intentions.create.missing.default.switch.case", new Object[0]) : super.getText();
        if (string == null) {
            OCCreateMissingSwitchCasesFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void invoke(OCStatement switchBlock, List<OCDeclaratorSymbol> missingCases) {
        if (this.myDefaultIsMissing) {
            OCChangeUtil.add(switchBlock, OCElementFactory.statementFromText("default:break;", switchBlock));
        } else {
            super.invoke(switchBlock, missingCases);
        }
    }

    @Override
    protected boolean proceedIfDefaultOrUnresolved(boolean defaultOrUnresolved) {
        return !defaultOrUnresolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/quickfixes/OCCreateMissingSwitchCasesFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/quickfixes/OCCreateMissingSwitchCasesFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

