/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.parser;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.PsiParser;
import com.intellij.lang.impl.PsiBuilderImpl;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.LineSet;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.NotNullFunction;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.TripleFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCParsing;
import com.jetbrains.cidr.lang.parser.OCPartialContext;
import com.jetbrains.cidr.lang.parser.OCRootElementType;
import com.jetbrains.cidr.lang.preprocessor.OCContextChangeSet;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.preprocessor.OCPreprocessingLexer;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalScopeable;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParsedLanguageAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCTemplateParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCParser
implements PsiParser {
    public static final Key<Boolean> IGNORE_INCLUSION_CONTEXT = new Key("IGNORE_INCLUSION_CONTEXT");
    private static final NotNullLazyKey<CachedValue<OCImmutableInclusionContext>, OCFile> FRAGMENT_CONTEXTS = NotNullLazyKey.create((String)"FRAGMENT_CONTEXTS", OCParser.createContextCalculator(false));
    private static final NotNullLazyKey<CachedValue<OCImmutableInclusionContext>, OCFile> FORCED_OBJCPP_FRAGMENT_CONTEXTS = NotNullLazyKey.create((String)"FRAGMENT_CONTEXTS", OCParser.createContextCalculator(true));
    private static final NotNullLazyKey<ReentrantLock, PsiFile> CS = NotNullLazyKey.create((String)"CS_INDEX", file -> new ReentrantLock(true));
    private static final Key<ProgressIndicator> CURRENT_LOCK_HOLDER = Key.create((String)"CURRENT_LOCK_HOLDER");
    private static final Key<SoftReference<OCPartialContext>> PARTIAL_CONTEXT = Key.create((String)"PARTIAL_CONTEXT");
    private static final Key<SoftReference<FileTextInfo>> FILE_TEXT = Key.create((String)"FILE_TEXT");
    private static final OCParser instance = new OCParser();
    private final List<Processor<PsiElement>> myListeners = new ArrayList<Processor<PsiElement>>();
    private boolean isLazyParsingEnabled = true;
    private static Boolean ourForceContextChangeCacheUsage;
    private static final TripleFunction<ASTNode, LighterASTNode, FlyweightCapableTreeStructure<LighterASTNode>, ThreeState> GLOBAL_REPARSE;

    private OCParser() {
    }

    @Contract(pure=true)
    public static OCParser getInstance() {
        return instance;
    }

    @TestOnly
    public void setLazyParsingEnabled(boolean isLazyParsingEnabled) {
        this.isLazyParsingEnabled = isLazyParsingEnabled;
    }

    @NotNull
    @Contract(pure=true)
    private static NotNullFunction<OCFile, CachedValue<OCImmutableInclusionContext>> createContextCalculator(boolean forceObjCpp) {
        NotNullFunction notNullFunction = dom -> {
            Project project = dom.getProject();
            return CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
                PsiElement ctx;
                OCInclusionContext inclusionContext = forceObjCpp ? OCInclusionContextUtil.calculateHeaderContext(dom, (OCLanguageKind)CLanguageKind.OBJ_CPP) : OCInclusionContextUtil.headerContext(dom).derive();
                OCFile context = dom;
                do {
                    inclusionContext.preprocessInclude(context, true);
                } while ((context = (ctx = context.getContext()) != null ? ctx.getContainingFile() : null) instanceof OCFile);
                return CachedValueProvider.Result.create((Object)inclusionContext, (Object[])new Object[]{FileSymbolTablesCache.getInstance(project).getOutOfBlockModificationTracker()});
            }, false);
        };
        if (notNullFunction == null) {
            OCParser.$$$reportNull$$$0(0);
        }
        return notNullFunction;
    }

    public static OCImmutableInclusionContext getCachedInclusionContext(OCFile file, boolean forceObjCpp) {
        return (OCImmutableInclusionContext)((CachedValue)(forceObjCpp ? FORCED_OBJCPP_FRAGMENT_CONTEXTS : FRAGMENT_CONTEXTS).getValue((UserDataHolder)file)).getValue();
    }

    public void addListener(Processor<PsiElement> listener) {
        this.myListeners.add(listener);
    }

    public void clearListeners() {
        this.myListeners.clear();
    }

    @NotNull
    public ASTNode parse(@NotNull IElementType root, @NotNull PsiBuilder builder2) {
        if (root == null) {
            OCParser.$$$reportNull$$$0(1);
        }
        if (builder2 == null) {
            OCParser.$$$reportNull$$$0(2);
        }
        builder2.setDebugMode(false);
        builder2.putUserData(PsiBuilderImpl.CUSTOM_COMPARATOR, GLOBAL_REPARSE);
        ASTNode aSTNode = new OCParsing(builder2, root, this.isLazyParsingEnabled ? OCParsing.BlockParsingMode.LAZY : OCParsing.BlockParsingMode.EAGER).parse();
        if (aSTNode == null) {
            OCParser.$$$reportNull$$$0(3);
        }
        return aSTNode;
    }

    public ASTNode parseDumbFile(IElementType root, PsiBuilder builder2) {
        builder2.setDebugMode(false);
        return new OCParsing(builder2, root).parseDumpFile();
    }

    public ASTNode parse(OCRootElementType root, ASTNode chameleon) {
        int offset;
        PsiFile file;
        PsiElement element;
        int lazyOffset;
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && application.isInternal() && Registry.is((String)"cidr.debug.show.parser.edt")) {
            OCLog.LOG.error("Reparse in EDT! Wil probably cause UI freeze!", new Attachment[]{new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString())});
        }
        PsiElement startElement = chameleon.getPsi();
        PsiFile startFile = startElement.getContainingFile();
        Project project = startFile.getProject();
        PsiFile original = startFile.getOriginalFile();
        PsiElement context = startFile.getContext();
        for (Processor<PsiElement> listener : this.myListeners) {
            listener.process((Object)startElement);
        }
        if (startElement instanceof OCLazyBlockStatementImpl) {
            lazyOffset = (context == null ? startElement : context).getTextRange().getStartOffset();
            element = startElement.getParent();
        } else {
            lazyOffset = -1;
            element = startElement;
        }
        if (!(context == null || element instanceof OCFile || startFile instanceof OCFile || element instanceof ASTWrapperPsiElement && element.getNode() instanceof FileElement)) {
            file = context.getContainingFile();
            offset = context.getParent().getTextOffset();
        } else {
            file = startFile;
            offset = element.getTextOffset();
        }
        assert (offset >= 0);
        return (ASTNode)OCParser.computeSyncWithEDTPriority(file, () -> {
            boolean parsingCodeFragment;
            boolean parseAsDummy = false;
            int lineNumber = 1;
            OCImmutableInclusionContext baseContext = null;
            OCContextChangeSet contextChangeSet = null;
            boolean symbolsAreLoaded = FileSymbolTablesCache.areSymbolsLoaded(project);
            boolean bl = parsingCodeFragment = file instanceof OCCodeFragment || element instanceof ASTWrapperPsiElement && OCElementTypes.CODE_FRAGMENTS.contains(chameleon.getElementType());
            if (project.isDefault() || parsingCodeFragment) {
                if (symbolsAreLoaded && !project.isDefault() && context != null && context.getContainingFile() instanceof OCFile && !OCParser.isSimplifiedParsingMode(file).booleanValue()) {
                    boolean forcedObjCpp = file instanceof OCCodeFragment && ((OCCodeFragment)file).getKind() == CLanguageKind.OBJ_CPP && ((OCFile)context.getContainingFile()).getKind() != CLanguageKind.OBJ_CPP;
                    baseContext = OCParser.getCachedInclusionContext((OCFile)context.getContainingFile(), forcedObjCpp);
                } else {
                    baseContext = OCInclusionContext.empty(OCLanguageKindCalculator.calculateLanguageKindFast(file), file);
                    if (InjectedLanguageManager.getInstance((Project)project).isInjectedFragment(file)) {
                        parseAsDummy = true;
                    }
                }
            } else if (symbolsAreLoaded && OCParser.isCodeInsightAvailable(chameleon)) {
                if (element instanceof OCFile || !(file instanceof OCFile)) {
                    baseContext = OCInclusionContextUtil.headerContext(file);
                    contextChangeSet = OCParser.changeSet(file, 0, -1);
                    parseAsDummy = baseContext.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel();
                } else {
                    baseContext = OCParser.evaluatePartialContext((OCFile)file, offset);
                    if (lazyOffset >= 0) {
                        lineNumber = OCParser.getCachedFileTextInfo((PsiFile)file).lineSet.findLineIndex(lazyOffset) + 1;
                    }
                }
            } else {
                parseAsDummy = true;
            }
            if (parseAsDummy) {
                OCLog.LOG.assertTrue(element instanceof OCFile || element instanceof ASTWrapperPsiElement, element.getClass());
                PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
                PsiBuilder builder2 = factory.createBuilder(project, chameleon, (Lexer)OCLexerWithDirectives.createDefault(), root.getLanguage(), chameleon.getChars());
                ASTNode result = this.parseDumbFile(chameleon.getElementType(), builder2);
                return result.getFirstChildNode();
            }
            OCInclusionContext currentFileContext = baseContext.derive();
            if (element instanceof OCFileImpl) {
                OCParser.setPartialContext(file, null);
                OCParsedLanguageAndConfiguration langAndConfig = new OCParsedLanguageAndConfiguration(currentFileContext.getConfiguration(), currentFileContext.getLanguageKind());
                ((OCFileImpl)file).setParsedLanguageAndConfiguration(langAndConfig);
                if (original != file && original instanceof OCFileImpl) {
                    ((OCFileImpl)original).setParsedLanguageAndConfiguration(langAndConfig);
                }
            } else {
                currentFileContext = OCParser.updatePartialContext(context != null ? context.getParent() : element, currentFileContext);
            }
            PsiFile baseFile = context != null ? context.getContainingFile() : original;
            OCPreprocessingLexer lexer = new OCPreprocessingLexer(currentFileContext, OCInclusionContextUtil.getVirtualFile(baseFile), OCParser.isSimplifiedParsingMode(currentFileContext.getRootFile()) != false ? OCPreprocessingLexer.IncludePreprocessingMode.SKIP : OCPreprocessingLexer.IncludePreprocessingMode.USE_SYMBOL_TABLE, lineNumber);
            if (element instanceof OCFileImpl && !(element instanceof OCCodeFragment)) {
                lexer.adjustNamespace();
            }
            lexer.setChangeSet(contextChangeSet);
            PsiBuilderFactory factory = PsiBuilderFactory.getInstance();
            PsiBuilder builder3 = factory.createBuilder(project, chameleon, (Lexer)lexer, root.getLanguage(), chameleon.getChars());
            lexer.setChangeSet(null);
            OCParser.cacheContextChangeIfRequired(file, contextChangeSet);
            ASTNode result = root.doParse(chameleon, builder3);
            return result.getFirstChildNode();
        });
    }

    @NotNull
    public static Boolean isSimplifiedParsingMode(@Nullable PsiFile file) {
        Boolean bl = (Boolean)IGNORE_INCLUSION_CONTEXT.get((UserDataHolder)file, (Object)false);
        if (bl == null) {
            OCParser.$$$reportNull$$$0(4);
        }
        return bl;
    }

    public static void setSimplifiedParsingMode(@NotNull PsiFile file, boolean isSimplified) {
        if (file == null) {
            OCParser.$$$reportNull$$$0(5);
        }
        IGNORE_INCLUSION_CONTEXT.set((UserDataHolder)file, (Object)isSimplified);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeSyncWithEDTPriority(@NotNull PsiFile file, @NotNull Computable<T> computable) {
        Object object;
        Object object2;
        ReentrantLock lock;
        if (file == null) {
            OCParser.$$$reportNull$$$0(6);
        }
        if (computable == null) {
            OCParser.$$$reportNull$$$0(7);
        }
        PsiFile contextHolder = OCParser.partialContextHolder(file);
        NotNullLazyKey<ReentrantLock, PsiFile> notNullLazyKey = CS;
        synchronized (notNullLazyKey) {
            lock = (ReentrantLock)CS.getValue((UserDataHolder)contextHolder);
        }
        ProgressIndicator originalInd = ProgressManager.getInstance().getProgressIndicator();
        boolean dispatchThread = ApplicationManager.getApplication().isDispatchThread();
        ProgressIndicator indicator = originalInd != null ? originalInd : new EmptyProgressIndicator();
        while (true) {
            indicator.checkCanceled();
            try {
                if (dispatchThread && lock.tryLock() || lock.tryLock(50L, TimeUnit.MILLISECONDS)) {
                    object2 = CURRENT_LOCK_HOLDER;
                    synchronized (object2) {
                        CURRENT_LOCK_HOLDER.set((UserDataHolder)contextHolder, (Object)indicator);
                        break;
                    }
                }
                if (!dispatchThread) continue;
                object2 = CURRENT_LOCK_HOLDER;
                synchronized (object2) {
                    ProgressIndicator curUser = (ProgressIndicator)CURRENT_LOCK_HOLDER.get((UserDataHolder)contextHolder);
                    if (curUser != null && !curUser.isCanceled()) {
                        curUser.cancel();
                    }
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        try {
            indicator.checkCanceled();
            if (originalInd != null) {
                object2 = computable.compute();
                return (T)object2;
            }
            if (dispatchThread) {
                object2 = ProgressManager.getInstance().runProcess(computable, indicator);
                return (T)object2;
            }
            Ref result = new Ref();
            if (!ProgressIndicatorUtils.runWithWriteActionPriority(() -> result.set(computable.compute()), (ProgressIndicator)indicator)) {
                throw new ProcessCanceledException();
            }
            object = result.get();
            return (T)object;
        }
        finally {
            object = CURRENT_LOCK_HOLDER;
            synchronized (object) {
                CURRENT_LOCK_HOLDER.set((UserDataHolder)contextHolder, null);
            }
            lock.unlock();
        }
    }

    private static boolean isCodeInsightAvailable(@NotNull ASTNode node) {
        PsiFile file;
        PsiElement psi;
        if (node == null) {
            OCParser.$$$reportNull$$$0(8);
        }
        if ((psi = node.getPsi()) != null && (file = psi.getContainingFile()) != null) {
            return OCCodeInsightUtil.isCodeInsightAvailable(file);
        }
        return OCCodeInsightUtil.isCodeInsightAvailable(node.getTextLength(), false);
    }

    private static void cacheContextChangeIfRequired(PsiFile file, OCContextChangeSet changeCache) {
        if (changeCache != null && changeCache.isUpdated()) {
            VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
            OCInclusionContextUtil.storeCachedContextChangeSet(file.getProject(), virtualFile, changeCache);
        }
    }

    private static OCContextChangeSet changeSet(PsiFile file, int validateFrom, int validateTo) {
        if (ourForceContextChangeCacheUsage != null && !ourForceContextChangeCacheUsage.booleanValue()) {
            return null;
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return null;
        }
        OCContextChangeSet cached = OCInclusionContextUtil.cachedContextChangeSet(file.getProject(), virtualFile);
        String text = OCParser.getCachedFileTextInfo((PsiFile)file).text;
        return OCContextChangeSet.reuse(text, cached, validateFrom, validateTo);
    }

    static OCImmutableInclusionContext evaluatePartialContext(OCFile file, int offset) {
        OCImmutableInclusionContext result;
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        FileSymbolTablesCache symbolsCache = (FileSymbolTablesCache)file.getProject().getComponent(FileSymbolTablesCache.class);
        if (symbolsCache != null) {
            FileSymbolTable symbolTable;
            OCInclusionContext context;
            OCPartialContext partialContext = OCParser.getPartialContext(file);
            if (partialContext == null) {
                context = OCInclusionContextUtil.headerContext(file).derive();
                symbolTable = symbolsCache.calcTableUsingPSI(file, virtualFile, context);
                OCPartialContext ctx = new OCPartialContext(symbolTable, context, 0);
                OCParser.setPartialContext(file, ctx);
                OCParser.ensureLazyBlocksParsed(file, 0, offset - 1);
                partialContext = OCParser.getPartialContext(file);
            }
            if (partialContext == null || partialContext.getFinalOffset() > offset) {
                context = OCInclusionContextUtil.headerContext(file).derive();
                symbolTable = symbolsCache.calcTableUsingPSI(file, virtualFile, context);
                OCContextChangeSet changeSet = OCParser.changeSet(file, 0, offset);
                context = context.preprocessFile(virtualFile, null, context.getInclusionLevel(), 0, offset, symbolTable.getContents(), changeSet);
                OCParser.cacheContextChangeIfRequired(file, changeSet);
                OCPartialContext ctx = new OCPartialContext(symbolTable, context, offset);
                OCParser.setPartialContext(file, ctx);
                result = context;
            } else {
                context = partialContext.getInclusionContext();
                OCParser.ensureLazyBlocksParsed(file, partialContext.getFinalOffset(), offset - 1);
                OCContextChangeSet changeSet = OCParser.changeSet(file, partialContext.getFinalOffset(), offset);
                context = context.preprocessFile(virtualFile, null, context.getInclusionLevel(), partialContext.getFinalOffset(), offset, partialContext.getSymbolTable().getContents(), changeSet);
                OCParser.cacheContextChangeIfRequired(file, changeSet);
                partialContext.setFinalOffset(offset);
                partialContext.setInclusionContext(context);
                result = context;
            }
        } else {
            result = OCInclusionContextUtil.headerContext(file);
        }
        return result;
    }

    @NotNull
    public static PsiFile partialContextHolder(@NotNull PsiFile file) {
        if (file == null) {
            OCParser.$$$reportNull$$$0(9);
        }
        PsiFile psiFile = file.getOriginalFile();
        if (psiFile == null) {
            OCParser.$$$reportNull$$$0(10);
        }
        return psiFile;
    }

    private static void setPartialContext(@NotNull PsiFile file, @Nullable OCPartialContext ctx) {
        if (file == null) {
            OCParser.$$$reportNull$$$0(11);
        }
        PARTIAL_CONTEXT.set((UserDataHolder)OCParser.partialContextHolder(file), (Object)new SoftReference((Object)ctx));
    }

    @Nullable
    private static OCPartialContext getPartialContext(@NotNull PsiFile file) {
        SoftReference ctxRef;
        if (file == null) {
            OCParser.$$$reportNull$$$0(12);
        }
        return (ctxRef = (SoftReference)PARTIAL_CONTEXT.get((UserDataHolder)OCParser.partialContextHolder(file))) == null ? null : (OCPartialContext)ctxRef.get();
    }

    private static void ensureLazyBlocksParsed(PsiFile file, int fromOffset, int toOffset) {
        if (fromOffset > toOffset) {
            return;
        }
        PsiElement start = file.findElementAt(fromOffset);
        PsiElement end = file.findElementAt(toOffset);
        if (start == null || end == null) {
            return;
        }
        if (!start.isValid() || !end.isValid()) {
            return;
        }
        PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)start, (PsiElement)end);
        if (commonParent == null) {
            return;
        }
        OCRecursiveVisitor visitor = new OCRecursiveVisitor(new TextRange(fromOffset, toOffset)){

            @Override
            @Contract(pure=true)
            protected TextRange getTextRange(PsiElement child) {
                return child.getTextRange();
            }
        };
        if (commonParent == start || commonParent == end) {
            commonParent.accept((PsiElementVisitor)visitor);
        } else {
            @NotNull PsiElement last = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)end);
            for (PsiElement i2 = PsiTreeUtil.findPrevParent((PsiElement)commonParent, (PsiElement)start); i2 != last; i2 = i2.getNextSibling()) {
                i2.accept((PsiElementVisitor)visitor);
            }
        }
    }

    @NotNull
    static OCInclusionContext updatePartialContext(PsiElement context, OCInclusionContext currentFileContext) {
        OCParsingNameScope nameScope = currentFileContext.getNameScope();
        if (context instanceof OCMethod) {
            nameScope = nameScope.defineLocalScope();
            for (OCMethodSelectorPart part : ((OCMethod)context).getParameters()) {
                String parameterName = part.getParameterName();
                if (parameterName == null) continue;
                nameScope.defineValue(parameterName, false);
            }
        } else if (context instanceof OCCallable) {
            String declaratorName;
            OCDeclarator declarator = null;
            OCFunctionDeclaration functionDeclaration = null;
            if (context instanceof OCFunctionDeclaration) {
                functionDeclaration = (OCFunctionDeclaration)context;
                declarator = functionDeclaration.getDeclarator();
            }
            ArrayList<String> qualifiers = new ArrayList<String>();
            for (OCCppNamespaceQualifier namespaceQualifier = declarator != null ? declarator.getNamespaceQualifier() : null; namespaceQualifier != null; namespaceQualifier = namespaceQualifier.getNamespaceQualifier()) {
                String name = namespaceQualifier.getName();
                if (name == null) continue;
                qualifiers.add(0, name);
            }
            OCParsingNameScope declarationNameScope = nameScope;
            for (String qualifier : qualifiers) {
                if (qualifier == null) continue;
                nameScope = nameScope.defineNamespace(qualifier);
            }
            nameScope = nameScope.defineLocalScope();
            String string = declaratorName = declarator != null ? declarator.getName() : null;
            if (declaratorName != null) {
                OCParsingNameScope.Kind existing = nameScope.getKind(declaratorName);
                boolean isTemplate = OCParsingNameScope.isTemplate(existing);
                boolean isConstructor = false;
                boolean isConvertOperator = false;
                if (OCParsingNameScope.isType(existing) && OCElementUtil.hasNoReturnType(functionDeclaration)) {
                    if (OCElementUtil.isOperatorDeclaration(declarator)) {
                        isConvertOperator = true;
                    } else if (qualifiers.isEmpty()) {
                        OCStruct parent = (OCStruct)PsiTreeUtil.getParentOfType((PsiElement)context, OCStruct.class, (boolean)true, (Class[])new Class[]{OCLocalScopeable.class});
                        if (parent != null && declaratorName.equals(parent.getName())) {
                            isConstructor = true;
                        }
                    } else if (declaratorName.equals(ContainerUtil.getLastItem(qualifiers)) && OCParsingNameScope.isType(declarationNameScope.getKind(qualifiers))) {
                        isConstructor = true;
                    }
                }
                if (!isConstructor && !isConvertOperator) {
                    nameScope.defineValue(declaratorName, isTemplate);
                }
            }
            List<PsiNamedElement> parameters = ((OCCallable)context).getParameters();
            OCTemplateParameterList templateParams = (OCTemplateParameterList)PsiTreeUtil.getChildOfType((PsiElement)context, OCTemplateParameterList.class);
            if (templateParams != null) {
                for (OCTypeParameterDeclaration declaration : templateParams.getTypeParameterDeclarations()) {
                    String name = declaration.getName();
                    if (name == null) continue;
                    nameScope.defineType(name, true);
                }
                for (OCParameterDeclaration declaration : templateParams.getParameterDeclarations()) {
                    OCDeclarator templateDeclarator = declaration.getDeclarator();
                    if (templateDeclarator == null) continue;
                    nameScope.defineValue(templateDeclarator.getName(), false);
                }
            }
            if (parameters != null) {
                for (PsiNamedElement parameter : parameters) {
                    nameScope.defineValue(parameter.getName(), false);
                }
            }
        }
        OCInclusionContext oCInclusionContext = currentFileContext.derive(nameScope);
        if (oCInclusionContext == null) {
            OCParser.$$$reportNull$$$0(13);
        }
        return oCInclusionContext;
    }

    @TestOnly
    public static void setForceContextChangeCacheUsage(@Nullable Boolean forceContextChangeCacheUsage) {
        ourForceContextChangeCacheUsage = forceContextChangeCacheUsage;
    }

    @NotNull
    private static FileTextInfo getCachedFileTextInfo(@NotNull PsiFile file) {
        if (file == null) {
            OCParser.$$$reportNull$$$0(14);
        }
        SoftReference textCacheRef = (SoftReference)FILE_TEXT.get((UserDataHolder)file);
        FileTextInfo textCache = (FileTextInfo)SoftReference.deref((Supplier)textCacheRef);
        long modificationStamp = file.getModificationStamp();
        if (textCache == null || textCache.timestamp != modificationStamp) {
            String text = file.getViewProvider().getContents().toString();
            textCache = new FileTextInfo(text, LineSet.createLineSet((CharSequence)text), modificationStamp);
            FILE_TEXT.set((UserDataHolder)file, (Object)new SoftReference((Object)textCache));
        }
        FileTextInfo fileTextInfo = textCache;
        if (fileTextInfo == null) {
            OCParser.$$$reportNull$$$0(15);
        }
        return fileTextInfo;
    }

    static {
        GLOBAL_REPARSE = (oldNode, newNode, structure) -> {
            if (oldNode.getElementType() == OCElementTypes.LAZY_BLOCK_STATEMENT && newNode.getTokenType() == OCElementTypes.LAZY_BLOCK_STATEMENT) {
                return ThreeState.NO;
            }
            return ThreeState.UNSURE;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/parser/OCParser";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createContextCalculator";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/parser/OCParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "isSimplifiedParsingMode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "partialContextHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePartialContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedFileTextInfo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSimplifiedParsingMode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeSyncWithEDTPriority";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCodeInsightAvailable";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "partialContextHolder";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setPartialContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPartialContext";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCachedFileTextInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class FileTextInfo {
        @NotNull
        final String text;
        @NotNull
        final LineSet lineSet;
        final long timestamp;

        private FileTextInfo(@NotNull String text, @NotNull LineSet lineSet, long timestamp) {
            if (text == null) {
                FileTextInfo.$$$reportNull$$$0(0);
            }
            if (lineSet == null) {
                FileTextInfo.$$$reportNull$$$0(1);
            }
            this.text = text;
            this.lineSet = lineSet;
            this.timestamp = timestamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "lineSet";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/parser/OCParser$FileTextInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

