/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCConstructorInitializationList;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;

public class OCAddFieldInitializerFix
extends OCPsiElementQuickFix<OCFunctionDefinition> {
    private OCDeclaratorSymbol myField;

    public OCAddFieldInitializerFix(@NotNull OCFunctionDefinition constructor, OCDeclaratorSymbol field) {
        if (constructor == null) {
            OCAddFieldInitializerFix.$$$reportNull$$$0(0);
        }
        super(constructor);
        this.myField = field;
    }

    @Override
    protected boolean isAvailable(@NotNull OCFunctionDefinition constructor) {
        if (constructor == null) {
            OCAddFieldInitializerFix.$$$reportNull$$$0(1);
        }
        return OCSearchScope.isInProjectSources(this.myField, constructor.getProject());
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.add.constructor.initializer.for.field", new Object[0]);
        if (string == null) {
            OCAddFieldInitializerFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected String getTextInternal() {
        return OCInspectionsBundle.message("intention.name.add.constructor.initializer", this.myField.getNameWithKindLowercase(OCCompilationContext.create(this.myField, this.getProject())));
    }

    @Override
    protected void invoke(PsiFile file, @NotNull OCFunctionDefinition constructor) {
        if (constructor == null) {
            OCAddFieldInitializerFix.$$$reportNull$$$0(3);
        }
        OCResolveContext context = OCResolveContext.forPsi(constructor);
        OCType type = this.myField.getResolvedType(context);
        OCConstructorFieldInitializer initializer = OCAddFieldInitializerFix.addFieldInitializer(constructor, this.myField, type.getDefaultValue(context));
        OCAddInitializerIntentionAction.invokeSmartCompletion(initializer.getArguments().get(0), type);
    }

    public static OCConstructorFieldInitializer addFieldInitializer(OCFunctionDefinition constructor, OCDeclaratorSymbol field, String initializerText) {
        String text = field.getName() + "(" + initializerText + ")";
        OCConstructorFieldInitializer initializer = OCElementFactory.constructorFieldInitializerFromText(text, constructor);
        OCConstructorInitializationList existingList = constructor.getConstructorInitializationList();
        if (existingList != null) {
            initializer = OCChangeUtil.add(existingList, initializer);
        } else {
            OCConstructorInitializationList list = OCElementFactory.constructorInitializationList(constructor);
            OCChangeUtil.add(list, initializer);
            list = constructor.setConstructorInitializationList(list);
            initializer = list.getInitializers().get(0);
        }
        return initializer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddFieldInitializerFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddFieldInitializerFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

