/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.base.Predicates;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.qualifiedName.QualifiedName;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCLazyNamedSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.VirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCConceptSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ConsumedTokenRange;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FileSymbolTable
implements Serializable,
VirtualFileOwner {
    public static final FileSymbolTable[] EMPTY_ARRAY = new FileSymbolTable[0];
    private static boolean ourShouldCompactSymbols = true;
    private static final Key<Map<Class<?>, Pair<Integer, Integer>>> DEBUG_STATS_KEY = Key.create((String)"FileSymbolTable.STATS_KEY");
    private static final Logger LOG = Logger.getInstance(FileSymbolTable.class);
    private ArrayList<OCSymbol> myContents;
    private ContextSignature mySignature;
    private volatile int myPackStamp;
    private transient VirtualFile myFile;
    private volatile transient int myUsingCount;
    private volatile transient boolean myValid;
    private volatile transient boolean myFallback;
    @Nullable
    private volatile transient List<ConsumedTokenRange> myConsumedTokenRanges;

    public FileSymbolTable() {
        this.myContents = new ArrayList();
        this.myValid = true;
        this.myConsumedTokenRanges = null;
    }

    @Override
    public void init(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(0);
        }
        this.myFile = file;
    }

    public FileSymbolTable(@NotNull VirtualFile file, @NotNull ContextSignature signature2) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(1);
        }
        if (signature2 == null) {
            FileSymbolTable.$$$reportNull$$$0(2);
        }
        this.myContents = new ArrayList();
        this.myValid = true;
        this.myConsumedTokenRanges = null;
        this.init(file);
        this.mySignature = signature2;
    }

    public FileSymbolTable(@NotNull VirtualFile file, @NotNull ContextSignature signature2, @Nullable List<ConsumedTokenRange> consumedTokenRanges) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(3);
        }
        if (signature2 == null) {
            FileSymbolTable.$$$reportNull$$$0(4);
        }
        this.myContents = new ArrayList();
        this.myValid = true;
        this.myConsumedTokenRanges = null;
        this.init(file);
        this.mySignature = signature2;
        this.myConsumedTokenRanges = consumedTokenRanges;
    }

    public void compact() {
        this.myContents.trimToSize();
    }

    @NotNull
    public ContextSignature getSignature() {
        ContextSignature contextSignature = this.mySignature;
        if (contextSignature == null) {
            FileSymbolTable.$$$reportNull$$$0(5);
        }
        return contextSignature;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            FileSymbolTable.$$$reportNull$$$0(6);
        }
        return virtualFile;
    }

    @NotNull
    public List<OCSymbol> getContents() {
        ArrayList<OCSymbol> arrayList = this.myContents;
        if (arrayList == null) {
            FileSymbolTable.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    public int internSymbols(@NotNull UserDataHolder statsHolder, Function<? super OCSymbol, ? extends OCSymbol> interner) {
        if (statsHolder == null) {
            FileSymbolTable.$$$reportNull$$$0(8);
        }
        int internedCount = 0;
        for (int i2 = 0; i2 < this.myContents.size(); ++i2) {
            OCSymbol each = this.myContents.get(i2);
            OCSymbol replacement = (OCSymbol)interner.fun((Object)each);
            FileSymbolTable.incInterned(statsHolder, each, false);
            if (each != replacement) {
                ++internedCount;
                FileSymbolTable.incInterned(statsHolder, each, true);
                this.myContents.set(i2, replacement);
                continue;
            }
            if (!FileSymbolTable.shouldCompactSymbols()) continue;
            each.compact();
        }
        return internedCount;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void setFallback(boolean fallback) {
        this.myFallback = fallback;
    }

    public boolean isFallback() {
        return this.myFallback;
    }

    @Nullable
    public List<ConsumedTokenRange> getConsumedTokenRanges() {
        return this.myConsumedTokenRanges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incInterned(@NotNull UserDataHolder statsHolder, @NotNull OCSymbol each, boolean interned) {
        if (statsHolder == null) {
            FileSymbolTable.$$$reportNull$$$0(9);
        }
        if (each == null) {
            FileSymbolTable.$$$reportNull$$$0(10);
        }
        if (!LOG.isDebugEnabled()) {
            return;
        }
        HashMap stats = (HashMap)statsHolder.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            stats = new HashMap();
            statsHolder.putUserData(DEBUG_STATS_KEY, stats);
        }
        HashMap hashMap = stats;
        synchronized (hashMap) {
            Pair s = (Pair)stats.get(each.getClass());
            if (s == null) {
                s = new Pair((Object)0, (Object)0);
            }
            s = interned ? new Pair((Object)((Integer)s.first + 1), (Object)((Integer)s.second)) : new Pair((Object)((Integer)s.first), (Object)((Integer)s.second + 2));
            stats.put(each.getClass(), s);
            if (each instanceof OCNamespaceSymbol) {
                ((OCNamespaceSymbol)each).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> {
                    FileSymbolTable.incInterned(statsHolder, symbol, false);
                    FileSymbolTable.incInterned(statsHolder, symbol, true);
                    return true;
                }));
            } else if (each instanceof OCClassSymbol) {
                ((OCClassSymbol)each).processMembers(null, OCMemberSymbol.class, symbol -> {
                    FileSymbolTable.incInterned(statsHolder, symbol, false);
                    FileSymbolTable.incInterned(statsHolder, symbol, true);
                    return true;
                });
            }
        }
    }

    public boolean tryReuseContents(FileSymbolTable original) {
        ArrayList<OCSymbol> tc = original.myContents;
        List<OCSymbol> contents = this.getContents();
        if (FileSymbolTable.hasSameElements(tc, contents)) {
            this.myContents = tc;
            this.myConsumedTokenRanges = original.myConsumedTokenRanges;
            return true;
        }
        return false;
    }

    public static void reportStats(@NotNull Project project) {
        Map stats;
        if (project == null) {
            FileSymbolTable.$$$reportNull$$$0(11);
        }
        if ((stats = (Map)project.getUserData(DEBUG_STATS_KEY)) == null) {
            return;
        }
        project.putUserData(DEBUG_STATS_KEY, null);
        for (Map.Entry each : stats.entrySet()) {
            LOG.debug(((Class)each.getKey()).getSimpleName() + ": interned=" + ((Pair)each.getValue()).first + " count=" + ((Pair)each.getValue()).second);
        }
    }

    public void updateOffsets(int start, int lengthShift, Set<OCSymbol> processed) {
        for (OCSymbol symbol : this.myContents) {
            if (!processed.add(symbol)) continue;
            symbol.updateOffset(start, lengthShift);
        }
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(12);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(13);
        }
        return FileSymbolTable.forFile(file, context, null);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(14);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(15);
        }
        Project project = file.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project).assertParsingAndSymbolBuildingAllowed();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        return cache.forFile(OCInclusionContextUtil.getVirtualFile(file), context, serializationSession);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(16);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(17);
        }
        return FileSymbolTable.forFile(file, context, null);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        if (file == null) {
            FileSymbolTable.$$$reportNull$$$0(18);
        }
        if (context == null) {
            FileSymbolTable.$$$reportNull$$$0(19);
        }
        Project project = context.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project).assertParsingAndSymbolBuildingAllowed();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        return cache.forFile(file, context, serializationSession);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @NotNull Class<T> symbolClass) {
        if (element == null) {
            FileSymbolTable.$$$reportNull$$$0(20);
        }
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(21);
        }
        return this.findSymbol(element, null, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @Nullable String symbolName, @NotNull Class<T> symbolClass) {
        if (element == null) {
            FileSymbolTable.$$$reportNull$$$0(22);
        }
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(23);
        }
        String lookupName = symbolName != null ? symbolName : OCElementUtil.getSymbolName(element);
        long offset = element instanceof OCElement ? ((OCElement)element).getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(element.getTextOffset(), 0);
        return this.findSymbol(lookupName, offset, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String symbolName, @NotNull Class<T> symbolClass) {
        if (symbolClass == null) {
            FileSymbolTable.$$$reportNull$$$0(24);
        }
        return this.findSymbol(symbolName, -1L, symbolClass);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private <T extends OCSymbol> T findSymbol(final @Nullable String symbolName, final long complexOffset, @NotNull Class<T> clazz) {
        void symbolClass;
        if (clazz == null) {
            FileSymbolTable.$$$reportNull$$$0(25);
        }
        OCSymbol[] result = new OCSymbol[1];
        OCSymbol[] possible = new OCSymbol[1];
        Processor<OCSymbol> processor = new Processor<OCSymbol>((Class)symbolClass, result, possible){
            final /* synthetic */ Class val$symbolClass;
            final /* synthetic */ OCSymbol[] val$result;
            final /* synthetic */ OCSymbol[] val$possible;
            {
                this.val$symbolClass = clazz;
                this.val$result = oCSymbolArray;
                this.val$possible = oCSymbolArray2;
            }

            public boolean process(OCSymbol symbol) {
                symbol = symbol.getDelegate();
                if ((complexOffset == -1L || symbol.getOffset() == OCSymbolOffsetUtil.getTextOffset(complexOffset)) && (symbolName == null || Objects.equals(symbolName, symbol.getName())) && this.val$symbolClass.isAssignableFrom(symbol.getClass())) {
                    if (complexOffset == -1L || symbol.getComplexOffset() == complexOffset) {
                        this.val$result[0] = symbol;
                        return false;
                    }
                    this.val$possible[0] = symbol;
                }
                if (symbol instanceof OCNamespaceSymbol) {
                    return ((OCNamespaceSymbol)symbol).processMembers((String)null, this);
                }
                if (symbol instanceof OCClassSymbol) {
                    return ((OCClassSymbol)symbol).processMembers(symbolName, this);
                }
                return true;
            }
        };
        ContainerUtil.process(this.myContents, (Processor)processor);
        return (T)(result[0] != null ? result[0] : possible[0]);
    }

    public boolean processFile(Processor<? super OCSymbol> processor) {
        for (OCSymbol symbol : this.myContents) {
            ProgressManager.checkCanceled();
            if (processor.process((Object)symbol.getDelegate())) continue;
            return false;
        }
        return true;
    }

    public boolean processFile(Processor<? super OCSymbol> processor, int afterOffset, int beforeOffset) {
        return OCResolveUtil.processSymbolsFromList((Processor<? super OCSymbol>)((Processor)symbol -> processor.process((Object)symbol.getDelegate())), this.myContents, afterOffset, beforeOffset);
    }

    public boolean processIncludes(@NotNull Processor<? super OCSymbol> processor) {
        if (processor == null) {
            FileSymbolTable.$$$reportNull$$$0(26);
        }
        for (OCSymbol item : this.myContents) {
            OCSymbol delegate = item.getDelegate();
            if (!(delegate instanceof OCIncludeSymbol) && !(delegate instanceof OCModuleImportSymbol) || processor.process((Object)delegate)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowProcessSymbols(@NotNull Processor<? super OCSymbol> processor) {
        if (processor == null) {
            FileSymbolTable.$$$reportNull$$$0(27);
        }
        for (OCSymbol content : this.myContents) {
            if (content == null || processor.process((Object)content.getDelegate())) continue;
            return false;
        }
        return false;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor, @Nullable String symbolName, @NotNull ProcessingState state, @Nullable Map<OCSymbol, VirtualFile> importsMap, @Nullable VirtualFile firstImportLink, @Nullable VirtualFile breakOn) {
        if (processor == null) {
            FileSymbolTable.$$$reportNull$$$0(28);
        }
        if (state == null) {
            FileSymbolTable.$$$reportNull$$$0(29);
        }
        if (this.isEmpty()) {
            return true;
        }
        if (!state.startProcessing(this)) {
            return true;
        }
        class Builder
        implements Processor<OCSymbol> {
            private final OCParsingNameScope myNameScope;
            final /* synthetic */ ProcessingState val$state;
            final /* synthetic */ Processor val$processor;
            final /* synthetic */ String val$symbolName;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ VirtualFile val$firstImportLink;
            final /* synthetic */ Map val$importsMap;

            Builder(OCParsingNameScope nameScope) {
                this.val$state = processingState;
                this.val$processor = processor;
                this.val$symbolName = string;
                this.val$breakOn = virtualFile;
                this.val$firstImportLink = virtualFile2;
                this.val$importsMap = map;
                this.myNameScope = nameScope;
            }

            public boolean process(OCSymbol symbol) {
                ProgressManager.checkCanceled();
                if (symbol instanceof OCModuleImportSymbol) {
                    if (this.val$state.myShouldProcessImports && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    if (!this.val$state.shouldProcessImport((OCModuleImportSymbol)symbol)) {
                        return true;
                    }
                    QualifiedName moduleName = ((OCModuleImportSymbol)symbol).getModuleName();
                    if (moduleName == null) {
                        return true;
                    }
                    return OCModuleResolver.processImportedHeaders(this.val$state.myContext, moduleName, (Processor<? super VirtualFile>)((Processor)file -> this.processInclude((VirtualFile)file, true)));
                }
                if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    include.enterNamespace(this.val$state.myContext);
                    VirtualFile includeFile = include.getTargetFile();
                    boolean once = include.isOnce();
                    if (this.val$state.myShouldProcessImports && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    if (!this.processInclude(includeFile, once)) {
                        return false;
                    }
                    include.exitNamespace(this.val$state.myContext);
                    return true;
                }
                if (this.val$symbolName != null && !this.val$symbolName.equals(symbol.getName())) {
                    return true;
                }
                this.updateImportsMap(symbol);
                this.updateContext(symbol);
                return this.val$processor.process((Object)symbol);
            }

            private boolean processInclude(@Nullable VirtualFile includeFile, boolean once) {
                if (this.val$breakOn != null && Comparing.equal((Object)includeFile, (Object)this.val$breakOn)) {
                    return false;
                }
                if (includeFile == null || !this.val$state.shouldProcessInclude(includeFile)) {
                    return true;
                }
                FileSymbolTable table = this.findTableForInclude(includeFile, once);
                if (table == null) {
                    return true;
                }
                VirtualFile link = this.val$firstImportLink == null ? includeFile : this.val$firstImportLink;
                return table.processSymbols((Processor<OCSymbol>)this.val$processor, this.val$symbolName, this.val$state, this.val$importsMap, link, this.val$breakOn);
            }

            @Nullable
            private FileSymbolTable findTableForInclude(@Nullable VirtualFile includeFile, boolean once) {
                if (includeFile != null && includeFile.isValid() && SymbolTableProvider.isSourceFile(this.val$state.myContext.getProject(), includeFile) && this.val$state.myContext.reserveInclude(includeFile, once)) {
                    return this.val$state.myCache.forFile(includeFile, this.val$state.myContext);
                }
                return null;
            }

            private void updateImportsMap(@NotNull OCSymbol symbol) {
                if (symbol == null) {
                    Builder.$$$reportNull$$$0(0);
                }
                if (this.val$importsMap != null && this.val$firstImportLink != null) {
                    OCType type;
                    this.val$importsMap.put(symbol, this.val$firstImportLink);
                    if ((symbol instanceof OCAliasUsingSymbol || symbol.getKind() == OCSymbolKind.TYPEDEF) && (type = symbol.getType()) instanceof OCStructType) {
                        List<OCStructSymbol> ss = ((OCStructType)type).getStructs();
                        for (OCStructSymbol struct : ss) {
                            if (!struct.isUnnamed()) continue;
                            ProgressManager.checkCanceled();
                            this.updateImportsMap(struct);
                        }
                    }
                    if (symbol instanceof OCMembersContainer) {
                        ((OCMembersContainer)((Object)symbol)).processMembers(null, symbol1 -> {
                            ProgressManager.checkCanceled();
                            this.updateImportsMap((OCSymbol)symbol1);
                            return true;
                        });
                    }
                }
            }

            private void updateContext(OCSymbol symbol) {
                if (symbol instanceof OCLazyNamedSymbol) {
                    return;
                }
                if (symbol instanceof OCMacroSymbol) {
                    this.val$state.myContext.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    this.val$state.myContext.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    boolean isCPP = this.val$state.myContext.getLanguageKind().isCpp();
                    if (isCPP && symbol instanceof OCNamespaceSymbol && !((OCNamespaceSymbol)symbol).isPredefinition()) {
                        OCParsingNameScope inner = this.myNameScope.defineNamespace(symbol.getName());
                        Builder innerProcessor = new Builder(inner);
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol12 -> {
                            innerProcessor.updateContext((OCSymbol)symbol12);
                            return true;
                        }));
                    }
                    if (kind.isType()) {
                        if (kind == OCSymbolKind.PROTOCOL) {
                            this.myNameScope.defineProtocol(symbol.getName());
                        } else if (kind.isClass() || kind == OCSymbolKind.COMPATIBILITY_ALIAS) {
                            this.myNameScope.defineInterface(symbol.getName());
                        } else {
                            boolean isTemplate = isCPP && kind.isStructLike() && ((OCStructSymbol)symbol).isTemplateSymbol();
                            this.myNameScope.defineType(symbol.getName(), isTemplate);
                        }
                    } else if (isCPP) {
                        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                            if (!symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).isTemplateSymbol()) {
                                this.myNameScope.defineValue(symbol.getName(), true);
                            }
                        } else if (symbol instanceof OCUsingSymbol) {
                            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                                this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            } else {
                                this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            }
                        } else if (symbol instanceof OCConceptSymbol) {
                            this.myNameScope.defineConcept(symbol.getName());
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "symbol", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable$1Builder", "updateImportsMap"));
            }
        }
        return this.processFile(new Builder(state.myContext.getNameScope()));
    }

    public boolean isEmpty() {
        return this.myContents.isEmpty();
    }

    public void append(OCSymbol symbol) {
        this.myContents.add(symbol);
    }

    public void appendAll(@NotNull List<OCSymbol> symbols) {
        if (symbols == null) {
            FileSymbolTable.$$$reportNull$$$0(30);
        }
        this.myContents.addAll(symbols);
    }

    public void sortSymbols() {
        FileSymbolTable.sortSymbols(this.myContents);
    }

    private static void sortSymbols(@Nullable List<OCSymbol> symbols) {
        if (symbols != null) {
            symbols.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
            for (OCSymbol symbol : symbols) {
                if (!(symbol instanceof OCNamespaceSymbol)) continue;
                FileSymbolTable.sortSymbols(((OCNamespaceSymbol)symbol).getMembersList());
            }
        }
    }

    public synchronized int incUsageCount() {
        return ++this.myUsingCount;
    }

    public int getUsageCount() {
        return this.myUsingCount;
    }

    public void resetUsageCount() {
        this.myUsingCount = 1;
    }

    public int getPackStamp() {
        return this.myPackStamp;
    }

    public void setPackStamp(int packStamp) {
        this.myPackStamp = packStamp;
    }

    @TestOnly
    public static void setShouldCompactSymbols(boolean value) {
        ourShouldCompactSymbols = value;
    }

    public static boolean shouldCompactSymbols() {
        return ourShouldCompactSymbols;
    }

    private static boolean hasSameElements(List<OCSymbol> l1, List<OCSymbol> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < l1.size(); ++i2) {
            if (l1.get(i2) == l2.get(i2)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statsHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "each";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolClass";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "internSymbols";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "incInterned";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportStats";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findSymbol";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processIncludes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "shallowProcessSymbols";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processSymbols";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "appendAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ProcessingState {
        @NotNull
        private final OCInclusionContext myContext;
        @NotNull
        private final FileSymbolTablesCache myCache;
        private final boolean myShouldProcessImports;
        private final Predicate<VirtualFile> myIncludePredicate;
        private final Predicate<OCModuleImportSymbol> myImportPredicate;
        private final Set<List<OCSymbol>> myProcessed;

        public ProcessingState(@NotNull OCInclusionContext context, boolean processImports) {
            if (context == null) {
                ProcessingState.$$$reportNull$$$0(0);
            }
            this(context, processImports, (Predicate<VirtualFile>)Predicates.alwaysTrue(), (Predicate<OCModuleImportSymbol>)Predicates.alwaysTrue());
        }

        public ProcessingState(@NotNull OCInclusionContext context, boolean processImports, @NotNull Predicate<VirtualFile> includePredicate, @NotNull Predicate<OCModuleImportSymbol> importPredicate) {
            if (context == null) {
                ProcessingState.$$$reportNull$$$0(1);
            }
            if (includePredicate == null) {
                ProcessingState.$$$reportNull$$$0(2);
            }
            if (importPredicate == null) {
                ProcessingState.$$$reportNull$$$0(3);
            }
            this.myProcessed = new ReferenceOpenHashSet();
            this.myContext = context;
            this.myCache = FileSymbolTablesCache.getInstance(context.getProject());
            this.myShouldProcessImports = processImports;
            this.myIncludePredicate = includePredicate;
            this.myImportPredicate = importPredicate;
        }

        private boolean startProcessing(@NotNull FileSymbolTable table) {
            if (table == null) {
                ProcessingState.$$$reportNull$$$0(4);
            }
            return this.myProcessed.add(table.myContents);
        }

        private boolean shouldProcessInclude(@NotNull VirtualFile targetFile) {
            if (targetFile == null) {
                ProcessingState.$$$reportNull$$$0(5);
            }
            return this.myIncludePredicate.test(targetFile);
        }

        private boolean shouldProcessImport(@NotNull OCModuleImportSymbol importSymbol) {
            if (importSymbol == null) {
                ProcessingState.$$$reportNull$$$0(6);
            }
            return this.myImportPredicate.test(importSymbol);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "includePredicate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importPredicate";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetFile";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importSymbol";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTable$ProcessingState";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "startProcessing";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldProcessInclude";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldProcessImport";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

