/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.EmptySymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.FileContentSnapshot;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SymbolTableProvider {
    private static final Logger LOG = Logger.getInstance(SymbolTableProvider.class);
    public static final ExtensionPointName<SymbolTableProvider> INSTANCE = ExtensionPointName.create((String)"cidr.lang.symbolTableProvider");

    protected abstract boolean isSource(@NotNull PsiFile var1);

    public abstract boolean isSource(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    public abstract boolean isSource(@NotNull Project var1, @NotNull VirtualFile var2);

    public boolean shouldPreProcess() {
        return false;
    }

    public abstract boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl var1);

    @NotNull
    public abstract FileSymbolTable calcTableUsingPSI(@NotNull PsiFile var1, @NotNull VirtualFile var2, @NotNull OCInclusionContext var3);

    @NotNull
    public abstract FileSymbolTable calcTable(@NotNull VirtualFile var1, @NotNull OCInclusionContext var2);

    @NotNull
    public static List<SymbolTableProvider> getProviders() {
        List list = INSTANCE.getExtensionList();
        if (list == null) {
            SymbolTableProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    public boolean shouldProcessPsiEvents(@NotNull PsiFile file) {
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(1);
        }
        return true;
    }

    @NotNull
    public static SymbolTableProvider getProvider(@NotNull PsiFile file) {
        SymbolTableProvider provider2;
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(2);
        }
        if ((provider2 = SymbolTableProvider.findProvider(file)) != null) {
            SymbolTableProvider symbolTableProvider = provider2;
            if (symbolTableProvider == null) {
                SymbolTableProvider.$$$reportNull$$$0(3);
            }
            return symbolTableProvider;
        }
        LOG.error(file.getClass() + "(\"" + file.getName() + "\")");
        return SymbolTableProvider.emptyTableProvider();
    }

    @Nullable
    public static SymbolTableProvider findProvider(@NotNull PsiFile file) {
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(4);
        }
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(file)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    public static SymbolTableProvider getProvider(@NotNull Project project, @NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        if (project == null) {
            SymbolTableProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SymbolTableProvider.$$$reportNull$$$0(7);
        }
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(project, file, context)) continue;
            SymbolTableProvider symbolTableProvider = provider2;
            if (symbolTableProvider == null) {
                SymbolTableProvider.$$$reportNull$$$0(8);
            }
            return symbolTableProvider;
        }
        LOG.error(file.getClass() + "(\"" + file.getName() + "\")");
        return SymbolTableProvider.emptyTableProvider();
    }

    @Nullable
    public static SymbolTableProvider findProvider(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            SymbolTableProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            SymbolTableProvider.$$$reportNull$$$0(10);
        }
        for (SymbolTableProvider provider2 : SymbolTableProvider.getProviders()) {
            if (!provider2.isSource(project, file)) continue;
            return provider2;
        }
        return null;
    }

    @NotNull
    private static SymbolTableProvider emptyTableProvider() {
        EmptySymbolTableProvider emptySymbolTableProvider = EmptySymbolTableProvider.INSTANCE;
        if (emptySymbolTableProvider == null) {
            SymbolTableProvider.$$$reportNull$$$0(11);
        }
        return emptySymbolTableProvider;
    }

    @Contract(value="_, null -> false")
    public static boolean isSourceFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        if (project == null) {
            SymbolTableProvider.$$$reportNull$$$0(12);
        }
        return virtualFile != null && SymbolTableProvider.findProvider(project, virtualFile) != null;
    }

    @Contract(value="null -> false")
    public static boolean isSourceFile(@Nullable PsiFile file) {
        return file != null && SymbolTableProvider.findProvider(file) != null;
    }

    @NotNull
    public static CharSequence getFileText(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            SymbolTableProvider.$$$reportNull$$$0(13);
        }
        if (project == null) {
            SymbolTableProvider.$$$reportNull$$$0(14);
        }
        CharSequence charSequence = FileContentSnapshot.get(virtualFile, project).getText();
        if (charSequence == null) {
            SymbolTableProvider.$$$reportNull$$$0(15);
        }
        return charSequence;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/SymbolTableProvider";
                break;
            }
            case 3: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyTableProvider";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "shouldProcessPsiEvents";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProvider";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSourceFile";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFileText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

