/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeGuesser {
    private static Set<String> KNOWN_MUTABLE_PREFIXES = ContainerUtil.set((Object[])new String[]{"NS", "CN", "UI"});

    @Nullable
    public static OCType getMethodGuessedReturnType(@NotNull OCMethodSymbol method, @NotNull OCObjectTypeContext receiverContext, @Nullable OCSendMessageExpression sendMessageExpr, @NotNull PsiElement context) {
        String typeName;
        if (method == null) {
            OCTypeGuesser.$$$reportNull$$$0(0);
        }
        if (receiverContext == null) {
            OCTypeGuesser.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCTypeGuesser.$$$reportNull$$$0(2);
        }
        String selector = method.getName();
        OCType originalType = receiverContext.getOriginalType();
        OCType result = originalType.isClassType() || originalType instanceof OCBlockPointerType ? originalType : OCPointerType.to(receiverContext.getType());
        boolean isId = "id".equals(method.getReturnType(context.getProject()).getName());
        if (result.isPointerToObject() && OCElementUtil.startsWithWord(selector, "mutableCopy") && (typeName = receiverContext.getType().getName()).length() > 2) {
            OCProtocolSymbol protocol = (OCProtocolSymbol)OCSymbolBase.findSymbolDefinition("NSMutableCopying", OCSymbolKind.PROTOCOL, context.getProject(), method.getContainingFile());
            String typeNamePrefix = typeName.substring(0, 2);
            if (protocol != null && ((OCObjectType)result.getTerminalType()).implementsProtocol(protocol) && KNOWN_MUTABLE_PREFIXES.contains(typeNamePrefix)) {
                OCType type = OCReferenceType.resolvedFromText(typeNamePrefix + "Mutable" + typeName.substring(2), context);
                return type instanceof OCObjectType ? OCPointerType.to(type) : null;
            }
        }
        if (isId) {
            if (result.isPointerToObject() && (method.isConstructorMethod() || method.isClassConstructorMethod() || method.isFactoryMethod())) {
                return result;
            }
            if (OCElementUtil.startsWithWord(selector, "copy") || selector.endsWith("Copy")) {
                return result;
            }
            if (OCTypeGuesser.isOfficialNamingConvention(selector) || "sharedInstance".equals(selector) || "instance".equals(selector)) {
                return originalType.isClassType() ? null : result;
            }
            if (OCSelectorAdHocResolver.isPerformSelectorMethod(method.getName()) && sendMessageExpr != null) {
                List methods;
                OCExpression selectorExpr;
                List<OCExpression> argumentExprs = sendMessageExpr.getArgumentExpressions();
                OCExpression oCExpression = selectorExpr = argumentExprs.isEmpty() ? null : argumentExprs.get(0);
                if (selectorExpr instanceof OCSelectorExpression && (methods = ((OCPolyVariantReference)selectorExpr.getReference()).resolveToSymbols()).size() == 1) {
                    return ((OCMethodSymbol)methods.get(0)).getReturnType(context.getProject()).resolve(context);
                }
            }
        }
        return null;
    }

    public static boolean isNewInstanceCreation(OCExpression expression) {
        if (expression instanceof OCSendMessageExpression) {
            String selector = ((OCSendMessageExpression)expression).getMessageSelector();
            if (OCTypeGuesser.isNewInstanceSelector(selector)) {
                return true;
            }
            if (OCTypeGuesser.isOfficialNamingConvention(selector)) {
                return OCTypeGuesser.isNewInstanceCreation(((OCSendMessageExpression)expression).getReceiverExpression());
            }
        }
        return false;
    }

    public static boolean isInitializerName(String name) {
        return OCElementUtil.startsWithWord(name, "init");
    }

    private static boolean isNewInstanceSelector(String selector) {
        return OCElementUtil.startsWithWord(selector, "alloc") || OCElementUtil.startsWithWord(selector, "new");
    }

    public static boolean isOfficialNamingConvention(String selector) {
        return OCTypeGuesser.isNewInstanceSelector(selector) || OCElementUtil.startsWithWord(selector, "init") || OCElementUtil.startsWithWord(selector, "autorelease") || OCElementUtil.startsWithWord(selector, "retain") || OCElementUtil.startsWithWord(selector, "self");
    }

    @Nullable
    private static List<OCSymbol> findImmediateEnumSymbolBefore(final OCSymbol target, PsiFile file) {
        if (file == null) {
            return null;
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(file.getProject());
        List<FileSymbolTable> tables = cache.allTablesForFile(file);
        final ArrayList<OCSymbol> enumConsts = new ArrayList<OCSymbol>();
        for (FileSymbolTable table : tables) {
            final boolean[] metSymbol = new boolean[]{false};
            table.processFile((Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                public boolean process(OCSymbol symbol) {
                    if (symbol == target) {
                        metSymbol[0] = true;
                        return false;
                    }
                    if (symbol.getKind() == OCSymbolKind.ENUM_CONST) {
                        enumConsts.add(symbol);
                    } else {
                        enumConsts.clear();
                    }
                    if (symbol.getKind() == OCSymbolKind.NAMESPACE) {
                        CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)collector);
                        List results = (List)collector.getResults();
                        results.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
                        if (!ContainerUtil.process((List)results, (Processor)this)) {
                            return false;
                        }
                    }
                    return true;
                }
            });
            if (!metSymbol[0] || enumConsts.isEmpty()) continue;
            return enumConsts;
        }
        return null;
    }

    public static void processGuessedEnumConsts(OCIntType type, Processor<OCSymbol> processor, PsiElement context) {
        String typedefName = type.getAliasName();
        if (typedefName != null) {
            CommonProcessors.FindFirstProcessor collector = new CommonProcessors.FindFirstProcessor();
            OCSymbolReference.getLocalReference(OCQualifiedName.parse(typedefName), context).processPossibleSymbols((Processor<OCSymbol>)collector, OCResolveContext.forPsi((PsiElement)context.getContainingFile()));
            OCSymbol typedefSymbol = (OCSymbol)collector.getFoundValue();
            if (typedefSymbol instanceof OCDeclaratorSymbol && typedefSymbol.getKind() == OCSymbolKind.TYPEDEF) {
                PsiFile file = typedefSymbol.getContainingPsiFile(context.getProject());
                List<OCSymbol> consts = OCTypeGuesser.findImmediateEnumSymbolBefore(typedefSymbol, file);
                if (consts != null) {
                    for (OCSymbol symbol : consts) {
                        processor.process((Object)symbol);
                    }
                    return;
                }
                String singular = StringUtil.unpluralize((String)typedefName);
                String[] typeWords = NameUtil.nameToWords((String)(singular != null ? singular : typedefName));
                OCResolveUtil.processGlobalSymbols(null, context, (Processor<OCSymbol>)((Processor)ocSymbol -> {
                    String constName;
                    return !(ocSymbol instanceof OCDeclaratorSymbol) || ocSymbol.getKind() != OCSymbolKind.ENUM_CONST || !OCTypeGuesser.matchesTypeName(constName = ocSymbol.getName(), typeWords) || !Comparing.equal((Object)ocSymbol.getContainingFile(), (Object)typedefSymbol.getContainingFile()) || processor.process(ocSymbol);
                }));
            }
        }
    }

    private static boolean matchesTypeName(String constName, String[] typeWords) {
        String[] constWords = NameUtil.nameToWords((String)constName);
        int curConst = 0;
        boolean strictPrefix = "k".equals(constWords[0]);
        if (strictPrefix) {
            curConst = 1;
            for (String typeWord : typeWords) {
                if (curConst >= constWords.length) {
                    return false;
                }
                if (!"ID".equals(typeWord) && !constWords[curConst].equals(typeWord)) {
                    return false;
                }
                ++curConst;
            }
            return true;
        }
        for (String typeWord : typeWords) {
            while (curConst < constWords.length && !constWords[curConst].equals(typeWord) && !"ID".equals(typeWord)) {
                ++curConst;
            }
            ++curConst;
        }
        return curConst <= constWords.length;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "receiverContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/types/OCTypeGuesser";
        objectArray[2] = "getMethodGuessedReturnType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

