/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCDeductionCandidateSymbol;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.resolve.v2.TypeProperties;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.types.FindConstructorResult;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCArrayToPointerChanger;
import com.jetbrains.cidr.lang.types.visitors.OCBooleanTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCNonPrimitiveTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeUnificationVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCTypeUtils {
    @NotNull
    private static final DeepHashingStrategy DEEP_EQUAL_HASHING_STRATEGY = new DeepHashingStrategy();

    @NotNull
    public static <T> HashingStrategy<T> deepEqualHashingStrategy() {
        DeepHashingStrategy deepHashingStrategy = DEEP_EQUAL_HASHING_STRATEGY;
        if (deepHashingStrategy == null) {
            OCTypeUtils.$$$reportNull$$$0(0);
        }
        return deepHashingStrategy;
    }

    @NotNull
    public static <T> Set<T> newSymbolWithSubstitutionSet() {
        return new THashSet(new TObjectHashingStrategy<T>(){

            public int computeHashCode(T symbol) {
                return symbol.hashCode() * 31 + (symbol instanceof OCSymbolWithSubstitution ? ((OCSymbolWithSubstitution)symbol).getSubstitution().hashCode() : 0);
            }

            public boolean equals(T o1, T o2) {
                return DeepEqual.equalObjects(o1, o2);
            }
        });
    }

    @NotNull
    public static Set<Pair<OCSymbolReference, OCTypeSubstitution>> newReferenceWithSubstitutionSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)DEEP_EQUAL_HASHING_STRATEGY);
    }

    @NotNull
    public static Map<OCTypeParameterSymbol, OCTypeArgument> newTypeParameterMap() {
        return new Object2ObjectOpenCustomHashMap((Hash.Strategy)DEEP_EQUAL_HASHING_STRATEGY);
    }

    @NotNull
    public static <T extends OCTypeArgument> Set<T> newTypeSet() {
        return new ObjectOpenCustomHashSet((Hash.Strategy)DEEP_EQUAL_HASHING_STRATEGY);
    }

    @NotNull
    public static Map<OCType, OCType> newTypesMap() {
        return new Object2ObjectOpenCustomHashMap((Hash.Strategy)DEEP_EQUAL_HASHING_STRATEGY);
    }

    @NotNull
    public static <TKey, TValue> ConcurrentMap<TKey, TValue> newDeepEqualityMap() {
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap(OCTypeUtils.deepEqualHashingStrategy());
        if (concurrentMap == null) {
            OCTypeUtils.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    public static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(2);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(4);
        }
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, false);
    }

    public static boolean isSignaturesConformsTo(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes) {
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(5);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(7);
        }
        return OCTypeUtils.areSignaturesEqual(s1, s2, context, checkFunctionReturnTypes, true);
    }

    private static boolean areSignaturesEqual(@NotNull OCSymbolWithQualifiedName s1, @NotNull OCSymbolWithQualifiedName s2, @NotNull OCResolveContext context, boolean checkFunctionReturnTypes, boolean conformsTo) {
        List templateParams2;
        if (s1 == null) {
            OCTypeUtils.$$$reportNull$$$0(8);
        }
        if (s2 == null) {
            OCTypeUtils.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(10);
        }
        if ((s1 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s1)).isTemplateSymbol()) != (s2 instanceof OCTemplateSymbol && ((OCTemplateSymbol)((Object)s2)).isTemplateSymbol())) {
            return false;
        }
        OCQualifiedName fqn1 = s1.getResolvedQualifiedName(false, false, context);
        OCQualifiedName fqn2 = s2.getResolvedQualifiedName(false, false, context);
        if (fqn1 == null || fqn2 == null || !fqn1.equals(fqn2)) {
            return false;
        }
        List parentTemplateParams1 = s1.getParent() == s2.getParent() && s1.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1.getParent())).getTemplateParameters() : Collections.emptyList();
        List parentTemplateParams2 = s1.getParent() == s2.getParent() && s2.getParent() instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2.getParent())).getTemplateParameters() : Collections.emptyList();
        List templateParams1 = s1 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s1)).getTemplateParameters() : Collections.emptyList();
        List<Object> list = templateParams2 = s2 instanceof OCTemplateSymbol ? ((OCTemplateSymbol)((Object)s2)).getTemplateParameters() : Collections.emptyList();
        if (templateParams1.size() != templateParams2.size()) {
            return false;
        }
        Map<OCTypeParameterSymbol, OCTypeArgument> map = OCTypeUtils.newTypeParameterMap();
        OCType t1 = (s1 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s1).getTypeWithoutSubstitution() : s1.getType()).resolve(context);
        OCType t2 = (s2 instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s2).getTypeWithoutSubstitution() : s2.getType()).resolve(context);
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t2, null, map, null, context).unify(t1, t2).isUnified()) {
            return false;
        }
        if (conformsTo) {
            return true;
        }
        if (!new OCTypeUnificationVisitor(false, checkFunctionReturnTypes, false, false, false, t1, null, new HashMap<OCTypeParameterSymbol, OCTypeArgument>(), null, context).unify(t2, t1).isUnified()) {
            return false;
        }
        block0: for (Map.Entry<OCTypeParameterSymbol, OCTypeArgument> each : map.entrySet()) {
            if (!(each.getValue() instanceof OCTypeParameterType)) {
                return false;
            }
            OCTypeParameterSymbol key = each.getKey();
            OCTypeParameterSymbol value = ((OCTypeParameterType)each.getValue()).getSymbol();
            if (!(s1.getParent() != s2.getParent() || Objects.equals(key.getName(), value.getName()) || templateParams1.contains(key) || templateParams2.contains(value))) {
                return false;
            }
            while (key != null && value != null) {
                if (templateParams1.indexOf(key) != templateParams2.indexOf(value)) {
                    return false;
                }
                if (parentTemplateParams1.indexOf(key) != parentTemplateParams2.indexOf(value)) {
                    return false;
                }
                if (!(key instanceof OCTypeParameterTypeSymbol) || !(value instanceof OCTypeParameterTypeSymbol)) continue block0;
                key = ((OCTypeParameterTypeSymbol)key).getQualifierTypeParameter();
                value = ((OCTypeParameterTypeSymbol)value).getQualifierTypeParameter();
            }
        }
        for (int i2 = 0; i2 < templateParams1.size(); ++i2) {
            OCType pt1 = ((OCTypeParameterSymbol)templateParams1.get(i2)).getType().resolve(context);
            OCType pt2 = ((OCTypeParameterSymbol)templateParams2.get(i2)).getType().resolve(context);
            if (pt1 instanceof OCTypeParameterType && pt2 instanceof OCTypeParameterType || pt1.equals(pt2, true, context)) continue;
            return false;
        }
        return true;
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(11);
        }
        return OCTypeUtils.getExtractExpressionType(type, context, disallowConst, false);
    }

    public static OCType getExtractExpressionType(OCType type, @NotNull PsiElement context, boolean disallowConst, boolean forceReferenceMode) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(12);
        }
        if ((type = type.resolve(context)) instanceof OCArrayType) {
            OCArrayType array = (OCArrayType)type;
            type = OCPointerType.to(array.getRefType(), array.getARCAttribute(), array.getClassQualifier(), false, false);
        }
        if (OCTypeUtils.isPassableByReference(type, forceReferenceMode, context)) {
            return OCCppReferenceType.to(disallowConst ? type : type.cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCCppReferenceType) {
            return OCCppReferenceType.to(((OCCppReferenceType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        if (!disallowConst && type instanceof OCPointerType && !(type instanceof OCBlockPointerType) && !type.isPointerToObject()) {
            return OCPointerType.to(((OCPointerType)type).getRefType().cloneWithConstModifier(context.getProject()));
        }
        return type;
    }

    public static boolean isPassableByReference(OCType type, boolean forceReferenceMode, PsiElement context) {
        return (forceReferenceMode || type instanceof OCStructType && ((OCStructType)type).getKind() != OCSymbolKind.ENUM || type instanceof OCReferenceType) && !OCCodeInsightUtil.isInPlainOldC(context);
    }

    @Nullable
    public static OCType getCollectionItemType(@NotNull OCType collectionType, final @NotNull OCResolveContext context) {
        OCProtocolSymbol protocol;
        OCObjectType objectType;
        OCClassSymbol symbol;
        if (collectionType == null) {
            OCTypeUtils.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(14);
        }
        if (collectionType instanceof OCObjectType && (symbol = (objectType = (OCObjectType)collectionType).getClassSymbol()) != null && (protocol = (OCProtocolSymbol)OCSymbolBase.findSymbolDefinition("NSFastEnumeration", OCSymbolKind.PROTOCOL, context.getProject(), symbol.getContainingFile())) != null && objectType.implementsProtocol(protocol)) {
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> processor = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol o) {
                    OCType returnType = o.getReturnType(context.getProject()).resolve(context);
                    if (returnType instanceof OCPointerType) {
                        returnType = ((OCPointerType)returnType).getRefType();
                    }
                    if (!(returnType instanceof OCObjectType)) {
                        return false;
                    }
                    return "NSEnumerator".equals(((OCObjectType)returnType).getClassName());
                }
            };
            Iterator<String> methodNamesIterator = Arrays.asList("keyEnumerator", "objectEnumerator", null).iterator();
            while (!processor.isFound() && methodNamesIterator.hasNext()) {
                objectType.processMembers(methodNamesIterator.next(), OCMethodSymbol.class, processor, true, false);
            }
            if (processor.isFound()) {
                OCTypeArgument argument;
                List<OCGenericParameterSymbol> parameters;
                OCInterfaceSymbol interfaceSymbol;
                OCMethodSymbol value = (OCMethodSymbol)processor.getFoundValue();
                assert (value != null);
                OCType returnType = value.getReturnType(context.getProject()).resolve(context);
                if (returnType instanceof OCPointerType) {
                    returnType = ((OCPointerType)returnType).getRefType();
                }
                if ((interfaceSymbol = ((OCObjectType)returnType).getInterface()) != null && !(parameters = interfaceSymbol.getGenericParameters()).isEmpty() && (argument = interfaceSymbol.getSubstitution().getSubstitutionFor(parameters.get(0))) instanceof OCType) {
                    return (OCType)argument;
                }
            }
        }
        return null;
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(15);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(16);
        }
        return OCTypeUtils.decayType(type, project, true);
    }

    public static OCType decayType(@NotNull OCType type, @NotNull Project project, boolean removeCV) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(17);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(18);
        }
        if (type instanceof OCArrayType) {
            type = OCArrayToPointerChanger.INSTANCE.visitArrayType((OCArrayType)type);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCFunctionType) {
            type = OCPointerType.to(type);
        }
        return removeCV ? type.cloneWithoutCVQualifiers(project) : type;
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, Class<? extends OCType> ... typeClasses) {
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(19);
        }
        if (expression == null) {
            return false;
        }
        return OCTypeUtils.isInstanceOfTypeResolved(expression, OCResolveContext.forPsi(expression), typeClasses);
    }

    public static boolean isInstanceOfTypeResolved(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext, Class<? extends OCType> ... typeClasses) {
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(20);
        }
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(21);
        }
        return OCTypeUtils.isInstanceOfType(OCTypeUtils.getResolvedCppReferencedType(expression, resolveContext), typeClasses);
    }

    @Nullable
    public static OCType getResolvedCppReferencedType(@Nullable OCExpression expression, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(22);
        }
        return expression != null ? OCTypeUtils.getResolvedCppReferencedType(expression.getResolvedType(resolveContext), resolveContext) : null;
    }

    @NotNull
    public static OCType getResolvedCppReferencedType(@NotNull OCType type, @NotNull OCResolveContext resolveContext) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(23);
        }
        if (resolveContext == null) {
            OCTypeUtils.$$$reportNull$$$0(24);
        }
        OCType resolvedType = type.resolve(resolveContext);
        OCType oCType = OCTypeUtils.getCppReferencedType(resolvedType);
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(25);
        }
        return oCType;
    }

    @Contract(value="!null -> !null")
    @Nullable
    public static OCType getCppReferencedType(@Nullable OCType type) {
        if (type instanceof OCCppReferenceType) {
            return ((OCCppReferenceType)type).getRefType();
        }
        return type;
    }

    public static boolean isCppReferenceType(@Nullable OCType type) {
        return type instanceof OCCppReferenceType;
    }

    public static boolean isInstanceOfType(@Nullable OCType type, Class<? extends OCType> ... typeClasses) {
        if (typeClasses == null) {
            OCTypeUtils.$$$reportNull$$$0(26);
        }
        if (type == null) {
            return false;
        }
        for (Class<? extends OCType> typeClass : typeClasses) {
            if (!typeClass.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean isIntegralType(@Nullable OCType type) {
        return type instanceof OCIntType;
    }

    public static boolean isEnumType(@Nullable OCType type) {
        return type instanceof OCStructType && ((OCStructType)type).isEnum();
    }

    @Nullable
    public static <T extends OCType> T getAs(@NotNull Class<T> cls, @Nullable OCType type) {
        if (cls == null) {
            OCTypeUtils.$$$reportNull$$$0(27);
        }
        if (type != null && cls.isAssignableFrom(type.getClass())) {
            return (T)type;
        }
        return null;
    }

    @NotNull
    public static OCType doSwitchImplicitConversion(@NotNull OCSwitchStatement swtch, @NotNull OCType switchType) {
        if (swtch == null) {
            OCTypeUtils.$$$reportNull$$$0(28);
        }
        if (switchType == null) {
            OCTypeUtils.$$$reportNull$$$0(29);
        }
        OCResolveContext context = OCResolveContext.forPsi(swtch);
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (!(switchType instanceof OCStructType)) {
            if (switchType.isIntegerCompatible(context)) {
                OCIntType oCIntType = OCIntType.INT;
                if (oCIntType == null) {
                    OCTypeUtils.$$$reportNull$$$0(30);
                }
                return oCIntType;
            }
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(31);
            }
            return oCType;
        }
        OCStructType clsTy = (OCStructType)switchType;
        if (clsTy.isEnum()) {
            OCStructType oCStructType = clsTy;
            if (oCStructType == null) {
                OCTypeUtils.$$$reportNull$$$0(32);
            }
            return oCStructType;
        }
        Pair<OCType, OCFunctionSymbol> conversionRes = OCTypeCompatibilityVisitor.convertByOperator(clsTy, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isIntegralType(type) || OCTypeUtils.isEnumType(type)));
        if (conversionRes == null) {
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(33);
            }
            return oCType;
        }
        if (!OCVisibility.isVisible((OCSymbol)conversionRes.second, swtch, null, context.getProject())) {
            OCType oCType = switchType;
            if (oCType == null) {
                OCTypeUtils.$$$reportNull$$$0(34);
            }
            return oCType;
        }
        OCType oCType = (OCType)conversionRes.first;
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    public static int getNonVariadicParametersCount(List<? extends OCType> parameterTypes) {
        int count = 0;
        for (OCType oCType : parameterTypes) {
            if (oCType instanceof OCVariadicType || oCType instanceof OCEllipsisType) continue;
            ++count;
        }
        return count;
    }

    @NotNull
    public static List<Object> getDefaultValues(boolean isConstexpr, @NotNull List<OCDeclaratorSymbol> paramSymbols) {
        if (paramSymbols == null) {
            OCTypeUtils.$$$reportNull$$$0(36);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i2 = paramSymbols.size() - 1; i2 >= 0 && paramSymbols.get(i2).hasInitializer(); --i2) {
            OCInitializerSymbol initializer = paramSymbols.get(i2).getInitializer();
            if (isConstexpr) {
                result.add(0, initializer);
                continue;
            }
            result.add(0, initializer.getPresentableName());
        }
        ArrayList<Object> arrayList = result;
        if (arrayList == null) {
            OCTypeUtils.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    public static int getNonInitializedParametersCount(@NotNull List<OCDeclaratorSymbol> parameterSymbols, @Nullable OCResolveContext context) {
        if (parameterSymbols == null) {
            OCTypeUtils.$$$reportNull$$$0(38);
        }
        int result = 0;
        for (OCDeclaratorSymbol param : parameterSymbols) {
            OCType paramType = param.getType();
            if (context != null) {
                paramType = paramType.resolve(context.clone());
            }
            if (param.hasInitializer() || paramType instanceof OCEllipsisType || paramType instanceof OCVoidType) break;
            if (paramType instanceof OCVariadicType) {
                List<OCType> expanded;
                if (context == null || (expanded = OCArgumentsList.expandVariadicTypes(Collections.singletonList(paramType), context)).size() == 1 && ContainerUtil.getFirstItem(expanded) == paramType) continue;
                result += expanded.size();
                continue;
            }
            ++result;
        }
        return result;
    }

    public static boolean hasAutoInside(@NotNull OCType type) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(39);
        }
        return type.accept(new OCBooleanTypeVisitor(){

            @Override
            public Boolean visitAutoType(OCAutoType type) {
                return type.getExpressionSymbol() == null && type.getExpressionElement() == null;
            }
        });
    }

    @NotNull
    public static OCType replaceAutoTypesWithTypeParameters(@NotNull OCType type, final @NotNull Map<OCType, OCType> map, @NotNull Project project) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(40);
        }
        if (map == null) {
            OCTypeUtils.$$$reportNull$$$0(41);
        }
        if (project == null) {
            OCTypeUtils.$$$reportNull$$$0(42);
        }
        OCType oCType = type.accept(new OCNonPrimitiveTypeCloneVisitor(){

            @Override
            public OCType visitAutoType(OCAutoType type) {
                OCTypeParameterTypeSymbol autoSymbol = new OCTypeParameterTypeSymbol(null, map.size(), "auto", null, Collections.emptyList(), null, false, true, true);
                OCTypeParameterType.ReplacedAutoType newType = new OCTypeParameterType.ReplacedAutoType(autoSymbol, type.isConst(), type.isVolatile());
                map.put(type, newType);
                return newType;
            }
        });
        if (oCType == null) {
            OCTypeUtils.$$$reportNull$$$0(43);
        }
        return oCType;
    }

    public static boolean isUnresolvedLambdaAutoType(@Nullable OCType type) {
        return type instanceof OCAutoType && ((OCAutoType)type).needsAutoParamsResolving();
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType type, @NotNull OCResolveContext context, @NotNull OCArgumentsList<? extends OCTypeOwner> argumentsList, boolean failIfNotUnified) {
        OCExpressionSymbol symbol;
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(44);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(45);
        }
        if (argumentsList == null) {
            OCTypeUtils.$$$reportNull$$$0(46);
        }
        if ((symbol = ((OCAutoType)type).getExpressionSymbol()) instanceof OCLambdaExpressionSymbol) {
            return ((OCLambdaExpressionSymbol)symbol).getResolvedType(context, argumentsList, failIfNotUnified);
        }
        return type;
    }

    @Nullable
    public static OCType resolveLambdaAutoType(@NotNull OCType lType, @NotNull OCType rType, @NotNull OCResolveContext context) {
        if (lType == null) {
            OCTypeUtils.$$$reportNull$$$0(47);
        }
        if (rType == null) {
            OCTypeUtils.$$$reportNull$$$0(48);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(49);
        }
        if (lType.getTerminalType() instanceof OCFunctionType) {
            OCArgumentsList arguments = new OCArgumentsList(((OCFunctionType)lType.getTerminalType()).getParameterTypes(), null);
            OCType resolvedType = OCTypeUtils.resolveLambdaAutoType(rType, context, arguments, false);
            if (resolvedType != null && resolvedType.getTerminalType() instanceof OCFunctionType) {
                return resolvedType;
            }
            ((OCAutoType)rType).setNeedsAutoParamsResolving(false);
            return rType.resolve(context);
        }
        OCExpressionSymbol expressionSymbol = ((OCAutoType)rType).getExpressionSymbol();
        if (expressionSymbol != null) {
            return expressionSymbol.getResolvedType(context);
        }
        return rType;
    }

    public static boolean isSameOrDerivedFrom(OCType derived, OCType base, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(50);
        }
        return TypeProperties.hasSameUnqualifiedType(derived, base, context) || TypeProperties.IsDerivedFrom(derived, base, context);
    }

    public static boolean isOrIsDerivedFromSpecializationOf(OCType derived, OCType base, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(51);
        }
        if (!(base instanceof OCStructType) || !(derived instanceof OCStructType)) {
            return false;
        }
        if (!OCTypeUtils.isPrimaryTemplate((OCStructType)base) || OCTypeUtils.isPrimaryTemplate((OCStructType)derived)) {
            return false;
        }
        if (TypeProperties.hasSameUnqualifiedType(derived, base, context)) {
            return true;
        }
        for (OCStructSymbol derivedSymbol : ((OCStructType)derived).getStructs()) {
            Ref result = new Ref((Object)false);
            derivedSymbol.processAllBaseClasses((symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol && !OCTypeUtils.isPrimaryTemplate((OCStructSymbol)symbol) && TypeProperties.hasSameUnqualifiedType(symbol.getResolvedType(context), base, context)) {
                    result.set((Object)true);
                    return false;
                }
                return true;
            }, context);
            if (!((Boolean)result.get()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimaryTemplate(OCStructType type) {
        return OCTypeUtils.isPrimaryTemplate(type.getSymbol());
    }

    public static boolean isPrimaryTemplate(OCStructSymbol symbol) {
        return symbol.isTemplateSymbol() && symbol.getSubstitution().isEmpty();
    }

    public static boolean isPolymorphic(@NotNull OCType type, @NotNull OCResolveContext context) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(52);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(53);
        }
        return type.isCppStructType(context) && !((OCStructType)type).processMembers(null, (Processor<? super OCSymbol>)((Processor)symbol -> !(symbol instanceof OCFunctionSymbol) || !((OCFunctionSymbol)symbol).isVirtual()), context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(54);
        }
        return OCTypeUtils.getSymbolType(symbol, null, context);
    }

    public static OCType getSymbolType(@Nullable OCSymbol symbol, @Nullable OCSymbolReference reference, @NotNull OCResolveContext context) {
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(55);
        }
        if (symbol instanceof OCStructSymbol) {
            return new OCFunctionType(OCVoidType.instance(), Collections.emptyList());
        }
        OCType type = symbol != null ? symbol.getType() : OCUnknownType.INSTANCE;
        type = OCTypeUtils.changeTypeReferences(type, reference, context);
        return type instanceof OCVariadicType ? ((OCVariadicType)type).getUnderlyingType() : type;
    }

    @NotNull
    public static OCType deduceDeclaratorTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, @NotNull OCDeclaratorSymbol symbol, @NotNull OCResolveContext context) {
        OCStructSymbol structSymbol;
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(56);
        }
        if (symbol == null) {
            OCTypeUtils.$$$reportNull$$$0(57);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(58);
        }
        if ((structSymbol = type.getSymbol()).isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty()) {
            boolean isListInitialization;
            List<OCExpressionSymbol> initializers;
            OCInitializerSymbol initializerSymbol = symbol.getInitializer();
            if (initializerSymbol != null) {
                initializers = initializerSymbol.getArguments();
                isListInitialization = initializerSymbol.isListInitializer();
            } else {
                initializers = Collections.emptyList();
                isListInitialization = false;
            }
            OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(initializers, context);
            return OCTypeUtils.deduceClassTemplateArguments(type, unresolvedType, arguments, isListInitialization, context, symbol.getContainingFile(), symbol.getComplexOffset());
        }
        OCStructType oCStructType = type;
        if (oCStructType == null) {
            OCTypeUtils.$$$reportNull$$$0(59);
        }
        return oCStructType;
    }

    @NotNull
    public static OCType deduceClassTemplateArguments(@NotNull OCStructType type, OCType unresolvedType, OCArgumentsList<?> arguments, boolean isListInitialization, @NotNull OCResolveContext context, @Nullable VirtualFile file, long complexOffset) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(60);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(61);
        }
        OCStructSymbol structSymbol = type.getSymbol();
        if (type.getArguments() == null && OCTypeUtils.hasNonDeducedClassTemplateArguments(structSymbol)) {
            OCStructSymbol deducedTypeSymbol;
            OCType deducedType;
            OCFunctionSymbol deductionFunction = OCTypeUtils.findDeductionCandidate(structSymbol, arguments, context, isListInitialization, file, complexOffset);
            OCType oCType = deducedType = deductionFunction != null ? deductionFunction.getEffectiveResolvedType(context) : null;
            if (deducedType instanceof OCStructType && !OCTypeUtils.hasNonDeducedClassTemplateArguments(deducedTypeSymbol = ((OCStructType)deducedType).getSymbol())) {
                if (unresolvedType instanceof OCReferenceType) {
                    List<OCTypeArgument> templateArguments = deducedTypeSymbol.getTemplateArguments(context);
                    OCSymbolReference reference = ((OCReferenceType)unresolvedType).getReference().cloneWithArguments(templateArguments);
                    deducedType = ((OCReferenceType)unresolvedType).cloneWithReference(reference).resolve(context);
                }
                OCType oCType2 = deducedType.cloneWithCVQualifiers(type.getCVQualifiers(), context.getProject());
                if (oCType2 == null) {
                    OCTypeUtils.$$$reportNull$$$0(62);
                }
                return oCType2;
            }
        }
        OCStructType oCStructType = type;
        if (oCStructType == null) {
            OCTypeUtils.$$$reportNull$$$0(63);
        }
        return oCStructType;
    }

    private static boolean hasNonDeducedClassTemplateArguments(OCStructSymbol structSymbol) {
        return structSymbol.isTemplateSymbol() && !structSymbol.isSpecialization() && structSymbol.getSubstitution().isEmpty();
    }

    @Nullable
    private static OCFunctionSymbol findDeductionCandidate(final @NotNull OCStructSymbol structSymbol, @NotNull OCArgumentsList<?> arguments, @NotNull OCResolveContext context, boolean isListInitialization, @Nullable VirtualFile file, long complexOffset) {
        if (structSymbol == null) {
            OCTypeUtils.$$$reportNull$$$0(64);
        }
        if (arguments == null) {
            OCTypeUtils.$$$reportNull$$$0(65);
        }
        if (context == null) {
            OCTypeUtils.$$$reportNull$$$0(66);
        }
        final HashSet<OCSymbol> deductionCandidates = new HashSet<OCSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol constructorSymbol) {
                if (constructorSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)constructorSymbol).isCppConstructor()) {
                    OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromConstructor(structSymbol, (OCFunctionSymbol)constructorSymbol);
                    return deductionCandidates.add(candidate);
                }
                return false;
            }
        };
        structSymbol.processConstructors((Processor<? super OCFunctionSymbol>)collector);
        OCSymbolReference.SymbolFilter guildeFilter = symbol -> {
            if (!(symbol instanceof OCDeductionGuideSymbol)) {
                return false;
            }
            return OCResolveUtil.isEarlierInCodeWithComplexOffset(symbol, file, complexOffset);
        };
        List<OCSymbol> guides = OCSymbolReference.getGlobalReference(OCQualifiedName.with(structSymbol.getType().getName()), null, null, -1L, guildeFilter).resolveToSymbols(context);
        for (OCSymbol guide : guides) {
            if (!(guide instanceof OCDeductionGuideSymbol)) continue;
            OCDeductionCandidateSymbol candidate = OCDeductionCandidateSymbol.createFromDeductionGuide(structSymbol, (OCDeductionGuideSymbol)guide);
            deductionCandidates.add(candidate);
        }
        deductionCandidates.add(structSymbol);
        FindConstructorResult overloadResult = OCResolveOverloadsUtil.resolveConstructorOverloads(structSymbol.getType(), deductionCandidates, arguments, false, isListInitialization, true, context, null);
        return overloadResult.getSymbol();
    }

    public static OCType changeTypeReferences(@NotNull OCType type, @Nullable OCSymbolReference reference) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(67);
        }
        return OCTypeUtils.changeTypeReferences(type, reference, null);
    }

    public static OCType changeTypeReferences(@NotNull OCType type, final @Nullable OCSymbolReference reference, final @Nullable OCResolveContext context) {
        if (type == null) {
            OCTypeUtils.$$$reportNull$$$0(68);
        }
        if (reference != null) {
            type = OCTypeCloneVisitor.cloneType(type, new OCTypeCloneVisitor(false){

                @Override
                public OCType visitReferenceType(OCReferenceType type) {
                    if (context != null && context.getResolvingTypeNames().contains(type.getReference().getQualifiedName().dropArguments())) {
                        return type;
                    }
                    return this.cloneReferenceType(type, type.getReference().cloneWithOffset(reference));
                }

                @Override
                public OCType visitDeferredType(OCDeferredType type) {
                    if (context == null) {
                        return super.visitDeferredType(type);
                    }
                    return type.getActualType(context).accept(this);
                }
            });
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCTypeUtils";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 45: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 58: 
            case 61: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collectionType";
                break;
            }
            case 15: 
            case 17: 
            case 23: 
            case 39: 
            case 40: 
            case 44: 
            case 52: 
            case 56: 
            case 60: 
            case 67: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 16: 
            case 18: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeClasses";
                break;
            }
            case 20: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "swtch";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramSymbols";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterSymbols";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsList";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lType";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rType";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structSymbol";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "deepEqualHashingStrategy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "newDeepEqualityMap";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCTypeUtils";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedCppReferencedType";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "doSwitchImplicitConversion";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValues";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceAutoTypesWithTypeParameters";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceDeclaratorTemplateArguments";
                break;
            }
            case 62: 
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "deduceClassTemplateArguments";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areSignaturesEqual";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSignaturesConformsTo";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExtractExpressionType";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCollectionItemType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "decayType";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfTypeResolved";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedCppReferencedType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isInstanceOfType";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getAs";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doSwitchImplicitConversion";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValues";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNonInitializedParametersCount";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasAutoInside";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "replaceAutoTypesWithTypeParameters";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "resolveLambdaAutoType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isSameOrDerivedFrom";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isOrIsDerivedFromSpecializationOf";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphic";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolType";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "deduceDeclaratorTemplateArguments";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "deduceClassTemplateArguments";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "findDeductionCandidate";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "changeTypeReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DeepHashingStrategy
    implements HashingStrategy<Object>,
    Hash.Strategy<Object> {
        private DeepHashingStrategy() {
        }

        public int hashCode(@Nullable Object object) {
            return object == null ? 0 : object.hashCode();
        }

        public boolean equals(@Nullable Object o1, @Nullable Object o2) {
            return DeepEqual.equalObjects(o1, o2);
        }
    }
}

