/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.util.Version;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDomainRegistry
implements DomainRegistry {
    private final Set<Domain> mySet = new LinkedHashSet<Domain>();

    protected BaseDomainRegistry() {
    }

    @Override
    @Nullable
    public Domain getDomain(@NotNull ColumnDescriptor descriptor2) {
        if (descriptor2 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(0);
        }
        return (Domain)ContainerUtil.find(this.mySet, domain -> domain.isSuitable(descriptor2));
    }

    @Override
    @NotNull
    public Collection<Domain> getDomains() {
        Set<Domain> set = Collections.unmodifiableSet(this.mySet);
        if (set == null) {
            BaseDomainRegistry.$$$reportNull$$$0(1);
        }
        return set;
    }

    protected final void add(@NotNull Domain domain) {
        String name;
        if (domain == null) {
            BaseDomainRegistry.$$$reportNull$$$0(2);
        }
        if (ContainerUtil.find(this.mySet, arg_0 -> BaseDomainRegistry.lambda$add$1(name = domain.name(), arg_0)) != null) {
            throw new AssertionError((Object)("Already have domain " + name + " in " + this.getClass().getSimpleName()));
        }
        this.mySet.add(domain);
    }

    protected final void remove(@NotNull String name) {
        if (name == null) {
            BaseDomainRegistry.$$$reportNull$$$0(3);
        }
        if (!this.mySet.removeIf(d2 -> d2.name().equals(name))) {
            throw new AssertionError((Object)("No domain " + name + " in " + this.getClass().getSimpleName()));
        }
    }

    @NotNull
    public static Domain getMostRecentDomain(@NotNull Domain domain, @NotNull Dbms dbms, @Nullable Version version) {
        DomainRegistry registry;
        if (domain == null) {
            BaseDomainRegistry.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(5);
        }
        if ((registry = BaseDomainRegistry.get(dbms, version)) == null) {
            Domain domain2 = Domain.EMPTY;
            if (domain2 == null) {
                BaseDomainRegistry.$$$reportNull$$$0(6);
            }
            return domain2;
        }
        Collection<Domain> domains = registry.getDomains();
        Domain unwrapped = DataGridUtilCore.unwrap(domain);
        List filtered2 = ContainerUtil.filter(domains, current -> current.contains(unwrapped));
        Comparator domainComparator = (Comparator)COMPARATOR_GENERATOR.fun((Object)unwrapped);
        ContainerUtil.sort((List)filtered2, (Comparator)domainComparator);
        Domain item = (Domain)ContainerUtil.getFirstItem((List)filtered2);
        Domain domain3 = item == null ? Domain.EMPTY : item.narrow(unwrapped);
        if (domain3 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(7);
        }
        return domain3;
    }

    @Nullable
    public static DomainRegistry get(@NotNull Dbms dbms, @Nullable Version version) {
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(8);
        }
        DomainRegistry registry = (DomainRegistry)EP.forDbms(dbms);
        return version == null || registry == null ? registry : new DomainRegistry.VersionedDomainRegistry(registry, version);
    }

    @Nullable
    public static Domain getDomain(@NotNull Dbms dbms, @Nullable Version version, @NotNull ColumnDescriptor descriptor2, boolean raw) {
        DomainRegistry registry;
        Domain domain;
        if (dbms == null) {
            BaseDomainRegistry.$$$reportNull$$$0(9);
        }
        if (descriptor2 == null) {
            BaseDomainRegistry.$$$reportNull$$$0(10);
        }
        Domain domain2 = domain = (registry = BaseDomainRegistry.get(dbms, version)) == null ? null : registry.getDomain(descriptor2);
        return domain == null ? null : (raw ? domain : domain.narrow(descriptor2));
    }

    private static /* synthetic */ boolean lambda$add$1(String name, Domain d2) {
        return d2.name().equals(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/BaseDomainRegistry";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/BaseDomainRegistry";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomains";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMostRecentDomain";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDomain";
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getMostRecentDomain";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

