/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.DynamicBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.PresentableId;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshConfigComboBox;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.SelectionAwareListCellRenderer;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataSourceSshPanel {
    private final Project myProject;
    private final LocalDataSource myDataSource;
    private final Disposable myParent;
    private JPanel myPanel;
    private JCheckBox myUseSshCheckBox;
    private SshConfigComboBox mySshConfigComboBox;

    public DataSourceSshPanel(@NotNull Project project, @NotNull LocalDataSource dataSource2, @NotNull Disposable parent2) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DataSourceSshPanel.$$$reportNull$$$0(1);
        }
        if (parent2 == null) {
            DataSourceSshPanel.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDataSource = dataSource2;
        this.myParent = parent2;
        this.$$$setupUI$$$();
        this.reset(this.myDataSource);
        this.myUseSshCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DataSourceSshPanel.this.updateSshPanel();
            }
        });
        this.mySshConfigComboBox.setProxyOpenSSHCompletion(() -> this.getActualHostPort());
        this.updateSshPanel();
    }

    private void updateSshPanel() {
        this.mySshConfigComboBox.setEnabled(this.myUseSshCheckBox.isSelected());
    }

    @Nullable
    protected Pair<String, String> getActualHostPort() {
        DatabaseDriver driver = this.myDataSource.getDatabaseDriver();
        String url = this.myDataSource.getUrl();
        return driver == null || url == null ? null : JdbcUrlParserUtil.extractHostPort(driver.getJDBCUrlParsers(), url, null);
    }

    public void updateInfoLabel() {
        Pair<String, String> hostPort = this.getActualHostPort();
        if (hostPort == null) {
            this.myUseSshCheckBox.setToolTipText(DatabaseBundle.message("DataSourceSshPanel.unable.to.find.host.port", new Object[0]));
        } else {
            this.myUseSshCheckBox.setToolTipText(DatabaseBundle.message("DataSourceSshPanel.remote.host.is", hostPort.first, hostPort.second));
        }
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            DataSourceSshPanel.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @Nullable
    public DataSourceSshTunnelConfiguration createSshConfig() {
        @Nullable SshConfig sshConfig = this.mySshConfigComboBox.getSelectedSshConfig();
        if (sshConfig == null) {
            return null;
        }
        return new DataSourceSshTunnelConfiguration(this.myUseSshCheckBox.isSelected(), sshConfig.getId());
    }

    @Nullable
    public SshUiData getUiData() {
        if (!this.myUseSshCheckBox.isSelected()) {
            return null;
        }
        Pair uiDataAndName = this.mySshConfigComboBox.getSelectedUiDataAndName();
        return uiDataAndName == null ? null : (SshUiData)uiDataAndName.first;
    }

    private void setupFromSshCfg(@Nullable DataSourceSshTunnelConfiguration c2) {
        this.myUseSshCheckBox.setSelected(c2 != null && c2.isEnabled());
        this.mySshConfigComboBox.reload(c2 == null ? null : PresentableId.createId((String)c2.getSshConfigId(), null), SshConfigVisibility.App);
    }

    private void createUIComponents() {
        this.mySshConfigComboBox = new SshConfigComboBox(this.myProject, this.myParent, SshConfigVisibility.App);
    }

    public void copyFrom(LocalDataSource actualDataSource) {
        this.myUseSshCheckBox.setSelected(true);
        this.setupFromSshCfg(actualDataSource.getSshConfiguration());
        this.updateSshPanel();
    }

    protected LocalDataSource getActualDataSource(LocalDataSource dataSource2) {
        return dataSource2;
    }

    @NotNull
    static LinkLabel<?> createLabel(final @NotNull Project project, final @NotNull Condition<LocalDataSource> condition, final @NotNull Consumer<? super LocalDataSource> processor, final @Nls @NotNull String emptyText) {
        if (project == null) {
            DataSourceSshPanel.$$$reportNull$$$0(4);
        }
        if (condition == null) {
            DataSourceSshPanel.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            DataSourceSshPanel.$$$reportNull$$$0(6);
        }
        if (emptyText == null) {
            DataSourceSshPanel.$$$reportNull$$$0(7);
        }
        return new LinkLabel(DatabaseBundle.message("ssl.copy.from", new Object[0]), null, (LinkListener)new LinkListener<Void>(){

            public void linkSelected(LinkLabel<Void> src, Void data) {
                List<LocalDataSource> sources = DataSourceSshPanel.findAvailableDataSources(project, (Condition<LocalDataSource>)condition);
                if (sources.isEmpty()) {
                    JBPopupFactory.getInstance().createPopupChooserBuilder(Collections.singletonList(emptyText)).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(dom -> {
                        JBLabel label = new JBLabel(dom, null, 2);
                        label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                        return label;
                    })).setRequestFocus(true).createPopup().showUnderneathOf(src);
                    return;
                }
                JBPopupFactory.getInstance().createPopupChooserBuilder(sources).setRenderer((ListCellRenderer)new SelectionAwareListCellRenderer(o -> {
                    JBLabel label = new JBLabel(o.getName(), o.getBaseIcon(), 2);
                    label.setBorder((Border)JBUI.Borders.empty((int)2, (int)4));
                    return label;
                })).setRequestFocus(true).setItemChosenCallback(source -> {
                    if (source == null) {
                        return;
                    }
                    processor.consume(source);
                }).createPopup().showUnderneathOf(src);
            }
        });
    }

    @NotNull
    private static List<LocalDataSource> findAvailableDataSources(Project project, Condition<LocalDataSource> condition) {
        List<DbDataSource> dataSources = DbPsiFacade.getInstance(project).getDataSources();
        List list = JBIterable.from(dataSources).map(DbElement::getDelegate).filter(LocalDataSource.class).filter(condition).sort(Comparator.comparing(AbstractDataSource::getName)).toList();
        if (list == null) {
            DataSourceSshPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void reset(@NotNull LocalDataSource ds) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(9);
        }
        this.setupFromSshCfg(ds.getSshConfiguration());
    }

    public void saveData(@NotNull LocalDataSource ds, boolean enforceCredentials) {
        if (ds == null) {
            DataSourceSshPanel.$$$reportNull$$$0(10);
        }
        DataSourceSshTunnelConfiguration newSsh = this.createSshConfig();
        if (enforceCredentials && newSsh != null) {
            newSsh.enforceCredentials(this.myProject);
        }
        ds.setSshConfiguration(newSsh);
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/DataSourceSshPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findAvailableDataSources";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 8: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "saveData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myUseSshCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(10);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DatabaseBundle", DataSourceSshPanel.class).getString("ssh.panel.use.ssh.tunnel"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(136, 22), null, 0, true));
        SshConfigComboBox sshConfigComboBox = this.mySshConfigComboBox;
        jPanel.add((Component)sshConfigComboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c2 = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c2 = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c2);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

