/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.console.SearchPathSender;
import com.intellij.database.console.client.DatabaseSessionClient;
import com.intellij.database.console.client.SessionClientHolder;
import com.intellij.database.console.client.VisibleDatabaseSessionClient;
import com.intellij.database.console.session.DatabaseSession;
import com.intellij.database.console.session.DatabaseSessionManager;
import com.intellij.database.csv.CsvFormat;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.ConsoleGridDataHookUp;
import com.intellij.database.datagrid.CsvDocumentDataHookUp;
import com.intellij.database.datagrid.DataBusGridDataHookUp;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGridSessionClient;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.JpaGridDataHookUp;
import com.intellij.database.datagrid.SqlDocumentDataHookUp;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.session.Session;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.vfs.fragment.CsvTableDataFragmentFile;
import com.intellij.database.vfs.fragment.SqlTableDataFragmentFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GridDataHookUpManager
extends SessionClientHolder<DataGridSessionClient, Parameters> {
    private final Project myProject;
    private final Map<VirtualFile, HookUpReference> myVirtualFileBasedHookUps;
    private final Set<HookUpReference> myHookUps;
    private final Object myLock;

    public GridDataHookUpManager(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(0);
        }
        super(DataGridSessionClient.class);
        this.myProject = project;
        this.myVirtualFileBasedHookUps = new HashMap<VirtualFile, HookUpReference>();
        this.myHookUps = new HashSet<HookUpReference>();
        this.myLock = new Object();
    }

    public static GridDataHookUpManager getInstance(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(1);
        }
        return (GridDataHookUpManager)project.getService(GridDataHookUpManager.class);
    }

    @NotNull
    public DataGridSessionClient getHookUp(@NotNull VirtualFile file, @NotNull Disposable parent2, @Nls @Nullable String sessionName) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(2);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(3);
        }
        DataGridSessionClient dataGridSessionClient = this.getOrCreateHookUp(file, this.generator((tableFile, session2) -> {
            Parameters parameters = new Parameters(this.myProject, (DatabaseSession)session2, (VirtualFile)tableFile);
            return (DataGridSessionClient)this.createClient(parameters);
        }, (dataSource2, title) -> sessionName != null ? DatabaseSessionManager.getExactSession(this.myProject, dataSource2, sessionName) : DatabaseSessionManager.getSession(this.myProject, dataSource2, title)), parent2);
        if (dataGridSessionClient == null) {
            GridDataHookUpManager.$$$reportNull$$$0(4);
        }
        return dataGridSessionClient;
    }

    @NotNull
    public DatabaseTableGridDataHookUp getOrCreateLightweight(@NotNull VirtualFile file, @NotNull Disposable parent2, @NotNull DatabaseDepartment department) {
        DatabaseTableGridDataHookUp cached;
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(5);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(6);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(7);
        }
        if ((cached = this.getCachedHookUp(file, parent2)) != null) {
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = cached;
            if (databaseTableGridDataHookUp == null) {
                GridDataHookUpManager.$$$reportNull$$$0(8);
            }
            return databaseTableGridDataHookUp;
        }
        HookUpFactory<VirtualFile, DatabaseTableGridDataHookUp, DatabaseSession> hookUpFactory = (tableFile, session2) -> {
            DatabaseTableGridDataHookUp hookUp = new DatabaseTableGridDataHookUp(this.myProject, (DatabaseSession)session2, (VirtualFile)tableFile, department);
            LocalDataSource target = (LocalDataSource)session2.getTarget();
            VisibleDatabaseSessionClient client = DatabaseSessionManager.facade(this.myProject, target, null, null, true, null, department).client((DatabaseSession)session2);
            Disposer.register((Disposable)parent2, (Disposable)hookUp);
            Disposer.register((Disposable)hookUp, (Disposable)client);
            return hookUp;
        };
        SessionFactory<DatabaseSession> sessionFactory = (dataSource2, title) -> DatabaseSessionManager.getSession(this.myProject, dataSource2, title);
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = (DatabaseTableGridDataHookUp)this.generator(hookUpFactory, sessionFactory).fun((Object)file);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(9);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull CsvTableDataFragmentFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(10);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(11);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, file1.getFormat(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent2);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(12);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public SqlDocumentDataHookUp getHookUp(@NotNull SqlTableDataFragmentFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(13);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(14);
        }
        SqlDocumentDataHookUp sqlDocumentDataHookUp = (SqlDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new SqlDocumentDataHookUp(this.myProject, file1.getDialect(), GridDataHookUpManager.getDocument(file1.getOriginalFile()), file1.getRange()), parent2);
        if (sqlDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(15);
        }
        return sqlDocumentDataHookUp;
    }

    @NotNull
    public CsvDocumentDataHookUp getHookUp(@NotNull VirtualFile file, @NotNull CsvFormat format, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(16);
        }
        if (format == null) {
            GridDataHookUpManager.$$$reportNull$$$0(17);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(18);
        }
        CsvDocumentDataHookUp csvDocumentDataHookUp = (CsvDocumentDataHookUp)this.getOrCreateHookUp(file, file1 -> new CsvDocumentDataHookUp(this.myProject, format, GridDataHookUpManager.getDocument(file1), null), parent2);
        if (csvDocumentDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(19);
        }
        return csvDocumentDataHookUp;
    }

    @NotNull
    public ConsoleGridDataHookUp createDatabaseHookUp(@NotNull Disposable parent2, @NotNull DatabaseSession session2, @NotNull SearchPathSender sender, @NotNull DatabaseDepartment department, @Nullable DataRequest.OwnerEx parentOwner) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(20);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(21);
        }
        if (sender == null) {
            GridDataHookUpManager.$$$reportNull$$$0(22);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(23);
        }
        ConsoleGridDataHookUp consoleGridDataHookUp = this.registerHookUp(new ConsoleGridDataHookUp(this.myProject, session2, department, sender, parentOwner), parent2);
        if (consoleGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(24);
        }
        return consoleGridDataHookUp;
    }

    @NotNull
    public DatabaseTableGridDataHookUp createDatabaseTableHookUp(@NotNull Disposable parent2, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @NotNull VirtualFile file) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(25);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(26);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(27);
        }
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(28);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.registerHookUp(new DatabaseTableGridDataHookUp(this.myProject, session2, file, department), parent2);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(29);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public DatabaseTableGridDataHookUp createDatabaseHookUp(@NotNull Disposable parent2, @NotNull DatabaseSession session2, @NotNull DatabaseDepartment department, @NotNull VirtualFile file) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(30);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(31);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(32);
        }
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(33);
        }
        DatabaseTableGridDataHookUp databaseTableGridDataHookUp = this.registerHookUp(new DatabaseTableGridDataHookUp(this.myProject, session2, file, department), parent2);
        if (databaseTableGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(34);
        }
        return databaseTableGridDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull LocalDataSource dataSource2, @NotNull Disposable parent2, @NotNull String query, @NotNull DatabaseDepartment department) {
        if (dataSource2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(35);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(36);
        }
        if (query == null) {
            GridDataHookUpManager.$$$reportNull$$$0(37);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(38);
        }
        DatabaseSession session2 = DatabaseSessionManager.getSession(this.myProject, dataSource2);
        DatabaseGridDataHookUp databaseGridDataHookUp = this.createReadOnlyDatabaseHookUp(session2, parent2, query, department);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(39);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull DatabaseSession session2, @NotNull Disposable parent2, @NotNull String query, @NotNull DatabaseDepartment department) {
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(40);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(41);
        }
        if (query == null) {
            GridDataHookUpManager.$$$reportNull$$$0(42);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(43);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ReadOnlyClientDatabaseGridDataHookUp(this.myProject, session2, query, department), parent2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(44);
        }
        return databaseGridDataHookUp;
    }

    @NotNull
    public DatabaseGridDataHookUp createReadOnlyDatabaseHookUp(@NotNull Disposable parent2, @NotNull String query, @NotNull DatabaseDepartment department, @NotNull DatabaseSession session2) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(45);
        }
        if (query == null) {
            GridDataHookUpManager.$$$reportNull$$$0(46);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(47);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(48);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ReadOnlyDatabaseGridDataHookUp(this.myProject, session2, query, department), parent2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(49);
        }
        return databaseGridDataHookUp;
    }

    public JpaGridDataHookUp createJpaHookUp(@NotNull Session session2, @NotNull Disposable parent2) {
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(50);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(51);
        }
        return this.registerHookUp(new JpaGridDataHookUp(this.myProject, session2), parent2);
    }

    @TestOnly
    @NotNull
    public DatabaseGridDataHookUp createMockHookUp(final @NotNull DbDataSource dataSource2, @NotNull DatabaseSession session2, @NotNull SearchPathSender sender, @NotNull DatabaseDepartment department) {
        if (dataSource2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(52);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(53);
        }
        if (sender == null) {
            GridDataHookUpManager.$$$reportNull$$$0(54);
        }
        if (department == null) {
            GridDataHookUpManager.$$$reportNull$$$0(55);
        }
        DatabaseGridDataHookUp databaseGridDataHookUp = this.registerHookUp(new ConsoleGridDataHookUp(this.myProject, session2, department, sender, null){

            @Override
            @NotNull
            public DbDataSource getDataSource() {
                DbDataSource dbDataSource = dataSource2;
                if (dbDataSource == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dbDataSource;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridDataHookUpManager$1", "getDataSource"));
            }
        }, session2);
        if (databaseGridDataHookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(56);
        }
        return databaseGridDataHookUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GridDataHookUp<DataConsumer.Row, DataConsumer.Column> acquire(@NotNull HookUpHandle handle2, @NotNull Disposable parent2) {
        if (handle2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(57);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(58);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (handle2.myRef == null || handle2.myRef.myReferenceCount <= 0) {
                return null;
            }
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(handle2.myRef));
            return handle2.myRef.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public HookUpHandle getHandle(@NotNull GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
        if (hookUp == null) {
            GridDataHookUpManager.$$$reportNull$$$0(59);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        HookUpReference res2 = null;
        for (HookUpReference ref : this.myHookUps) {
            if (ref.myHookUp != hookUp) continue;
            res2 = ref;
            break;
        }
        HookUpHandle hookUpHandle = new HookUpHandle(res2);
        // MONITOREXIT : object
        if (hookUpHandle != null) return hookUpHandle;
        GridDataHookUpManager.$$$reportNull$$$0(60);
        return hookUpHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected List<DataGridSessionClient> getActiveClients(@NotNull Project project) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(61);
        }
        Object object = this.myLock;
        // MONITORENTER : object
        List<DataGridSessionClient> list = this.myVirtualFileBasedHookUps.values().stream().filter(h -> h.myHookUp instanceof DataGridSessionClient).filter(h -> h.myReferenceCount > 0).map(h -> (DataGridSessionClient)h.myHookUp).collect(Collectors.toList());
        // MONITOREXIT : object
        if (list != null) return list;
        GridDataHookUpManager.$$$reportNull$$$0(62);
        return list;
    }

    @Override
    protected void register(@NotNull Project project, @NotNull DataGridSessionClient session2) {
        if (project == null) {
            GridDataHookUpManager.$$$reportNull$$$0(63);
        }
        if (session2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(64);
        }
    }

    @Override
    @NotNull
    protected DataGridSessionClient createClientInner(@NotNull Parameters parameters) {
        if (parameters == null) {
            GridDataHookUpManager.$$$reportNull$$$0(65);
        }
        return new DataGridSessionClient(parameters.project, parameters.session, parameters.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends VirtualFile, H extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> H getOrCreateHookUp(final @NotNull F file, @NotNull Function<F, H> hookUpFactory, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(66);
        }
        if (hookUpFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(67);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(68);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = this.myVirtualFileBasedHookUps.get(file);
            if (ref == null || ref.myReferenceCount <= 0) {
                GridDataHookUp hookUp = (GridDataHookUp)hookUpFactory.fun(file);
                ref = new HookUpReference(hookUp){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void dispose() {
                        super.dispose();
                        Object object = GridDataHookUpManager.this.myLock;
                        synchronized (object) {
                            GridDataHookUpManager.this.myVirtualFileBasedHookUps.remove(file);
                        }
                    }
                };
                this.myVirtualFileBasedHookUps.put(file, ref);
                this.myHookUps.add(ref);
            }
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(ref));
            return (H)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DatabaseTableGridDataHookUp getCachedHookUp(@NotNull VirtualFile file, @NotNull Disposable parent2) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(69);
        }
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(70);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = this.myVirtualFileBasedHookUps.get(file);
            if (ref == null || ref.myReferenceCount <= 0 || !(ref.myHookUp instanceof DatabaseTableGridDataHookUp)) {
                return null;
            }
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(ref));
            return (DatabaseTableGridDataHookUp)ref.myHookUp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends GridDataHookUp<DataConsumer.Row, DataConsumer.Column>> T registerHookUp(T hookUp, @NotNull Disposable parent2) {
        if (parent2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(71);
        }
        Object object = this.myLock;
        synchronized (object) {
            HookUpReference ref = new HookUpReference(hookUp);
            this.myHookUps.add(ref);
            Disposer.register((Disposable)parent2, (Disposable)this.createHookUpReferenceDisposable(ref));
            return hookUp;
        }
    }

    private Disposable createHookUpReferenceDisposable(final @NotNull HookUpReference ref) {
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(72);
        }
        if (!GridDataHookUpManager.isClosingToReopen(ref)) {
            ++ref.myReferenceCount;
        }
        return new Disposable(){
            private final AtomicBoolean myDisposed = new AtomicBoolean(false);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dispose() {
                if (!this.myDisposed.compareAndSet(false, true)) {
                    return;
                }
                if (GridDataHookUpManager.isClosingToReopen(ref)) {
                    return;
                }
                Object object = GridDataHookUpManager.this.myLock;
                synchronized (object) {
                    if (--ref.myReferenceCount <= 0) {
                        Disposer.dispose((Disposable)ref);
                        GridDataHookUpManager.this.myHookUps.remove(ref);
                    }
                }
            }
        };
    }

    private static boolean isClosingToReopen(@NotNull @NotNull @NotNull HookUpReference ref) {
        VirtualFile file;
        if (ref == null) {
            GridDataHookUpManager.$$$reportNull$$$0(73);
        }
        return (file = DataGridUtil.getVirtualFile(ref.myHookUp)) != null && file.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN) == Boolean.TRUE;
    }

    @NotNull
    private <F extends VirtualFile, H extends DatabaseGridDataHookUp, S extends DatabaseSession> Function<F, H> generator(@NotNull HookUpFactory<F, H, S> factory, @NotNull SessionFactory<S> sessionFactory) {
        if (factory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(74);
        }
        if (sessionFactory == null) {
            GridDataHookUpManager.$$$reportNull$$$0(75);
        }
        Function function2 = file -> {
            DbDataSource dataSource2 = Objects.requireNonNull(DbImplUtilCore.findDataSource(this.myProject, file));
            Object session2 = sessionFactory.create(DbImplUtil.getLocalDataSource(dataSource2), DatabaseSession.getTitle(this.myProject, file));
            return (DatabaseGridDataHookUp)factory.construct(file, session2);
        };
        if (function2 == null) {
            GridDataHookUpManager.$$$reportNull$$$0(76);
        }
        return function2;
    }

    @NotNull
    private static Document getDocument(@NotNull VirtualFile file) {
        if (file == null) {
            GridDataHookUpManager.$$$reportNull$$$0(77);
        }
        Document document = Objects.requireNonNull(FileDocumentManager.getInstance().getDocument(file));
        if (document == null) {
            GridDataHookUpManager.$$$reportNull$$$0(78);
        }
        return document;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 49: 
            case 56: 
            case 60: 
            case 62: 
            case 76: 
            case 78: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 49: 
            case 56: 
            case 60: 
            case 62: 
            case 76: 
            case 78: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: 
            case 16: 
            case 28: 
            case 33: 
            case 66: 
            case 69: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 14: 
            case 18: 
            case 20: 
            case 25: 
            case 30: 
            case 36: 
            case 41: 
            case 45: 
            case 51: 
            case 58: 
            case 68: 
            case 70: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 49: 
            case 56: 
            case 60: 
            case 62: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 7: 
            case 23: 
            case 27: 
            case 32: 
            case 38: 
            case 43: 
            case 47: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "department";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 21: 
            case 26: 
            case 31: 
            case 40: 
            case 48: 
            case 50: 
            case 53: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 22: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sender";
                break;
            }
            case 35: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 37: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handle";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUpFactory";
                break;
            }
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sessionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager";
                break;
            }
            case 4: 
            case 12: 
            case 15: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getHookUp";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLightweight";
                break;
            }
            case 24: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseHookUp";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createDatabaseTableHookUp";
                break;
            }
            case 39: 
            case 44: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createMockHookUp";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandle";
                break;
            }
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveClients";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "generator";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getHookUp";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 49: 
            case 56: 
            case 60: 
            case 62: 
            case 76: 
            case 78: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateLightweight";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseHookUp";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createDatabaseTableHookUp";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createReadOnlyDatabaseHookUp";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createJpaHookUp";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "createMockHookUp";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getHandle";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getActiveClients";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "register";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "createClientInner";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHookUp";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getCachedHookUp";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "registerHookUp";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "createHookUpReferenceDisposable";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isClosingToReopen";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "generator";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 19: 
            case 24: 
            case 29: 
            case 34: 
            case 39: 
            case 44: 
            case 49: 
            case 56: 
            case 60: 
            case 62: 
            case 76: 
            case 78: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface SessionFactory<S extends DatabaseSession> {
        @NotNull
        public S create(@NotNull LocalDataSource var1, @Nls @NotNull String var2);
    }

    private static interface HookUpFactory<F, H, S> {
        @NotNull
        public H construct(@NotNull F var1, @NotNull S var2);
    }

    static class Parameters
    extends SessionClientHolder.Parameters {
        final VirtualFile file;

        Parameters(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull VirtualFile file) {
            if (project == null) {
                Parameters.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                Parameters.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Parameters.$$$reportNull$$$0(2);
            }
            super(project, session2);
            this.file = file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "session";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/datagrid/GridDataHookUpManager$Parameters";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ReadOnlyClientDatabaseGridDataHookUp
    extends ReadOnlyDatabaseGridDataHookUp
    implements DatabaseSessionClient {
        private ReadOnlyClientDatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull String query, @NotNull DatabaseDepartment department) {
            if (project == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            if (department == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            super(project, session2, query, department);
            session2.attach(this);
        }

        @Override
        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            return new DatabaseGridDataHookUp.DatabaseLoader(){

                @Override
                protected boolean canUpdateQueryText() {
                    return true;
                }

                @Override
                protected String createQueryText(@NotNull DataBusGridDataHookUp.QueryAttributes attributes2, @Nullable GridRequestSource source) {
                    if (attributes2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return myQuery;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyClientDatabaseGridDataHookUp$1", "createQueryText"));
                }
            };
        }

        @Override
        @NotNull
        public String getTitle() {
            String string = this.myQuery;
            if (string == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void detached(@NotNull DatabaseSessionClient.DetachTrigger trigger) {
            if (trigger == null) {
                ReadOnlyClientDatabaseGridDataHookUp.$$$reportNull$$$0(5);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "department";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyClientDatabaseGridDataHookUp";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trigger";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyClientDatabaseGridDataHookUp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "detached";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ReadOnlyDatabaseGridDataHookUp
    extends DatabaseGridDataHookUp {
        @NlsSafe
        protected final String myQuery;

        protected ReadOnlyDatabaseGridDataHookUp(@NotNull Project project, @NotNull DatabaseSession session2, @NotNull String query, @NotNull DatabaseDepartment department) {
            if (project == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(0);
            }
            if (session2 == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(1);
            }
            if (query == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(2);
            }
            if (department == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(3);
            }
            super(project, session2, department);
            this.myQuery = query;
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }

        @Override
        @NotNull
        protected DatabaseGridDataHookUp.DatabaseLoader createLoader() {
            return new DatabaseGridDataHookUp.DatabaseLoader(){

                @Override
                protected boolean canUpdateQueryText() {
                    return false;
                }
            };
        }

        @Override
        @NotNull
        public DatabaseSession getSession() {
            DatabaseSession databaseSession = super.getSession();
            if (databaseSession == null) {
                ReadOnlyDatabaseGridDataHookUp.$$$reportNull$$$0(4);
            }
            return databaseSession;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "department";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/GridDataHookUpManager$ReadOnlyDatabaseGridDataHookUp";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSession";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class HookUpReference
    implements Disposable {
        private final GridDataHookUp<DataConsumer.Row, DataConsumer.Column> myHookUp;
        private int myReferenceCount = 0;

        private HookUpReference(GridDataHookUp<DataConsumer.Row, DataConsumer.Column> hookUp) {
            this.myHookUp = hookUp;
            if (this.myHookUp instanceof Disposable) {
                Disposer.register((Disposable)this, (Disposable)((Disposable)this.myHookUp));
            }
        }

        public void dispose() {
        }
    }

    public static final class HookUpHandle {
        private final HookUpReference myRef;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HookUpHandle handle2 = (HookUpHandle)o;
            return Objects.equals(this.myRef, handle2.myRef);
        }

        public int hashCode() {
            return this.myRef != null ? this.myRef.hashCode() : 0;
        }

        private HookUpHandle(@Nullable HookUpReference ref) {
            this.myRef = ref;
        }
    }
}

