/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.helpers.CouchbaseJdbcHelper;
import com.intellij.database.remote.jdbc.helpers.MongoJdbcHelper;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.JdbcUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.TIntObjectHashMap;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExtractorsUtil {
    private ExtractorsUtil() {
    }

    @NotNull
    public static String getPresentableSize(long length) {
        String string = StringUtil.formatFileSize((long)length);
        if (string == null) {
            ExtractorsUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getTypeName(@Nullable DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(1);
        }
        return value2 instanceof UnparsedValue && ((UnparsedValue)value2).getDomain() != null ? Objects.requireNonNull(((UnparsedValue)value2).getDomain()).simpleName() : (dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value2) : (dbms.is(Dbms.COUCHBASE_QUERY) ? CouchbaseJdbcHelper.getTypeName((Object)value2) : (column2 != null ? column2.typeName : "unknown")));
    }

    public static int guessJdbcType(@NotNull DataConsumer.Column column2, @Nullable Object value2, @NotNull Dbms dbms) {
        if (column2 == null) {
            ExtractorsUtil.$$$reportNull$$$0(2);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(3);
        }
        if (dbms.in(Dbms.DOCUMENT_ORIENTED) && value2 != null && !(value2 instanceof ReservedCellValue)) {
            Domain type;
            Domain domain = type = value2 instanceof UnparsedValue ? ((UnparsedValue)value2).getDomain() : null;
            if (type != null) {
                return ExtractorsUtil.guessJdbcType(type, dbms);
            }
            String typeName = dbms.is(Dbms.MONGO) ? MongoJdbcHelper.getTypeName((Object)value2) : CouchbaseJdbcHelper.getTypeName((Object)value2);
            return ExtractorsUtil.guessJdbcType(typeName, dbms);
        }
        if (column2.type != 1111 && column2.type != 0 && (!dbms.is(Dbms.ORACLE) || column2.type != 100 && column2.type != 101)) {
            return column2.type;
        }
        int byType = JdbcUtil.guessJdbcTypeByName(column2.typeName);
        if (byType == -6 && column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (byType != 1111 || column2.clazz == null) {
            return byType;
        }
        if (JdbcUtil.isFloat(column2.clazz)) {
            return 6;
        }
        if (JdbcUtil.isDouble(column2.clazz)) {
            return 8;
        }
        if (JdbcUtil.isBigDecimal(column2.clazz)) {
            return 3;
        }
        if (column2.clazz.equals("java.lang.Boolean")) {
            return 16;
        }
        if (column2.clazz.equals("java.lang.String")) {
            return 12;
        }
        if (column2.clazz.equals("java.lang.Integer")) {
            return 4;
        }
        if (column2.clazz.equals("java.lang.Double")) {
            return 8;
        }
        if (column2.clazz.equals("java.lang.Float")) {
            return 6;
        }
        if (column2.clazz.endsWith(".Date")) {
            return 91;
        }
        if (column2.clazz.endsWith(".Time")) {
            return 92;
        }
        if (column2.clazz.endsWith(".Timestamp")) {
            return 93;
        }
        if (column2.clazz.endsWith(".UUID")) {
            return 12;
        }
        return column2.type;
    }

    public static int guessJdbcType(@NotNull Domain type, @NotNull Dbms dbms) {
        if (type == null) {
            ExtractorsUtil.$$$reportNull$$$0(4);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(5);
        }
        if (LogicalType.isText(type.getLogicType())) {
            return 12;
        }
        if (ObjectFormatter.isIntDomain(type)) {
            return 4;
        }
        if (ObjectFormatter.isLongDomain(type)) {
            return -5;
        }
        switch (type.getLogicType()) {
            case CLOB: {
                return 2005;
            }
            case TIME: {
                return 92;
            }
            case DATE: {
                return 91;
            }
            case TIMESTAMP: {
                return 93;
            }
            case BOOLEAN: {
                return 16;
            }
            case DOUBLE_PRECISION: {
                return 8;
            }
            case SINGLE_PRECISION: {
                return 6;
            }
        }
        return ExtractorsUtil.guessJdbcType(type.simpleName(), dbms);
    }

    private static int guessJdbcType(@NotNull String typeName, @NotNull Dbms dbms) {
        if (typeName == null) {
            ExtractorsUtil.$$$reportNull$$$0(6);
        }
        if (dbms == null) {
            ExtractorsUtil.$$$reportNull$$$0(7);
        }
        Integer type = dbms.is(Dbms.MONGO) ? (Integer)MongoJdbcHelper.TYPES_MAP.get(typeName) : (Integer)CouchbaseJdbcHelper.TYPES_MAP.get(typeName);
        return type != null ? type : 1111;
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, DataExtractor.Text extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            ExtractorsUtil.$$$reportNull$$$0(8);
        }
        return ExtractorsUtil.extract(out, dbms, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, extractor, rows, selectedColumns);
    }

    @NotNull
    public static CharOut extract(@NotNull CharOut out, Dbms dbms, @NotNull ExtractionConfig config, List<DataConsumer.Column> allColumns, DataExtractor.Text extractor, List<DataConsumer.Row> rows, int ... selectedColumns) {
        if (out == null) {
            ExtractorsUtil.$$$reportNull$$$0(9);
        }
        if (config == null) {
            ExtractorsUtil.$$$reportNull$$$0(10);
        }
        DataExtractor.Extraction e = extractor.startExtraction(out, dbms, allColumns, config, selectedColumns);
        e.addData(rows);
        e.complete();
        CharOut charOut = out;
        if (charOut == null) {
            ExtractorsUtil.$$$reportNull$$$0(11);
        }
        return charOut;
    }

    public static DataExtractor.Text getSingleValueExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            ExtractorsUtil.$$$reportNull$$$0(12);
        }
        return new DefaultValuesExtractor(converter){

            @Override
            protected boolean isStringLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
                if (dbms == null) {
                    1.$$$reportNull$$$0(0);
                }
                return false;
            }

            @Override
            public DefaultValuesExtractor.DefaultExtraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, ExtractionConfig config, int ... selectedColumns) {
                return new DefaultValuesExtractor.DefaultExtraction(out, dbms, ExtractionConfigKt.DEFAULT_CONFIG, allColumns, selectedColumns){

                    @Override
                    protected void appendData(List<DataConsumer.Row> rows) {
                        TIntObjectHashMap<DataConsumer.Column> columnsMap = ExtractorsUtil.getColumnNumsToColumnsMapping(this.myAllColumns);
                        int[] selection = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
                        if (rows.isEmpty() || selection.length == 0) {
                            return;
                        }
                        int selectedColumn = selection[0];
                        DataConsumer.Column column2 = (DataConsumer.Column)columnsMap.get(selectedColumn);
                        if (column2 == null) {
                            return;
                        }
                        DataConsumer.Row row = rows.get(0);
                        this.myOutput.append(this.getValueLiteral(row, column2, this.myDbms, ObjectFormatterMode.DEFAULT));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dbms", "com/intellij/database/extractors/ExtractorsUtil$1", "isStringLiteral"));
            }
        };
    }

    public static TIntObjectHashMap<DataConsumer.Column> getColumnNumsToColumnsMapping(@NotNull List<DataConsumer.Column> columns) {
        if (columns == null) {
            ExtractorsUtil.$$$reportNull$$$0(13);
        }
        TIntObjectHashMap m = new TIntObjectHashMap(columns.size());
        for (DataConsumer.Column column2 : columns) {
            m.put(column2.columnNum, (Object)column2);
        }
        return m;
    }

    public static int[] getNonEmptySelection(@NotNull List<DataConsumer.Column> allColumns, int[] providedSelection) {
        if (allColumns == null) {
            ExtractorsUtil.$$$reportNull$$$0(14);
        }
        if (providedSelection.length != 0) {
            return providedSelection;
        }
        int[] selection = new int[allColumns.size()];
        for (int i2 = 0; i2 < allColumns.size(); ++i2) {
            selection[i2] = allColumns.get((int)i2).columnNum;
        }
        return selection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableSize";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/ExtractorsUtil";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "extract";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "guessJdbcType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "extract";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSingleValueExtractor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getColumnNumsToColumnsMapping";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptySelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

