/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DefaultValuesExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.util.CharOut;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TranspositionAwareExtractor
extends DefaultValuesExtractor {
    protected static final DataConsumer.Column ROW_NAMES_COLUMN = new DataConsumer.Column(0, "Column", 12, "", "");

    protected TranspositionAwareExtractor(@NotNull ObjectFormatter converter) {
        if (converter == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(0);
        }
        super(converter);
    }

    @Override
    public String getValueLiteral(@NotNull Dbms dbms, @NotNull String value2, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(1);
        }
        if (value2 == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(2);
        }
        return super.getValueLiteral(dbms, value2, TranspositionAwareExtractor.getOriginalRow(row, column2), TranspositionAwareExtractor.getOriginalColumn(row, column2));
    }

    @Override
    protected boolean isStringLiteral(@NotNull Dbms dbms, @Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        if (dbms == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(3);
        }
        return false;
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull DataConsumer.Row row, @NotNull DataConsumer.Column column2, @NotNull Dbms dbms, @NotNull ObjectFormatterMode mode) {
        if (row == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(4);
        }
        if (column2 == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(6);
        }
        if (mode == null) {
            TranspositionAwareExtractor.$$$reportNull$$$0(7);
        }
        return super.getValueAsString(TranspositionAwareExtractor.getOriginalRow(row, column2), TranspositionAwareExtractor.getOriginalColumn(row, column2), dbms, mode);
    }

    @Override
    public final DataExtractor.Extraction startExtraction(CharOut out, Dbms dbms, List<DataConsumer.Column> allColumns, ExtractionConfig config, int ... selectedColumns) {
        return this.startExtraction(out, dbms, allColumns, config, config.isTransposed(), selectedColumns);
    }

    protected abstract TranspositionAwareExtraction startExtraction(CharOut var1, Dbms var2, List<DataConsumer.Column> var3, @NotNull ExtractionConfig var4, boolean var5, int ... var6);

    @Nullable
    protected static DataConsumer.Column getOriginalColumn(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        return row instanceof TransposedRow ? ((TransposedRow)row).originalColumn : column2;
    }

    @Nullable
    protected static DataConsumer.Row getOriginalRow(@Nullable DataConsumer.Row row, @Nullable DataConsumer.Column column2) {
        return column2 instanceof TransposedColumn ? ((TransposedColumn)column2).originalRow : row;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/TranspositionAwareExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueLiteral";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringLiteral";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class TransposedColumn
    extends DataConsumer.Column {
        public final DataConsumer.Row originalRow;

        public TransposedColumn(int columnNum, DataConsumer.Row originalRow) {
            super(columnNum, "Value (" + originalRow.getRowNum() + ")", 12, "", "");
            this.originalRow = originalRow;
        }
    }

    protected static class TransposedRow
    extends DataConsumer.Row
    implements GridRow {
        public final DataConsumer.Column originalColumn;

        public TransposedRow(int rowNum, Object[] values2, DataConsumer.Column originalColumn) {
            super(rowNum, values2);
            this.originalColumn = originalColumn;
        }
    }

    protected abstract class TranspositionAwareExtraction
    extends DefaultValuesExtractor.DefaultExtraction {
        public TranspositionAwareExtraction(CharOut output, @NotNull Dbms dbms, ExtractionConfig config, List<DataConsumer.Column> allColumns, int[] selectedColumnIndices) {
            if (config == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(0);
            }
            super(output, dbms, config, allColumns, selectedColumnIndices);
        }

        @Override
        protected final void appendHeader(boolean appendNewLine) {
            if (!this.myConfig.isTransposed()) {
                this.doAppendHeader(appendNewLine);
            }
        }

        @Override
        protected final void appendData(List<DataConsumer.Row> rows) {
            if (!this.myConfig.isTransposed()) {
                this.doAppendData(rows);
            } else {
                this.doTransposedExtraction(rows);
            }
        }

        @Override
        protected final void appendFooter() {
            if (!this.myConfig.isTransposed()) {
                this.doAppendFooter();
            }
        }

        @NotNull
        protected String getRowNumber(DataConsumer.Row row) {
            if (!this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0)) {
                Object rowNumber = ROW_NAMES_COLUMN.getValue(row);
                return rowNumber instanceof String ? (String)rowNumber : "";
            }
            String string = String.valueOf(row.getRowNum());
            if (string == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        protected DataConsumer.Column getRowNumbersColumn() {
            DataConsumer.Column column2 = !this.myAllColumns.isEmpty() && ROW_NAMES_COLUMN == this.myAllColumns.get(0) ? ROW_NAMES_COLUMN : super.getRowNumbersColumn();
            if (column2 == null) {
                TranspositionAwareExtraction.$$$reportNull$$$0(2);
            }
            return column2;
        }

        protected void doTransposedExtraction(List<DataConsumer.Row> rows) {
            List<DataConsumer.Column> transposedColumns = this.getTransposedColumns(rows);
            int[] selectedColumns = new int[Math.max(0, transposedColumns.size() - 1)];
            for (int i2 = 0; i2 < selectedColumns.length; ++i2) {
                selectedColumns[i2] = i2 + 1;
            }
            TranspositionAwareExtraction e = TranspositionAwareExtractor.this.startExtraction(this.myOutput, this.myDbms, transposedColumns, this.myConfig.toBuilder().setTransposed(false).build(), this.myConfig.isTransposed(), selectedColumns);
            e.addData(this.getTransposedRows(rows));
            e.complete();
        }

        protected abstract void doAppendHeader(boolean var1);

        protected abstract void doAppendData(List<DataConsumer.Row> var1);

        protected void doAppendFooter() {
            super.appendFooter();
        }

        protected List<DataConsumer.Row> getTransposedRows(List<DataConsumer.Row> rows) {
            int[] originalSelection = ExtractorsUtil.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            ArrayList<DataConsumer.Row> transposedRows = new ArrayList<DataConsumer.Row>(originalSelection.length);
            for (int i2 : originalSelection) {
                DataConsumer.Column column2 = (DataConsumer.Column)this.myAllColumns.get(i2);
                Object[] transposedRow = new Object[rows.size() + 1];
                transposedRow[0] = column2.name;
                for (int j = 0; j < rows.size(); ++j) {
                    transposedRow[j + 1] = column2.getValue(rows.get(j));
                }
                transposedRows.add(new TransposedRow(i2, transposedRow, column2));
            }
            return transposedRows;
        }

        protected List<DataConsumer.Column> getTransposedColumns(List<DataConsumer.Row> rows) {
            ArrayList<DataConsumer.Column> transposedColumns = new ArrayList<DataConsumer.Column>(rows.size() + 1);
            transposedColumns.add(ROW_NAMES_COLUMN);
            for (int i2 = 0; i2 < rows.size(); ++i2) {
                transposedColumns.add(new TransposedColumn(i2 + 1, rows.get(i2)));
            }
            return transposedColumns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/TranspositionAwareExtractor$TranspositionAwareExtraction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumber";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRowNumbersColumn";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

