/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.ui.DatabaseTargetChooser;
import com.intellij.database.dbimport.ui.tree.DatabaseChooseByNamePanel;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMixinElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.diff.DbDiffCheckOption;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.model.diff.DbMigrationAction;
import com.intellij.database.model.diff.SchemaDiffRequest;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.diff.DiffManager;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.icons.AllIcons;
import com.intellij.ide.diff.DirDiffSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaDiffAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        Pair<DbElement, DbElement> elements = SchemaDiffAction.getElements(e);
        DbElement single = SchemaDiffAction.getSingleElement(e);
        e.getPresentation().setEnabled(project != null && (elements != null || single != null));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            SchemaDiffAction.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        Pair<DbElement, DbElement> pair = SchemaDiffAction.getElements(e);
        if (pair != null) {
            SchemaDiffAction.showDiff((DbElement)pair.first, (DbElement)pair.second);
            return;
        }
        DbElement single = SchemaDiffAction.getSingleElement(e);
        if (single != null) {
            SchemaDiffAction.showDiffWithChooser(single);
        }
    }

    private static void showDiffWithChooser(@NotNull DbElement single) {
        if (single == null) {
            SchemaDiffAction.$$$reportNull$$$0(2);
        }
        HashSet kinds = new HashSet();
        SchemaDiffAction.fillPossible(single, o -> kinds.add(o.getKind()));
        DbElement element2 = new DatabaseTargetChooser(single.getProject(), "", new DatabaseChooseByNamePanel.DatabaseChooseByNameContributor(kinds.toArray(new ObjectKind[0]))).choose(DatabaseBundle.message("compare.with", new Object[0]));
        if (element2 == null) {
            return;
        }
        Pair<DbElement, DbElement> aligned = SchemaDiffAction.alignElements(single, element2);
        if (aligned == null) {
            return;
        }
        SchemaDiffAction.showDiff((DbElement)aligned.first, (DbElement)aligned.second);
    }

    private static void showDiff(@NotNull DbElement from, @NotNull DbElement to) {
        DirDiffSettings settings;
        Couple<DbDiffElement> elements;
        if (from == null) {
            SchemaDiffAction.$$$reportNull$$$0(3);
        }
        if (to == null) {
            SchemaDiffAction.$$$reportNull$$$0(4);
        }
        if ((elements = SchemaDiffAction.createElements(from, to, settings = SchemaDiffAction.createSettings(from.getDataSource().getDbms(), to.getDataSource().getDbms()))) == null) {
            return;
        }
        SchemaDiffRequest request = new SchemaDiffRequest((DbDiffElement)((Object)elements.first), (DbDiffElement)((Object)elements.second));
        DiffManager.getInstance().showDiff(from.getProject(), (DiffRequest)request);
    }

    @NotNull
    public static DirDiffSettings createSettings(@NotNull Dbms dbms1, @NotNull Dbms dbms2) {
        if (dbms1 == null) {
            SchemaDiffAction.$$$reportNull$$$0(5);
        }
        if (dbms2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(6);
        }
        DirDiffSettings settings = new DirDiffSettings();
        settings.showSize = false;
        settings.showDate = false;
        settings.showCompareModes = false;
        settings.enableSyncActions = false;
        DefaultActionGroup options = new DefaultActionGroup(DatabaseBundle.message("action.options.text", new Object[0]), true);
        options.getTemplatePresentation().setIcon(AllIcons.General.GearPlain);
        SchemaDiffAction.addActionOption(settings, "IGNORE_ORDER", DatabaseBundle.message("action.ignore.order.text", new Object[0]), "alt O", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_CASE", DatabaseBundle.message("action.ignore.case.text", new Object[0]), "alt C", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_IMPLICIT_OBJECTS", DatabaseBundle.message("action.ignore.implicit.objects.text", new Object[0]), "alt I", options);
        SchemaDiffAction.addActionOption(settings, "IGNORE_SOURCE_CODE", DatabaseBundle.message("action.ignore.source.code.text", new Object[0]), "alt S", options);
        if (ScriptingOptionStatic.IGNORE_OWNER.getApplicableDbs().value((Object)dbms1) || ScriptingOptionStatic.IGNORE_OWNER.getApplicableDbs().value((Object)dbms2)) {
            SchemaDiffAction.addActionOption(settings, "PG_IGNORE_OWNER", DatabaseBundle.message("action.ignore.owner.text", new Object[0]), "alt W", options);
        }
        if (ScriptingOptionStatic.IGNORE_DEFINER.getApplicableDbs().value((Object)dbms1) || ScriptingOptionStatic.IGNORE_DEFINER.getApplicableDbs().value((Object)dbms2)) {
            SchemaDiffAction.addActionOption(settings, "MYSQL_IGNORE_DEFINER", DatabaseBundle.message("action.ignore.definer.text", new Object[0]), "alt D", options);
        }
        settings.addExtraAction((AnAction)options);
        settings.addExtraAction((AnAction)Separator.getInstance());
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.FORWARD));
        settings.addExtraAction((AnAction)new DbMigrationAction(DbMigrationAction.Direction.BACKWARD));
        DirDiffSettings dirDiffSettings = settings;
        if (dirDiffSettings == null) {
            SchemaDiffAction.$$$reportNull$$$0(7);
        }
        return dirDiffSettings;
    }

    private static void addActionOption(DirDiffSettings settings, String key, @NlsActions.ActionText String text2, String shortcut, DefaultActionGroup options) {
        settings.customSettings.put(key, DbDiffCheckOption.getOption(key));
        options.add((AnAction)new DbDiffCheckOption(key, text2, shortcut));
    }

    @Nullable
    public static Couple<DbDiffElement> createElements(DbElement e1, DbElement e2, DirDiffSettings settings) {
        BasicElement b1 = SchemaDiffAction.getElement(e1);
        BasicElement b2 = SchemaDiffAction.getElement(e2);
        if (b1 == null || b2 == null) {
            return null;
        }
        boolean stepUp = DbDiffElement.isContainer(b1) || DbDiffElement.isContainer(b2);
        DbDiffElement de1 = SchemaDiffAction.createElement(e1, settings, e2, stepUp);
        DbDiffElement de2 = SchemaDiffAction.createElement(e2, settings, e1, stepUp);
        return de1 != null && de2 != null ? Couple.of((Object)((Object)de1), (Object)((Object)de2)) : null;
    }

    @Nullable
    private static BasicElement getElement(DbElement e) {
        if (e instanceof DbDataSource) {
            BasicModel model = (BasicModel)ObjectUtils.tryCast((Object)((DbDataSource)e).getModel(), BasicModel.class);
            return model == null ? null : model.getRoot();
        }
        return (BasicElement)ObjectUtils.tryCast((Object)e.getDelegate(), BasicElement.class);
    }

    @Nullable
    public static DbDiffElement createElement(DbElement element2, DirDiffSettings settings, DbElement other, boolean stepUp) {
        Dbms dbms = DbImplUtilCore.getDbms(other);
        BasicElement e = SchemaDiffAction.getElement(element2);
        if (e == null) {
            return null;
        }
        BasicElement realRoot = stepUp || e.getParent() == null ? e : e.getParent();
        DbDiffRoot root2 = new DbDiffRoot(element2.getDataSource(), settings, dbms, e);
        return new DbDiffElement(root2, realRoot, SchemaDiffAction.createAltElement(root2.getAltModel(), realRoot));
    }

    private static BasicModElement createAltElement(@Nullable BasicModModel model, BasicElement e) {
        if (model == null) {
            return null;
        }
        BasicMetaObject<?> meta = ((BasicMetaModel)model.getMetaModel()).findBestMetaObject(e.getMetaObject());
        if (meta == null) {
            return null;
        }
        Ref res2 = Ref.create();
        model.modify(BasicModRoot.class, r -> {
            res2.set((Object)SchemaDiffAction.instantiate(r, meta));
            if (res2.isNull()) {
                BasicModMixinElement.dropChildren(r);
            }
        });
        return (BasicModElement)res2.get();
    }

    @Nullable
    private static BasicModElement instantiate(@NotNull BasicModElement o, @NotNull BasicMetaObject<?> meta) {
        if (o == null) {
            SchemaDiffAction.$$$reportNull$$$0(8);
        }
        if (meta == null) {
            SchemaDiffAction.$$$reportNull$$$0(9);
        }
        if (meta.kind == o.getKind()) {
            return o;
        }
        BasicMetaObject<?> p2 = meta.getParent();
        BasicModElement parent2 = p2 == null ? null : SchemaDiffAction.instantiate(o, p2);
        Family family = parent2 == null ? null : parent2.familyOf(meta.kind);
        return family == null ? null : (BasicModElement)family.createNewOne();
    }

    @Nullable
    private static DbElement getSingleElement(AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        return elements != null && elements.length == 1 ? (DbElement)ObjectUtils.tryCast((Object)elements[0], DbElement.class) : null;
    }

    @Nullable
    private static Pair<DbElement, DbElement> getElements(AnActionEvent e) {
        PsiElement[] elements = (PsiElement[])e.getData(LangDataKeys.PSI_ELEMENT_ARRAY);
        if (elements == null || elements.length != 2 || !(elements[0] instanceof DbElement) || !(elements[1] instanceof DbElement)) {
            return null;
        }
        return SchemaDiffAction.alignElements((DbElement)elements[0], (DbElement)elements[1]);
    }

    @Nullable
    private static Pair<DbElement, DbElement> alignElements(DbElement e1, DbElement e2) {
        block4: {
            DbElement same;
            HashMap possible1 = new HashMap();
            HashMap possible2 = new HashMap();
            e1 = SchemaDiffAction.fillPossible(e1, o -> possible1.put(o.getKind(), o));
            e2 = SchemaDiffAction.fillPossible(e2, o -> possible2.put(o.getKind(), o));
            while ((same = (DbElement)possible2.get(e1.getKind())) == null) {
                DbElement p2 = e1.getParent();
                if (p2 != null && possible1.containsKey(p2.getKind())) {
                    e1 = p2;
                    continue;
                }
                break block4;
            }
            e2 = same;
        }
        if (e1.getKind() != e2.getKind()) {
            return null;
        }
        if (e1.getDelegate() instanceof DasTableChild) {
            return null;
        }
        return Pair.create((Object)e1, (Object)e2);
    }

    private static DbElement fillPossible(@NotNull DbElement el, @NotNull Consumer<DbElement> consumer2) {
        if (el == null) {
            SchemaDiffAction.$$$reportNull$$$0(10);
        }
        if (consumer2 == null) {
            SchemaDiffAction.$$$reportNull$$$0(11);
        }
        if (DasUtil.getParentOfKind(el, ObjectKind.SCHEMA, true) == null) {
            DbElement tmp2 = el;
            while (tmp2 != null) {
                consumer2.accept(tmp2);
                el = tmp2;
                tmp2 = tmp2.getKind() == ObjectKind.SCHEMA ? null : (DbElement)tmp2.getDasChildren(null).single();
            }
            return el;
        }
        consumer2.accept(el);
        return el;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "single";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms1";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/SchemaDiffAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showDiffWithChooser";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSettings";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "instantiate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

