/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.console.ExecutionConcession;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.run.ConsoleDataRequest;
import com.intellij.database.run.ui.ErrorNotificationPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleDataRequestUi {
    private final ConsoleDataRequest myConsoleDataRequest;
    private static final Accepter WARNING = (request, errorInfo) -> errorInfo.isWarning();
    private static final Accepter WARNING_NOT_LAST = (request, errorInfo) -> errorInfo.isWarning() && !request.isLastInChain();
    private static final Accepter ERROR = (request, errorInfo) -> !errorInfo.isWarning();
    private static final Accepter ERROR_NOT_LAST = (request, errorInfo) -> !errorInfo.isWarning() && !request.isLastInChain();
    private static final Accepter NOT_LAST = (request, errorInfo) -> !request.isLastInChain();
    private static final Key<ErrorPanelInfo> ERROR_PANEL_KEY = Key.create((String)"ERROR_PANEL_KEY");

    public ConsoleDataRequestUi(ConsoleDataRequest consoleDataRequest) {
        this.myConsoleDataRequest = consoleDataRequest;
    }

    @NotNull
    private ErrorNotificationPanel createErrorNotificationPanel(final @NotNull DataRequest.CoupledWithEditor.ErrorNavigator navigator, final @NotNull Editor sourceEditor, @NotNull Throwable error2, @Nullable Consumer<ConsoleDataRequest.Decision> feedbackListener, @NotNull ConsoleDataRequest.ErrorInfo errorInfo, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        if (navigator == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(0);
        }
        if (sourceEditor == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(1);
        }
        if (error2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(2);
        }
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(3);
        }
        ErrorNotificationPanel.Builder builder = ErrorNotificationPanel.create(null, error2, sourceEditor.getContentComponent());
        if (fixes != null && !fixes.isEmpty()) {
            for (DatabaseErrorHandler.Fix fix : fixes) {
                builder.addLink(fix.getName(), fix.getName(), () -> DataSourceUiUtil.applyFix(this.myConsoleDataRequest.getConsole().getProject(), fix, null));
            }
            builder.addSpace();
        }
        Iterable<ErrorPanelConfigurator> configurators = ErrorPanelConfigurator.filterFor(this.myConsoleDataRequest, errorInfo);
        configurators.forEach(c2 -> c2.configure(builder, this.myConsoleDataRequest, feedbackListener, errorInfo));
        ErrorNotificationPanel notificationPanel = builder.build();
        notificationPanel.getContent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() != 2) {
                    return;
                }
                navigator.navigate();
                sourceEditor.getContentComponent().requestFocusInWindow();
                ConsoleDataRequestUi.this.updateHighlighting();
            }
        });
        ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, (Object)new ErrorPanelInfo(notificationPanel, feedbackListener));
        ErrorNotificationPanel errorNotificationPanel = notificationPanel;
        if (errorNotificationPanel == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(4);
        }
        return errorNotificationPanel;
    }

    public static void hideErrorPanel(@NotNull Editor sourceEditor) {
        ErrorPanelInfo epInfo;
        if (sourceEditor == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(5);
        }
        if ((epInfo = (ErrorPanelInfo)ERROR_PANEL_KEY.get((UserDataHolder)sourceEditor)) == null || sourceEditor.getProject() == null) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)sourceEditor.getProject()).getPsiFile(sourceEditor.getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)sourceEditor.getProject());
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            editorManager.removeBottomComponent(fileEditor, (JComponent)epInfo.errorPanel);
            ERROR_PANEL_KEY.set((UserDataHolder)sourceEditor, null);
            sourceEditor.getContentComponent().requestFocusInWindow();
        }
    }

    private void handleQueryError(@NotNull DataRequest.CoupledWithEditor.ErrorNavigator navigator, @NotNull Throwable error2, @Nullable List<DatabaseErrorHandler.Fix> fixes, @Nullable Consumer<ConsoleDataRequest.Decision> feedbackListener, @NotNull ConsoleDataRequest.ErrorInfo errorInfo) {
        if (navigator == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(6);
        }
        if (error2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(7);
        }
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(8);
        }
        if (error2 instanceof ProcessCanceledException) {
            return;
        }
        if (feedbackListener == null && !DatabaseSettings.getSettings().isShowErrorInEditor()) {
            return;
        }
        if (!this.myConsoleDataRequest.getEditor().getContentComponent().isShowing()) {
            return;
        }
        Project project = this.myConsoleDataRequest.getConsole().getProject();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myConsoleDataRequest.getEditor().getDocument());
        if (file == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        FileEditor fileEditor = editorManager.getSelectedEditor(file.getVirtualFile());
        if (fileEditor != null) {
            ErrorNotificationPanel errorPanel = this.createErrorNotificationPanel(navigator, this.myConsoleDataRequest.getEditor(), error2, feedbackListener, errorInfo, fixes);
            editorManager.addBottomComponent(fileEditor, (JComponent)errorPanel);
            Container parent2 = errorPanel.getParent();
            if (parent2 instanceof JComponent) {
                ((JComponent)parent2).setBorder((Border)JBUI.Borders.empty());
            }
            this.myConsoleDataRequest.getEditor().getContentComponent().requestFocusInWindow();
            if (navigator.canNavigate()) {
                navigator.navigate();
            }
        }
    }

    @NotNull
    private DataRequest.CoupledWithEditor.ErrorNavigator createErrorNavigator(@NotNull Throwable error2) {
        if (error2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(9);
        }
        Project project = this.myConsoleDataRequest.getConsole().getProject();
        Dbms dbms = this.myConsoleDataRequest.getConsole().getTarget().getDbms();
        final int position = DatabaseErrorHandler.EP.forDbms(dbms).getErrorOffsetFromException(project, error2, this.myConsoleDataRequest.query);
        return new DataRequest.CoupledWithEditor.ErrorNavigator(){

            @Override
            public void navigate() {
                int resultOffset = this.getOffset();
                if (resultOffset != -1) {
                    ConsoleDataRequestUi.this.scrollToRange(TextRange.create((int)resultOffset, (int)resultOffset), true);
                    return;
                }
                TextRange range = ConsoleDataRequestUi.this.myConsoleDataRequest.getRange();
                if (range != null) {
                    ConsoleDataRequestUi.this.scrollToRange(range, false);
                }
            }

            @Override
            public boolean canNavigate() {
                return this.getOffset() != -1 || ConsoleDataRequestUi.this.myConsoleDataRequest.getRange() != null;
            }

            private int getOffset() {
                TextRange currentRange = ConsoleDataRequestUi.this.myConsoleDataRequest.getRange();
                if (currentRange == null || ConsoleDataRequestUi.this.myConsoleDataRequest.getInitialRange() != null && !ConsoleDataRequestUi.this.myConsoleDataRequest.getInitialRange().equals((Object)currentRange)) {
                    return -1;
                }
                int offset = position >= 0 ? position + currentRange.getStartOffset() : -1;
                return offset >= currentRange.getEndOffset() ? currentRange.getEndOffset() : offset;
            }
        };
    }

    public void updateConsoleUI(boolean scrollToQuery) {
        TextRange range;
        this.closeErrorPanel();
        if (scrollToQuery && (range = this.myConsoleDataRequest.getRange()) != null) {
            this.scrollToRange(range, false);
        }
        this.updateHighlighting();
    }

    public DataRequest.CoupledWithEditor.ErrorNavigator reportError(@NotNull Throwable error2, @NotNull ConsoleDataRequest.ErrorInfo errorInfo, @Nullable ExecutionConcession concession, @Nullable List<DatabaseErrorHandler.Fix> fixes) {
        if (error2 == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(10);
        }
        if (errorInfo == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(11);
        }
        ConsoleDataRequest.ProblemSolver solver = errorInfo.isWarning() ? this.myConsoleDataRequest.getWarningSolver() : this.myConsoleDataRequest.getErrorSolver();
        solver.newProblem(concession);
        DataRequest.CoupledWithEditor.ErrorNavigator navigator = this.createErrorNavigator(error2);
        ConsoleDataRequest.ErrorsSolver errorsSolver = new ConsoleDataRequest.ErrorsSolver();
        SwingUtilities.invokeLater(() -> {
            this.updateConsoleUI(errorsSolver.isEnabled());
            if (!solver.isEnabled()) {
                return;
            }
            this.handleQueryError(navigator, error2, fixes, (Consumer<ConsoleDataRequest.Decision>)((Consumer)feedback -> {
                this.closeErrorPanel();
                solver.solve((ConsoleDataRequest.Decision)((Object)((Object)feedback)), this.myConsoleDataRequest, concession);
            }), errorInfo);
        });
        return navigator;
    }

    public void closeErrorPanel() {
        ConsoleDataRequestUi.hideErrorPanel(this.myConsoleDataRequest.getEditor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scrollToRange(@NotNull TextRange range, boolean strict) {
        Editor editor;
        if (range == null) {
            ConsoleDataRequestUi.$$$reportNull$$$0(12);
        }
        if ((editor = this.myConsoleDataRequest.getEditor()).isDisposed() || !editor.getContentComponent().isShowing()) {
            return;
        }
        CaretModel caretModel = editor.getCaretModel();
        if (!strict && range.contains(caretModel.getOffset())) {
            return;
        }
        int offset = range.getEndOffset();
        caretModel.moveToOffset(offset);
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.disableAnimation();
        try {
            scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
        finally {
            scrollingModel.enableAnimation();
        }
        TextRange existing = EditorUtil.getSelectionInAnyMode((Editor)editor);
        if (!existing.containsOffset(offset)) {
            editor.getSelectionModel().setSelection(offset, offset);
        }
    }

    private void updateHighlighting() {
        Project project = this.myConsoleDataRequest.getConsole().getProject();
        if (!project.isOpen() || this.myConsoleDataRequest.getEditor().isDisposed()) {
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(this.myConsoleDataRequest.getEditor().getDocument());
        if (file != null) {
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project).restart(file);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigator";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceEditor";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ConsoleDataRequestUi";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorNotificationPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNotificationPanel";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hideErrorPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "handleQueryError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createErrorNavigator";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scrollToRange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class EscapeHandler
    extends EditorActionHandler {
        private final EditorActionHandler myOriginalHandler;

        public EscapeHandler(EditorActionHandler originalHandler) {
            this.myOriginalHandler = originalHandler;
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(0);
            }
            if (this.myOriginalHandler != null && this.myOriginalHandler.isEnabled(editor, caret, dataContext)) {
                this.myOriginalHandler.execute(editor, caret, dataContext);
            }
            ConsoleDataRequestUi.hideErrorPanel(editor);
        }

        protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
            if (editor == null) {
                EscapeHandler.$$$reportNull$$$0(1);
            }
            if (caret == null) {
                EscapeHandler.$$$reportNull$$$0(2);
            }
            return ERROR_PANEL_KEY.get((UserDataHolder)editor) != null || this.myOriginalHandler.isEnabled(editor, caret, dataContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "caret";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$EscapeHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doExecute";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabledForCaret";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ErrorPanelInfo {
        public final ErrorNotificationPanel errorPanel;
        public final Consumer<ConsoleDataRequest.Decision> decisionConsumer;

        ErrorPanelInfo(@NotNull ErrorNotificationPanel errorPanel, @Nullable Consumer<ConsoleDataRequest.Decision> decisionConsumer) {
            if (errorPanel == null) {
                ErrorPanelInfo.$$$reportNull$$$0(0);
            }
            this.errorPanel = errorPanel;
            this.decisionConsumer = decisionConsumer;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorPanel", "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelInfo", "<init>"));
        }
    }

    public static interface Accepter {
        public boolean accept(@NotNull ConsoleDataRequest var1, @NotNull ConsoleDataRequest.ErrorInfo var2);
    }

    private static class LinkConfigurator
    implements Configurator {
        private final ConsoleDataRequest.Decision myDecision;
        private final String myText;
        private final @NlsActions.ActionText String myLinkHtml;
        private final boolean mySuppress;

        LinkConfigurator(@NotNull ConsoleDataRequest.Decision decision, @NotNull String text2, @NlsActions.ActionText @NotNull String linkHtml) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(0);
            }
            if (text2 == null) {
                LinkConfigurator.$$$reportNull$$$0(1);
            }
            if (linkHtml == null) {
                LinkConfigurator.$$$reportNull$$$0(2);
            }
            this(decision, text2, linkHtml, false);
        }

        LinkConfigurator(@NotNull ConsoleDataRequest.Decision decision, @NotNull String text2, @NlsActions.ActionText @NotNull String linkHtml, boolean suppress) {
            if (decision == null) {
                LinkConfigurator.$$$reportNull$$$0(3);
            }
            if (text2 == null) {
                LinkConfigurator.$$$reportNull$$$0(4);
            }
            if (linkHtml == null) {
                LinkConfigurator.$$$reportNull$$$0(5);
            }
            this.myDecision = decision;
            this.myText = text2;
            this.myLinkHtml = linkHtml;
            this.mySuppress = suppress;
        }

        @Override
        public void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<ConsoleDataRequest.Decision> listener2, @NotNull ConsoleDataRequest.ErrorInfo errorInfo) {
            if (builder == null) {
                LinkConfigurator.$$$reportNull$$$0(6);
            }
            if (request == null) {
                LinkConfigurator.$$$reportNull$$$0(7);
            }
            if (errorInfo == null) {
                LinkConfigurator.$$$reportNull$$$0(8);
            }
            if (listener2 != null) {
                builder.addLink(this.myText, this.myLinkHtml, () -> {
                    listener2.consume((Object)this.myDecision);
                    if (this.mySuppress) {
                        assert (errorInfo.getSuppressAction() != null);
                        errorInfo.getSuppressAction().run();
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "decision";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linkHtml";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$LinkConfigurator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configure";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Configurator {
        public void configure(@NotNull ErrorNotificationPanel.Builder var1, @NotNull ConsoleDataRequest var2, @Nullable Consumer<ConsoleDataRequest.Decision> var3, @NotNull ConsoleDataRequest.ErrorInfo var4);
    }

    private static enum ErrorPanelConfigurator {
        STOP(NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.STOP, "&stop", DatabaseBundle.message("action.span.style.text.decoration.underline.s.span.top.text", new Object[0]))),
        RETRY(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.RETRY, "&retry", DatabaseBundle.message("action.span.style.text.decoration.underline.r.span.etry.text", new Object[0]))),
        IGNORE_ERROR(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE, "&ignore", DatabaseBundle.message("action.span.style.text.decoration.underline.i.span.gnore.text", new Object[0]))),
        IGNORE_ALL_ERRORS(ERROR_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE_ALL, "ignore_&all", DatabaseBundle.message("action.ignore.span.style.text.decoration.underline.span.ll.text", new Object[0]))),
        SKIP(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE, "&skip", DatabaseBundle.message("action.span.style.text.decoration.underline.s.span.kip.text", new Object[0]))),
        SKIP_ALL(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.IGNORE_ALL, "skip &all", DatabaseBundle.message("action.skip.span.style.text.decoration.underline.span.ll.text", new Object[0]))),
        FORCE_EXECUTE(WARNING, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE, "&execute", DatabaseBundle.message("action.span.style.text.decoration.underline.e.span.xecute.text", new Object[0]))),
        FORCE_EXECUTE_AND_SUPPRESS((r, e) -> e.getSuppressAction() != null, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE, "exec_s&uppress", DatabaseBundle.message("action.execute.s.span.style.text.decoration.underline.u.span.ppress.text", new Object[0]), true)),
        FORCE_EXECUTE_ALL(WARNING_NOT_LAST, new LinkConfigurator(ConsoleDataRequest.Decision.FORCE_EXECUTE_ALL, "execute_&all", DatabaseBundle.message("action.execute.span.style.text.decoration.underline.span.ll.text", new Object[0]))),
        WARNING_MESSAGE_TYPE(WARNING, (b2, r, l, e) -> b2.messageType(MessageType.WARNING)),
        ERROR_MESSAGE_TYPE(ERROR, (b2, r, l, e) -> b2.messageType(MessageType.ERROR)),
        CLOSE((r, e) -> true, (b2, r, l, e) -> b2.addCloseButton(() -> ConsoleDataRequestUi.hideErrorPanel(r.getEditor())));

        private final Accepter myAccepter;
        private final Configurator myConfigurator;

        private ErrorPanelConfigurator(Accepter accepter, Configurator configurator) {
            if (accepter == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(0);
            }
            if (configurator == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(1);
            }
            this.myAccepter = accepter;
            this.myConfigurator = configurator;
        }

        boolean isAcceptable(@NotNull ConsoleDataRequest request, @NotNull ConsoleDataRequest.ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(2);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(3);
            }
            return this.myAccepter.accept(request, errorInfo);
        }

        void configure(@NotNull ErrorNotificationPanel.Builder builder, @NotNull ConsoleDataRequest request, @Nullable Consumer<ConsoleDataRequest.Decision> listener2, @NotNull ConsoleDataRequest.ErrorInfo errorInfo) {
            if (builder == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(4);
            }
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(5);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(6);
            }
            this.myConfigurator.configure(builder, request, listener2, errorInfo);
        }

        @NotNull
        static Iterable<ErrorPanelConfigurator> filterFor(@NotNull ConsoleDataRequest request, @NotNull ConsoleDataRequest.ErrorInfo errorInfo) {
            if (request == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(7);
            }
            if (errorInfo == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(8);
            }
            JBIterable jBIterable = JBIterable.of((Object[])ErrorPanelConfigurator.values()).filter(v -> v.isAcceptable(request, errorInfo));
            if (jBIterable == null) {
                ErrorPanelConfigurator.$$$reportNull$$$0(9);
            }
            return jBIterable;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accepter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurator";
                    break;
                }
                case 2: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorInfo";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelConfigurator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/ConsoleDataRequestUi$ErrorPanelConfigurator";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterFor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isAcceptable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "filterFor";
                    break;
                }
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

