/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.google.common.collect.Iterables;
import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.concurrency.ResultConsumer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.data.types.DasColumnRef;
import com.intellij.database.data.types.PredicateSpecKt;
import com.intellij.database.data.types.PredicateValuesKt;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DataGridUtilCore;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.extractors.DisplayHtmlValuesExtractor;
import com.intellij.database.extractors.ExtractionConfigKt;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ModelRelationManager;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.actions.CountRowsAction;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.DataGridDocumentationCommand;
import com.intellij.database.run.ui.DataGridDocumentationHelper;
import com.intellij.database.script.generator.dml.DmlHelper;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.Version;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.SameThreadExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntHashSet;
import java.awt.Color;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Pair;
import kotlin.Triple;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataGridDocumentationProvider
extends AbstractDocumentationProvider
implements ExternalDocumentationHandler {
    private static final String VIEW_MODE_PROPERTY = "DataGrid.QuickDoc.View";
    private static final Key<State> GRID_HINT_STATE_KEY = Key.create((String)"GRID_HINT_STATE_KEY");

    public static String buildAndRunQueries(@NotNull DataGrid dataGrid, @Nls CharSequence initialValue) {
        boolean noRelationships;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(0);
        }
        DasTable databaseTable = DataGridUtilCore.getDatabaseTable(dataGrid);
        DbDataSource dataSource2 = DataGridUtil.getDatabaseSystem(dataGrid);
        if (dataSource2 == null || databaseTable == null) {
            return null;
        }
        ModelIndex<DataConsumer.Row> selectedRow = dataGrid.getSelectionModel().getSelectedRow();
        boolean badSelection = !selectedRow.isValid(dataGrid) || dataGrid.getSelectionModel().getSelectedRowCount() != 1;
        boolean bl = noRelationships = !DataGridDocumentationProvider.hasNavigatableKeys(dataSource2, databaseTable);
        if (badSelection || noRelationships) {
            DataGridDocumentationProvider.setHint(dataGrid, null);
            return null;
        }
        State state = (State)dataGrid.getUserData(GRID_HINT_STATE_KEY);
        List<QueryInfo> newQueries = DataGridDocumentationProvider.buildQueries(dataSource2, dataGrid, selectedRow, EnumSet.of(KeyType.FOREIGN, KeyType.EXPORTED));
        if (state != null && state.queries.equals(newQueries) && selectedRow.equals(state.row) && System.currentTimeMillis() - state.timestamp <= 5000L) {
            return state.current;
        }
        state = new State(newQueries, selectedRow, null);
        DataGridDocumentationProvider.setHint(dataGrid, state);
        DataGridDocumentationProvider.runQueries(dataGrid, state, initialValue.toString());
        return null;
    }

    public static boolean hasNavigatableKeys(@NotNull DbDataSource dataSource2, @NotNull DasTable databaseTable) {
        if (dataSource2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(2);
        }
        return !Iterables.isEmpty(ModelRelationManager.getExportedKeys(dataSource2.getProject(), databaseTable)) || !Iterables.isEmpty(ModelRelationManager.getForeignKeys(dataSource2.getProject(), databaseTable));
    }

    public static List<QueryInfo> buildQueries(@NotNull DasDataSource dataSource2, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull EnumSet<KeyType> keyTypes) {
        if (dataSource2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(3);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (keyTypes == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(6);
        }
        GridModel model = dataGrid.getDataModel(DataAccessType.DATABASE_DATA);
        TIntHashSet selectedColumnIndices = new TIntHashSet((keyTypes.contains((Object)KeyType.SELECTED) ? dataGrid.getSelectionModel().getSelectedColumns() : model.getColumnIndices()).asArray());
        DasTable databaseTable = DataGridUtilCore.getDatabaseTable(dataGrid);
        LinkedHashMap<String, QueryInfo> queries = new LinkedHashMap<String, QueryInfo>();
        if (keyTypes.contains((Object)KeyType.FOREIGN)) {
            DataGridDocumentationProvider.collectForeignKeyQueries(queries, databaseTable, dataSource2.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        if (keyTypes.contains((Object)KeyType.EXPORTED)) {
            DataGridDocumentationProvider.collectExportedKeyQueries(queries, databaseTable, dataSource2.getDbms(), dataGrid, selectedRow, selectedColumnIndices);
        }
        return new ArrayList<QueryInfo>(queries.values());
    }

    private static void collectForeignKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(8);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(9);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(11);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(12);
        }
        for (DasForeignKey key : ModelRelationManager.getForeignKeys(DataGridUtil.getProject(dataGrid), databaseTable)) {
            DataGridDocumentationProvider.collectKeyQueries(queries, databaseTable, dbms, dataGrid, selectedRow, selectedColumns, key, false);
        }
    }

    private static void collectKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns, @NotNull DasForeignKey key, boolean exported) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(13);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(16);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(17);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(18);
        }
        if (key == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(19);
        }
        DasTable table = exported ? key.getTable() : key.getRefTable();
        List<Triple<DasColumnRef, ModelIndex<DataConsumer.Column>, Object>> columnsAndValues = DataGridDocumentationProvider.tryCollectValues(dataGrid, selectedRow, selectedColumns, key, !exported);
        if (table == null || columnsAndValues == null || columnsAndValues.isEmpty()) {
            return;
        }
        GridModel dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ValuesWhereClause whereClause2 = new ValuesWhereClause(ContainerUtil.map(columnsAndValues, v -> {
            String formatted = DataGridUtil.formatValue((DataConsumer.Column)dataModel.getColumn((ModelIndex)v.getSecond()), dataGrid.getObjectFormatter(), dbms, v.getThird());
            return new Triple((Object)((DasColumnRef)v.getFirst()), (Object)PredicateValuesKt.predicateValue(formatted), PredicateSpecKt.DEFAULT_OPS);
        }), "AND", null);
        DbDataSource system = DataGridUtil.getDatabaseSystem(dataGrid);
        Version version = system == null ? null : system.getVersion();
        SelectTask task2 = DmlTaskKt.allColumns(table).version(version).limit(exported ? 2 : 1).whereClause(whereClause2).build(DbImplUtil.createBuilderForUIExec(dbms, (DasObject)databaseTable));
        DmlHelper generator = DmlUtilKt.dmlGenerator(dbms);
        String query = generator.generate(task2).getStatement();
        DataGridDocumentationProvider.collectQuery(queries, new QueryInfo(query, table, exported, ArrayUtil.toStringArray((Collection)ContainerUtil.map(columnsAndValues, c2 -> ((DasColumnRef)c2.getFirst()).getName())), ContainerUtil.map(columnsAndValues, c2 -> c2.getThird()).toArray()), key);
    }

    private static void collectExportedKeyQueries(@NotNull Map<String, QueryInfo> queries, @NotNull DasTable databaseTable, @NotNull Dbms dbms, @NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns) {
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(20);
        }
        if (databaseTable == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (dbms == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(22);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(25);
        }
        JBIterable referencingKeys = ModelRelationManager.getExportedKeys(DataGridUtil.getProject(dataGrid), databaseTable).filter(DasForeignKey.class);
        for (DasForeignKey key : referencingKeys) {
            DataGridDocumentationProvider.collectKeyQueries(queries, databaseTable, dbms, dataGrid, selectedRow, selectedColumns, key, true);
        }
    }

    private static void collectQuery(@NotNull Map<String, QueryInfo> queries, @NotNull QueryInfo newQueryInfo, @NotNull DasConstraint key) {
        String keyText;
        String query;
        QueryInfo info;
        if (queries == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (newQueryInfo == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(27);
        }
        if (key == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(28);
        }
        if ((info = queries.get(query = newQueryInfo.query)) == null) {
            info = newQueryInfo;
            queries.put(query, info);
        }
        if (!info.keysAndColumns.contains(keyText = key.getName() + "(" + StringUtil.join(key.getColumnsRef().names(), (String)", ") + ")")) {
            if (!info.keysAndColumns.isEmpty()) {
                info.keysAndColumns = info.keysAndColumns + ", ";
            }
            info.keysAndColumns = info.keysAndColumns + keyText;
        }
    }

    @Nullable
    protected static List<Triple<DasColumnRef, ModelIndex<DataConsumer.Column>, Object>> tryCollectValues(@NotNull DataGrid dataGrid, @NotNull ModelIndex<DataConsumer.Row> selectedRow, @NotNull TIntHashSet selectedColumns, @NotNull DasForeignKey key, boolean keyInCurrentGrid) {
        boolean noIndexColumnSelected;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (selectedRow == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (selectedColumns == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(31);
        }
        if (key == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(32);
        }
        List currentGridColumns = JBIterable.from((keyInCurrentGrid ? key.getColumnsRef() : key.getRefColumns()).resolveObjects()).filter(DasColumn.class).toList();
        List otherGridColumns = JBIterable.from((keyInCurrentGrid ? key.getRefColumns() : key.getColumnsRef()).resolveObjects()).filter(DasColumn.class).toList();
        ArrayList<Pair> columnsAndIndexes = new ArrayList<Pair>();
        for (int i2 = 0; i2 < currentGridColumns.size(); ++i2) {
            DasColumn currentGridColumn = (DasColumn)currentGridColumns.get(i2);
            ModelIndex<DataConsumer.Column> idx = DataGridUtil.findColumn(dataGrid, currentGridColumn.getName());
            if (!idx.isValid(dataGrid) || i2 >= otherGridColumns.size()) continue;
            DasColumn otherGridColumn = (DasColumn)otherGridColumns.get(i2);
            columnsAndIndexes.add(new Pair((Object)otherGridColumn, idx));
        }
        boolean bl = noIndexColumnSelected = ContainerUtil.find(columnsAndIndexes, column2 -> selectedColumns.contains(((ModelIndex)column2.getSecond()).asInteger())) == null;
        if (noIndexColumnSelected) {
            return null;
        }
        GridModel dataModel = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        return ContainerUtil.map(columnsAndIndexes, columnAndIndex -> new Triple((Object)new DasColumnRef((DasColumn)columnAndIndex.getFirst()), (Object)((ModelIndex)columnAndIndex.getSecond()), dataModel.getValueAt(selectedRow, (ModelIndex)columnAndIndex.getSecond())));
    }

    private static void runQueries(final DataGrid dataGrid, final State state, final @Nls String initialValue) {
        if (state.queries.isEmpty()) {
            return;
        }
        final PsiElement element2 = DataGridUtil.getPsiElementForSelection(dataGrid);
        if (element2 == null || DataGridPomTarget.unwrapCell(element2) == null) {
            return;
        }
        final Project project = element2.getProject();
        DatabaseGridDataHookUp ownerEx = DataGridUtil.getDatabaseHookUp(dataGrid);
        if (ownerEx == null) {
            return;
        }
        ownerEx.getMessageBus().getDataProducer().processRequest(new DataRequest.RawRequest(ownerEx){

            @Override
            public void processRaw(DataRequest.Context context, DatabaseConnectionCore connection2) {
                String doc = DataGridDocumentationProvider.getQuickDocFooter(state, dataGrid, (DatabaseConnection)connection2);
                if (doc != null) {
                    QuickDocUtil.updateQuickDoc((Project)project, (PsiElement)element2, (String)(initialValue + doc));
                }
            }
        });
    }

    @Nullable
    @Nls
    public static String getQuickDocFooter(@NotNull State state, @NotNull DataGrid dataGrid, @NotNull DatabaseConnection connection2) {
        if (state == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(33);
        }
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(34);
        }
        if (connection2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(35);
        }
        StringBuilder sb = new StringBuilder();
        for (QueryInfo info : state.queries) {
            DataGridDocumentationProvider.checkCancelled(state, dataGrid);
            int length = sb.length();
            DataSourceUtil.tryLoadFirstNRows(connection2, info.query, sb, 1);
            DataGridDocumentationProvider.checkCancelled(state, dataGrid);
            if (sb.length() == length) continue;
            @Nls String title = DatabaseBundle.message("documentation.referenced.1.first.referencing.1", !info.exported ? 0 : 1, info.table.getName());
            sb.insert(length, "<br><b>" + title + ":</b><br>" + info.keysAndColumns);
        }
        if (sb.length() == 0) {
            return null;
        }
        sb.insert(0, "<br>");
        DataGridDocumentationProvider.setHint(dataGrid, new State(state.queries, state.row, sb.toString()));
        return sb.toString();
    }

    private static void checkCancelled(State state, DataGrid dataGrid) {
        if (dataGrid.getUserData(GRID_HINT_STATE_KEY) != state) {
            throw new ProcessCanceledException();
        }
    }

    public static void setHint(@NotNull DataGrid dataGrid, @Nullable State state) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(36);
        }
        dataGrid.putUserData(GRID_HINT_STATE_KEY, state);
    }

    @NotNull
    public static String getCellDocumentation(@NotNull DataGrid dataGrid, final DataGridDocumentationCommand mode) {
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(37);
        }
        StringBuilder sb = new StringBuilder(DisplayHtmlValuesExtractor.getHeader());
        SelectionModel selectionModel = dataGrid.getSelectionModel();
        boolean singleValue = selectionModel.getSelectedColumnCount() + selectionModel.getSelectedRowCount() == 2;
        final boolean plainMode = singleValue && mode != DataGridDocumentationCommand.transposed;
        CharOut.Wrapper out = new CharOut.Wrapper(CharOut.Util.newSink(sb)){
            static final int max = 10240;

            @Override
            @NotNull
            public CharOut append(@NotNull CharSequence seq) {
                CharSequence trimmedSeq;
                if (seq == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (seq.length() == 0) {
                    2 v0 = this;
                    if (v0 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return v0;
                }
                boolean truncate = mode != DataGridDocumentationCommand.full && (double)seq.length() > 11264.0;
                CharSequence charSequence = trimmedSeq = truncate ? seq.subSequence(0, 10240) : seq;
                if (plainMode) {
                    DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate(), DataGridDocumentationCommand.transposed, DatabaseBundle.message("cells.view.mode.transposed", new Object[0]));
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;&nbsp;&nbsp;"), DataGridDocumentationCommand.full, DatabaseBundle.message("cells.show.all.N.byte", ExtractorsUtil.getPresentableSize(seq.length())));
                    }
                    super.append("<br><br><pre><code>");
                    this.appendInner(trimmedSeq);
                    super.append("</code>");
                    if (truncate) {
                        DataGridDocumentationProvider.appendHyperLinkCommand(this.getDelegate().append("&nbsp;"), DataGridDocumentationCommand.full, DatabaseBundle.message("cells.show.N.byte.more", ExtractorsUtil.getPresentableSize(seq.length() - 10240)));
                    }
                    super.append("</pre>");
                } else if (truncate) {
                    this.appendInner(trimmedSeq);
                    super.append(" " + ExtractorsUtil.getPresentableSize(seq.length() - 10240) + " more...");
                } else {
                    this.appendInner(seq);
                }
                2 v2 = this;
                if (v2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                return v2;
            }

            void appendInner(CharSequence trimmedSeq) {
                int cur2 = 0;
                int len = trimmedSeq.length();
                while (cur2 < len) {
                    int next = StringUtil.indexOf((CharSequence)trimmedSeq, (char)'\n', (int)cur2);
                    next = next < 0 ? len : next;
                    super.append(trimmedSeq.subSequence(cur2, next));
                    if (next != len) {
                        super.append(" \n");
                    }
                    cur2 = next + 1;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "seq";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "append";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "append";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        final ObjectFormatter delegateFormatter = dataGrid.getObjectFormatter();
        ObjectFormatter converter = new ObjectFormatter(){

            @Override
            @Nullable
            public String objectToString(@Nullable Object o, DataConsumer.Column column2, Dbms dbms, @NotNull ObjectFormatterMode mode) {
                if (mode == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (o instanceof ObjectFormatter.ImageInfo) {
                    ObjectFormatter.ImageInfo oo = (ObjectFormatter.ImageInfo)o;
                    String s2 = delegateFormatter.objectToString(oo.stripBytes(), column2, dbms, ObjectFormatterMode.DISPLAY);
                    return DataGridDocumentationHelper.createImageRefTag(oo, s2);
                }
                String s3 = delegateFormatter.objectToString(o, column2, dbms, ObjectFormatterMode.DISPLAY);
                return HtmlValuesExtractor.escapeChars(s3);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/database/run/ui/DataGridDocumentationProvider$3", "objectToString"));
            }
        };
        if (singleValue) {
            DataGridUtil.extractSelectedValues(dataGrid, ExtractorsUtil.getSingleValueExtractor(converter), out);
        } else {
            int[] columns = (mode == DataGridDocumentationCommand.transposed ? dataGrid.getVisibleColumns() : selectionModel.getSelectedColumns()).asArray();
            Color color = Objects.requireNonNull(EditorColorsUtil.getGlobalOrDefaultColor((ColorKey)DocumentationComponent.COLOR_KEY));
            DisplayHtmlValuesExtractor extractor = new DisplayHtmlValuesExtractor(color, converter);
            DataGridDocumentationCommand command = mode == DataGridDocumentationCommand.transposed ? DataGridDocumentationCommand.regular : DataGridDocumentationCommand.transposed;
            String text2 = mode == DataGridDocumentationCommand.transposed ? DatabaseBundle.message("cells.view.mode.regular", new Object[0]) : DatabaseBundle.message("cells.view.mode.transposed", new Object[0]);
            DataGridDocumentationProvider.appendHyperLinkCommand(out.getDelegate(), command, text2).append("<br><br>");
            Dbms dbms = DataGridUtil.getDbms(dataGrid);
            List<DataConsumer.Column> allColumns = dataGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumns();
            List<DataConsumer.Row> selectedRows = DataGridUtil.getSelectedRows(dataGrid);
            ExtractorsUtil.extract((CharOut)out, dbms, ExtractionConfigKt.builder().setTransposed(mode == DataGridDocumentationCommand.transposed).build(), allColumns, extractor, selectedRows, columns);
        }
        String result2 = DataGridDocumentationProvider.buildAndRunQueries(dataGrid, sb);
        String string = (result2 == null ? sb : sb.append(result2)).append("<br><br><br>").toString();
        if (string == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    public Image getLocalImageForElement(@NotNull PsiElement element2, @NotNull String imageSpec) {
        if (element2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(39);
        }
        if (imageSpec == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(40);
        }
        return DataGridDocumentationHelper.resolveImageRef(imageSpec);
    }

    @Nullable
    public String generateDoc(PsiElement element2, @Nullable PsiElement originalElement) {
        DataGridPomTarget.Cell cell = DataGridPomTarget.unwrapCell(element2);
        if (cell != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)element2.getProject());
            DataGridDocumentationCommand command = DataGridDocumentationCommand.getCommand(propertiesComponent.getValue(VIEW_MODE_PROPERTY), DataGridDocumentationCommand.regular);
            return DataGridDocumentationProvider.getCellDocumentation(cell.dataGrid, command);
        }
        DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid(element2);
        if (DataGridUtil.getQueryText(dataGrid) != null) {
            return DataGridDocumentationProvider.getGridDocumentation(element2.getProject(), dataGrid);
        }
        return null;
    }

    @Nullable
    private static String getGridDocumentation(Project project, @NotNull DataGrid dataGrid) {
        String queryText2;
        if (dataGrid == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(41);
        }
        if ((queryText2 = DataGridUtil.getQueryText(dataGrid)) == null) {
            return null;
        }
        GridPagingModel pageModel = dataGrid.getDataHookup().getPageModel();
        String curCount = pageModel.getTotalRowCount() + (!pageModel.isTotalRowCountPrecise() ? "+" : "");
        return "<b>rows:</b> " + curCount + (pageModel.isTotalRowCountUpdateable() ? DataGridDocumentationHelper.getCountCommand(pageModel.isTotalRowCountPrecise()) : "") + "<br><br><pre><code>" + DbSqlUtil.sql2Html(project, (Language)DataGridUtil.getSqlDialect(dataGrid), queryText2) + "</code></pre>";
    }

    public boolean handleExternal(PsiElement element2, PsiElement originalElement) {
        return false;
    }

    public boolean handleExternalLink(PsiManager psiManager, String link, PsiElement context) {
        return false;
    }

    public boolean canFetchDocumentationLink(String link) {
        return link != null && link.startsWith("db-doc://");
    }

    @Nullable
    public String extractRefFromLink(@NotNull String link) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(42);
        }
        return link.endsWith(DataGridDocumentationCommand.count.name()) ? "$keepScrollingPosition$" : null;
    }

    @NotNull
    public String fetchExternalDocumentation(@NotNull String link, @Nullable PsiElement element2) {
        if (link == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(43);
        }
        if (element2 == null) {
            return "";
        }
        int paramStart = link.indexOf(63);
        String substring = link.substring("db-doc://".length() + 1, paramStart == -1 ? link.length() : paramStart);
        DataGridDocumentationCommand command = DataGridDocumentationCommand.getCommand(substring, null);
        Project project = element2.getProject();
        if (command == DataGridDocumentationCommand.count) {
            int queryIdx;
            Long rowCount = DataGridDocumentationProvider.getUpdatedRowCount(project, element2);
            if (rowCount == null || !project.isOpen()) {
                return "";
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            String text2 = component == null ? null : component.getText();
            int n = queryIdx = text2 == null ? -1 : text2.indexOf(link);
            if (queryIdx < 0) {
                return "";
            }
            int idx0 = text2.lastIndexOf("</b>", queryIdx) + "</b>".length() + 1;
            int idx1 = text2.indexOf("</a>", queryIdx + link.length()) + "</a>".length();
            if (idx0 < 0 || idx1 < 0) {
                return "";
            }
            String string = text2.substring(0, idx0) + rowCount + DataGridDocumentationHelper.getCountCommand(true) + text2.substring(idx1);
            if (string == null) {
                DataGridDocumentationProvider.$$$reportNull$$$0(44);
            }
            return string;
        }
        if (command == DataGridDocumentationCommand.transposed || command == DataGridDocumentationCommand.regular) {
            PropertiesComponent.getInstance((Project)project).setValue(VIEW_MODE_PROPERTY, command.name());
        }
        return DataGridDocumentationProvider.getCellDocumentation(Objects.requireNonNull(DataGridPomTarget.unwrapDataGrid(element2)), command);
    }

    public boolean canHandleExternal(@Nullable PsiElement element2, @Nullable PsiElement originalElement) {
        return false;
    }

    @Nullable
    private static Long getUpdatedRowCount(@NotNull Project project, @Nullable PsiElement element2) {
        AsyncFutureResult<Long> rowCountResult;
        if (project == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(45);
        }
        if (element2 instanceof DbTable) {
            VirtualFile file = ((DbTable)element2).getVirtualFile();
            if (file == null) {
                return null;
            }
            final Disposable disposable2 = Disposer.newDisposable();
            Disposer.register((Disposable)project, (Disposable)disposable2);
            GridDataHookUp hookUp = (GridDataHookUp)UIUtil.invokeAndWaitIfNeeded(() -> GridDataHookUpManager.getInstance(project).getOrCreateLightweight(file, disposable2, DGDepartment.QUICK_DOCUMENTATION));
            rowCountResult = CountRowsAction.countRows(hookUp);
            rowCountResult.addConsumer(SameThreadExecutor.INSTANCE, (ResultConsumer)new ResultConsumer<Long>(){

                public void onSuccess(Long value2) {
                    Disposer.dispose((Disposable)disposable2);
                }

                public void onFailure(@NotNull Throwable t) {
                    if (t == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    Disposer.dispose((Disposable)disposable2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/intellij/database/run/ui/DataGridDocumentationProvider$4", "onFailure"));
                }
            });
        } else {
            DataGrid grid = DataGridPomTarget.unwrapDataGrid(element2);
            if (grid == null) {
                return null;
            }
            rowCountResult = CountRowsAction.countRows(grid);
        }
        try {
            return (Long)rowCountResult.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @NotNull
    private static CharOut appendHyperLinkCommand(@NotNull CharOut sb, @NotNull DataGridDocumentationCommand command, @NotNull String text2) {
        if (sb == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(46);
        }
        if (command == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(47);
        }
        if (text2 == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(48);
        }
        CharOut charOut = sb.append("<a href=\"db-doc:///" + command.name() + "\">" + text2 + "</a>");
        if (charOut == null) {
            DataGridDocumentationProvider.$$$reportNull$$$0(49);
        }
        return charOut;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 38: 
            case 44: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 38: 
            case 44: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataGrid";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "databaseTable";
                break;
            }
            case 5: 
            case 11: 
            case 17: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedRow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyTypes";
                break;
            }
            case 7: 
            case 13: 
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queries";
                break;
            }
            case 9: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 12: 
            case 18: 
            case 25: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedColumns";
                break;
            }
            case 19: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newQueryInfo";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 38: 
            case 44: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DataGridDocumentationProvider";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellDocumentation";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "fetchExternalDocumentation";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "appendHyperLinkCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAndRunQueries";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasNavigatableKeys";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildQueries";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "collectForeignKeyQueries";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "collectKeyQueries";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectExportedKeyQueries";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectQuery";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "tryCollectValues";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getQuickDocFooter";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "setHint";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getCellDocumentation";
                break;
            }
            case 38: 
            case 44: 
            case 49: {
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getLocalImageForElement";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getGridDocumentation";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "extractRefFromLink";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "fetchExternalDocumentation";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedRowCount";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "appendHyperLinkCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 38: 
            case 44: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class QueryInfo {
        public final String query;
        public final DasTable table;
        public final boolean exported;
        public final String[] columnNames;
        public final Object[] values;
        @NlsSafe
        public String keysAndColumns = "";

        QueryInfo(String query, DasTable table, boolean exported, String[] columnNames, Object[] values2) {
            this.query = query;
            this.table = table;
            this.exported = exported;
            this.columnNames = columnNames;
            this.values = values2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryInfo info = (QueryInfo)o;
            return this.query.equals(info.query);
        }

        public int hashCode() {
            return this.query.hashCode();
        }
    }

    public static class State {
        final List<QueryInfo> queries;
        final ModelIndex<DataConsumer.Row> row;
        final String current;
        final long timestamp = System.currentTimeMillis();

        public State(List<QueryInfo> queries, ModelIndex<DataConsumer.Row> row, String current) {
            this.queries = queries;
            this.row = row;
            this.current = current;
        }
    }

    public static enum KeyType {
        EXPORTED,
        FOREIGN,
        SELECTED;

    }
}

