/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.extractors.JsonUtilKt;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.run.ui.MinimizedFormat;
import com.intellij.database.script.MongoJSLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\t\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\r\u0012\u0004\u0012\u00020\n0\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/run/ui/MongoJSFormat;", "Lcom/intellij/database/run/ui/MinimizedFormat;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "value", "", "document", "Lcom/intellij/openapi/editor/Document;", "(Lcom/intellij/database/datagrid/DataGrid;Ljava/lang/Object;Lcom/intellij/openapi/editor/Document;)V", "reformat", "", "disableUpdateListener", "Lkotlin/Function1;", "Lkotlin/Function0;", "restore", "", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.database.impl"})
public final class MongoJSFormat
implements MinimizedFormat {
    private final DataGrid grid;
    private final Object value;
    private final Document document;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String restore(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.text");
        return string;
    }

    @Override
    public void reformat(@NotNull Function1<? super Function0<Unit>, Unit> disableUpdateListener) {
        Intrinsics.checkNotNullParameter(disableUpdateListener, (String)"disableUpdateListener");
        Dbms dbms = DataGridUtil.getDbms(this.grid);
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(grid)");
        ObjectFormatter objectFormatter = this.grid.getObjectFormatter();
        Intrinsics.checkNotNullExpressionValue((Object)objectFormatter, (String)"grid.objectFormatter");
        String formatted = JsonUtilKt.toJson$default(this.value, dbms, objectFormatter, ObjectFormatterMode.JS_SCRIPT, null, true, 16, null);
        disableUpdateListener.invoke((Object)new Function0<Unit>(this, formatted){
            final /* synthetic */ MongoJSFormat this$0;
            final /* synthetic */ String $formatted;

            public final void invoke() {
                MongoJSFormat.access$getDocument$p(this.this$0).setText((CharSequence)this.$formatted);
            }
            {
                this.this$0 = mongoJSFormat;
                this.$formatted = string;
                super(0);
            }
        });
    }

    public MongoJSFormat(@NotNull DataGrid grid, @Nullable Object value2, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.grid = grid;
        this.value = value2;
        this.document = document;
    }

    public static final /* synthetic */ Document access$getDocument$p(MongoJSFormat $this) {
        return $this.document;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/run/ui/MongoJSFormat$Companion;", "", "()V", "detect", "Lcom/intellij/database/run/ui/MongoJSFormat;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "value", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.database.impl"})
    public static final class Companion {
        @Nullable
        public final MongoJSFormat detect(@NotNull DataGrid grid, @Nullable Object value2, @NotNull Project project, @NotNull Document document) {
            PsiFile file;
            Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            PsiFile psiFile = file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            return Intrinsics.areEqual((Object)(psiFile != null ? psiFile.getLanguage() : null), (Object)((Object)MongoJSLanguage.INSTANCE)) && (value2 instanceof List || value2 instanceof Map) ? new MongoJSFormat(grid, value2, document) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

