/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ObjectUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GridCellEditorFactory {
    public static final int SUITABILITY_UNSUITABLE = 0;
    public static final int SUITABILITY_MIN = 1;
    public static final int SUITABILITY_MAX = 10;

    public int getSuitability(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @NotNull
    public IsEditableChecker getIsEditableChecker();

    @NotNull
    public ValueParser getValueParser(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @NotNull
    public ValueFormatter getValueFormatter(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3, @Nullable Object var4);

    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3, @Nullable Object var4, EventObject var5);

    public static class DefaultValueToText
    implements ValueFormatter {
        private final DataGrid myGrid;
        private final ModelIndex<DataConsumer.Column> myColumnIdx;
        private final Object myValue;

        public DefaultValueToText(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Column> columnIdx, @Nullable Object value2) {
            if (grid == null) {
                DefaultValueToText.$$$reportNull$$$0(0);
            }
            if (columnIdx == null) {
                DefaultValueToText.$$$reportNull$$$0(1);
            }
            this.myGrid = grid;
            this.myColumnIdx = columnIdx;
            this.myValue = ObjectUtils.notNull((Object)value2, (Object)((Object)ReservedCellValue.NULL));
        }

        @Override
        @NotNull
        public ValueFormatterResult format() {
            if (this.myValue instanceof LobInfo) {
                return new ValueFormatterResult(this.myValue instanceof LobInfo.ClobInfo ? ((LobInfo.ClobInfo)this.myValue).data : "");
            }
            GridModel model = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
            DataConsumer.Column column2 = model.getColumn(this.myColumnIdx);
            String text2 = this.myValue instanceof ReservedCellValue || column2 == null ? "" : StringUtil.notNullize((String)this.myGrid.getObjectFormatter().objectToString(this.myValue, column2, DataGridUtil.getDbms(this.myGrid), ObjectFormatterMode.DISPLAY));
            return new ValueFormatterResult(text2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "grid";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "columnIdx";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/run/ui/grid/editors/GridCellEditorFactory$DefaultValueToText";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ValueFormatterResult {
        public final String text;
        public final Charset charset;
        public final byte[] bom;

        public ValueFormatterResult(String text2) {
            this(text2, StandardCharsets.UTF_8, CharsetToolkit.UTF8_BOM);
        }

        public ValueFormatterResult(String text2, Charset charset, byte[] bom) {
            this.text = text2;
            this.charset = charset;
            this.bom = bom;
        }
    }

    public static interface ValueFormatter {
        @NotNull
        public ValueFormatterResult format();
    }

    public static interface ValueParser {
        @NotNull
        public Object parse(@NotNull String var1, @Nullable Document var2);
    }

    public static interface IsEditableChecker {
        public boolean isEditable(@NotNull Dbms var1, @Nullable Object var2);
    }
}

