/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelFacade;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.SequenceIdentity;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModSequence;
import com.intellij.database.model.basic.BasicModTableOrView;
import com.intellij.database.model.basic.BasicModTypedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.model.properties.Grants;
import com.intellij.database.schemaEditor.DbObjectEditor;
import com.intellij.database.schemaEditor.DbObjectEditorFactoryHelper;
import com.intellij.database.view.ModelLightCopier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbObjectEditorFactory {
    public static final DbmsExtension<DbObjectEditorFactory> EP = new DbmsExtension("com.intellij.database.objectEditorFactory");
    public static final DbObjectEditorFactory DEFAULT = new DbObjectEditorFactory();
    private static final Map<Class<?>, Converter<String, ?>> ourConverters;
    private static final Map<Class<? extends Collection>, Factory<? extends Collection<?>>> ourCollections;

    @NotNull
    public static DbObjectEditorFactory forDbms(@NotNull Dbms dbms) {
        if (dbms == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(0);
        }
        DbObjectEditorFactory dbObjectEditorFactory = (DbObjectEditorFactory)ObjectUtils.notNull((Object)EP.forDbms(dbms), (Object)DEFAULT);
        if (dbObjectEditorFactory == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(1);
        }
        return dbObjectEditorFactory;
    }

    @NotNull
    public DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(2);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(3);
        }
        DbObjectEditor dbObjectEditor = this.createObjectEditor(project, meta, null);
        if (dbObjectEditor == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(4);
        }
        return dbObjectEditor;
    }

    @NotNull
    public BasicModElement pull(@NotNull BasicModModel target, @NotNull BasicElement source, @NotNull BasicMetaObject<?> edit) {
        if (target == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(5);
        }
        if (source == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(6);
        }
        if (edit == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(7);
        }
        Grants.Controller<?, ?> gc = ModelFacade.forDbms(target.getDbms()).getModelHelper().getGrantController();
        Ref res2 = Ref.create();
        ((BaseModel)target).modify(target.getRoot(), BasicModRoot.class, true, r -> {
            res2.set((Object)DbObjectEditorFactory.pullObjectsForGrantee(target, source, gc));
            if (res2.isNull()) {
                res2.set((Object)ModelLightCopier.copy(source, target));
                this.pullGrantees(source, (BasicModElement)res2.get(), gc);
            }
        });
        BasicModElement basicModElement = (BasicModElement)res2.get();
        if (basicModElement == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(8);
        }
        return basicModElement;
    }

    @Nullable
    private static <G extends Grants.Grant, U extends BasicElement> BasicModElement pullObjectsForGrantee(@NotNull BasicModModel target, @NotNull BasicElement source, @Nullable Grants.Controller<G, U> gc) {
        if (target == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(9);
        }
        if (source == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(10);
        }
        Object grantee = gc == null ? null : (Object)gc.asGrantee(source);
        BasicElement parent2 = source.getParent();
        if (grantee == null || parent2 == null) {
            return null;
        }
        BasicModElement resP = ModelLightCopier.copy(parent2, target, true);
        return (BasicModElement)ObjectUtils.tryCast(gc.findGrantee(gc.withGrantee(gc.create(), grantee), resP), BasicModElement.class);
    }

    private <U extends BasicElement> void pullGrantees(@NotNull BasicElement src, @NotNull BasicModElement tgt, @Nullable Grants.Controller<?, U> ge) {
        if (src == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(11);
        }
        if (tgt == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(12);
        }
        if (ge == null) {
            return;
        }
        JBIterable<Family<U>> srcG = ge.granteeFamiliesFor(src);
        JBIterable<Family<U>> tgtG = ge.granteeFamiliesFor(tgt);
        Iterator srcIt = srcG.iterator();
        Iterator tgtIt = tgtG.iterator();
        while (srcIt.hasNext() && tgtIt.hasNext()) {
            this.pullFamily((Family)srcIt.next(), (ModFamily)tgtIt.next());
        }
    }

    protected void pullFamily(@Nullable BasicElement src, @Nullable BasicModElement tgt, @NotNull ObjectKind kind) {
        if (kind == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(13);
        }
        this.pullFamily(src == null ? null : src.familyOf(kind), (ModFamily<?>)(tgt == null ? null : tgt.familyOf(kind)));
    }

    protected void pullFamily(@Nullable Family<?> src, @Nullable ModFamily<?> tgt) {
        if (src != null && tgt != null && tgt.isEmpty() && src.isNotEmpty()) {
            ModelLightCopier.copyFamily(src, tgt);
        }
    }

    @NotNull
    public <E extends BasicElement> DbObjectEditor createObjectEditor(@NotNull Project project, @NotNull BasicMetaObject<E> meta, @Nullable List<BasicMetaPropertyId<?>> invalid) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(14);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(15);
        }
        ArrayList properties = ContainerUtil.newArrayList((Object[])meta.properties);
        this.reorderProperties(meta, properties);
        List<DbObjectEditor> editors = this.createEditors(project, meta, properties, invalid);
        DbObjectEditor dbObjectEditor = DbObjectEditorFactoryHelper.getInstance().createCompoundEditor(editors);
        if (dbObjectEditor == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(16);
        }
        return dbObjectEditor;
    }

    @NotNull
    protected <E extends BasicElement> List<DbObjectEditor> createEditors(@NotNull Project project, @NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaProperty<E, ?>> properties, @Nullable List<BasicMetaPropertyId<?>> invalid) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(17);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(18);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(19);
        }
        ArrayList<DbObjectEditor> editors = new ArrayList<DbObjectEditor>(properties.size());
        while (!properties.isEmpty()) {
            BasicMetaProperty<E, ?> property = properties.get(0);
            if (!this.createPropertyEditor(project, meta, property, properties, editors) && invalid != null) {
                invalid.add(property.id);
            }
            properties.remove(property);
        }
        ContainerUtil.addIfNotNull(editors, (Object)DbObjectEditorFactory.createAnyGrantsEditor(project, meta));
        ArrayList<DbObjectEditor> arrayList = editors;
        if (arrayList == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Nullable
    public static DbObjectEditor createAnyGrantsEditor(@NotNull Project project, @NotNull BasicMetaObject<?> meta) {
        Dbms dbms;
        Grants.Controller<?, ?> grantCtl;
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(21);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(22);
        }
        if ((grantCtl = ModelFacade.forDbms(dbms = meta.getModel().dbms).getModelHelper().getGrantController()) == null) {
            return null;
        }
        DbObjectEditorFactoryHelper helper = DbObjectEditorFactoryHelper.getInstance();
        if (grantCtl.asGrantee((BasicElement)meta.newDataObject()) != null) {
            return helper.createGranteeGrantsEditor(project, meta, grantCtl);
        }
        return helper.createGrantsEditor(project, meta, grantCtl);
    }

    protected <E extends BasicElement> boolean createPropertyEditor(@NotNull Project project, @NotNull BasicMetaObject<E> meta, BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaProperty<E, ?>> properties, @NotNull List<DbObjectEditor> editors) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(23);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(24);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(25);
        }
        if (editors == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(26);
        }
        if (property.internal.booleanValue()) {
            return true;
        }
        DbObjectEditor editor = this.createPropertyEditor(project, meta, property, properties);
        if (editor == null) {
            return false;
        }
        editors.add(editor);
        return true;
    }

    @NlsSafe
    @NotNull
    protected String getTitle(@NotNull BasicMetaPropertyId<?> prop) {
        if (prop == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(27);
        }
        return DbObjectEditorFactory.words(prop.name);
    }

    protected <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaProperty<E, ?>> properties) {
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(28);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(29);
        }
        DbObjectEditorFactory.moveTo(properties, 0, BasicModNamedElement.NAME, BasicModNamedElement.COMMENT, BasicModTableOrView.TEMPORARY, BasicModTypedElement.DATA_TYPE, BasicModSequence.SEQUENCE_IDENTITY);
    }

    public static <E extends BasicElement> void moveTo(List<BasicMetaProperty<E, ?>> list, int idx, BasicMetaPropertyId<?> ... values2) {
        for (BasicMetaPropertyId<?> value2 : values2) {
            int newIdx = DbObjectEditorFactory.moveTo(list, idx, value2);
            if (newIdx == -1) continue;
            idx = newIdx + 1;
        }
    }

    public static <E extends BasicElement> int moveTo(List<BasicMetaProperty<E, ?>> list, int idx, BasicMetaPropertyId<?> value2) {
        int valIdx = DbObjectEditorFactory.indexOf(list, value2);
        if (valIdx == -1) {
            return -1;
        }
        if (valIdx == idx) {
            return idx;
        }
        if (valIdx < idx) {
            --idx;
        }
        list.add(idx, list.remove(valIdx));
        return idx;
    }

    protected static <E extends BasicElement> BasicMetaProperty<E, ?> remove(List<BasicMetaProperty<E, ?>> list, BasicMetaPropertyId<?> value2) {
        int idx = DbObjectEditorFactory.indexOf(list, value2);
        return idx == -1 ? null : list.remove(idx);
    }

    protected static <E extends BasicElement> int indexOf(List<BasicMetaProperty<E, ?>> list, BasicMetaPropertyId<?> value2) {
        int e = list.size();
        for (int i2 = 0; i2 < e; ++i2) {
            if (!list.get((int)i2).id.equals(value2)) continue;
            return i2;
        }
        return -1;
    }

    private static NameValueType parseNvt(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        int typeSep = StringUtil.indexOf((CharSequence)s2, (char)':', (int)0, (int)valSepSafe);
        return new NameValueType(s2.substring(0, typeSep == -1 ? valSepSafe : typeSep), valSep == -1 ? "" : s2.substring(valSep + 1), typeSep == -1 ? "" : s2.substring(typeSep + 1, valSepSafe));
    }

    @NotNull
    private static String serializeNvt(NameValueType nvt) {
        String string = nvt.getName() + (String)(StringUtil.isEmpty((String)nvt.getType()) ? "" : ":" + nvt.getType()) + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(30);
        }
        return string;
    }

    private static NameValue parseNv(String s2) {
        int valSep = s2.indexOf(61);
        int valSepSafe = valSep == -1 ? s2.length() : valSep;
        return new NameValue(s2.substring(0, valSepSafe), valSep == -1 ? "" : s2.substring(valSep + 1));
    }

    @NotNull
    private static String serializeNv(NameValue nvt) {
        String string = nvt.getName() + "=" + nvt.getValue();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(31);
        }
        return string;
    }

    private static <T> void put(ContainerUtil.ImmutableMapBuilder<Class<?>, Converter<String, ?>> builder, Class<T> clazz, Function<T, String> from, Function<String, T> to) {
        builder.put(clazz, new Converter<String, T>(from, to));
    }

    @Nullable
    public <E extends BasicElement> DbObjectEditor createPropertyEditor(@NotNull Project project, @NotNull BasicMetaObject<E> meta, @NotNull BasicMetaProperty<E, ?> property, @NotNull List<BasicMetaProperty<E, ?>> properties) {
        if (project == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(32);
        }
        if (meta == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(33);
        }
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(34);
        }
        if (properties == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(35);
        }
        DbObjectEditorFactoryHelper helper = DbObjectEditorFactoryHelper.getInstance();
        if (property.id == BasicModNamedElement.NAME) {
            DbObjectEditorFactory.remove(properties, BasicModNamedElement.NAME);
            DbObjectEditorFactory.remove(properties, BasicModNamedElement.NAME_QUOTED);
            DbObjectEditorFactory.remove(properties, BasicModNamedElement.NAME_SCRIPTED);
            DbObjectEditorFactory.remove(properties, BasicModNamedElement.NAME_SURROGATE);
            return helper.createNameEditor(project);
        }
        DbObjectEditor editor = this.getTextEditor(property, helper);
        if (editor != null) {
            return editor;
        }
        BasicMetaProperty<E, Object> prop = property.tryCast(Boolean.class);
        if (prop != null) {
            return helper.createBoolPropEditor(prop, this.getTitle(property.id));
        }
        prop = property.tryCast(SequenceIdentity.class);
        if (prop != null) {
            return helper.createSeqIdPropEditor(prop, this.getTitle(property.id));
        }
        prop = property.tryCast(Enum.class);
        if (prop != null) {
            return helper.createEnumPropEditor(prop, this.getTitle(property.id));
        }
        if (property.id.type instanceof BasicMetaType.CollectionMetaType) {
            return this.createPropertyEditor(property, (BasicMetaType.CollectionMetaType)property.id.type);
        }
        return null;
    }

    @Nullable
    private <E extends BasicElement, T> DbObjectEditor getTextEditor(@NotNull BasicMetaProperty<E, T> property, DbObjectEditorFactoryHelper helper) {
        Converter<String, T> converter;
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(36);
        }
        if ((converter = DbObjectEditorFactory.getConverter(property)) != null) {
            return helper.createTextPropEditor(property, this.getTitle(property.id), converter.from, converter.to);
        }
        return null;
    }

    private static <E extends BasicElement, T> Converter<String, T> getConverter(@NotNull BasicMetaProperty<E, T> property) {
        if (property == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(37);
        }
        return ourConverters.get(property.id.getValueClass());
    }

    @Nullable
    public <E extends BasicElement> DbObjectEditor createPropertyEditor(BasicMetaProperty<E, ?> property, BasicMetaType.CollectionMetaType<?, ?> type) {
        Factory<? extends Collection<?>> fac = ourCollections.get(property.id.getValueClass());
        if (fac == null) {
            return null;
        }
        DbObjectEditorFactoryHelper helper = DbObjectEditorFactoryHelper.getInstance();
        Converter<String, ?> converter = ourConverters.get(type.elementClass);
        if (converter != null) {
            return helper.createTextCollectionPropEditor(property, this.getTitle(property.id), converter.from, converter.to, fac);
        }
        if (Enum.class.isAssignableFrom(type.elementClass)) {
            return helper.createEnumListEditor(property, this.getTitle(property.id), type.elementClass, fac);
        }
        return null;
    }

    @NotNull
    private static String words(@NotNull String s2) {
        if (s2 == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(38);
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < s2.length(); ++i2) {
            char prev = i2 < 1 ? (char)'\u0000' : s2.charAt(i2 - 1);
            char cur2 = s2.charAt(i2);
            if (Character.isLowerCase(prev) && Character.isUpperCase(cur2)) {
                sb.append(' ');
            }
            sb.append(cur2);
        }
        String string = sb.toString();
        if (string == null) {
            DbObjectEditorFactory.$$$reportNull$$$0(39);
        }
        return string;
    }

    static {
        ourCollections = ContainerUtil.immutableMapBuilder().put(List.class, ArrayList::new).put(Set.class, LinkedHashSet::new).build();
        ContainerUtil.ImmutableMapBuilder builder = ContainerUtil.immutableMapBuilder();
        DbObjectEditorFactory.put(builder, String.class, Functions.id(), Functions.id());
        DbObjectEditorFactory.put(builder, OneTimeString.class, s2 -> s2 == null ? "" : s2.toString(false), s2 -> new OneTimeString(s2));
        DbObjectEditorFactory.put(builder, Byte.class, Object::toString, Byte::parseByte);
        DbObjectEditorFactory.put(builder, Short.class, Object::toString, Short::parseShort);
        DbObjectEditorFactory.put(builder, Integer.class, Object::toString, Integer::parseInt);
        DbObjectEditorFactory.put(builder, Long.class, Object::toString, Long::parseLong);
        DbObjectEditorFactory.put(builder, Float.class, Object::toString, Float::parseFloat);
        DbObjectEditorFactory.put(builder, Double.class, Object::toString, Double::parseDouble);
        DbObjectEditorFactory.put(builder, BigInteger.class, Object::toString, BigInteger::new);
        DbObjectEditorFactory.put(builder, DataType.class, dt -> dt.equals(DataType.UNKNOWN) ? "" : dt.getSpecification(), s2 -> StringUtil.isEmpty((String)s2) ? DataType.UNKNOWN : DataTypeFactory.of(s2));
        DbObjectEditorFactory.put(builder, NameValue.class, DbObjectEditorFactory::serializeNv, DbObjectEditorFactory::parseNv);
        DbObjectEditorFactory.put(builder, NameValueType.class, DbObjectEditorFactory::serializeNvt, DbObjectEditorFactory::parseNvt);
        ourConverters = builder.build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 30: 
            case 31: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 30: 
            case 31: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 30: 
            case 31: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 2: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 15: 
            case 18: 
            case 22: 
            case 24: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meta";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edit";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: 
            case 25: 
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editors";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
            case 34: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/DbObjectEditorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forDbms";
                break;
            }
            case 4: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createObjectEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "pull";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditors";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNvt";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "serializeNv";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "words";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forDbms";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 30: 
            case 31: 
            case 39: {
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createObjectEditor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "pull";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "pullObjectsForGrantee";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "pullGrantees";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "pullFamily";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createEditors";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAnyGrantsEditor";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createPropertyEditor";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "reorderProperties";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getTextEditor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConverter";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "words";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 30: 
            case 31: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Converter<A, B> {
        public final Function<B, A> from;
        public final Function<A, B> to;

        private Converter(Function<B, A> from, Function<A, B> to) {
            this.from = from;
            this.to = to;
        }
    }
}

