/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseViewTreeFun;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\nH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bJ\b\u0010\u001c\u001a\u00020\nH\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0010\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/DataSourceNode;", "Lcom/intellij/database/model/basic/BasicNode;", "dbDataSource", "Lcom/intellij/database/psi/DbDataSource;", "(Lcom/intellij/database/psi/DbDataSource;)V", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "groupName", "", "getGroupName", "()Ljava/lang/String;", "modelRoot", "Lcom/intellij/database/model/basic/BasicRoot;", "getModelRoot", "()Lcom/intellij/database/model/basic/BasicRoot;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "realDataSource", "Lcom/intellij/database/dataSource/AbstractDataSource;", "getDisplayName", "getModel", "Lcom/intellij/database/model/basic/BasicModel;", "iterateChildren", "Lcom/intellij/util/containers/JBIterable;", "toString", "Companion", "intellij.database.impl"})
public final class DataSourceNode
implements BasicNode {
    @JvmField
    @NotNull
    public final AbstractDataSource realDataSource;
    @JvmField
    @NotNull
    public final DbDataSource dbDataSource;
    private static final Key<DataSourceNode> DATA_SOURCE_NODE;
    private static final Object syncObject;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Project getProject() {
        Project project = this.dbDataSource.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"dbDataSource.project");
        return project;
    }

    @NotNull
    public final Dbms getDbms() {
        Dbms dbms = this.realDataSource.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"realDataSource.dbms");
        return dbms;
    }

    @Nullable
    public final String getGroupName() {
        return this.realDataSource.getGroupName();
    }

    @Nullable
    public final BasicRoot getModelRoot() {
        BasicModel basicModel = this.getModel();
        return basicModel != null ? basicModel.getRoot() : null;
    }

    @Override
    @Nullable
    public BasicModel getModel() {
        DasModel dasModel = this.realDataSource.getModel();
        if (!(dasModel instanceof BasicModel)) {
            dasModel = null;
        }
        return (BasicModel)dasModel;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.realDataSource.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"realDataSource.name");
        return string;
    }

    @NotNull
    public String toString() {
        return this.realDataSource.getName() + ": DSN";
    }

    @NotNull
    public final JBIterable<BasicNode> iterateChildren() {
        JBIterable jBIterable;
        BasicRoot root2 = this.getModelRoot();
        if (root2 != null) {
            JBIterable jBIterable2 = JBIterable.from((Iterable)root2.getFamilies());
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"JBIterable.from(root.families)");
        } else {
            JBIterable jBIterable3 = JBIterable.empty();
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.empty()");
        }
        return jBIterable;
    }

    public DataSourceNode(@NotNull DbDataSource dbDataSource) {
        Intrinsics.checkNotNullParameter((Object)dbDataSource, (String)"dbDataSource");
        AbstractDataSource abstractDataSource = DatabaseViewTreeFun.unwrap(dbDataSource);
        if (abstractDataSource == null) {
            throw (Throwable)new IllegalArgumentException("Invalid DbDataSource: it doesn't wrap a real DataSource");
        }
        this.realDataSource = abstractDataSource;
        this.dbDataSource = dbDataSource;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"DATA_SOURCE_NODE");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"DATA_SOURCE_NODE\")");
        DATA_SOURCE_NODE = key;
        syncObject = new Object();
    }

    @JvmStatic
    @NotNull
    public static final DataSourceNode node(@NotNull DbDataSource $this$node, @NotNull Project inProject) {
        return Companion.node($this$node, inProject);
    }

    @JvmStatic
    @NotNull
    public static final DataSourceNode node(@NotNull DbDataSource $this$node) {
        return Companion.node($this$node);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\n\u001a\u00020\u0005*\u00020\u000bH\u0007J\u0014\u0010\n\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u0016\u0010\u0007\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/database/view/DataSourceNode$Companion;", "", "()V", "DATA_SOURCE_NODE", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/view/DataSourceNode;", "getDATA_SOURCE_NODE$annotations", "syncObject", "Ljava/lang/Object;", "getSyncObject$annotations", "node", "Lcom/intellij/database/psi/DbDataSource;", "inProject", "Lcom/intellij/openapi/project/Project;", "intellij.database.impl"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getDATA_SOURCE_NODE$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getSyncObject$annotations() {
        }

        @JvmStatic
        @NotNull
        public final DataSourceNode node(@NotNull DbDataSource $this$node, @NotNull Project inProject) {
            Intrinsics.checkNotNullParameter((Object)$this$node, (String)"$this$node");
            Intrinsics.checkNotNullParameter((Object)inProject, (String)"inProject");
            DbDataSource dbDataSource = DbImplUtil.getDbDataSource(inProject, $this$node);
            if (dbDataSource == null) {
                throw (Throwable)new IllegalArgumentException("No DbDataSource for the given " + $this$node.getClass().getSimpleName() + " (" + $this$node + ')');
            }
            DbDataSource dbd = dbDataSource;
            return this.node(dbd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final DataSourceNode node(@NotNull DbDataSource $this$node) {
            Intrinsics.checkNotNullParameter((Object)$this$node, (String)"$this$node");
            DataSourceNode attachedNode = (DataSourceNode)$this$node.getUserData(DATA_SOURCE_NODE);
            if (attachedNode == null) {
                Object object = syncObject;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (object) {
                    boolean bl3 = false;
                    attachedNode = (DataSourceNode)$this$node.getUserData(DATA_SOURCE_NODE);
                    if (attachedNode == null) {
                        attachedNode = new DataSourceNode($this$node);
                        $this$node.putUserData(DATA_SOURCE_NODE, attachedNode);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            DataSourceNode dataSourceNode = attachedNode;
            Intrinsics.checkNotNull((Object)dataSourceNode);
            return dataSourceNode;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

