/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.database.util.SqlDialects;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.IsExternal;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlInspectionBase
extends LocalInspectionTool {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        String string = SqlInspectionBase.getShortName((String)super.getID());
        if (string == null) {
            SqlInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            SqlInspectionBase.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            SqlInspectionBase.$$$reportNull$$$0(2);
        }
        if (!(file instanceof SqlFile)) {
            return null;
        }
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)file);
        if (this.isDialectIgnored(dialect)) {
            return null;
        }
        ArrayList<ProblemDescriptor> result2 = new ArrayList<ProblemDescriptor>();
        SqlAnnotationVisitor visitor2 = this.createAnnotationVisitor((SqlFile)file, dialect, manager, result2, isOnTheFly);
        if (visitor2 == null) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        file.accept((PsiElementVisitor)this.createRecursiveVisitor(visitor2));
        return result2.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    @NotNull
    protected PsiRecursiveElementWalkingVisitor createRecursiveVisitor(final SqlAnnotationVisitor visitor2) {
        return new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof SqlElement) {
                    visitor2.myCheckSubtree = false;
                    ((SqlElement)element2).accept((SqlVisitor)visitor2);
                } else {
                    visitor2.myCheckSubtree = true;
                }
                if (visitor2.myCheckSubtree) {
                    super.visitElement(element2);
                }
            }

            protected void elementFinished(PsiElement element2) {
                visitor2.elementFinished(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/inspections/SqlInspectionBase$1", "visitElement"));
            }
        };
    }

    protected boolean isDialectIgnored(SqlLanguageDialectEx dialect) {
        return dialect == SqlDialects.getGenericDialect();
    }

    @Nullable
    protected SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        if (dialect == null) {
            SqlInspectionBase.$$$reportNull$$$0(3);
        }
        if (manager == null) {
            SqlInspectionBase.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            SqlInspectionBase.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    protected SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlFile file, @NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result2, boolean onTheFly) {
        if (file == null) {
            SqlInspectionBase.$$$reportNull$$$0(6);
        }
        if (dialect == null) {
            SqlInspectionBase.$$$reportNull$$$0(7);
        }
        if (manager == null) {
            SqlInspectionBase.$$$reportNull$$$0(8);
        }
        if (result2 == null) {
            SqlInspectionBase.$$$reportNull$$$0(9);
        }
        return this.createAnnotationVisitor(dialect, manager, result2, onTheFly);
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = SqlBundle.message("sql.inspections.group.name", new Object[0]);
        if (string == null) {
            SqlInspectionBase.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = StringUtil.getShortName((String)((Object)((Object)this)).getClass().getName());
        if (string == null) {
            SqlInspectionBase.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/inspections/SqlInspectionBase";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/inspections/SqlInspectionBase";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SqlAnnotationVisitor
    extends SqlVisitor {
        private boolean myCheckSubtree;
        protected InspectionManager myManager;
        protected SqlLanguageDialectEx myDialect;
        protected Collection<ProblemDescriptor> myResults;

        public SqlAnnotationVisitor(InspectionManager manager, SqlLanguageDialect dialect, Collection<ProblemDescriptor> results2) {
            this.myManager = manager;
            this.myDialect = (SqlLanguageDialectEx)dialect;
            this.myResults = results2;
        }

        public void visitSqlElement(SqlElement o) {
            this.myCheckSubtree = true;
        }

        protected void addDescriptor(ProblemDescriptor problemDescriptor) {
            this.myResults.add(problemDescriptor);
        }

        protected boolean shouldNotCheckElement(SqlElement o) {
            return PsiUtilCore.hasErrorElementChild((PsiElement)o.getParent()) || PsiUtilCore.hasErrorElementChild((PsiElement)o) || this.myDialect.mayContainExternalPsi() && SyntaxTraverser.psiApi().parents((Object)o).filter(Conditions.instanceOf((Class[])new Class[]{SqlResultSetExpression.class, IsExternal.class})).first() instanceof IsExternal;
        }

        public void elementFinished(PsiElement element2) {
        }
    }
}

