/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtilBase;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlTokenElement;
import org.jetbrains.annotations.NotNull;

public class SqlStringTokenElement
extends SqlTokenElement {
    public SqlStringTokenElement(@NotNull IElementType type, CharSequence text2) {
        if (type == null) {
            SqlStringTokenElement.$$$reportNull$$$0(0);
        }
        super(type, text2);
    }

    @NotNull
    public String getTokenText() {
        return SqlStringTokenElement.getTokenText((ASTNode)this);
    }

    @NotNull
    public TextRange getRangeInElement() {
        return SqlStringTokenElement.getRangeInElement((ASTNode)this);
    }

    @NotNull
    static String getTokenText(@NotNull ASTNode node) {
        String unescapedText;
        if (node == null) {
            SqlStringTokenElement.$$$reportNull$$$0(1);
        }
        if ((unescapedText = StringUtil.notNullize((String)(node instanceof PsiElement ? InjectedLanguageUtilBase.getUnescapedLeafText((PsiElement)((PsiElement)node), (boolean)false) : node.getText()))).length() < 2 || node.getElementType() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            String string = unescapedText;
            if (string == null) {
                SqlStringTokenElement.$$$reportNull$$$0(2);
            }
            return string;
        }
        int end2 = unescapedText.length() - 1;
        char quoteChar = unescapedText.charAt(end2);
        String quote = String.valueOf(quoteChar);
        int idx = unescapedText.indexOf(quoteChar == ']' ? 91 : (int)quoteChar);
        if (idx < 0) {
            String string = unescapedText;
            if (string == null) {
                SqlStringTokenElement.$$$reportNull$$$0(3);
            }
            return string;
        }
        int begin = idx + 1;
        if (begin > end2) {
            String string = unescapedText;
            if (string == null) {
                SqlStringTokenElement.$$$reportNull$$$0(4);
            }
            return string;
        }
        String unquoted = unescapedText.substring(begin, end2);
        String string = quoteChar == ']' ? unquoted : StringUtil.replace((String)unquoted, (String)(quote + quote), (String)quote);
        if (string == null) {
            SqlStringTokenElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    static TextRange getRangeInElement(@NotNull ASTNode node) {
        TextRange result2;
        if (node == null) {
            SqlStringTokenElement.$$$reportNull$$$0(6);
        }
        String text2 = node.getText();
        int length = text2.length();
        IElementType type = node.getElementType();
        if (type == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            result2 = TextRange.from((int)0, (int)length);
        } else {
            int prefixLength;
            char start2 = type == SqlTokens.SQL_STRING_TOKEN || type == SqlTokens.SQL_UNCLOSED_TOKEN ? Character.toUpperCase(text2.charAt(0)) : (char)'\u0000';
            char prefix = start2 == 'N' || start2 == 'B' || start2 == 'X' || start2 == 'E' ? start2 : (char)'\u0000';
            int n = prefixLength = prefix == '\u0000' ? 0 : 1;
            if (length - prefixLength == 1) {
                TextRange textRange = TextRange.from((int)0, (int)length);
                if (textRange == null) {
                    SqlStringTokenElement.$$$reportNull$$$0(7);
                }
                return textRange;
            }
            if (prefix != '\u0000') {
                SqlStringTokenElement.assertCorrectLength(node, length - 3);
                result2 = TextRange.from((int)2, (int)(length - 3));
            } else {
                SqlStringTokenElement.assertCorrectLength(node, length - 2);
                result2 = TextRange.from((int)1, (int)(length - 2));
            }
        }
        TextRange textRange = result2;
        if (textRange == null) {
            SqlStringTokenElement.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static void assertCorrectLength(@NotNull ASTNode node, int length) {
        if (node == null) {
            SqlStringTokenElement.$$$reportNull$$$0(9);
        }
        if (length >= 0) {
            return;
        }
        PsiElement psi = node.getPsi();
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)psi.getProject()).getInjectionHost(psi);
        PsiFile file = psi.getContainingFile();
        TextRange range = node.getTextRange();
        String fileText = file.getText();
        int d2 = 50;
        TextRange fragmentRange = TextRange.create((int)Math.max(0, range.getStartOffset() - d2), (int)Math.min(fileText.length(), range.getEndOffset() + d2));
        String fragment = fragmentRange.substring(fileText);
        SqlDialectImplUtilCore.LOG.error(String.format("length: %s; type: %s; range: %s; text: %s\nhost.lang: %s; text: %s;\nfile.lang: %s(%s); length: %s; class: %s; file.name: %s\nfile.fragment%s: %s", length, node.getElementType(), range, node.getText(), host == null ? "<null>" : host.getLanguage().getID(), host == null ? "<null>" : host.getText(), file.getLanguage().getID(), file instanceof SqlFile ? ((SqlFile)file).getSqlLanguage().getID() : "<null>", fileText.length(), file.getClass().getSimpleName(), file.getName(), fragmentRange, fragment) + (String)(host != null ? "\nhost.lang: " + host.getLanguage().getID() + "; host.text: " + host.getText() + ";" : ""));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlStringTokenElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlStringTokenElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTokenText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "assertCorrectLength";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

