/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFileParser;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiException;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiFailLogger;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiJsonUtils;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainsV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainsV1Kt;
import com.jetbrains.cidr.cpp.toolchains.CPPCompilerSwitchesUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.CompilerSpecificSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cmake.psi.CMakeFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeApiProfileGenerationResult
extends CMakeProfileGenerationResult {
    @NlsSafe
    private static final String API_DIR_V_1 = ".cmake/api/v1";
    @NlsSafe
    private static final String CODE_MODEL_V_2 = "codemodel-v2";
    @NlsSafe
    private static final String CACHE_V_2 = "cache-v2";
    @NlsSafe
    private static final String CMAKE_FILES_V_1 = "cmakeFiles-v1";
    @NlsSafe
    private static final String TOOLCHAINS_V_1 = "toolchains-v1";
    private static final Pattern COMPILER_FILE_PATTERN = Pattern.compile("^CMake(\\w+)Compiler.cmake$");
    @Nullable
    CMakeModel myPreviousModel;
    @Nullable
    private String myProjectName;
    private Collection<CMakeProfileTargetInfo> myTargetInfos;
    @Nullable
    private String cudaHostCompiler;
    @NotNull
    private final CMakeApiFailLogger myFailLogger;

    public CMakeApiProfileGenerationResult(@NotNull CMakeGenerator generator2, @NotNull CMakeGenerator.Parameters parameters, @Nullable CMakeModel previousModel) {
        if (generator2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(0);
        }
        if (parameters == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(1);
        }
        super(generator2, parameters);
        this.myFailLogger = new CMakeApiFailLogger();
        this.myPreviousModel = previousModel;
    }

    @Override
    @Nullable
    protected String getCMakeGeneratorName() {
        if (CMakeGenerator.isAPIForced() && !CMakeGenerator.hasUserSpecifiedGenerator(this.parameters.additionalOptions)) {
            return CMakeGenerator.getGeneratorSpec(this.parameters.environment.getToolSet(), false);
        }
        return null;
    }

    @Override
    protected void beforeGenerate(@NotNull Path generationDir2) {
        if (generationDir2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(2);
        }
        super.beforeGenerate(generationDir2);
        Path queryPath = generationDir2.resolve(".cmake/api/v1/query");
        try {
            CMakeGenerator.ensurePathExists(queryPath, true);
            this.createQueryIfMissing(queryPath, CODE_MODEL_V_2);
            this.createQueryIfMissing(queryPath, CACHE_V_2);
            this.createQueryIfMissing(queryPath, CMAKE_FILES_V_1);
            if (Registry.is((String)"cmake.api.toolchains.v1")) {
                this.createQueryIfMissing(queryPath, TOOLCHAINS_V_1);
            }
        }
        catch (CMakeApiException | IOException e) {
            this.hasGenerationError = true;
            this.reportError(e);
        }
    }

    private void createQueryIfMissing(Path queryDir, String query) throws CMakeApiException {
        try {
            CMakeGenerator.ensurePathExists(queryDir.resolve(query), false);
        }
        catch (IOException e) {
            this.fail("can not create " + query + " query: " + e.getLocalizedMessage());
        }
    }

    @Override
    protected void loadInfo(@NotNull File generationDir2, @NotNull CMakeGenerator.CommonInfo commonInfo) {
        if (generationDir2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(3);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(4);
        }
        try {
            this.doLoadInfo(generationDir2, commonInfo);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            if (!this.hasGenerationError) {
                this.reportError(e);
            }
            ArrayList<CMakeProfileTargetInfo> infos = new ArrayList<CMakeProfileTargetInfo>();
            this.fillFromPreviousModel(infos, commonInfo);
            this.myTargetInfos = infos;
        }
    }

    private void fillFromPreviousModel(@NotNull List<CMakeProfileTargetInfo> infos, @NotNull CMakeGenerator.CommonInfo commonInfo) {
        if (infos == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(5);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(6);
        }
        if (this.myPreviousModel == null) {
            return;
        }
        this.myPreviousModel.getCMakeDependencyFiles().forEach(commonInfo::addDependencyFile);
        this.myPreviousModel.getHeaderAndResourceFiles().forEach(commonInfo::addSourceFile);
        this.myPreviousModel.getFileExtensions().forEach(commonInfo::addExtension);
        this.myProjectName = this.myPreviousModel.getProjectName();
        for (CMakeTarget target : this.myPreviousModel.getTargets()) {
            List<CMakeConfiguration> configurations = target.getBuildConfigurations();
            for (CMakeConfiguration configuration : configurations) {
                if (configuration.getProfileId() != this.parameters.profileId) continue;
                CMakeProfileTargetInfo info = new CMakeProfileTargetInfo(this.parameters.environment, this.myGenerator.getCMakeListsFile(), configuration.getConfigurationGenerationDir(), configuration.getConfigurationAndTargetGenerationDir(), target.getName(), configuration.getTargetType(), configuration.getGenerator(), configuration.getBuildType(), configuration.getBuildWorkingDir());
                info.sources = new HashMap<File, CMakeFileSettings>(configuration.getSourcesMap());
                info.productFile = configuration.getProductFile();
                info.linkerFlags = new ArrayList<String>(configuration.getLinkerFlags());
                info.perLanguageSettings = new HashMap<OCLanguageKind, CMakeConfigurationSettings>(configuration.getPerLanguageSettingsMap());
                infos.add(info);
            }
        }
    }

    private void doLoadInfo(@NotNull File generationDir2, @NotNull CMakeGenerator.CommonInfo commonInfo) throws CMakeApiException {
        File[] inds;
        if (generationDir2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(7);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(8);
        }
        this.myFailLogger.pushScope(generationDir2.getPath());
        File replyDir = new File(generationDir2, ".cmake/api/v1/reply");
        if (!replyDir.exists()) {
            this.fail("no reply dir found");
        }
        if ((inds = replyDir.listFiles((dir, name2) -> name2.startsWith("index-"))) == null || inds.length == 0) {
            this.fail("no index file found");
        }
        Arrays.sort(inds, (o1, o2) -> Comparing.compare((Comparable)((Object)o2.getName()), (Comparable)((Object)o1.getName())));
        File indexFile = inds[0];
        JsonObject indexObj = this.loadJsonObject(indexFile);
        JsonObject cmakeObj = this.getJsonObject(indexObj, "cmake");
        JsonObject generatorObj = this.getJsonObject(cmakeObj, "generator");
        CMakeConfiguration.Generator generator2 = new CMakeConfiguration.Generator(CMakeApiProfileGenerationResult.getName(generatorObj), true);
        JsonObject reply = this.getJsonObject(indexObj, "reply");
        JsonObject cmInfoObj = this.getJsonObject(reply, CODE_MODEL_V_2);
        JsonObject codeModelObj = this.loadReplyFile(replyDir, cmInfoObj);
        JsonObject cmPaths = this.getJsonObject(codeModelObj, "paths");
        String topLevelSourceDirPath = cmPaths.get("source").getAsString();
        File topLevelSourceDir = new File(this.parameters.environment.toLocalPath(topLevelSourceDirPath));
        String topLevelBuildDirPath = cmPaths.get("build").getAsString();
        File topLevelBuildDir = new File(this.parameters.environment.toLocalPath(topLevelBuildDirPath));
        JsonObject cmakeFiles = this.loadReplyFile(replyDir, this.getJsonObject(reply, CMAKE_FILES_V_1));
        Set cudaFolders = FileCollectionFactory.createCanonicalFileSet();
        for (JsonElement depElm : this.getJsonArray(cmakeFiles, "inputs")) {
            JsonObject depObj = depElm.getAsJsonObject();
            if (CMakeApiProfileGenerationResult.getBool(depObj, "isCMake")) continue;
            if (CMakeApiProfileGenerationResult.getBool(depObj, "isGenerated")) {
                @NlsSafe String string = depObj.get("path").getAsString();
                if (!string.endsWith(".o.cmake.pre-gen") && !string.endsWith(".obj.cmake.pre-gen")) continue;
                File cudaDir = CMakeGenerator.toLocalFile(this.parameters.environment, topLevelSourceDir, string).getParentFile();
                cudaFolders.add(cudaDir);
                continue;
            }
            String string = depObj.get("path").getAsString();
            if (string == null) {
                this.fail("no path for a file in cmakeFiles-v1");
            }
            File depFile = CMakeGenerator.toLocalFile(this.parameters.environment, topLevelSourceDir, string);
            commonInfo.addDependencyFile(depFile);
        }
        JsonObject toolchainsObj = Registry.is((String)"cmake.api.toolchains.v1") ? this.loadOptionalReplyFile(replyDir, this.getJsonObject(reply, TOOLCHAINS_V_1)) : null;
        Map<OCLanguageKind, CompilerInfo> compilers = this.readCompilerInfoMap(cmakeFiles, toolchainsObj, topLevelSourceDir);
        for (Map.Entry entry : compilers.entrySet()) {
            OCLanguageKind languageKind = (OCLanguageKind)entry.getKey();
            for (String extension : ((CompilerInfo)entry.getValue()).extensions) {
                commonInfo.addExtension(extension, languageKind);
            }
        }
        JsonElement cacheElm = reply.get(CACHE_V_2);
        if (cacheElm == null) {
            this.fail("no cache-v2 found");
        }
        JsonObject jsonObject = this.loadReplyFile(replyDir, cacheElm.getAsJsonObject());
        List<String> types = null;
        for (JsonElement entryElm : this.getJsonArray(jsonObject, "entries")) {
            JsonObject entry = entryElm.getAsJsonObject();
            String name3 = CMakeApiProfileGenerationResult.getName(entry);
            if ("CMAKE_CUDA_HOST_COMPILER".equals(name3)) {
                this.cudaHostCompiler = entry.get("value").getAsString();
            }
            if (!"CMAKE_CONFIGURATION_TYPES".equals(name3)) continue;
            String typesString = entry.get("value").getAsString();
            types = CMakeCacheFileParser.parseListValue(typesString);
            break;
        }
        if (types != null) {
            this.setBuildTypes(types);
        }
        Map targetInfos = CMakeGenerator.createOrderedTargetKeysMap();
        JsonArray cfgArray = this.getJsonArray(codeModelObj, "configurations");
        if (cfgArray.size() == 0) {
            this.fail("no configurations in codemodel-v2");
        }
        HashMap<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache = new HashMap<String, CPPEnvironment.ExecutablePathResult>(2);
        boolean forceFirstConfig = cfgArray.size() == 1 || "Default".equals(this.parameters.buildType);
        for (JsonElement cfgElm : cfgArray) {
            JsonObject cfgObj = cfgElm.getAsJsonObject();
            JsonElement builtTypeName = cfgObj.get("name");
            if (builtTypeName == null) {
                this.fail("no configuration name");
            }
            String buildType2 = builtTypeName.getAsString();
            if (!forceFirstConfig && !this.parameters.buildType.equals(buildType2)) continue;
            String string = buildType2 = StringUtil.isEmpty((String)buildType2) ? "Default" : buildType2;
            if (this.myProjectName == null) {
                JsonObject projObj;
                JsonElement projNameElm;
                JsonArray projArray = this.getJsonArray(cfgObj, "projects");
                if (projArray.size() == 0) {
                    this.fail("no projects in codemodel-v2");
                }
                if ((projNameElm = (projObj = (JsonObject)projArray.get(0)).get("name")) == null) {
                    this.fail("no project name");
                }
                this.myProjectName = projNameElm.getAsString();
            }
            Map<File, CMakeGenerator.CudaTargetInfo> cudaInfo = null;
            for (JsonElement targetElm : this.getJsonArray(cfgObj, "targets")) {
                String tgtFileName = this.getJsonFilePath(targetElm.getAsJsonObject());
                JsonObject tgtObject = this.loadReplyFile(replyDir, tgtFileName);
                if (CMakeApiProfileGenerationResult.getBool(tgtObject, "isGeneratorProvided")) continue;
                this.myFailLogger.pushScope(tgtFileName);
                if (cudaInfo == null) {
                    cudaInfo = this.loadCudaInfo(cudaFolders);
                }
                CMakeProfileTargetInfo target = this.loadTargetInfo(tgtObject, buildType2, generator2, topLevelSourceDir, topLevelBuildDir, compilers, commonInfo, cudaInfo, resolvedExecutableCache);
                targetInfos.put(target.targetName, target);
                this.myFailLogger.popScope();
            }
            if (!forceFirstConfig) continue;
            break;
        }
        this.myTargetInfos = targetInfos.values();
        this.myFailLogger.popScope();
    }

    @NotNull
    private JsonArray getJsonArray(@NonNls @NotNull JsonObject parentObj, @NonNls @NotNull String arrayName) throws CMakeApiException {
        if (parentObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(9);
        }
        if (arrayName == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(10);
        }
        JsonArray jsonArray = CMakeApiJsonUtils.getJsonArray(parentObj, arrayName, this.myFailLogger);
        if (jsonArray == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(11);
        }
        return jsonArray;
    }

    @NotNull
    @NonNls
    private JsonObject getJsonObject(@NonNls @NotNull JsonObject parentObj, @NonNls @NotNull String objectName) throws CMakeApiException {
        if (parentObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(12);
        }
        if (objectName == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(13);
        }
        JsonObject jsonObject = CMakeApiJsonUtils.getJsonObject(parentObj, objectName, this.myFailLogger);
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(14);
        }
        return jsonObject;
    }

    @Nullable
    private JsonObject loadOptionalReplyFile(@NotNull File replyDir, @NotNull JsonObject infoObj) {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(15);
        }
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(16);
        }
        try {
            return this.loadReplyFile(replyDir, infoObj);
        }
        catch (CMakeApiException ex) {
            return null;
        }
    }

    @NotNull
    private JsonObject loadReplyFile(@NotNull File replyDir, @NotNull JsonObject infoObj) throws CMakeApiException {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(17);
        }
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(18);
        }
        String cmFileName = this.getJsonFilePath(infoObj);
        return this.loadReplyFile(replyDir, cmFileName);
    }

    @NotNull
    private JsonObject loadReplyFile(@NotNull File replyDir, String cmFileName) throws CMakeApiException {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(19);
        }
        ProgressManager.checkCanceled();
        File cmFile = new File(replyDir, cmFileName);
        JsonObject cmObject = this.loadJsonObject(cmFile);
        ProgressManager.checkCanceled();
        JsonObject jsonObject = cmObject;
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(20);
        }
        return jsonObject;
    }

    @NotNull
    private String getJsonFilePath(@NotNull JsonObject infoObj) throws CMakeApiException {
        JsonElement fileElm;
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(21);
        }
        if ((fileElm = infoObj.get("jsonFile")) == null) {
            this.fail("no file path in " + infoObj);
        }
        String string = fileElm.getAsString();
        if (string == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    private Map<OCLanguageKind, CompilerInfo> readCompilerInfoMap(@NotNull JsonObject cmakeFiles, @Nullable JsonObject toolchainsObj, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(23);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(24);
        }
        if (toolchainsObj != null && Registry.is((String)"cmake.api.toolchains.v1")) {
            return this.readToolchainsCompilerInfoMap(toolchainsObj, cmakeFiles, topLevelSourceDir);
        }
        HashMap<OCLanguageKind, CompilerInfo> result = new HashMap<OCLanguageKind, CompilerInfo>();
        for (Map.Entry<OCLanguageKind, Pair<File, String>> compilerFile : this.findCompilerFiles(cmakeFiles, topLevelSourceDir).entrySet()) {
            File file = (File)compilerFile.getValue().getFirst();
            String langID = (String)compilerFile.getValue().getSecond();
            OCLanguageKind kind = compilerFile.getKey();
            try {
                CompilerInfo info = this.readCompilerInfo(file, langID);
                result.put(kind, info);
            }
            catch (CMakeException e) {
                this.fail("can't parse: " + file.getPath());
            }
        }
        HashMap<OCLanguageKind, CompilerInfo> hashMap = result;
        if (hashMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(25);
        }
        return hashMap;
    }

    @NotNull
    private Map<OCLanguageKind, CompilerInfo> readToolchainsCompilerInfoMap(@NotNull JsonObject toolchainsObj, @NotNull JsonObject cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (toolchainsObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(26);
        }
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(27);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(28);
        }
        ToolchainsV1 toolchains2 = ToolchainsV1Kt.readToolchainsV1(toolchainsObj, this.myFailLogger);
        HashMap<OCLanguageKind, CompilerInfo> result = new HashMap<OCLanguageKind, CompilerInfo>();
        for (ToolchainV1 toolchain : toolchains2.getToolchains()) {
            OCLanguageKind languageKind = CMakeApiProfileGenerationResult.toLanguageKind(toolchain.getLanguage());
            if (languageKind == null) continue;
            String path = StringUtil.notNullize((String)toolchain.getCompiler().getPath());
            String id = StringUtil.notNullize((String)toolchain.getCompiler().getId());
            CMakeCompiler compiler = this.getCMakeCompiler(path, id);
            CompilerInfo compilerInfo = new CompilerInfo(compiler, path, toolchain.getSourceFileExtensions(), toolchain.getCompiler().getImplicitLinkFrameworkDirectories(), toolchain.getCompiler().getTarget());
            if (id.equals("NVIDIA")) {
                this.readCudaHostCompiler(cmakeFiles, topLevelSourceDir);
            }
            result.put(languageKind, compilerInfo);
        }
        HashMap<OCLanguageKind, CompilerInfo> hashMap = result;
        if (hashMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(29);
        }
        return hashMap;
    }

    @NotNull
    private Map<OCLanguageKind, Pair<File, String>> findCompilerFiles(@NotNull JsonObject cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(30);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(31);
        }
        HashMap<OCLanguageKind, Pair<File, String>> result = new HashMap<OCLanguageKind, Pair<File, String>>();
        for (JsonElement input : this.getJsonArray(cmakeFiles, "inputs")) {
            String langID;
            OCLanguageKind kind;
            String path = input.getAsJsonObject().get("path").getAsString();
            String name2 = new File(path).getName();
            Matcher matcher = COMPILER_FILE_PATTERN.matcher(name2);
            if (!matcher.find() || (kind = CMakeApiProfileGenerationResult.toLanguageKind(langID = matcher.group(1))) == null) continue;
            File file = CMakeGenerator.toLocalFile(this.parameters.environment, topLevelSourceDir, path);
            result.put(kind, (Pair<File, String>)new Pair((Object)file, (Object)langID));
        }
        HashMap<OCLanguageKind, Pair<File, String>> hashMap = result;
        if (hashMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(32);
        }
        return hashMap;
    }

    @NotNull
    private CompilerInfo readCompilerInfo(@NotNull File file, @NotNull String langID) throws CMakeException, CMakeApiException {
        CMakeFile cmakeFile;
        List<String> exePaths;
        if (file == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(33);
        }
        if (langID == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(34);
        }
        if ((exePaths = this.getCMakeVariableValues(cmakeFile = this.parseCMakeFile(file), "CMAKE_" + langID + "_COMPILER")).isEmpty()) {
            this.fail("no compiler exe for " + langID);
        }
        @NlsSafe String path = exePaths.get(0);
        List<String> ids = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_COMPILER_ID");
        if (ids.isEmpty()) {
            this.fail("no compiler ID for " + langID);
        }
        @NlsSafe String id = ids.get(0);
        List<String> extensions = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_SOURCE_FILE_EXTENSIONS");
        if (extensions.isEmpty()) {
            this.fail("no extensions for " + langID);
        }
        List<String> implicitFrameworkDirs = this.readImplicitFrameworkDirs(langID, cmakeFile);
        if (id.equals("NVIDIA")) {
            this.readCudaHostCompiler(cmakeFile);
        }
        CMakeCompiler compiler = this.getCMakeCompiler(path, id);
        return new CompilerInfo(compiler, path, extensions, implicitFrameworkDirs);
    }

    private void readCudaHostCompiler(@NotNull JsonObject cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(35);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(36);
        }
        for (Map.Entry<OCLanguageKind, Pair<File, String>> compilerFile : this.findCompilerFiles(cmakeFiles, topLevelSourceDir).entrySet()) {
            File file = (File)compilerFile.getValue().getFirst();
            OCLanguageKind kind = compilerFile.getKey();
            if (!kind.isCuda()) continue;
            try {
                CMakeFile cmakeFile = this.parseCMakeFile(file);
                this.readCudaHostCompiler(cmakeFile);
            }
            catch (CMakeException e) {
                this.fail("can't parse: " + file.getPath());
            }
        }
    }

    private void readCudaHostCompiler(@NotNull CMakeFile cmakeFile) {
        List<String> hostCompiler;
        if (cmakeFile == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(37);
        }
        if ((hostCompiler = this.getCMakeVariableValues(cmakeFile, "CMAKE_CUDA_HOST_COMPILER")) != null && hostCompiler.size() > 0) {
            this.cudaHostCompiler = hostCompiler.get(0);
        }
    }

    @NotNull
    private List<String> readImplicitFrameworkDirs(@NotNull String langID, @NotNull CMakeFile cmakeFile) throws CMakeApiException {
        List<String> values;
        if (langID == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(38);
        }
        if (cmakeFile == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(39);
        }
        if ((values = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES")).size() > 1) {
            this.fail("unexpected value for the implicit framework dirs: '" + values + "'");
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            CMakeInterpreter.expandListArgument(value.trim(), result);
        }
        result.removeIf(s -> StringUtil.isEmptyOrSpaces((String)s));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(40);
        }
        return arrayList;
    }

    private static boolean getBool(@NotNull JsonObject depObj, @NotNull String flag) {
        JsonElement flagElm;
        if (depObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(41);
        }
        if (flag == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(42);
        }
        return (flagElm = depObj.get(flag)) != null && flagElm.getAsBoolean();
    }

    @Nullable
    private static CMakeGenerator.CudaTargetInfo getCudaInfoForCurrentTarget(@NotNull JsonObject target, @NotNull CPPEnvironment environment2, @NotNull File topLevelSourceDir, @NotNull Map<File, CMakeGenerator.CudaTargetInfo> cudaInfo) {
        JsonArray sourcesArray;
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(43);
        }
        if (environment2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(44);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(45);
        }
        if (cudaInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(46);
        }
        if ((sourcesArray = target.getAsJsonArray("sources")) == null || sourcesArray.size() < 1) {
            return null;
        }
        JsonObject currentTargetObj = sourcesArray.get(0).getAsJsonObject();
        if (currentTargetObj == null) {
            return null;
        }
        JsonElement pathElm = currentTargetObj.get("path");
        if (pathElm == null) {
            return null;
        }
        String sourcePath = pathElm.getAsString();
        File sourceFileDir = CMakeGenerator.toLocalFile(environment2, topLevelSourceDir, sourcePath).getParentFile();
        return sourceFileDir == null ? null : cudaInfo.get(sourceFileDir);
    }

    @NotNull
    private CMakeProfileTargetInfo loadTargetInfo(@NotNull JsonObject target, @NotNull String buildType2, @NotNull CMakeConfiguration.Generator generator2, @NotNull File topLevelSourceDir, @NotNull File topLevelBuildDir, @NotNull Map<OCLanguageKind, CompilerInfo> compilers, @NotNull CMakeGenerator.CommonInfo commonInfo, @NotNull Map<File, CMakeGenerator.CudaTargetInfo> cudaInfo, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) throws CMakeApiException {
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(47);
        }
        if (buildType2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(48);
        }
        if (generator2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(49);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(50);
        }
        if (topLevelBuildDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(51);
        }
        if (compilers == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(52);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(53);
        }
        if (cudaInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(54);
        }
        if (resolvedExecutableCache == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(55);
        }
        CPPEnvironment environment2 = this.parameters.environment;
        CidrCompilerSwitches.Format flagsFormat = CPPCompilerSwitchesUtil.getFlagsFormat(environment2);
        String targetName = CMakeApiProfileGenerationResult.getName(target);
        String targetType = target.get("type").getAsString();
        JsonElement traceElm = target.get("backtrace");
        int traceNum = traceElm == null ? 0 : traceElm.getAsInt();
        JsonObject traceGraph = this.getJsonObject(target, "backtraceGraph");
        JsonArray traceNodes = this.getJsonArray(traceGraph, "nodes");
        if (traceNodes.size() == 0) {
            this.fail("no backtrace");
        }
        JsonObject bottomNode = traceNodes.get(traceNum).getAsJsonObject();
        while (bottomNode != null && bottomNode.get("parent") != null) {
            bottomNode = traceNodes.get(bottomNode.get("parent").getAsInt()).getAsJsonObject();
        }
        if (bottomNode == null) {
            this.fail("can't find the bottom node");
        }
        int fileIdx = bottomNode.get("file").getAsInt();
        String filePath = this.getJsonArray(traceGraph, "files").get(fileIdx).getAsString();
        File cmakeFile = CMakeGenerator.toLocalFile(environment2, topLevelSourceDir, filePath);
        if (!cmakeFile.exists()) {
            this.fail("no CMakeLists.txt file at " + cmakeFile.getPath());
        }
        commonInfo.addDependencyFile(cmakeFile);
        String relativeBuildDir = this.getJsonObject(target, "paths").get("build").getAsString();
        File buildDir = CMakeGenerator.toLocalFile(environment2, topLevelBuildDir, relativeBuildDir);
        if (!buildDir.exists()) {
            this.fail("no build dir at " + buildDir.getPath());
        }
        HashMap<OCLanguageKind, CMakeConfigurationSettings> commonLangSettings = new HashMap<OCLanguageKind, CMakeConfigurationSettings>();
        List<CompileGroup> compileGroups = this.readCompileGroups(target, compilers, flagsFormat, commonLangSettings, buildDir, generator2, resolvedExecutableCache);
        Map sourcesMap = FileCollectionFactory.createCanonicalFileMap();
        CMakeGenerator.CudaTargetInfo cudaTargetInfo = CMakeApiProfileGenerationResult.getCudaInfoForCurrentTarget(target, environment2, topLevelSourceDir, cudaInfo);
        this.addCudaCmakeTargets(cudaTargetInfo, commonLangSettings, sourcesMap);
        HashMap<OCLanguageKind, OCLanguageKind> predef2GenKinds = new HashMap<OCLanguageKind, OCLanguageKind>();
        for (JsonElement srcElm : this.getJsonArray(target, "sources")) {
            int cgIdx;
            CompileGroup group;
            JsonObject src = srcElm.getAsJsonObject();
            if (CMakeApiProfileGenerationResult.getBool(src, "isGenerated")) continue;
            String path = src.get("path").getAsString();
            File srcFile = CMakeGenerator.toLocalFile(environment2, topLevelSourceDir, path);
            commonInfo.addSourceFile(srcFile);
            JsonElement cgElm = src.get("compileGroupIndex");
            if (cgElm == null || (group = compileGroups.get(cgIdx = cgElm.getAsInt())) == null) continue;
            OCLanguageKind effectiveLangKind = CMakeApiProfileGenerationResult.getEffectiveLanguageKind(srcFile.getName(), group.languageKind, predef2GenKinds);
            CMakeFileSettings settings = new CMakeFileSettings(effectiveLangKind, null, group.leadFlags, group.flags, group.defines);
            sourcesMap.put(srcFile, settings);
        }
        CMakeProfileTargetInfo info = new CMakeProfileTargetInfo(environment2, cmakeFile, this.parameters.generationDir, buildDir, targetName, CMakeConfiguration.TargetType.fromString(targetType), generator2, buildType2, buildDir);
        info.productFile = this.readTargetProductFile(target, topLevelBuildDir, environment2, info.targetName);
        if (info.productFile == null && info.targetType != CMakeConfiguration.TargetType.UTILITY) {
            this.reportNoProductFile(info);
        }
        CMakeApiProfileGenerationResult.adjustLanguageSettingsMap(commonLangSettings, predef2GenKinds);
        info.perLanguageSettings = commonLangSettings;
        info.linkerFlags = CMakeApiProfileGenerationResult.readTargetLinkerFlags(target, flagsFormat);
        info.sources = sourcesMap;
        CMakeProfileTargetInfo cMakeProfileTargetInfo = info;
        if (cMakeProfileTargetInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(56);
        }
        return cMakeProfileTargetInfo;
    }

    @NotNull
    private List<CompileGroup> readCompileGroups(@NotNull JsonObject target, @NotNull Map<OCLanguageKind, CompilerInfo> compilers, @NotNull CidrCompilerSwitches.Format flagsFormat, @NotNull Map<OCLanguageKind, CMakeConfigurationSettings> settingsMap, @NotNull File buildWorkingDir, @NotNull CMakeConfiguration.Generator generator2, @NotNull Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache) throws CMakeApiException {
        CompilerInfo compilerInfo;
        OCLanguageKind kind;
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(57);
        }
        if (compilers == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(58);
        }
        if (flagsFormat == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(59);
        }
        if (settingsMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(60);
        }
        if (buildWorkingDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(61);
        }
        if (generator2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(62);
        }
        if (resolvedExecutableCache == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(63);
        }
        ArrayList<CompileGroup> compileGroups = new ArrayList<CompileGroup>();
        JsonElement cgsElm = target.get("compileGroups");
        if (cgsElm == null) {
            ArrayList<CompileGroup> arrayList = compileGroups;
            if (arrayList == null) {
                CMakeApiProfileGenerationResult.$$$reportNull$$$0(64);
            }
            return arrayList;
        }
        for (JsonElement cgElm : cgsElm.getAsJsonArray()) {
            Object includesElm;
            JsonObject compileGroup = cgElm.getAsJsonObject();
            String string = compileGroup.get("language").getAsString();
            kind = CMakeApiProfileGenerationResult.toLanguageKind(string);
            if (kind == null) {
                compileGroups.add(null);
                continue;
            }
            compilerInfo = this.getCompilerInfo(compilers, kind);
            OCCompilerKind compilerKind = compilerInfo.compiler.getCompilerKind();
            CompilerSpecificSwitchBuilder sysrootFlagBuilder = this.createSwitchBuilder(compilerKind);
            JsonObject sysrootObj = compileGroup.getAsJsonObject("sysroot");
            if (sysrootObj != null) {
                String sysroot = sysrootObj.get("path").getAsString();
                sysrootFlagBuilder.withSysroot(sysroot);
            }
            CompilerSpecificSwitchBuilder targetFlagBuilder = this.createSwitchBuilder(compilerKind);
            if (compilerInfo.target != null && !compilerInfo.target.isEmpty()) {
                targetFlagBuilder.withTarget(compilerInfo.target);
            }
            CompilerSpecificSwitchBuilder incFlagBuilder = this.createSwitchBuilder(compilerKind);
            if (!generator2.name.contains("Visual")) {
                incFlagBuilder.withPosixSearchPathFlags();
            }
            if ((includesElm = compileGroup.get("includes")) != null) {
                HashSet<String> addedFrameworkDirs = new HashSet<String>(compilerInfo.implicitFrameworkDirs);
                for (JsonElement incElm : includesElm.getAsJsonArray()) {
                    JsonObject include = incElm.getAsJsonObject();
                    boolean isSystem = CMakeApiProfileGenerationResult.getBool(include, "isSystem");
                    String path = include.get("path").getAsString();
                    File incFile = new File(path);
                    if (SystemInfo.isMac && incFile.isDirectory() && incFile.getName().endsWith(".framework")) {
                        String searchPath = incFile.getParent();
                        if (!addedFrameworkDirs.add(searchPath)) continue;
                        incFlagBuilder = isSystem ? incFlagBuilder.withSystemFrameworkSearchPath(searchPath) : incFlagBuilder.withFrameworkSearchPath(searchPath);
                        continue;
                    }
                    incFlagBuilder = isSystem ? incFlagBuilder.withSystemIncludePath(path) : incFlagBuilder.withIncludePath(path);
                }
            }
            ArrayList<String> flagFragments = new ArrayList<String>(incFlagBuilder.build().getList(flagsFormat));
            flagFragments.add(sysrootFlagBuilder.build().getCommandLineString(flagsFormat));
            flagFragments.add(targetFlagBuilder.build().getCommandLineString(flagsFormat));
            JsonElement ccfElm = compileGroup.get("compileCommandFragments");
            if (ccfElm != null) {
                JsonArray compileCodeFrags = ccfElm.getAsJsonArray();
                for (JsonElement frag2 : compileCodeFrags) {
                    String fragText = frag2.getAsJsonObject().get("fragment").getAsString();
                    flagFragments.add(fragText);
                }
            }
            ArrayList<String> defineFragments = new ArrayList<String>();
            JsonElement definesElm = compileGroup.get("defines");
            if (definesElm != null) {
                for (JsonElement defElm : definesElm.getAsJsonArray()) {
                    String define = defElm.getAsJsonObject().get("define").getAsString();
                    defineFragments.add(define);
                }
            }
            compileGroups.add(new CompileGroup(kind, compilerKind, Collections.emptyList(), flagFragments, defineFragments));
        }
        HashMap<OCLanguageKind, LinkedHashSet<String>> langToCommonFlags = new HashMap<OCLanguageKind, LinkedHashSet<String>>();
        HashMap<OCLanguageKind, LinkedHashSet<String>> langToCommonDefines = new HashMap<OCLanguageKind, LinkedHashSet<String>>();
        for (CompileGroup compileGroup : compileGroups) {
            if (compileGroup == null) continue;
            kind = compileGroup.languageKind;
            CMakeApiProfileGenerationResult.updateCommon(langToCommonFlags, kind, compileGroup.flagFragments);
            CMakeApiProfileGenerationResult.updateCommon(langToCommonDefines, kind, compileGroup.defineFragments);
        }
        for (CompileGroup compileGroup : compileGroups) {
            if (compileGroup == null) continue;
            kind = compileGroup.languageKind;
            compilerInfo = this.getCompilerInfo(compilers, kind);
            CMakeApiProfileGenerationResult.processUnique(langToCommonFlags, kind, compileGroup.flagFragments, frag -> group.flags.addAll(CMakeApiProfileGenerationResult.readCompilerFlags(frag, flagsFormat, compilerInfo.compiler)));
            CompilerSpecificSwitchBuilder defFlagBuilder = this.createSwitchBuilder(compileGroup.compilerKind);
            CMakeApiProfileGenerationResult.processUnique(langToCommonDefines, kind, compileGroup.defineFragments, frag -> defFlagBuilder.withMacro(frag));
            List groupDefines = defFlagBuilder.buildRaw();
            compileGroup.defines.addAll(groupDefines);
        }
        for (Map.Entry entry : langToCommonFlags.entrySet()) {
            boolean hasCCBinFlag;
            kind = (OCLanguageKind)entry.getKey();
            compilerInfo = this.getCompilerInfo(compilers, kind);
            LinkedHashSet commonFlagFrags = (LinkedHashSet)entry.getValue();
            ArrayList<@NlsSafe String> commonFlags = new ArrayList<String>();
            for (String frag3 : commonFlagFrags) {
                commonFlags.addAll(CMakeApiProfileGenerationResult.readCompilerFlags(frag3, flagsFormat, compilerInfo.compiler));
            }
            boolean bl = hasCCBinFlag = NVCCCompiler.Companion.getCCBinOption(commonFlags) != null;
            if (kind.isCuda() && !hasCCBinFlag && !StringUtil.isEmptyOrSpaces((String)this.cudaHostCompiler)) {
                commonFlags.add("-ccbin=" + this.cudaHostCompiler);
            }
            CompilerSpecificSwitchBuilder defineBuilder = this.createSwitchBuilder(this.getCompilerInfo(compilers, (OCLanguageKind)kind).compiler.getCompilerKind());
            LinkedHashSet commonDefineFrags = (LinkedHashSet)langToCommonDefines.get(kind);
            for (String define : commonDefineFrags) {
                defineBuilder.withMacro(define);
            }
            List commonDefines = defineBuilder.buildRaw();
            Pair<String, String> result = CMakeApiProfileGenerationResult.resolveToExecutableOrGetFromCache(compilerInfo.path, buildWorkingDir, this.parameters.environment, resolvedExecutableCache);
            String errorMessage = (String)result.first;
            if (errorMessage != null) {
                List list = (List)this.fail(errorMessage);
                if (list == null) {
                    CMakeApiProfileGenerationResult.$$$reportNull$$$0(65);
                }
                return list;
            }
            String effectiveCompilerPath = (String)result.second;
            settingsMap.put(kind, new CMakeConfigurationSettings(compilerInfo.compiler, new File(effectiveCompilerPath), commonFlags, commonDefines));
        }
        ArrayList<CompileGroup> arrayList = compileGroups;
        if (arrayList == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(66);
        }
        return arrayList;
    }

    @NotNull
    private static List<String> readCompilerFlags(@NotNull String flagStr, @NotNull CidrCompilerSwitches.Format flagsFormat, @NotNull CMakeCompiler compiler) {
        if (flagStr == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(67);
        }
        if (flagsFormat == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(68);
        }
        if (compiler == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(69);
        }
        List flags = CidrSwitchBuilder.parseArgs((String)flagStr, (CidrCompilerSwitches.Format)flagsFormat);
        ArrayList mutableFlags = new ArrayList(flags);
        List list = compiler.getCompilerKind().fixPchSwitches(mutableFlags);
        if (list == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(70);
        }
        return list;
    }

    @NotNull
    private CompilerInfo getCompilerInfo(@NotNull Map<OCLanguageKind, CompilerInfo> compilers, @NotNull OCLanguageKind kind) throws CMakeApiException {
        CompilerInfo compilerInfo;
        if (compilers == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(71);
        }
        if (kind == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(72);
        }
        if ((compilerInfo = compilers.get(kind)) == null) {
            this.fail("no compiler found for " + kind);
        }
        CompilerInfo compilerInfo2 = compilerInfo;
        if (compilerInfo2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(73);
        }
        return compilerInfo2;
    }

    @NotNull
    private CompilerSpecificSwitchBuilder createSwitchBuilder(@NotNull OCCompilerKind compilerKind) throws CMakeApiException {
        CompilerSpecificSwitchBuilder result;
        if (compilerKind == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(74);
        }
        if ((result = compilerKind.getSwitchBuilder(new CidrSwitchBuilder())) == null) {
            this.fail("can't create a flag builder for " + compilerKind);
        }
        CompilerSpecificSwitchBuilder compilerSpecificSwitchBuilder = result;
        if (compilerSpecificSwitchBuilder == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(75);
        }
        return compilerSpecificSwitchBuilder;
    }

    @NotNull
    private Map<File, CMakeGenerator.CudaTargetInfo> loadCudaInfo(@NotNull Set<File> cudaFolders) throws CMakeApiException {
        if (cudaFolders == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(76);
        }
        Map cudaInfo = FileCollectionFactory.createCanonicalFileMap();
        for (File cudaFile : cudaFolders) {
            try {
                cudaInfo.put(cudaFile, this.loadCudaTargetInfo(cudaFile));
            }
            catch (CMakeException e) {
                this.fail(e);
            }
        }
        Map map2 = cudaInfo;
        if (map2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(77);
        }
        return map2;
    }

    private static void processUnique(@NotNull Map<OCLanguageKind, LinkedHashSet<String>> commonSettings, @NotNull OCLanguageKind kind, @NotNull List<String> fragments, @NotNull Consumer<String> c) {
        if (commonSettings == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(78);
        }
        if (kind == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(79);
        }
        if (fragments == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(80);
        }
        if (c == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(81);
        }
        LinkedHashSet<String> commonFrags = commonSettings.get(kind);
        for (String frag : fragments) {
            if (commonFrags.contains(frag)) continue;
            c.accept(frag);
        }
    }

    private static void updateCommon(Map<OCLanguageKind, LinkedHashSet<String>> langToCommonFlags, OCLanguageKind kind, List<String> groupFragments) {
        LinkedHashSet<String> commonFlags = langToCommonFlags.get(kind);
        if (commonFlags == null) {
            commonFlags = new LinkedHashSet<String>(groupFragments);
            langToCommonFlags.put(kind, commonFlags);
        } else {
            commonFlags.retainAll(groupFragments);
        }
    }

    @NotNull
    private static List<String> readTargetLinkerFlags(@NotNull JsonObject target, CidrCompilerSwitches.Format flagsFormat) {
        JsonElement linkElm;
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(82);
        }
        if ((linkElm = target.get("link")) == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CMakeApiProfileGenerationResult.$$$reportNull$$$0(83);
            }
            return list;
        }
        JsonElement fragmentsElm = linkElm.getAsJsonObject().get("commandFragments");
        if (fragmentsElm == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                CMakeApiProfileGenerationResult.$$$reportNull$$$0(84);
            }
            return list;
        }
        ArrayList<String> allFlags = new ArrayList<String>();
        JsonArray fragments = (JsonArray)fragmentsElm;
        for (JsonElement fragment : fragments) {
            String flagsText = fragment.getAsJsonObject().get("fragment").getAsString();
            List flags = CidrSwitchBuilder.parseArgs((String)flagsText, (CidrCompilerSwitches.Format)flagsFormat);
            allFlags.addAll(flags);
        }
        ArrayList<String> arrayList = allFlags;
        if (arrayList == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(85);
        }
        return arrayList;
    }

    @Nullable
    private File readTargetProductFile(@NotNull JsonObject target, @NotNull File topLevelBuildDir, @NotNull CPPEnvironment environment2, @NotNull String targetName) {
        boolean emulateNotFound;
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(86);
        }
        if (topLevelBuildDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(87);
        }
        if (environment2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(88);
        }
        if (targetName == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(89);
        }
        if (emulateNotFound = this.myGenerator.shouldEmulateProductNotFoundForTargetAndProfile((Pair<String, String>)Pair.create((Object)targetName, (Object)this.parameters.profileName))) {
            return null;
        }
        JsonArray artifacts = target.getAsJsonArray("artifacts");
        if (artifacts != null && artifacts.size() > 0) {
            String path = artifacts.get(0).getAsJsonObject().get("path").getAsString();
            return CMakeGenerator.toLocalFile(environment2, topLevelBuildDir, path);
        }
        return CMakeGenerator.toLocalFile(environment2, topLevelBuildDir, targetName);
    }

    @Contract(value="_ -> fail")
    private <T> T fail(@NonNls @NotNull String reason) throws CMakeApiException {
        if (reason == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(90);
        }
        return this.myFailLogger.fail(reason);
    }

    @Contract(value="_ -> fail")
    private void fail(@NotNull Throwable cause) throws CMakeApiException {
        if (cause == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(91);
        }
        this.myFailLogger.fail(cause);
    }

    private void reportError(@NotNull Throwable error) {
        if (error == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(92);
        }
        CPPLog.LOG.info(error);
        this.parameters.listener.message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, null, null, "CMake File API: " + error.getLocalizedMessage()));
    }

    @NotNull
    private JsonObject loadJsonObject(@NotNull File file) throws CMakeApiException {
        if (file == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(93);
        }
        JsonObject indexObj = null;
        try {
            String indexContents = FileUtil.loadFile((File)file);
            indexObj = (JsonObject)new Gson().fromJson(indexContents, JsonObject.class);
            if (indexObj == null) {
                this.fail("failed to load from '" + file.getPath() + "'. ");
            }
        }
        catch (IOException e) {
            this.fail(e.getLocalizedMessage());
        }
        JsonObject jsonObject = indexObj;
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(94);
        }
        return jsonObject;
    }

    @NotNull
    private static String getName(@NotNull JsonObject target) {
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(95);
        }
        String string = target.get("name").getAsString();
        if (string == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(96);
        }
        return string;
    }

    @Override
    @Nullable
    public String getProjectName() {
        return this.myProjectName;
    }

    @Override
    @NotNull
    public Collection<? extends CMakeProfileTargetInfo> getTargetInfos() {
        Collection<CMakeProfileTargetInfo> collection = this.myTargetInfos;
        if (collection == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(97);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 94: 
            case 96: 
            case 97: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 94: 
            case 96: 
            case 97: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentObj";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayName";
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 94: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectName";
                break;
            }
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replyDir";
                break;
            }
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoObj";
                break;
            }
            case 23: 
            case 27: 
            case 30: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFiles";
                break;
            }
            case 24: 
            case 28: 
            case 31: 
            case 36: 
            case 45: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelSourceDir";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainsObj";
                break;
            }
            case 33: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langID";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depObj";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 43: 
            case 47: 
            case 57: 
            case 82: 
            case 86: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 44: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 46: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cudaInfo";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 51: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelBuildDir";
                break;
            }
            case 52: 
            case 58: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilers";
                break;
            }
            case 55: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedExecutableCache";
                break;
            }
            case 59: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagsFormat";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsMap";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildWorkingDir";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flagStr";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 72: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cudaFolders";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSettings";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragments";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetName";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonArray";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonObject";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "loadReplyFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonFilePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompilerInfoMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "readToolchainsCompilerInfoMap";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompilerFiles";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "readImplicitFrameworkDirs";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTargetInfo";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompileGroups";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompilerFlags";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompilerInfo";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "createSwitchBuilder";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCudaInfo";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray2;
                objectArray2[1] = "readTargetLinkerFlags";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJsonObject";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeGenerate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillFromPreviousModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLoadInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getJsonArray";
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 94: 
            case 96: 
            case 97: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJsonObject";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadOptionalReplyFile";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "loadReplyFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getJsonFilePath";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerInfoMap";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readToolchainsCompilerInfoMap";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "findCompilerFiles";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerInfo";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readCudaHostCompiler";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readImplicitFrameworkDirs";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBool";
                break;
            }
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getCudaInfoForCurrentTarget";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "loadTargetInfo";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "readCompileGroups";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerFlags";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "getCompilerInfo";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "createSwitchBuilder";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "loadCudaInfo";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "processUnique";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "readTargetLinkerFlags";
                break;
            }
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "readTargetProductFile";
                break;
            }
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "loadJsonObject";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 14: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 56: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 73: 
            case 75: 
            case 77: 
            case 83: 
            case 84: 
            case 85: 
            case 94: 
            case 96: 
            case 97: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class CompileGroup {
        @NotNull
        final OCLanguageKind languageKind;
        @NotNull
        final OCCompilerKind compilerKind;
        @NotNull
        final List<String> leadFlags;
        @NotNull
        final List<String> flagFragments;
        @NotNull
        final List<String> flags;
        @NotNull
        final List<String> defineFragments;
        @NotNull
        final List<String> defines;

        private CompileGroup(@NotNull OCLanguageKind kind, @NotNull OCCompilerKind compilerKind, @NotNull List<String> leadFlags, @NotNull List<String> flagFragments, @NotNull List<String> defineFragments) {
            if (kind == null) {
                CompileGroup.$$$reportNull$$$0(0);
            }
            if (compilerKind == null) {
                CompileGroup.$$$reportNull$$$0(1);
            }
            if (leadFlags == null) {
                CompileGroup.$$$reportNull$$$0(2);
            }
            if (flagFragments == null) {
                CompileGroup.$$$reportNull$$$0(3);
            }
            if (defineFragments == null) {
                CompileGroup.$$$reportNull$$$0(4);
            }
            this.flags = new ArrayList<String>();
            this.defines = new ArrayList<String>();
            this.languageKind = kind;
            this.compilerKind = compilerKind;
            this.leadFlags = leadFlags;
            this.flagFragments = flagFragments;
            this.defineFragments = defineFragments;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "kind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compilerKind";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "leadFlags";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flagFragments";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defineFragments";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult$CompileGroup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class CompilerInfo {
        @NotNull
        final CMakeCompiler compiler;
        @NotNull
        final String path;
        @NotNull
        final List<String> extensions;
        @NotNull
        final List<String> implicitFrameworkDirs;
        @Nullable
        final String target;

        private CompilerInfo(@NotNull CMakeCompiler compiler, @NotNull String path, @NotNull List<String> extensions, @NotNull List<String> implicitFrameworkDirs, @Nullable String target) {
            if (compiler == null) {
                CompilerInfo.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CompilerInfo.$$$reportNull$$$0(1);
            }
            if (extensions == null) {
                CompilerInfo.$$$reportNull$$$0(2);
            }
            if (implicitFrameworkDirs == null) {
                CompilerInfo.$$$reportNull$$$0(3);
            }
            this.compiler = compiler;
            this.path = path;
            this.extensions = extensions;
            this.implicitFrameworkDirs = implicitFrameworkDirs;
            this.target = target;
        }

        private CompilerInfo(@NotNull CMakeCompiler compiler, @NotNull String path, @NotNull List<String> extensions, @NotNull List<String> implicitFrameworkDirs) {
            if (compiler == null) {
                CompilerInfo.$$$reportNull$$$0(4);
            }
            if (path == null) {
                CompilerInfo.$$$reportNull$$$0(5);
            }
            if (extensions == null) {
                CompilerInfo.$$$reportNull$$$0(6);
            }
            if (implicitFrameworkDirs == null) {
                CompilerInfo.$$$reportNull$$$0(7);
            }
            this(compiler, path, extensions, implicitFrameworkDirs, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compiler";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensions";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "implicitFrameworkDirs";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult$CompilerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

