/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.coverage;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.Version;
import com.intellij.util.VersionUtil;
import com.jetbrains.cidr.cpp.execution.coverage.CMakeCoverageUtil;
import com.jetbrains.cidr.execution.coverage.CidrCoverageBundle;
import com.jetbrains.cidr.execution.coverage.CidrCoverageLogKt;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import java.io.File;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bJ(\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageToolVersionMatcher;", "", "()V", "getCompilerVersion", "Lcom/intellij/openapi/util/Version;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "environment", "Lcom/jetbrains/cidr/lang/toolchains/CidrToolEnvironment;", "getToolVersion", "tool", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "match", "", "toolName", "toolCommandLine", "Companion", "intellij.clion.coverage"})
public final class CMakeCoverageToolVersionMatcher {
    @JvmField
    @NotNull
    public static final Regex VERSION_PATTERN;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final String match(@NotNull String toolName, @NotNull GeneralCommandLine toolCommandLine, @NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Version compilerVersion;
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Intrinsics.checkNotNullParameter((Object)toolCommandLine, (String)"toolCommandLine");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Version toolVersion = this.getToolVersion(toolCommandLine, environment2);
        if (toolVersion == null) {
            CidrCoverageLogKt.getCidrCoverageLog().info("Cannot match tool/compiler versions: tool version is null");
        }
        if ((compilerVersion = this.getCompilerVersion(configuration, environment2)) == null) {
            CidrCoverageLogKt.getCidrCoverageLog().info("Cannot match tool/compiler versions: compiler version is null");
        }
        if (toolVersion != null && compilerVersion != null && Intrinsics.areEqual((Object)toolVersion, (Object)compilerVersion) ^ true) {
            return CidrCoverageBundle.message("coverage.tool.version.mismatch", toolName, toolVersion.toString(), compilerVersion.toString());
        }
        return null;
    }

    @Nullable
    public final Version getToolVersion(@NotNull GeneralCommandLine tool, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)tool, (String)"tool");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        ProcessOutput processOutput = environment2.getHostMachine().runProcess(tool.withParameters(new String[]{"--version"}), 500);
        boolean bl = false;
        boolean bl2 = false;
        ProcessOutput out = processOutput;
        boolean bl3 = false;
        ProcessOutput processOutput2 = out;
        Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"out");
        return VersionUtil.parseVersion((String)processOutput2.getStdout(), (Pattern[])new Pattern[]{VERSION_PATTERN.toPattern()});
    }

    @Nullable
    public final Version getCompilerVersion(@NotNull RunConfiguration configuration, @NotNull CidrToolEnvironment environment2) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        OCCompilerSettings oCCompilerSettings = CMakeCoverageUtil.Companion.getMostRelevantCompilerSettings(configuration);
        if (oCCompilerSettings == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = oCCompilerSettings;
        OCCompilerKind compilerKind = compilerSettings.getCompilerKind();
        File compilerExecutable = compilerSettings.getCompilerExecutable();
        File compilerWorkingDirectory = compilerSettings.getCompilerWorkingDir();
        if ((Intrinsics.areEqual((Object)compilerKind, (Object)ClangCompilerKind.INSTANCE) || Intrinsics.areEqual((Object)compilerKind, (Object)GCCCompilerKind.INSTANCE)) && compilerExecutable != null && compilerWorkingDirectory != null) {
            GCCCompiler compiler = new GCCCompiler(compilerExecutable, compilerWorkingDirectory, environment2, (TempFilesPool)TempFilesPool.INSTANCE);
            String string = compiler.readVersion(VERSION_PATTERN.toPattern());
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                return VersionUtil.parseVersion((String)it, (Pattern[])new Pattern[]{VERSION_PATTERN.toPattern()});
            }
        }
        CidrCoverageLogKt.getCidrCoverageLog().info("Cannot get compiler version: compilerExecutable/compilerWorkingDirectory is not found or it's not clang/gcc");
        return null;
    }

    static {
        Companion = new Companion(null);
        VERSION_PATTERN = new Regex("^.*?([\\d]+\\.[\\d]+\\.?[\\d]*).*", RegexOption.MULTILINE);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/cpp/execution/coverage/CMakeCoverageToolVersionMatcher$Companion;", "", "()V", "VERSION_PATTERN", "Lkotlin/text/Regex;", "intellij.clion.coverage"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

