/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.execution.manager;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.execution.CLionRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CMakeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.execution.CMakeRunConfigurationType;
import com.jetbrains.cidr.cpp.execution.manager.CLionRunConfigurationManager;
import com.jetbrains.cidr.cpp.execution.manager.CLionRunConfigurationManagerHelper;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import java.util.Comparator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public class CMakeRunConfigurationManagerHelper
implements CLionRunConfigurationManagerHelper {
    private static volatile boolean ourEnableInTests = false;

    @TestOnly
    public static void setEnableInTests(boolean enableInTests) {
        ourEnableInTests = enableInTests;
    }

    @TestOnly
    public static void recreateRunConfigurations(@NotNull Project project) {
        if (project == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(0);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        CLionRunConfigurationManager manager = CLionRunConfigurationManager.getInstance(project);
        CMakeRunConfigurationManagerHelper helper = new CMakeRunConfigurationManagerHelper();
        manager.recreateRunConfigurations(helper);
    }

    @Override
    @NotNull
    public CidrBuildConfigurationHelper<? extends CidrBuildConfiguration, ? extends CidrBuildTarget<?>> getBuildHelper(@NotNull Project project) {
        if (project == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(1);
        }
        CMakeBuildConfigurationHelper cMakeBuildConfigurationHelper = CMakeRunConfigurationType.getHelper(project);
        if (cMakeBuildConfigurationHelper == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(2);
        }
        return cMakeBuildConfigurationHelper;
    }

    @Override
    @NotNull
    public Predicate<RunnerAndConfigurationSettings> getRunConfigurationsFilter() {
        Predicate<RunnerAndConfigurationSettings> predicate = settings -> {
            RunConfiguration runConfig = settings.getConfiguration();
            return runConfig instanceof CMakeAppRunConfiguration;
        };
        if (predicate == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(3);
        }
        return predicate;
    }

    @Override
    @NotNull
    public ConfigurationFactory getConfigurationFactory(@NotNull CidrBuildConfigurationHelper<? extends CidrBuildConfiguration, ? extends CidrBuildTarget<?>> buildHelper, @NotNull CidrBuildTarget<?> buildTarget) {
        if (buildHelper == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(4);
        }
        if (buildTarget == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(5);
        }
        CPPLog.LOG.assertTrue(buildHelper instanceof CMakeBuildConfigurationHelper);
        CMakeBuildConfigurationHelper cmakeBuildHelper = (CMakeBuildConfigurationHelper)buildHelper;
        CPPLog.LOG.assertTrue(buildTarget instanceof CMakeTarget);
        CMakeTarget cmakeBuildTarget = (CMakeTarget)buildTarget;
        ConfigurationFactory configurationFactory = cmakeBuildHelper.getDefaultTargetType(cmakeBuildTarget).getFactory();
        if (configurationFactory == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(6);
        }
        return configurationFactory;
    }

    @Override
    @NotNull
    public String getProjectName(@NotNull Project project) {
        if (project == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(7);
        }
        String string = ((CMakeBuildConfigurationHelper)this.getBuildHelper(project)).getProjectName();
        if (string == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public Comparator<? super Pair<RunnerAndConfigurationSettings, CLionRunConfiguration<?, ?>>> getConfigurationsComparator() {
        Comparator comparator = (c1, c2) -> {
            int r = -Comparing.compare((((CLionRunConfiguration)c1.second).getExecutableData() != null ? 1 : 0) != 0, (((CLionRunConfiguration)c2.second).getExecutableData() != null ? 1 : 0) != 0);
            if (r != 0) {
                return r;
            }
            if (!(c1.second instanceof CMakeAppRunConfiguration) || !(c2.second instanceof CMakeAppRunConfiguration)) {
                CPPLog.LOG.error("Only CMakeAppRunConfiguration can get here. Should be checked in `getRunConfigurationsFilter()`");
                return r;
            }
            return Comparing.compare((boolean)((CMakeAppRunConfiguration)c1.second).isBuildAllTargets(), (boolean)((CMakeAppRunConfiguration)c2.second).isBuildAllTargets());
        };
        if (comparator == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(9);
        }
        return comparator;
    }

    @Override
    public void updateBuildConfiguration(@NotNull RunManagerImpl runManager, @NotNull CidrBuildConfigurationHelper buildHelper, @NotNull RunnerAndConfigurationSettings settings, @NotNull CLionRunConfiguration<?, ?> config) {
        CMakeTarget cmakeTarget;
        if (runManager == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(10);
        }
        if (buildHelper == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(12);
        }
        if (config == null) {
            CMakeRunConfigurationManagerHelper.$$$reportNull$$$0(13);
        }
        CPPLog.LOG.assertTrue(buildHelper instanceof CMakeBuildConfigurationHelper);
        CMakeBuildConfigurationHelper cmakeBuildHelper = (CMakeBuildConfigurationHelper)buildHelper;
        CPPLog.LOG.assertTrue(config instanceof CMakeAppRunConfiguration);
        CMakeAppRunConfiguration cmakeConfig = (CMakeAppRunConfiguration)config;
        BuildTargetAndConfigurationData data = config.getTargetAndConfigurationData();
        if (data == null) {
            return;
        }
        boolean isBuildAll = cmakeConfig.isBuildAllTargets();
        CMakeTarget cMakeTarget = cmakeTarget = isBuildAll ? (CMakeTarget)ContainerUtil.getFirstItem(cmakeBuildHelper.getTargets()) : (CMakeTarget)cmakeBuildHelper.findTarget(data.target);
        if (cmakeTarget != null && cmakeBuildHelper.findConfiguration(cmakeTarget, data.configurationName) == null) {
            config.setTargetAndConfigurationData(new BuildTargetAndConfigurationData((CidrBuildTarget)(isBuildAll ? null : cmakeTarget), cmakeBuildHelper.getDefaultConfiguration(cmakeTarget)));
            runManager.fireRunConfigurationChanged(settings);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/execution/manager/CMakeRunConfigurationManagerHelper";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildTarget";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runManager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/execution/manager/CMakeRunConfigurationManagerHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunConfigurationsFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationsComparator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recreateRunConfigurations";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBuildHelper";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationFactory";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectName";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateBuildConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Startup
    implements StartupActivity.DumbAware {
        public void runActivity(final @NotNull Project project) {
            if (project == null) {
                Startup.$$$reportNull$$$0(0);
            }
            if (!ourEnableInTests && ApplicationManager.getApplication().isUnitTestMode()) {
                return;
            }
            MessageBusConnection connection = project.getMessageBus().connect((Disposable)project);
            connection.subscribe(CMakeWorkspaceListener.TOPIC, (Object)new CMakeWorkspaceListener(){

                @Override
                public void afterApplyingNoLocks() {
                    CMakeRunConfigurationType.getHelper(project).mapTargetToConfigurationType();
                }

                @Override
                public void reloadingFinished(boolean canceled2) {
                    if (canceled2) {
                        return;
                    }
                    CLionRunConfigurationManager manager = CLionRunConfigurationManager.getInstance(project);
                    if (!manager.shouldGenerateConfigurations()) {
                        return;
                    }
                    CMakeRunConfigurationManagerHelper helper = new CMakeRunConfigurationManagerHelper();
                    manager.updateRunConfigurations(helper);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/cpp/execution/manager/CMakeRunConfigurationManagerHelper$Startup", "runActivity"));
        }
    }
}

