/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.external.system;

import com.intellij.build.BuildContentManager;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.cpp.external.system.CLionExternalLog;
import com.jetbrains.cidr.cpp.external.system.CLionExternalUtilKt;
import com.jetbrains.cidr.external.system.fus.CidrExternalUsageUtil;
import com.jetbrains.cidr.external.system.workspace.ExternalWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u001a(\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\b\u001a\u0004\u0018\u00010\t\u001a\u000e\u0010\r\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u000e"}, d2={"changeLinkedExternalProjectPath", "", "project", "Lcom/intellij/openapi/project/Project;", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "newProjectPath", "Lcom/intellij/openapi/vfs/VirtualFile;", "workspace", "Lcom/jetbrains/cidr/external/system/workspace/ExternalWorkspace;", "linkExternalProject", "projectSettings", "Lcom/intellij/openapi/externalSystem/settings/ExternalProjectSettings;", "showBuildToolWindow", "intellij.clion.externalSystem"})
public final class CLionExternalUtilKt {
    public static final void linkExternalProject(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalProjectSettings projectSettings, @Nullable ExternalWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)projectSettings, (String)"projectSettings");
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) {
            ExternalProjectsManagerImpl.getInstance((Project)project).setStoreExternally(true);
        }
        CLionExternalLog.INSTANCE.getLOG().info("Opening " + systemId.getReadableName() + " \"" + project.getName() + "\" project");
        Consumer resultListener2 = new Consumer(systemId, project){
            final /* synthetic */ ProjectSystemId $systemId;
            final /* synthetic */ Project $project;

            public final void consume(Boolean it) {
                Logger logger = CLionExternalLog.INSTANCE.getLOG();
                StringBuilder stringBuilder = new StringBuilder().append("Opening ").append(this.$systemId.getReadableName()).append(" \"").append(this.$project.getName()).append("\" project ");
                Boolean bl = it;
                Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"it");
                logger.info(stringBuilder.append(bl != false ? "finished successfully!" : "failed!").toString());
                CidrExternalUsageUtil.INSTANCE.logProjectLinked(this.$systemId, this.$project);
                CLionExternalUtilKt.showBuildToolWindow(this.$project);
            }
            {
                this.$systemId = projectSystemId;
                this.$project = project;
            }
        };
        ExternalWorkspace externalWorkspace = workspace;
        if (externalWorkspace != null) {
            externalWorkspace.initialize(new File(projectSettings.getExternalProjectPath()));
        }
        ExternalSystemUtil.linkExternalProject((ProjectSystemId)systemId, (ExternalProjectSettings)projectSettings, (Project)project, (Consumer)resultListener2, (boolean)false, (ProgressExecutionMode)ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @RequiresEdt
    public static final void changeLinkedExternalProjectPath(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull VirtualFile newProjectPath, @Nullable ExternalWorkspace workspace) {
        ExternalProjectSettings projectSettings;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)newProjectPath, (String)"newProjectPath");
        AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)systemId);
        Intrinsics.checkNotNullExpressionValue((Object)abstractExternalSystemSettings, (String)"ExternalSystemApiUtil.ge\u2026ttings(project, systemId)");
        AbstractExternalSystemSettings systemSettings = abstractExternalSystemSettings;
        Collection collection = systemSettings.getLinkedProjectsSettings();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"systemSettings.linkedProjectsSettings");
        Collection allProjectSettings = collection;
        if (allProjectSettings.isEmpty()) {
            throw (Throwable)new IllegalStateException("No " + systemId.getReadableName() + " projects linked. Please link new project first");
        }
        if (allProjectSettings.size() > 1) {
            throw (Throwable)new IllegalStateException("Multiple Makefile projects linked. Can't update project path. Linked projects: " + allProjectSettings);
        }
        ExternalProjectSettings externalProjectSettings = projectSettings = (ExternalProjectSettings)CollectionsKt.first((Iterable)allProjectSettings);
        Intrinsics.checkNotNullExpressionValue((Object)externalProjectSettings, (String)"projectSettings");
        String oldProjectPath = externalProjectSettings.getExternalProjectPath();
        CLionExternalLog.INSTANCE.getLOG().info(StringsKt.trimMargin$default((String)("Updating " + systemId.getReadableName() + " \"" + project.getName() + "\" project path.\n                               | Old path: " + oldProjectPath + ".\n                               | New path: " + newProjectPath), null, (int)1, null));
        projectSettings.setExternalProjectPath(newProjectPath.getPath());
        systemSettings.setLinkedProjectsSettings((Collection)CollectionsKt.listOf((Object)projectSettings));
        ExternalWorkspace externalWorkspace = workspace;
        if (externalWorkspace != null) {
            Path path = newProjectPath.toNioPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"newProjectPath.toNioPath()");
            externalWorkspace.selectProjectDir(path);
        }
        ExternalProjectsManagerImpl.getInstance((Project)project).forgetExternalProjectData(systemId, oldProjectPath);
    }

    public static final void showBuildToolWindow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CLionExternalLog.INSTANCE.getLOG().debug("Show Build tool window", new Object[]{ExceptionUtil.currentStackTrace()});
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isHeadlessEnvironment()) {
            StartupManager.getInstance((Project)project).runAfterOpened(new Runnable(project){
                final /* synthetic */ Project $project;

                public final void run() {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ showBuildToolWindow.1 this$0;

                        public final void run() {
                            ToolWindow toolWindow = BuildContentManager.getInstance((Project)this.this$0.$project).getOrCreateToolWindow();
                            Intrinsics.checkNotNullExpressionValue((Object)toolWindow, (String)"BuildContentManager.getI\u2026).getOrCreateToolWindow()");
                            ToolWindow toolWindow2 = toolWindow;
                            if (toolWindow2.isAvailable() && !toolWindow2.isVisible()) {
                                toolWindow2.show(null);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, ModalityState.NON_MODAL, this.$project.getDisposed());
                }
                {
                    this.$project = project;
                }
            });
        }
    }
}

