/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileFrame;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileProblemDescription;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileStack;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileErrorCaptionTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileMessageTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileStackFrameTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryProfileGroupingStrategy {
    public static final Comparator<MemoryProfileTreeNode> COMPARATOR = Comparator.comparing(MemoryProfileTreeNode::toString);
    @NotNull
    protected final MemoryProfileTreeDataModel myDataModel;

    public MemoryProfileGroupingStrategy(@NotNull MemoryProfileTreeDataModel dataModel) {
        if (dataModel == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(0);
        }
        this.myDataModel = dataModel;
    }

    public final void insertToTree(@NotNull MemoryProfileError error) {
        if (error == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(1);
        }
        MemoryProfileTreeNode parentNode = this.customizeInsertion(error);
        this.appendError(error, parentNode);
    }

    public abstract MemoryProfileTreeNode customizeInsertion(@NotNull MemoryProfileError var1);

    protected void appendError(@NotNull MemoryProfileError error, @NotNull MemoryProfileTreeNode parentNode) {
        block5: {
            block4: {
                String caption;
                if (error == null) {
                    MemoryProfileGroupingStrategy.$$$reportNull$$$0(2);
                }
                if (parentNode == null) {
                    MemoryProfileGroupingStrategy.$$$reportNull$$$0(3);
                }
                if (!StringUtil.isNotEmpty((String)(caption = error.getCaption()))) break block4;
                parentNode = this.appendErrorTitle(parentNode, caption, error);
                for (MemoryProfileProblemDescription description : error.getProblemDescriptions()) {
                    this.appendProblemDescription(parentNode, description);
                }
                break block5;
            }
            if (error.getProblemDescriptions().isEmpty()) break block5;
            parentNode = this.appendErrorTitle(parentNode, error.getProblemDescriptions().get(0).getText(), error);
            this.appendStack(parentNode, error.getProblemDescriptions().get(0).getStack());
            for (int i = 1; i < error.getProblemDescriptions().size(); ++i) {
                this.appendProblemDescription(parentNode, error.getProblemDescriptions().get(i));
            }
        }
    }

    protected MemoryProfileTreeNode tryInsertNode(@NotNull MemoryProfileTreeNode nodeToInsert, @NotNull MemoryProfileTreeNode parentNode) {
        int index;
        if (nodeToInsert == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(5);
        }
        if ((index = TreeUtil.indexedBinarySearch((TreeNode)parentNode, (TreeNode)nodeToInsert, COMPARATOR)) >= 0) {
            return (MemoryProfileTreeNode)parentNode.getChildAt(index);
        }
        TreeUtil.insertNode((MutableTreeNode)nodeToInsert, (MutableTreeNode)parentNode, (DefaultTreeModel)this.myDataModel, COMPARATOR);
        return nodeToInsert;
    }

    private void appendProblemDescription(@NotNull MemoryProfileTreeNode parentNode, @NotNull MemoryProfileProblemDescription description) {
        String text;
        if (parentNode == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(6);
        }
        if (description == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(text = description.getText()))) {
            MemoryProfileMessageTreeNode errorTreeNode = new MemoryProfileMessageTreeNode(text);
            parentNode.insert(errorTreeNode, parentNode.getChildCount());
        }
        this.appendStack(parentNode, description.getStack());
    }

    private void appendStack(@NotNull MemoryProfileTreeNode parentNode, @NotNull MemoryProfileStack stack) {
        if (parentNode == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(8);
        }
        if (stack == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(9);
        }
        List stackFrameTreeNodes = stack.getFrames().stream().map(frame -> new MemoryProfileStackFrameTreeNode((MemoryProfileFrame)frame, this.myDataModel.getProject())).collect(Collectors.toList());
        TreeUtil.addChildrenTo((MutableTreeNode)parentNode, stackFrameTreeNodes);
    }

    private MemoryProfileTreeNode appendErrorTitle(@NotNull MemoryProfileTreeNode parentNode, @Nls @NotNull String caption, @NotNull MemoryProfileError error) {
        if (parentNode == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(10);
        }
        if (caption == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(11);
        }
        if (error == null) {
            MemoryProfileGroupingStrategy.$$$reportNull$$$0(12);
        }
        MemoryProfileErrorCaptionTreeNode node2 = new MemoryProfileErrorCaptionTreeNode(caption, error);
        TreeUtil.insertNode((MutableTreeNode)node2, (MutableTreeNode)parentNode, (DefaultTreeModel)this.myDataModel, (boolean)true, COMPARATOR);
        return node2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeToInsert";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caption";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/MemoryProfileGroupingStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "insertToTree";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendError";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "tryInsertNode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "appendProblemDescription";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "appendStack";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "appendErrorTitle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

