/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.profiling.ui;

import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.tree.IndexTreePathState;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileTreeDataModel;
import com.jetbrains.cidr.cpp.profiling.MemoryProfileUtil;
import com.jetbrains.cidr.cpp.profiling.error.MemoryProfileError;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileErrorCaptionTreeNode;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTree;
import com.jetbrains.cidr.cpp.profiling.tree.MemoryProfileTreeNode;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class MemoryProfileExclusionHandler
implements ExclusionHandler<MemoryProfileTreeNode> {
    private static final Logger LOG = Logger.getInstance(MemoryProfileExclusionHandler.class);
    private Set<MemoryProfileTreeNode> myNodesToExclude;
    @NotNull
    private final MemoryProfileTree myTree;
    @NotNull
    private final MemoryProfileTreeDataModel myDataModel;

    public MemoryProfileExclusionHandler(@NotNull MemoryProfileTree tree) {
        if (tree == null) {
            MemoryProfileExclusionHandler.$$$reportNull$$$0(0);
        }
        this.myNodesToExclude = new HashSet<MemoryProfileTreeNode>();
        this.myTree = tree;
        this.myDataModel = (MemoryProfileTreeDataModel)tree.getModel();
    }

    public boolean isNodeExclusionAvailable(@NotNull MemoryProfileTreeNode node2) {
        if (node2 == null) {
            MemoryProfileExclusionHandler.$$$reportNull$$$0(1);
        }
        return node2.canBeExcluded() && !this.myNodesToExclude.contains(node2);
    }

    public boolean isNodeExcluded(@NotNull MemoryProfileTreeNode node2) {
        if (node2 == null) {
            MemoryProfileExclusionHandler.$$$reportNull$$$0(2);
        }
        return this.myNodesToExclude.contains(node2);
    }

    public void excludeNode(@NotNull MemoryProfileTreeNode node2) {
        if (node2 == null) {
            MemoryProfileExclusionHandler.$$$reportNull$$$0(3);
        }
        this.myNodesToExclude.add(node2);
    }

    public void includeNode(@NotNull MemoryProfileTreeNode node2) {
        if (node2 == null) {
            MemoryProfileExclusionHandler.$$$reportNull$$$0(4);
        }
        LOG.warn("includeNode() is not supported by MemoryProfileExclusionHandler");
    }

    public boolean isActionEnabled(boolean isExcludeAction) {
        return isExcludeAction;
    }

    public void onDone(boolean isExcludeAction) {
        if (!isExcludeAction) {
            return;
        }
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null) {
            for (TreePath selectionPath : selectionPaths) {
                IndexTreePathState selectionState = new IndexTreePathState(selectionPath);
                MemoryProfileUtil.removeNode((MemoryProfileTreeNode)selectionPath.getLastPathComponent(), this.myDataModel);
                selectionState.restoreSelection((JTree)((Object)this.myTree));
            }
        }
        HashSet<MemoryProfileError> errorsToRetain = new HashSet<MemoryProfileError>();
        TreeUtil.traverse((TreeNode)((TreeNode)this.myDataModel.getRoot()), node2 -> {
            if (node2 instanceof MemoryProfileErrorCaptionTreeNode) {
                errorsToRetain.add(((MemoryProfileErrorCaptionTreeNode)node2).getError());
            }
            return true;
        });
        this.myDataModel.retainAll(errorsToRetain);
        this.myNodesToExclude.clear();
        this.myTree.revalidate();
        this.myTree.repaint();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/cpp/profiling/ui/MemoryProfileExclusionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeExclusionAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isNodeExcluded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "excludeNode";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "includeNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

