/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.project.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.ConcurrencyUtil;
import com.jetbrains.cidr.cpp.CLionExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.project.command.CPPCommandObject;
import com.jetbrains.cidr.cpp.project.command.CPPCompilationCommandConverterKt;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.external.system.model.ExternalFileConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalLanguageConfiguration;
import com.jetbrains.cidr.external.system.model.ExternalResolveConfiguration;
import com.jetbrains.cidr.external.system.model.impl.ExternalFileConfigurationImpl;
import com.jetbrains.cidr.external.system.model.impl.ExternalLanguageConfigurationImpl;
import com.jetbrains.cidr.external.system.model.impl.ExternalResolveConfigurationImpl;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.compiler.NVCCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompiler;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerBase;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerResolver;
import com.jetbrains.cidr.lang.workspace.compiler.OCOptionsFilteringCapable;
import com.jetbrains.cidr.lang.workspace.compiler.TempFilesPool;
import com.jetbrains.cidr.lang.workspace.compiler.UnknownCompilerKind;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0010B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandConverter;", "Lkotlinx/coroutines/CoroutineScope;", "environment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "project", "Lcom/intellij/openapi/project/Project;", "context", "Lkotlin/coroutines/CoroutineContext;", "(Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/CoroutineContext;)V", "coroutineContext", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "convert", "Lcom/jetbrains/cidr/external/system/model/ExternalResolveConfiguration;", "command", "Lcom/jetbrains/cidr/cpp/project/command/CPPCommandObject;", "UnresolvedCompilerException", "intellij.clion.execution"})
public final class CPPCompilationCommandConverter
implements CoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext;
    private final CPPEnvironment environment;
    private final Project project;

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @NotNull
    public final ExternalResolveConfiguration convert(@NotNull CPPCommandObject command) throws UnresolvedCompilerException {
        List list;
        OCLanguageKind oCLanguageKind;
        List list2;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CoroutineScopeKt.ensureActive((CoroutineScope)this);
        File compilerExecutable = command.getCompilerExecutable();
        Path path = this.environment.getHostMachine().getPath(compilerExecutable.getPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"environment.hostMachine.\u2026(compilerExecutable.path)");
        OCCompilerKind compilerKind = OCCompilerResolver.Companion.resolve(this.project, path, (CidrToolEnvironment)this.environment);
        if (Intrinsics.areEqual((Object)compilerKind, (Object)UnknownCompilerKind.INSTANCE)) {
            throw (Throwable)new UnresolvedCompilerException(compilerExecutable);
        }
        CidrCompilerSwitches cidrCompilerSwitches = new CidrSwitchBuilder().addAllRaw(command.getArguments()).build();
        Intrinsics.checkNotNullExpressionValue((Object)cidrCompilerSwitches, (String)"CidrSwitchBuilder().addA\u2026ommand.arguments).build()");
        CidrCompilerSwitches switches = cidrCompilerSwitches;
        CPPCompilationCommandConverter cPPCompilationCommandConverter = this;
        boolean bl = false;
        boolean bl2 = false;
        CPPCompilationCommandConverter $this$run = cPPCompilationCommandConverter;
        boolean bl3 = false;
        OCCompiler oCCompiler = OCCompilerBase.getCompilerInstance((Project)$this$run.project, (OCCompilerKind)compilerKind, (File)compilerExecutable, (File)command.getDirectory(), (CidrToolEnvironment)((CidrToolEnvironment)$this$run.environment), (TempFilesPool)((TempFilesPool)TempFilesPool.INSTANCE));
        Intrinsics.checkNotNullExpressionValue((Object)oCCompiler, (String)"OCCompilerBase.getCompil\u2026, TempFilesPool.INSTANCE)");
        OCCompiler compiler = oCCompiler;
        if (!(compiler instanceof OCOptionsFilteringCapable)) {
            list2 = switches.getList(CidrCompilerSwitches.Format.RAW);
        } else {
            HashSet<String> skipNames = new HashSet<String>();
            CoroutineScopeKt.ensureActive((CoroutineScope)$this$run);
            String envFilePath = $this$run.environment.toEnvPath(command.getFile().getPath());
            String envDirectoryPath = $this$run.environment.toEnvPath(command.getDirectory().getPath());
            Iterator iterator = $this$run.environment.getSupportedFileSeparators().iterator();
            while (iterator.hasNext()) {
                String separatorFileName;
                String separatorDirectoryName;
                char separator = ((Character)iterator.next()).charValue();
                skipNames.add(FileUtilRt.toSystemDependentName((String)command.getOriginalFilePath(), (char)separator));
                Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.toSystemDependentName((String)envFilePath, (char)separator), (String)"FileUtilRt.toSystemDepen\u2026e(envFilePath, separator)");
                Intrinsics.checkNotNullExpressionValue((Object)FileUtilRt.toSystemDependentName((String)envDirectoryPath, (char)separator), (String)"FileUtilRt.toSystemDepen\u2026DirectoryPath, separator)");
                String relativeEnvPath = FileUtilRt.getRelativePath((String)separatorDirectoryName, (String)separatorFileName, (char)separator);
                skipNames.add(separatorFileName);
                if (relativeEnvPath == null) continue;
                skipNames.add(relativeEnvPath);
            }
            CoroutineScopeKt.ensureActive((CoroutineScope)$this$run);
            list2 = ((OCOptionsFilteringCapable)compiler).filterOptions(switches, (Set)skipNames).getList(CidrCompilerSwitches.Format.RAW);
        }
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"run {\n\n      val compile\u2026witches.Format.RAW)\n    }");
        List filteredSwitches = list2;
        CPPLog.LOG.debug("Filtered options for file '" + command.getFile() + "': " + CollectionsKt.joinToString$default((Iterable)filteredSwitches, null, null, null, (int)0, null, null, (int)63, null));
        OCLanguageKind oCLanguageKind2 = OCCompilerBase.resolveLanguage((OCCompilerKind)compilerKind, (List)filteredSwitches);
        if (oCLanguageKind2 == null) {
            oCLanguageKind2 = oCLanguageKind = OCFileTypeHelpers.getLanguageKind((String)command.getFile().getName());
        }
        if (oCLanguageKind2 == null) {
            oCLanguageKind = (OCLanguageKind)CLanguageKind.CPP;
        }
        Intrinsics.checkNotNullExpressionValue((Object)oCLanguageKind, (String)"OCCompilerBase.resolveLa\u2026     ?: CLanguageKind.CPP");
        OCLanguageKind languageKind = oCLanguageKind;
        CPPLog.LOG.debug("Language kind for file '" + command.getFile() + "': " + languageKind.getDisplayName());
        if (languageKind.isCuda()) {
            list = CollectionsKt.toMutableList((Collection)CollectionsKt.listOfNotNull((Object)NVCCCompiler.Companion.getCCBinOption(filteredSwitches)));
        } else {
            bl2 = false;
            list = new ArrayList();
        }
        List ccbinSwitch = list;
        ExternalLanguageConfigurationImpl languageConfiguration = new ExternalLanguageConfigurationImpl(languageKind, compilerKind, compilerExecutable, ccbinSwitch);
        ExternalFileConfigurationImpl fileConfiguration = new ExternalFileConfigurationImpl(command.getFile(), languageKind, filteredSwitches);
        String string = CPPCompilationCommandConverterKt.access$configurationId(command);
        String string2 = CPPCompilationCommandConverterKt.access$configurationName(command);
        File file = command.getDirectory();
        CPPToolchains.Toolchain toolchain = this.environment.getToolchain();
        Intrinsics.checkNotNullExpressionValue((Object)toolchain, (String)"environment.toolchain");
        return new ExternalResolveConfigurationImpl(string, string2, null, file, toolchain.getName(), SetsKt.mutableSetOf((Object[])new ExternalLanguageConfiguration[]{languageConfiguration}), SetsKt.mutableSetOf((Object[])new ExternalFileConfiguration[]{fileConfiguration}));
    }

    public CPPCompilationCommandConverter(@NotNull CPPEnvironment environment2, @NotNull Project project, @NotNull CoroutineContext context) {
        Intrinsics.checkNotNullParameter((Object)environment2, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.environment = environment2;
        this.project = project;
        ExecutorService executorService = ConcurrencyUtil.newSameThreadExecutorService();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"ConcurrencyUtil.newSameThreadExecutorService()");
        this.coroutineContext = ExecutorsKt.from((ExecutorService)executorService).plus(context);
    }

    public /* synthetic */ CPPCompilationCommandConverter(CPPEnvironment cPPEnvironment, Project project, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            coroutineContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;
        }
        this(cPPEnvironment, project, coroutineContext);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/cpp/project/command/CPPCompilationCommandConverter$UnresolvedCompilerException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "compilerExecutable", "Ljava/io/File;", "(Ljava/io/File;)V", "getCompilerExecutable", "()Ljava/io/File;", "intellij.clion.execution"})
    public static final class UnresolvedCompilerException
    extends Exception {
        @NotNull
        private final File compilerExecutable;

        @NotNull
        public final File getCompilerExecutable() {
            return this.compilerExecutable;
        }

        public UnresolvedCompilerException(@NotNull File compilerExecutable) {
            Intrinsics.checkNotNullParameter((Object)compilerExecutable, (String)"compilerExecutable");
            super(CLionExecutionBundle.message("command.unknown.compiler.executable.message", compilerExecutable.toString()));
            this.compilerExecutable = compilerExecutable;
        }
    }
}

