/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.search;

import com.intellij.lang.cacheBuilder.DefaultWordsScanner;
import com.intellij.lang.cacheBuilder.WordOccurrence;
import com.intellij.lang.cacheBuilder.WordsScanner;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lexer.Lexer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Processor;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import com.jetbrains.cmake.psi.CMakeLexer;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeFindUsagesProvider
implements FindUsagesProvider {
    @Nullable
    public WordsScanner getWordsScanner() {
        return new DollarSignSplittingScanner((Lexer)new CMakeLexer(), CMakeElementTypes.IDENTIFIERS, CMakeElementTypes.COMMENTS, CMakeElementTypes.LITERALS);
    }

    public boolean canFindUsagesFor(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(0);
        }
        return psiElement instanceof PsiNamedElement || psiElement.getNode().getElementType() == CMakeTokenTypes.ID || psiElement.getNode().getElementType() == CMakeTokenTypes.LITERAL;
    }

    @Nullable
    public String getHelpId(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(1);
        }
        return "reference.dialogs.findUsages.other";
    }

    @NotNull
    public String getType(@NotNull PsiElement element) {
        if (element == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(2);
        }
        if (element instanceof CMakeCommandNameMixin) {
            String string = CMakeBundle.message("cmake.command.name", new Object[0]);
            if (string == null) {
                CMakeFindUsagesProvider.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (element instanceof CMakeArgument) {
            String string = CMakeBundle.message("cmake.argument.command.name", new Object[0]);
            if (string == null) {
                CMakeFindUsagesProvider.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = CMakeBundle.message("cmake.search.element", new Object[0]);
        if (string == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getDescriptiveName(@NotNull PsiElement element) {
        String name2;
        if (element == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(6);
        }
        if (element instanceof PsiNamedElement && (name2 = ((PsiNamedElement)element).getName()) != null) {
            String string = "'" + name2 + "'";
            if (string == null) {
                CMakeFindUsagesProvider.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = "'" + element.getText() + "'";
        if (string == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getNodeText(@NotNull PsiElement element, boolean useFullName) {
        if (element == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(9);
        }
        String string = this.getDescriptiveName(element);
        if (string == null) {
            CMakeFindUsagesProvider.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cmake/search/CMakeFindUsagesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cmake/search/CMakeFindUsagesProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptiveName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsagesFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getHelpId";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptiveName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNodeText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DollarSignSplittingScanner
    extends DefaultWordsScanner {
        DollarSignSplittingScanner(Lexer lexer, TokenSet identifiers, TokenSet comments, TokenSet literals) {
            this(lexer, identifiers, comments, literals, TokenSet.EMPTY);
        }

        DollarSignSplittingScanner(Lexer lexer, TokenSet identifiers, TokenSet comments, TokenSet literals, TokenSet skipCodeContext) {
            super(lexer, identifiers, comments, literals, skipCodeContext);
        }

        public void processWords(@NotNull CharSequence fileText, @NotNull Processor<? super WordOccurrence> processor2) {
            if (fileText == null) {
                DollarSignSplittingScanner.$$$reportNull$$$0(0);
            }
            if (processor2 == null) {
                DollarSignSplittingScanner.$$$reportNull$$$0(1);
            }
            super.processWords(fileText, occurrence -> {
                CharSequence currentWord = occurrence.getBaseText().subSequence(occurrence.getStart(), occurrence.getEnd());
                if (!processor2.process(occurrence)) {
                    return false;
                }
                int start = occurrence.getStart();
                for (int i = 0; i < currentWord.length(); ++i) {
                    WordOccurrence wordOccurrence;
                    char nextChar = currentWord.charAt(i);
                    if (nextChar != '$') continue;
                    if (occurrence.getBaseText().subSequence(start, occurrence.getStart() + i).length() > 0 && !processor2.process((Object)(wordOccurrence = new WordOccurrence(occurrence.getBaseText(), start, occurrence.getStart() + i, occurrence.getKind())))) {
                        return false;
                    }
                    start = i + 1;
                }
                if (start != occurrence.getStart() && occurrence.getBaseText().subSequence(occurrence.getStart() + start, occurrence.getEnd()).length() > 0) {
                    return processor2.process((Object)new WordOccurrence(occurrence.getBaseText(), occurrence.getStart() + start, occurrence.getEnd(), occurrence.getKind()));
                }
                return true;
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cmake/search/CMakeFindUsagesProvider$DollarSignSplittingScanner";
            objectArray[2] = "processWords";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

