/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.actions;

import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.run.HttpRequestHistoryManager;
import com.intellij.httpClient.http.request.run.HttpRequestInvalidLogFileException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.awt.RelativePoint;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestShowHistoryAction
extends AnAction {
    public HttpRequestShowHistoryAction() {
        super(RestClientBundle.messagePointer("action.RESTClient.ShowHistory.text", new Object[0]));
        this.getTemplatePresentation().setDescription(RestClientBundle.messagePointer("http.request.show.log.file.action.description", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(0);
        }
        if ((project = event.getProject()) == null || project.isDefault()) {
            this.showErrorBalloon(null, event, RestClientBundle.message("http.request.show.log.file.action.failed.default.project", new Object[0]), null);
            return;
        }
        try {
            HttpRequestPsiFile logFile = HttpRequestHistoryManager.getInstance(project).getLogFile();
            FileEditorManager.getInstance((Project)project).openFile(logFile.getVirtualFile(), true);
        }
        catch (HttpRequestInvalidLogFileException e) {
            this.showErrorBalloon(project, event, e.getMessage(), e.getOpenConfiguration());
        }
    }

    protected void showErrorBalloon(@Nullable Project project, @NotNull AnActionEvent event, @NotNull @NlsContexts.PopupContent String message2, final @Nullable Runnable openConfig) {
        InputEvent inputEvent;
        if (event == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(1);
        }
        if (message2 == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(2);
        }
        RelativePoint point = (inputEvent = event.getInputEvent()) instanceof MouseEvent ? new RelativePoint((MouseEvent)inputEvent) : JBPopupFactory.getInstance().guessBestPopupLocation(event.getDataContext());
        String fullMessage = openConfig != null ? HttpRequestShowHistoryAction.openConfigMessage(message2) : message2;
        HyperlinkAdapter listener = openConfig != null ? new HyperlinkAdapter(){

            protected void hyperlinkActivated(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    openConfig.run();
                }
            }
        } : null;
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(fullMessage, MessageType.ERROR, (HyperlinkListener)listener).setFadeoutTime(fullMessage.length() > 100 ? 5000L : 2000L);
        if (project != null) {
            builder.setDisposable((Disposable)project);
        }
        builder.createBalloon().show(point, Balloon.Position.below);
    }

    @NlsContexts.PopupContent
    @NotNull
    private static String openConfigMessage(@NotNull @Nls String message2) {
        if (message2 == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(3);
        }
        String string = new HtmlBuilder().append(message2).br().appendLink("\"config\"", RestClientBundle.message("http.request.show.log.file.action.failed.open.config", new Object[0])).toString();
        if (string == null) {
            HttpRequestShowHistoryAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/actions/HttpRequestShowHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/actions/HttpRequestShowHistoryAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "openConfigMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showErrorBalloon";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "openConfigMessage";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

