/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.converters.curl;

import com.intellij.httpClient.converters.RequestBuilder;
import com.intellij.httpClient.converters.curl.CurlMultipartBodyBuilder;
import com.intellij.httpClient.converters.curl.CurlRequestBuilder$WhenMappings;
import com.intellij.httpClient.converters.curl.CurlRequestBuilderKt;
import com.intellij.httpClient.converters.curl.CurlRequestFormBody;
import com.intellij.httpClient.converters.curl.CurlRequestMessageBody;
import com.intellij.httpClient.converters.curl.RequestFieldParam;
import com.intellij.httpClient.execution.HttpRequestConfig;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.ssl.SslConfiguration;
import com.intellij.util.NullableFunction;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00022\u0006\u0010!\u001a\u00020\u00022\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J8\u0010%\u001a\u00020\u0016\"\b\b\u0000\u0010&*\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u00022\u001a\u0010)\u001a\u0016\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\u00030+\u0012\u0004\u0012\u0002H&0*H\u0016J\u0010\u0010,\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J&\u0010-\u001a\u00020\u0016\"\b\b\u0000\u0010&*\u00020'2\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002H&0*H\u0016J\u0012\u00100\u001a\u00020\u00162\b\u00101\u001a\u0004\u0018\u000102H\u0016J\u0010\u00103\u001a\u00020\u00162\u0006\u00104\u001a\u00020\u0002H\u0016J\u0010\u00105\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0010\u00106\u001a\u00020\u0016*\u000607j\u0002`8H\u0002J\u0010\u00109\u001a\u00020\u0016*\u000607j\u0002`8H\u0002J\u0010\u0010\u0017\u001a\u00020\u0016*\u000607j\u0002`8H\u0002J\u0010\u0010\f\u001a\u00020\u0016*\u000607j\u0002`8H\u0002J\u0010\u0010\u000f\u001a\u00020\u0016*\u000607j\u0002`8H\u0002J\u0010\u0010\u0010\u001a\u00020\u0016*\u000607j\u0002`8H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/httpClient/converters/curl/CurlRequestBuilder;", "Lcom/intellij/httpClient/converters/RequestBuilder;", "", "Lcom/intellij/httpClient/converters/curl/CurlRequestFormBody;", "()V", "allowRedirect", "", "authData", "Lcom/intellij/httpClient/execution/auth/HttpClientAuthData;", "body", "Lcom/intellij/httpClient/converters/curl/CurlRequestMessageBody;", "contentType", "headers", "", "Lcom/intellij/httpClient/converters/curl/RequestFieldParam;", "method", "protocol", "Lcom/intellij/httpClient/converters/RequestBuilder$HttpProtocol;", "queryParams", "url", "build", "withAuthData", "", "data", "withConfig", "config", "Lcom/intellij/httpClient/execution/HttpRequestConfig;", "withEmptyCredentials", "withFileToSend", "file", "Ljava/io/File;", "withHeader", "name", "value", "optionProvider", "Lcom/intellij/util/NullableFunction;", "withMethod", "withMultipartBody", "E", "", "multipartBoundary", "multipartInitializer", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/httpClient/converters/RequestBuilder$MultipartBodyBuilder;", "withProtocol", "withQueryParameters", "queryInitializer", "Lcom/intellij/httpClient/converters/RequestBuilder$QueryBuilder;", "withSslConfiguration", "sslConfiguration", "Lcom/intellij/httpClient/execution/ssl/SslConfiguration;", "withTextToSend", "text", "withUrl", "authentication", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "buildUrl", "intellij.restClient"})
public final class CurlRequestBuilder
implements RequestBuilder<String, CurlRequestFormBody> {
    private String url = "";
    private String method = "GET";
    private final List<RequestFieldParam> queryParams;
    private CurlRequestMessageBody body;
    private boolean allowRedirect;
    private RequestBuilder.HttpProtocol protocol;
    private final List<RequestFieldParam> headers;
    private String contentType;
    private HttpClientAuthData authData;

    @Override
    public void withUrl(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.url = url;
    }

    @Override
    public void withMethod(@NotNull String method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.method = method;
    }

    @Override
    public void withProtocol(@NotNull RequestBuilder.HttpProtocol protocol) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        this.protocol = protocol;
    }

    @Override
    public <E extends Throwable> void withQueryParameters(@NotNull ThrowableConsumer<RequestBuilder.QueryBuilder, E> queryInitializer) {
        Intrinsics.checkNotNullParameter(queryInitializer, (String)"queryInitializer");
        queryInitializer.consume((Object)new RequestBuilder.QueryBuilder(this){
            final /* synthetic */ CurlRequestBuilder this$0;

            public final void addQueryParameter(@NotNull String key2, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                CurlRequestBuilder.access$getQueryParams$p(this.this$0).add(new RequestFieldParam(key2, value));
            }
            {
                this.this$0 = curlRequestBuilder;
            }
        });
    }

    @Override
    public void withAuthData(@NotNull HttpClientAuthData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.authData = data;
    }

    @Override
    public void withHeader(@NotNull String name, @NotNull String value, @NotNull NullableFunction<String, String> optionProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter(optionProvider, (String)"optionProvider");
        this.headers.add(new RequestFieldParam(name, value));
        if (StringsKt.equals((String)"Content-Type", (String)name, (boolean)true)) {
            String string;
            String string2 = (String)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)value, (char[])new char[]{';'}, (boolean)false, (int)0, (int)6, null));
            if (string2 != null) {
                String string3 = string2;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            } else {
                string = null;
            }
            this.contentType = string;
        }
    }

    @Override
    public void withFileToSend(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        String string = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
        this.body = new CurlRequestMessageBody.SingleDataBody.FileBody(string);
    }

    @Override
    public void withTextToSend(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.body = new CurlRequestMessageBody.SingleDataBody.ExactBody(text);
    }

    @Override
    public <E extends Throwable> void withMultipartBody(@Nullable String multipartBoundary, @NotNull ThrowableConsumer<? super RequestBuilder.MultipartBodyBuilder<CurlRequestFormBody>, E> multipartInitializer) {
        Intrinsics.checkNotNullParameter(multipartInitializer, (String)"multipartInitializer");
        CurlMultipartBodyBuilder partsBuilder = new CurlMultipartBodyBuilder();
        multipartInitializer.consume((Object)partsBuilder);
        this.body = new CurlRequestMessageBody.MultipartBody(partsBuilder.getParts());
    }

    @Override
    public void withConfig(@NotNull HttpRequestConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.allowRedirect = config.isFollowRedirects();
    }

    @Override
    public void withEmptyCredentials() {
        this.authData = new HttpClientAuthData(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, "Negotiate"), new Credentials(){

            @Nullable
            public Principal getUserPrincipal() {
                return null;
            }

            @Nullable
            public String getPassword() {
                return null;
            }
        });
    }

    @Override
    @NotNull
    public String build() {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append("curl");
        this.method($this$buildString);
        this.buildUrl($this$buildString);
        this.protocol($this$buildString);
        this.headers($this$buildString);
        this.data($this$buildString);
        this.authentication($this$buildString);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private final void method(StringBuilder $this$method) {
        String string = this.method;
        boolean bl = false;
        boolean bl2 = false;
        String it = string;
        boolean bl3 = false;
        $this$method.append(" -X ");
        $this$method.append(this.method);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildUrl(StringBuilder $this$buildUrl) {
        if (this.allowRedirect) {
            $this$buildUrl.append(" --location");
        }
        $this$buildUrl.append(" \"");
        $this$buildUrl.append(this.url);
        List<RequestFieldParam> list = this.queryParams;
        boolean bl = false;
        boolean bl2 = false;
        List<RequestFieldParam> it = list;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        List<RequestFieldParam> list2 = !collection.isEmpty() ? list : null;
        if (list2 != null) {
            list = list2;
            bl = false;
            bl2 = false;
            it = list;
            boolean bl5 = false;
            $this$buildUrl.append("?");
            for (RequestFieldParam requestFieldParam : this.queryParams) {
                void name;
                String string = requestFieldParam.component1();
                String value = requestFieldParam.component2();
                $this$buildUrl.append((String)name);
                $this$buildUrl.append("=");
                $this$buildUrl.append(value);
                $this$buildUrl.append("&");
            }
            $this$buildUrl.deleteCharAt($this$buildUrl.length() - 1);
        }
        $this$buildUrl.append("\"");
    }

    private final void protocol(StringBuilder $this$protocol) {
        if (this.protocol == null) {
            return;
        }
        RequestBuilder.HttpProtocol httpProtocol = this.protocol;
        if (httpProtocol != null) {
            switch (CurlRequestBuilder$WhenMappings.$EnumSwitchMapping$0[httpProtocol.ordinal()]) {
                case 1: {
                    $this$protocol.append(" --http1.0");
                    break;
                }
                case 2: {
                    $this$protocol.append(" --http1.1");
                    break;
                }
                case 3: {
                    $this$protocol.append(" --http2");
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void headers(StringBuilder $this$headers) {
        for (RequestFieldParam requestFieldParam : this.headers) {
            void name;
            String string = requestFieldParam.component1();
            String value = requestFieldParam.component2();
            CurlRequestBuilderKt.access$lineSeparator($this$headers);
            $this$headers.append("-H \"");
            $this$headers.append((String)name);
            $this$headers.append(": ");
            $this$headers.append(value);
            $this$headers.append("\"");
        }
    }

    private final void data(StringBuilder $this$data) {
        block0: {
            CurlRequestMessageBody curlRequestMessageBody = this.body;
            if (curlRequestMessageBody == null) break block0;
            CurlRequestMessageBody curlRequestMessageBody2 = curlRequestMessageBody;
            boolean bl = false;
            boolean bl2 = false;
            CurlRequestMessageBody $this$run = curlRequestMessageBody2;
            boolean bl3 = false;
            $this$run.appendData($this$data, this.contentType);
        }
    }

    private final void authentication(StringBuilder $this$authentication) {
        String string;
        String string2;
        boolean bl;
        String string3;
        HttpClientAuthData httpClientAuthData = this.authData;
        if (httpClientAuthData == null) {
            return;
        }
        HttpClientAuthData authData = httpClientAuthData;
        CurlRequestBuilderKt.access$lineSeparator($this$authentication);
        AuthScope authScope = authData.getScope();
        Intrinsics.checkNotNullExpressionValue((Object)authScope, (String)"authData.scope");
        String string4 = authScope.getScheme();
        if (string4 != null) {
            string3 = string4;
            bl = false;
            String string5 = string3;
            if (string5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string6 = string5.toLowerCase();
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).toLowerCase()");
        } else {
            string2 = null;
        }
        String string7 = string2;
        string3 = "Basic";
        bl = false;
        String string8 = string3.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
        if (Intrinsics.areEqual((Object)string7, (Object)string8)) {
            string = "--basic ";
        } else {
            string3 = "Digest";
            bl = false;
            String string9 = string3.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase()");
            if (Intrinsics.areEqual((Object)string7, (Object)string9)) {
                string = "--digest ";
            } else {
                string3 = "Negotiate";
                bl = false;
                String string10 = string3.toLowerCase();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.String).toLowerCase()");
                string = Intrinsics.areEqual((Object)string7, (Object)string10) ? "--negotiate " : "";
            }
        }
        String option = string;
        $this$authentication.append(option);
        $this$authentication.append("--user ");
        Credentials credentials = authData.getAuthCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials, (String)"authData.authCredentials");
        Principal principal = credentials.getUserPrincipal();
        string7 = principal != null ? principal.getName() : null;
        boolean bl2 = false;
        String string11 = string7;
        if (string11 == null) {
            string11 = "";
        }
        $this$authentication.append(string11);
        $this$authentication.append(":");
        Credentials credentials2 = authData.getAuthCredentials();
        Intrinsics.checkNotNullExpressionValue((Object)credentials2, (String)"authData.authCredentials");
        string7 = credentials2.getPassword();
        bl2 = false;
        String string12 = string7;
        if (string12 == null) {
            string12 = "";
        }
        $this$authentication.append(string12);
    }

    @Override
    public void withSslConfiguration(@Nullable SslConfiguration sslConfiguration) {
    }

    public CurlRequestBuilder() {
        boolean bl = false;
        this.queryParams = new ArrayList();
        this.allowRedirect = true;
        bl = false;
        this.headers = new ArrayList();
    }

    public static final /* synthetic */ List access$getQueryParams$p(CurlRequestBuilder $this) {
        return $this.queryParams;
    }
}

