/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.execution.auth;

import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.auth.HttpClientAuthBasicConfigurator;
import com.intellij.httpClient.execution.auth.HttpClientAuthConfigurator;
import com.intellij.httpClient.execution.auth.HttpClientAuthData;
import com.intellij.httpClient.execution.auth.HttpClientAuthHeaderConfigurator;
import com.intellij.httpClient.execution.auth.HttpClientOsAuthConfigurator;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpClientAuthConfigurationManager {
    private static final List<HttpClientAuthConfigurator> CONFIGURATORS = ContainerUtil.newArrayList((Object[])new HttpClientAuthConfigurator[]{new HttpClientAuthHeaderConfigurator(), new HttpClientAuthBasicConfigurator(), new HttpClientOsAuthConfigurator()});

    public static void configure(@Nullable HttpClientAuthData authData, @NotNull CredentialsProvider provider, @NotNull HttpRequestBase request) {
        if (provider == null) {
            HttpClientAuthConfigurationManager.$$$reportNull$$$0(0);
        }
        if (request == null) {
            HttpClientAuthConfigurationManager.$$$reportNull$$$0(1);
        }
        for (HttpClientAuthConfigurator configurator : CONFIGURATORS) {
            configurator.configure(authData, provider, request);
        }
    }

    public static void cleanUp(@NotNull RestClientRequest request) {
        if (request == null) {
            HttpClientAuthConfigurationManager.$$$reportNull$$$0(2);
        }
        for (HttpClientAuthConfigurator configurator : CONFIGURATORS) {
            configurator.cleanup(request.authData);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/execution/auth/HttpClientAuthConfigurationManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configure";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanUp";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

