/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.List;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.lang.references.MarkdownAnchorReferenceImpl;
import org.intellij.plugins.markdown.lang.references.MissingExtensionFileReferenceBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownAnchorPathReferenceProvider
implements PathReferenceProvider {
    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        String anchor;
        if (psiElement == null) {
            MarkdownAnchorPathReferenceProvider.$$$reportNull$$$0(0);
        }
        if (references == null) {
            MarkdownAnchorPathReferenceProvider.$$$reportNull$$$0(1);
        }
        if (!(psiElement instanceof MarkdownPsiElement)) {
            return false;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)psiElement);
        String elementText = psiElement.getText();
        int anchorOffset = elementText.indexOf(35);
        if (anchorOffset == -1) {
            return false;
        }
        FileReference fileReference = null;
        if (range.getStartOffset() != anchorOffset && ((fileReference = MarkdownAnchorPathReferenceProvider.findFileReference(references)) == null || fileReference.resolve() == null)) {
            for (PsiReference reference : references) {
                if (!(reference instanceof MissingExtensionFileReferenceBase)) continue;
                fileReference = reference;
                break;
            }
            if (fileReference == null || fileReference.resolve() == null) {
                return false;
            }
        }
        try {
            int endIndex = range.getEndOffset();
            if (endIndex <= anchorOffset) {
                endIndex = anchorOffset + 1;
            }
            anchor = elementText.substring(anchorOffset + 1, endIndex);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new RuntimeException(elementText, e);
        }
        references.add((PsiReference)new MarkdownAnchorReferenceImpl(anchor, (PsiReference)fileReference, psiElement, anchorOffset + 1));
        return false;
    }

    @Nullable
    static FileReference findFileReference(List<PsiReference> references) {
        FileReference fileReference = null;
        for (PsiReference reference : references) {
            if (!(reference instanceof FileReference)) continue;
            fileReference = ((FileReference)reference).getFileReferenceSet().getLastReference();
            break;
        }
        return fileReference;
    }

    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
        if (path == null) {
            MarkdownAnchorPathReferenceProvider.$$$reportNull$$$0(2);
        }
        if (element == null) {
            MarkdownAnchorPathReferenceProvider.$$$reportNull$$$0(3);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/markdown/lang/references/MarkdownAnchorPathReferenceProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createReferences";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPathReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

