/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.visitors.Visitor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.TrimmingInlineHolderProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFenceGeneratingProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\f\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J$\u0010\r\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006R\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/html/ParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/TrimmingInlineHolderProvider;", "()V", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag", "processNode", "intellij.markdown"})
public final class ParagraphGeneratingProvider
extends TrimmingInlineHolderProvider {
    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default((HtmlGenerator.HtmlGeneratingVisitor)visitor, (ASTNode)node, (CharSequence)"p", (CharSequence[])new CharSequence[0], (boolean)false, (int)8, null);
    }

    public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        visitor.consumeTagClose((CharSequence)"p");
    }

    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.openTag(visitor, text, node);
        for (ASTNode child : this.childrenToRender(node)) {
            if (child instanceof LeafASTNode) {
                IElementType iElementType = child.getType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownTokenTypes.TEXT)) {
                    int left = child.getStartOffset();
                    for (String line : StringsKt.split$default((CharSequence)ASTUtilKt.getTextInNode((ASTNode)child, (CharSequence)text), (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null)) {
                        int right = left + line.length();
                        visitor.consumeHtml((CharSequence)("<span " + HtmlGenerator.Companion.getSRC_ATTRIBUTE_NAME() + "='" + left + ".." + right + "'>" + MarkdownCodeFenceGeneratingProvider.Companion.escape$intellij_markdown(line) + "</span>"));
                        left += right + 1;
                    }
                    continue;
                }
                visitor.visitLeaf(child);
                continue;
            }
            ASTNodeKt.accept((ASTNode)child, (Visitor)((Visitor)visitor));
        }
        this.closeTag(visitor, text, node);
    }
}

