/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.toolchains;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.ToolchainsBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class CPPToolchainsUtil {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^[a-zA-Z() \\d]*([\\d]+\\.[\\d]+\\.?[\\d]*).*", 8);

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @NotNull ToolVersion toolVersion) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(0);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(1);
        }
        if (toolVersion == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(2);
        }
        return CPPToolchainsUtil.checkVersion(min, max, toolVersion.versionNumber);
    }

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @Nullable Version version) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(3);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(4);
        }
        return CPPToolchainsUtil.checkVersion(min, max, version, "settings.select.UnsupportedVersion", "settings.select.UnsupportedVersion.range");
    }

    @Nls
    @Nullable
    public static String checkVersion(@NotNull Version min, @NotNull Version max, @Nullable Version version, @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull String singleVersionMessageKey, @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull @PropertyKey(resourceBundle="messages.ToolchainsBundle") @NotNull String versionRangeMessage) {
        if (min == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(5);
        }
        if (max == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(6);
        }
        if (singleVersionMessageKey == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(7);
        }
        if (versionRangeMessage == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(8);
        }
        if (version == null || CPPToolchainsUtil.compareVersions(min, version) < 0 || CPPToolchainsUtil.compareVersions(max, version) > 0) {
            return min.equals((Object)max) ? ToolchainsBundle.message(singleVersionMessageKey, version, CPPToolchainsUtil.toWildcardString(min)) : ToolchainsBundle.message(versionRangeMessage, version, CPPToolchainsUtil.toWildcardString(min), CPPToolchainsUtil.toWildcardString(max));
        }
        return null;
    }

    @NlsSafe
    @NotNull
    public static String toWildcardString(@NotNull Version version) {
        if (version == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(9);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(version.major);
        if (version.minor != -1) {
            builder.append(".").append(version.minor);
            if (version.bugfix != -1) {
                builder.append(".").append(version.bugfix);
            } else {
                builder.append(".x");
            }
        } else {
            builder.append(".x");
        }
        String string = builder.toString();
        if (string == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    public static int compareVersions(@NotNull Version baseline, @NotNull Version version) {
        if (baseline == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(11);
        }
        if (version == null) {
            CPPToolchainsUtil.$$$reportNull$$$0(12);
        }
        return version.compareTo(baseline.major == -1 ? null : Integer.valueOf(baseline.major), baseline.minor == -1 ? null : Integer.valueOf(baseline.minor), baseline.bugfix == -1 ? null : Integer.valueOf(baseline.bugfix));
    }

    @NlsSafe
    @Nullable
    public static String preparePath(@Nullable String path) {
        return StringUtil.nullize((String)StringUtil.trim((String)path), (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "min";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "max";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolVersion";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "singleVersionMessageKey";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRangeMessage";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseline";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/toolchains/CPPToolchainsUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toWildcardString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toWildcardString";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

